/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.commons;

import java.nio.ByteBuffer;

public class HexTools {
    public static final int SPACING_NONE = 0;
    public static final int SPACING_OCTET = 3;
    public static final int SPACING_NIBBLE = 4;
    public static final int SPACING_BYTE = 8;
    public static final int SPACING_WORD = 16;
    private static final char[] digits = "0123456789ABCDEF".toCharArray();

    public static StringBuffer dump(ByteBuffer buffer) {
        int len = buffer.remaining();
        int pos = buffer.position();
        byte[] b = new byte[len];
        buffer.get(b);
        buffer.position(pos);
        return HexTools.dump(b);
    }

    public static StringBuffer dump(ByteBuffer buffer, int length, boolean printAddress) {
        int len = buffer.remaining();
        int pos = buffer.position();
        if (length > 0 && len > length) {
            len = length;
        }
        byte[] b = new byte[len];
        buffer.get(b);
        buffer.position(pos);
        if (printAddress) {
            return HexTools.dump(b, pos);
        }
        return HexTools.dump(b, 0);
    }

    public static StringBuffer dump(ByteBuffer buffer, int startAddress) {
        int len = buffer.remaining();
        int pos = buffer.position();
        byte[] b = new byte[len];
        buffer.get(b);
        buffer.position(pos);
        return HexTools.dump(b, startAddress);
    }

    public static StringBuffer dump(String data) {
        return HexTools.dump(data.getBytes());
    }

    public static StringBuffer dump(String data, int startAddress) {
        return HexTools.dump(data.getBytes(), startAddress);
    }

    public static StringBuffer dump(byte[] data) {
        int dataLen = data.length;
        int hexDigits = Integer.toString(dataLen - 1, 16).length();
        if (hexDigits < 2) {
            hexDigits = 2;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer chb = new StringBuffer("| ");
        for (int i = 0; i < dataLen; ++i) {
            if (i % 16 == 0) {
                sb.append(HexTools.toHex(i, hexDigits * 4, 0)).append(":");
            }
            sb.append(" ").append(HexTools.toHex(data[i]));
            char ch = (char)data[i];
            chb.append(data[i] >= 32 && data[i] < 127 ? Character.valueOf(ch) : ".");
            if (i % 8 == 7) {
                sb.append(" ");
                chb.append(" ");
            }
            if (i % 16 != 15) continue;
            sb.append(chb);
            sb.append("\n");
            chb = new StringBuffer("| ");
        }
        int last = dataLen % 16;
        if (last > 0) {
            for (int i = last; i < 16; ++i) {
                sb.append(" --");
                chb.append(" ");
                if (i % 8 != 7) continue;
                sb.append(" ");
                chb.append(" ");
            }
            sb.append(chb);
            chb = null;
            sb.append("\n");
        }
        return sb;
    }

    public static StringBuffer dump(byte[] data, int startAddress) {
        int dataLength = data.length;
        int startAddressMod = startAddress % 16;
        int startAddressMain = startAddress - startAddressMod;
        int hexDigitCount = Integer.toString(dataLength + startAddress - 1, 16).length();
        if ((hexDigitCount += hexDigitCount % 2) < 2) {
            hexDigitCount = 2;
        }
        int hexDigitLengthCount = Integer.toString(dataLength, 16).length();
        if ((hexDigitLengthCount += hexDigitLengthCount % 2) < 2) {
            hexDigitLengthCount = 2;
        }
        StringBuffer sb = new StringBuffer();
        StringBuffer chb = new StringBuffer("| ");
        sb.append("Start: ").append(startAddress).append(" (0x").append(HexTools.toHex(startAddress, hexDigitCount * 4, 0)).append(")  End: ").append(startAddress + dataLength - 1).append(" (0x").append(HexTools.toHex(startAddress + dataLength - 1, hexDigitCount * 4, 0)).append(")  Length: ").append(dataLength).append(" (0x").append(HexTools.toHex(dataLength, hexDigitLengthCount * 4, 0)).append(")\n");
        for (int i = 0; i < dataLength; ++i) {
            if ((i + startAddressMod) % 16 == 0 || i == 0) {
                if (i == 0) {
                    sb.append(HexTools.toHex(i + startAddressMain, hexDigitCount * 4, 0)).append(":");
                } else {
                    sb.append(HexTools.toHex(i + startAddress, hexDigitCount * 4, 0)).append(":");
                }
            }
            if (i == 0 && startAddressMod > 0) {
                for (int j = 0; j < startAddressMod; ++j) {
                    sb.append(" --");
                    chb.append(" ");
                    if (j % 8 != 7) continue;
                    sb.append(" ");
                    chb.append(" ");
                }
            }
            sb.append(" ").append(HexTools.toHex(data[i]));
            char ch = (char)data[i];
            chb.append(data[i] >= 32 && data[i] < 127 ? Character.valueOf(ch) : ".");
            if ((i + startAddressMod) % 8 == 7) {
                sb.append(" ");
                chb.append(" ");
            }
            if ((i + startAddressMod) % 16 != 15) continue;
            sb.append(chb);
            sb.append("\n");
            chb = new StringBuffer("| ");
        }
        int last = (dataLength - (16 - startAddressMod)) % 16;
        if (last < 0) {
            last += 16;
        }
        if (last > 0) {
            for (int i = last; i < 16; ++i) {
                sb.append(" --");
                chb.append(" ");
                if (i % 8 != 7) continue;
                sb.append(" ");
                chb.append(" ");
            }
            sb.append(chb);
            chb = null;
            sb.append("\n");
        }
        return sb;
    }

    public static String pad(String in, int length, char pad, boolean limitMaxLength) {
        int inLength = in.length();
        if (inLength > length) {
            if (limitMaxLength) {
                return "<" + in.substring(inLength - (length - 1), inLength);
            }
            return in;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < length - inLength; ++i) {
            sb.append(pad);
        }
        sb.append(in);
        return sb.toString();
    }

    public static String toHex(byte digit) {
        return String.valueOf(new char[]{digits[digit >> 4 & 0xF], digits[digit & 0xF]});
    }

    public static String toHex(char digit) {
        return String.valueOf(new char[]{digits[digit >> 12 & 0xF], digits[digit >> 8 & 0xF], digits[digit >> 4 & 0xF], digits[digit & 0xF]});
    }

    public static String toHex(char digit, boolean isSpaced) {
        if (!isSpaced) {
            return HexTools.toHex(digit);
        }
        return String.valueOf(new char[]{digits[digit >> 12 & 0xF], digits[digit >> 8 & 0xF], ' ', digits[digit >> 4 & 0xF], digits[digit & 0xF]});
    }

    public static String toHex(short digit) {
        return String.valueOf(new char[]{digits[digit >> 12 & 0xF], digits[digit >> 8 & 0xF], digits[digit >> 4 & 0xF], digits[digit & 0xF]});
    }

    public static String toHex(short digit, boolean isSpaced) {
        if (!isSpaced) {
            return HexTools.toHex(digit);
        }
        return String.valueOf(new char[]{digits[digit >> 12 & 0xF], digits[digit >> 8 & 0xF], ' ', digits[digit >> 4 & 0xF], digits[digit & 0xF]});
    }

    public static String toHex(int digit) {
        return HexTools.toHex((short)(digit >> 16 & 0xFFFF)) + HexTools.toHex((short)(digit & 0xFFFF));
    }

    public static String toHex(int digit, boolean isSpaced) {
        if (!isSpaced) {
            return HexTools.toHex(digit);
        }
        return HexTools.toHex((short)(digit >> 16 & 0xFFFF), true) + ' ' + HexTools.toHex((short)(digit & 0xFFFF), true);
    }

    public static String toHex(long digit) {
        return HexTools.toHex((short)(digit >> 48 & 0xFFFFL)) + HexTools.toHex((short)(digit >> 32 & 0xFFFFL)) + HexTools.toHex((short)(digit >> 16 & 0xFFFFL)) + HexTools.toHex((short)(digit & 0xFFFFL));
    }

    public static String toHex(long digit, boolean isSpaced) {
        if (!isSpaced) {
            return HexTools.toHex(digit);
        }
        return HexTools.toHex((short)(digit >> 48 & 0xFFFFL), true) + ' ' + HexTools.toHex((short)(digit >> 32 & 0xFFFFL), true) + ' ' + HexTools.toHex((short)(digit >> 16 & 0xFFFFL), true) + ' ' + HexTools.toHex((short)(digit & 0xFFFFL), true);
    }

    public static String toBits(byte digit, boolean isSpaced) {
        return HexTools.toBits(digit, 8, 4);
    }

    public static String toBits(byte digit) {
        return HexTools.toBits(digit, 8, 0);
    }

    public static String toBits(long digit, int bits, int spacing) {
        int shift = bits - 1;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < bits; ++i) {
            if (spacing > 0 && i > 0 && (bits - i) % spacing == 0) {
                b.append(' ');
            }
            b.append((digit >> shift - i & 1L) == 1L ? (char)'1' : '0');
        }
        return b.toString();
    }

    public static String toHex(long digit, int bits, int spacing) {
        int nibs = bits / 4;
        int shift = nibs - 1;
        spacing /= 4;
        StringBuffer b = new StringBuffer();
        for (int i = 0; i < nibs; ++i) {
            if (spacing > 0 && i > 0 && (nibs - i) % spacing == 0) {
                b.append(' ');
            }
            b.append(digits[(int)(digit >> (shift - i) * 4) & 0xF]);
        }
        return b.toString();
    }

    public static int toUInt(byte digit) {
        return digit & 0xFF;
    }

    public static int toUInt(short digit) {
        return digit & 0xFFFF;
    }

    public static long toUInt(int digit) {
        return (long)digit & 0xFFFFFFFFL;
    }

    public static byte byteToBcd(byte digit) {
        return (byte)((digit / 10 | digit % 10 << 4) & 0xFF);
    }

    public static byte bcdToByte(byte digit) {
        return (byte)((digit & 0xF) * 10 + (digit >> 4 & 0xF) & 0xFF);
    }
}

