/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractAsnEncodable;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractRemoteOperation;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ErrorCodeImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.ErrorCode;
import org.mobicents.protocols.ss7.isup.message.parameter.ErrorCodeType;
import org.mobicents.protocols.ss7.isup.message.parameter.Parameter;
import org.mobicents.protocols.ss7.isup.message.parameter.RemoteOperation;
import org.mobicents.protocols.ss7.isup.message.parameter.ReturnError;

public class ReturnErrorImpl
extends AbstractRemoteOperation
implements ReturnError {
    private Long invokeId;
    private ErrorCode errorCode;
    private Parameter parameter;

    public ReturnErrorImpl() {
        super(RemoteOperation.OperationType.ReturnError);
    }

    public void setInvokeId(Long i) {
        if (i == null || i < -128L || i > 127L) {
            throw new IllegalArgumentException("Invoke ID our of range: <-128,127>: " + i);
        }
        this.invokeId = i;
    }

    public Long getInvokeId() {
        return this.invokeId;
    }

    public void setErrorCode(ErrorCode ec) {
        this.errorCode = ec;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public void setParameter(Parameter p) {
        this.parameter = p;
    }

    public Parameter getParameter() {
        return this.parameter;
    }

    public void decode(AsnInputStream ais) throws ParameterException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 2 || localAis.getTagClass() != 0) {
                throw new ParameterException("Error while decoding Invoke: bad tag or tag class for InvokeID: tag=" + tag + ", tagClass = " + localAis.getTagClass());
            }
            this.invokeId = localAis.readInteger();
            if (localAis.available() == 0) {
                return;
            }
            while (localAis.available() > 0) {
                tag = localAis.readTag();
                ErrorCodeType type = null;
                switch (tag) {
                    case 6: {
                        type = ErrorCodeType.Global;
                    }
                    case 2: {
                        if (this.errorCode != null) {
                            throw new ParameterException();
                        }
                        if (localAis.getTagClass() != 0) {
                            throw new ParameterException();
                        }
                        if (type == null) {
                            type = ErrorCodeType.Local;
                        }
                        ErrorCodeImpl ec = new ErrorCodeImpl();
                        ec.setErrorCodeType(type);
                        ec.decode(localAis);
                        this.errorCode = ec;
                    }
                }
                if (this.parameter != null) {
                    throw new ParameterException();
                }
                this.parameter = new ParameterImpl(tag, localAis, true);
            }
        }
        catch (IOException e) {
            throw new ParameterException("IOException while decoding Invoke: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while decoding Invoke: " + e.getMessage(), e);
        }
    }

    public void encode(AsnOutputStream aos) throws ParameterException {
        if (this.invokeId == null) {
            throw new ParameterException("Invoke ID not set!");
        }
        try {
            aos.writeTag(2, false, 3);
            int pos = aos.StartContentDefiniteLength();
            aos.writeInteger(this.invokeId);
            if (this.errorCode != null) {
                ((AbstractAsnEncodable)((Object)this.errorCode)).encode(aos);
            }
            if (this.parameter != null) {
                ((AbstractAsnEncodable)((Object)this.parameter)).encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new ParameterException("IOException while encoding Invoke: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParameterException("AsnException while encoding Invoke: " + e.getMessage(), e);
        }
    }
}

