/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.mobicents.protocols.ss7.isup.ISUPMessageFactory;
import org.mobicents.protocols.ss7.isup.ISUPParameterFactory;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.AbstractISUPMessage;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.CircuitIdentificationCodeImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.EndOfOptionalParametersImpl;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.MessageTypeImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.CircuitIdentificationCode;
import org.mobicents.protocols.ss7.isup.message.parameter.ISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.MessageType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ISUPMessageImpl
extends AbstractISUPMessage {
    protected static final EndOfOptionalParametersImpl _END_OF_OPTIONAL_PARAMETERS = new EndOfOptionalParametersImpl();
    protected Map<Integer, ISUPParameter> f_Parameters;
    protected Map<Integer, ISUPParameter> v_Parameters;
    protected Map<Integer, ISUPParameter> o_Parameters;
    protected Set<Integer> mandatoryCodes;
    protected Set<Integer> mandatoryVariableCodes;
    protected Set<Integer> optionalCodes;
    protected Map<Integer, Integer> mandatoryCodeToIndex;
    protected Map<Integer, Integer> mandatoryVariableCodeToIndex;
    protected Map<Integer, Integer> optionalCodeToIndex;
    protected CircuitIdentificationCode cic;
    protected int sls;

    public ISUPMessageImpl(Set<Integer> mandatoryCodes, Set<Integer> mandatoryVariableCodes, Set<Integer> optionalCodes, Map<Integer, Integer> mandatoryCode2Index, Map<Integer, Integer> mandatoryVariableCode2Index, Map<Integer, Integer> optionalCode2Index) {
        this.f_Parameters = new TreeMap<Integer, ISUPParameter>();
        this.v_Parameters = new TreeMap<Integer, ISUPParameter>();
        this.o_Parameters = new TreeMap<Integer, ISUPParameter>();
        this.mandatoryCodes = mandatoryCodes;
        this.mandatoryVariableCodes = mandatoryVariableCodes;
        this.optionalCodes = optionalCodes;
        this.mandatoryCodeToIndex = mandatoryCode2Index;
        this.mandatoryVariableCodeToIndex = mandatoryVariableCode2Index;
        this.optionalCodeToIndex = optionalCode2Index;
    }

    public ISUPMessageImpl() {
    }

    @Override
    public void setSls(int sls) {
        this.sls = sls & 0xF;
    }

    @Override
    public int getSls() {
        return this.sls;
    }

    @Override
    public abstract boolean hasAllMandatoryParameters();

    @Override
    public abstract MessageType getMessageType();

    @Override
    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        this.encode(bos);
        return bos.toByteArray();
    }

    @Override
    public int encode(ByteArrayOutputStream bos) throws ParameterException {
        boolean optionalPresent = this.o_Parameters.size() > 1;
        this.encodeMandatoryParameters(this.f_Parameters, bos);
        this.encodeMandatoryVariableParameters(this.v_Parameters, bos, optionalPresent);
        if (optionalPresent) {
            this.encodeOptionalParameters(this.o_Parameters, bos);
        }
        return bos.size();
    }

    protected void encodeMandatoryParameters(Map<Integer, ISUPParameter> parameters, ByteArrayOutputStream bos) throws ParameterException {
        if (this.cic == null) {
            throw new ParameterException("CIC is not set!");
        }
        ((AbstractISUPParameter)((Object)this.cic)).encode(bos);
        for (ISUPParameter p : parameters.values()) {
            ((AbstractISUPParameter)p).encode(bos);
        }
    }

    protected void encodeMandatoryVariableParameters(Map<Integer, ISUPParameter> parameters, ByteArrayOutputStream bos, boolean isOptionalPartPresent) throws ParameterException {
        try {
            byte[] pointers = null;
            if (!this.mandatoryVariablePartPossible()) {
                if (this.optionalPartIsPossible()) {
                    pointers = isOptionalPartPresent ? new byte[]{1} : new byte[]{0};
                    bos.write(pointers);
                }
            } else {
                pointers = this.optionalPartIsPossible() ? new byte[parameters.size() + 1] : new byte[parameters.size()];
                ByteArrayOutputStream parametersBodyBOS = new ByteArrayOutputStream();
                byte lastParameterLength = 0;
                byte currentParameterLength = 0;
                for (int index = 0; index < parameters.size(); ++index) {
                    AbstractISUPParameter p = (AbstractISUPParameter)parameters.get(index);
                    byte[] body = p.encode();
                    currentParameterLength = (byte)body.length;
                    if (body.length > 255) {
                        throw new ParameterException("Length of body must not be greater than one octet - 255 ");
                    }
                    if (index == 0) {
                        lastParameterLength = currentParameterLength;
                        pointers[index] = (byte)(parameters.size() + (this.optionalPartIsPossible() ? 1 : 0));
                    } else {
                        pointers[index] = (byte)(pointers[index - 1] + lastParameterLength);
                        lastParameterLength = currentParameterLength;
                    }
                    parametersBodyBOS.write(currentParameterLength);
                    parametersBodyBOS.write(body);
                }
                if (this.optionalPartIsPossible() && isOptionalPartPresent) {
                    pointers[pointers.length - 1] = (byte)(pointers[pointers.length - 2] + lastParameterLength);
                }
                bos.write(pointers);
                bos.write(parametersBodyBOS.toByteArray());
            }
        }
        catch (ParameterException pe) {
            throw pe;
        }
        catch (Exception e) {
            throw new ParameterException(e);
        }
    }

    protected void encodeOptionalParameters(Map<Integer, ISUPParameter> parameters, ByteArrayOutputStream bos) throws ParameterException {
        for (ISUPParameter p : parameters.values()) {
            if (p == null) continue;
            byte[] b = ((AbstractISUPParameter)p).encode();
            if (b.length > 255) {
                throw new ParameterException("Parameter length is over 255: " + p);
            }
            if (!(p instanceof EndOfOptionalParametersImpl)) {
                bos.write(p.getCode());
                bos.write(b.length);
            }
            try {
                bos.write(b);
            }
            catch (IOException e) {
                throw new ParameterException("Failed to encode optional parameters.", e);
            }
        }
    }

    @Override
    public int decode(byte[] b, ISUPMessageFactory messageFactory, ISUPParameterFactory parameterFactory) throws ParameterException {
        int index = 0;
        index += this.decodeMandatoryParameters(parameterFactory, b, index);
        if (this.mandatoryVariablePartPossible()) {
            index += this.decodeMandatoryVariableParameters(parameterFactory, b, index);
        }
        if (!this.optionalPartIsPossible() || b.length == index || b[index] == 0) {
            return index;
        }
        index += b[index];
        index += this.decodeOptionalParameters(parameterFactory, b, index);
        return index;
    }

    protected int decodeMandatoryParameters(ISUPParameterFactory parameterFactory, byte[] b, int index) throws ParameterException {
        int localIndex = index;
        if (b.length - index >= 3) {
            try {
                byte[] cic = new byte[]{b[index++], b[index++]};
                this.cic = new CircuitIdentificationCodeImpl();
                ((AbstractISUPParameter)((Object)this.cic)).decode(cic);
            }
            catch (Exception e) {
                throw new ParameterException("Failed to parse CircuitIdentificationCode due to: ", e);
            }
            try {
                if (b[index] != this.getMessageType().getCode()) {
                    throw new ParameterException("Message code is not: " + this.getMessageType().getCode());
                }
            }
            catch (Exception e) {
                throw new ParameterException("Failed to parse MessageCode due to: ", e);
            }
            return ++index - localIndex;
        }
        throw new IllegalArgumentException("byte[] must have atleast three octets");
    }

    protected int decodeMandatoryVariableParameters(ISUPParameterFactory parameterFactory, byte[] b, int index) throws ParameterException {
        int readCount = 0;
        if (b.length - index > 0) {
            int extPIndex = -1;
            try {
                int count;
                readCount = count = this.getNumberOfMandatoryVariableLengthParameters();
                for (int parameterIndex = 0; parameterIndex < count; ++parameterIndex) {
                    int lengthPointerIndex = index + parameterIndex;
                    int parameterLengthIndex = b[lengthPointerIndex] + lengthPointerIndex;
                    byte parameterLength = b[parameterLengthIndex];
                    byte[] parameterBody = new byte[parameterLength];
                    System.arraycopy(b, parameterLengthIndex + 1, parameterBody, 0, parameterLength);
                    this.decodeMandatoryVariableBody(parameterFactory, parameterBody, parameterIndex);
                }
            }
            catch (ArrayIndexOutOfBoundsException aioobe) {
                throw new ParameterException("Failed to read parameter, to few octets in buffer, parameter index: " + extPIndex, aioobe);
            }
            catch (IllegalArgumentException e) {
                throw new ParameterException("Failed to parse, paramet index: " + extPIndex, e);
            }
        } else {
            throw new ParameterException("To few bytes to decode mandatory variable part. There should be atleast on byte to indicate optional part.");
        }
        return readCount;
    }

    protected int decodeOptionalParameters(ISUPParameterFactory parameterFactory, byte[] b, int index) throws ParameterException {
        int localIndex = index;
        int readCount = 0;
        if (b.length - index > 0) {
            boolean readParameter = true;
            while (readParameter) {
                if (b.length - localIndex <= 0 || b[localIndex] == 0) {
                    readParameter = false;
                    continue;
                }
                readParameter = true;
                byte extPCode = -1;
                int assumedParameterLength = -1;
                try {
                    int parameterLength;
                    byte parameterCode;
                    extPCode = parameterCode = b[localIndex++];
                    assumedParameterLength = parameterLength = b[localIndex++];
                    byte[] parameterBody = new byte[parameterLength];
                    System.arraycopy(b, localIndex, parameterBody, 0, parameterLength);
                    readCount += 2 + parameterLength;
                    this.decodeOptionalBody(parameterFactory, parameterBody, parameterCode);
                    if (b.length - (localIndex += parameterLength) > 0 && b[localIndex] != 0) {
                        readParameter = true;
                        continue;
                    }
                    readParameter = false;
                }
                catch (ArrayIndexOutOfBoundsException aioobe) {
                    throw new ParameterException("Failed to read parameter, to few octets in buffer, parameter code: " + extPCode + ", assumed length: " + assumedParameterLength, aioobe);
                }
                catch (IllegalArgumentException e) {
                    throw new ParameterException("Failed to parse parameter: " + extPCode, e);
                }
            }
        }
        return readCount;
    }

    protected abstract void decodeMandatoryVariableBody(ISUPParameterFactory var1, byte[] var2, int var3) throws ParameterException;

    protected abstract void decodeOptionalBody(ISUPParameterFactory var1, byte[] var2, byte var3) throws ParameterException;

    protected abstract int getNumberOfMandatoryVariableLengthParameters();

    protected abstract boolean optionalPartIsPossible();

    protected boolean mandatoryVariablePartPossible() {
        return this.getNumberOfMandatoryVariableLengthParameters() != 0;
    }

    @Override
    public void addParameter(ISUPParameter param) throws ParameterException {
        if (param == null) {
            throw new IllegalArgumentException("Argument must not be null");
        }
        int paramCode = param.getCode();
        if (this.mandatoryCodes.contains(paramCode)) {
            int index = this.mandatoryCodeToIndex.get(paramCode);
            this.f_Parameters.put(index, (AbstractISUPParameter)param);
            return;
        }
        if (this.mandatoryVariableCodes.contains(paramCode)) {
            int index = this.mandatoryVariableCodeToIndex.get(paramCode);
            this.v_Parameters.put(index, (AbstractISUPParameter)param);
            return;
        }
        if (this.optionalCodes.contains(paramCode)) {
            int index = this.optionalCodeToIndex.get(paramCode);
            this.o_Parameters.put(index, (AbstractISUPParameter)param);
            return;
        }
        throw new ParameterException("Parameter with code: " + paramCode + " is not defined in any type: mandatory, mandatory variable or optional");
    }

    @Override
    public ISUPParameter getParameter(int parameterCode) throws ParameterException {
        if (this.mandatoryCodes.contains(parameterCode)) {
            int index = this.mandatoryCodeToIndex.get(parameterCode);
            return this.f_Parameters.get(index);
        }
        if (this.mandatoryVariableCodes.contains(parameterCode)) {
            int index = this.mandatoryVariableCodeToIndex.get(parameterCode);
            return this.v_Parameters.get(index);
        }
        if (this.optionalCodes.contains(parameterCode)) {
            int index = this.optionalCodeToIndex.get(parameterCode);
            return this.o_Parameters.get(index);
        }
        throw new ParameterException("Parameter with code: " + parameterCode + " is not defined in any type: mandatory, mandatory variable or optional");
    }

    @Override
    public void removeParameter(int parameterCode) throws ParameterException {
        int index;
        if (this.mandatoryCodes.contains(parameterCode)) {
            index = this.mandatoryCodeToIndex.get(parameterCode);
            this.f_Parameters.remove(index);
        }
        if (this.mandatoryVariableCodes.contains(parameterCode)) {
            index = this.mandatoryVariableCodeToIndex.get(parameterCode);
            this.v_Parameters.remove(index);
        }
        if (this.optionalCodes.contains(parameterCode)) {
            index = this.optionalCodeToIndex.get(parameterCode);
            this.o_Parameters.remove(index);
        }
        throw new ParameterException("Parameter with code: " + parameterCode + " is not defined in any type: mandatory, mandatory variable or optional");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ISUPMessage [\n===");
        sb.append(this.getMessageType().getMessageName().toString());
        sb.append(", code=");
        sb.append(this.getMessageType().getCode());
        sb.append("\nF: [");
        boolean i1 = false;
        for (ISUPParameter p : this.f_Parameters.values()) {
            if (p instanceof MessageTypeImpl) continue;
            if (!i1) {
                i1 = true;
            } else {
                sb.append("\n  ");
            }
            sb.append("==");
            sb.append(p);
        }
        sb.append("]\nV: [");
        i1 = false;
        for (ISUPParameter p : this.v_Parameters.values()) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append("\n  ");
            }
            sb.append("==");
            sb.append(p);
        }
        sb.append("]\nO: [");
        i1 = false;
        for (ISUPParameter p : this.o_Parameters.values()) {
            if (p instanceof EndOfOptionalParametersImpl) continue;
            if (!i1) {
                i1 = true;
            } else {
                sb.append("\n  ");
            }
            sb.append("==");
            sb.append(p);
        }
        sb.append("]]");
        return sb.toString();
    }

    @Override
    public CircuitIdentificationCode getCircuitIdentificationCode() {
        return this.cic;
    }

    @Override
    public void setCircuitIdentificationCode(CircuitIdentificationCode cic) {
        this.cic = cic;
    }
}

