/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.dialog;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPUserAbortReason;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;

public class CAPUserAbortPrimitiveImpl
implements CAPAsnPrimitive {
    public static final long[] CAP_AbortReason_OId = new long[]{0L, 4L, 0L, 0L, 1L, 1L, 2L, 2L};
    private CAPUserAbortReason reason;

    public CAPUserAbortPrimitiveImpl() {
    }

    public CAPUserAbortPrimitiveImpl(CAPUserAbortReason reason) {
        this.reason = reason;
    }

    public CAPUserAbortReason getCAPUserAbortReason() {
        return this.reason;
    }

    public int getTag() throws CAPException {
        return 10;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPUserAbortPrimitive: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPUserAbortPrimitive: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CAPUserAbortPrimitive: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CAPUserAbortPrimitive: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws CAPParsingComponentException, IOException, AsnException {
        int code = (int)ais.readIntegerData(length);
        this.reason = CAPUserAbortReason.getInstance(code);
        if (this.reason == null) {
            this.reason = CAPUserAbortReason.no_reason_given;
        }
        if (ais.available() > 0) {
            throw new AsnException("Too much source data");
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, 0, 10);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CAPUserAbortPrimitive: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.reason == null) {
            throw new CAPException("reason field must not be empty");
        }
        try {
            aos.writeIntegerData(this.reason.getCode());
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding CAPUserAbortPrimitive: " + e.getMessage(), e);
        }
    }
}

