/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.mobicents.protocols.ss7.sccp.SccpProtocolVersion;
import org.mobicents.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCause;
import org.mobicents.protocols.ss7.sccp.parameter.ReturnCauseValue;

public class ReturnCauseImpl
extends AbstractParameter
implements ReturnCause {
    private ReturnCauseValue value;
    private int digValue;

    public ReturnCauseImpl() {
        this.value = ReturnCauseValue.UNQALIFIED;
    }

    public ReturnCauseImpl(ReturnCauseValue value) {
        this.value = value;
        if (value != null) {
            this.digValue = value.getValue();
        }
    }

    public ReturnCauseImpl(int digValue) {
        this.digValue = digValue;
        this.value = ReturnCauseValue.getInstance(digValue);
    }

    public ReturnCauseValue getValue() {
        return this.value;
    }

    public int getDigitalValue() {
        return this.digValue;
    }

    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (in.read() != 1) {
                throw new ParseException();
            }
            this.digValue = in.read() & 0xFF;
            this.value = ReturnCauseValue.getInstance(this.digValue);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void encode(OutputStream out, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            out.write(1);
            out.write(this.digValue);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public void decode(byte[] bb, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        this.digValue = bb[0] & 0xFF;
        this.value = ReturnCauseValue.getInstance(this.digValue);
    }

    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)this.digValue};
    }

    public String toString() {
        if (this.value != null) {
            return this.value.toString();
        }
        return Integer.valueOf(this.digValue).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.digValue;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ReturnCauseImpl other = (ReturnCauseImpl)obj;
        return this.digValue == other.digValue;
    }
}

