/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.sms;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MWStatus;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.sms.MWStatusImpl;
import org.mobicents.protocols.ss7.map.service.sms.SmsMessageImpl;

public class InformServiceCentreRequestImpl
extends SmsMessageImpl
implements InformServiceCentreRequest {
    protected static final int _TAG_AdditionalAbsentSubscriberDiagnosticSM = 0;
    private ISDNAddressString storedMSISDN;
    private MWStatus mwStatus;
    private MAPExtensionContainer extensionContainer;
    private Integer absentSubscriberDiagnosticSM;
    private Integer additionalAbsentSubscriberDiagnosticSM;

    public InformServiceCentreRequestImpl() {
    }

    public InformServiceCentreRequestImpl(ISDNAddressString storedMSISDN, MWStatus mwStatus, MAPExtensionContainer extensionContainer, Integer absentSubscriberDiagnosticSM, Integer additionalAbsentSubscriberDiagnosticSM) {
        this.storedMSISDN = storedMSISDN;
        this.mwStatus = mwStatus;
        this.extensionContainer = extensionContainer;
        this.absentSubscriberDiagnosticSM = absentSubscriberDiagnosticSM;
        this.additionalAbsentSubscriberDiagnosticSM = additionalAbsentSubscriberDiagnosticSM;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.InformServiceCentre_Request;
    }

    public int getOperationCode() {
        return 63;
    }

    public ISDNAddressString getStoredMSISDN() {
        return this.storedMSISDN;
    }

    public MWStatus getMwStatus() {
        return this.mwStatus;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public Integer getAbsentSubscriberDiagnosticSM() {
        return this.absentSubscriberDiagnosticSM;
    }

    public Integer getAdditionalAbsentSubscriberDiagnosticSM() {
        return this.additionalAbsentSubscriberDiagnosticSM;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding InformServiceCentreRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding InformServiceCentreRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding InformServiceCentreRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding InformServiceCentreRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.storedMSISDN = null;
        this.mwStatus = null;
        this.extensionContainer = null;
        this.absentSubscriberDiagnosticSM = null;
        this.additionalAbsentSubscriberDiagnosticSM = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block9: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Parameter storedMSISDN is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.storedMSISDN = new ISDNAddressStringImpl();
                        ((ISDNAddressStringImpl)this.storedMSISDN).decodeAll(ais);
                        continue block9;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Parameter mw-Status is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.mwStatus = new MWStatusImpl();
                        ((MWStatusImpl)this.mwStatus).decodeAll(ais);
                        continue block9;
                    }
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding reportSMDeliveryStatusRequest: Parameter extensionContainer is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block9;
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Parameter absentSubscriberDiagnosticSM is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.absentSubscriberDiagnosticSM = (int)ais.readInteger();
                        continue block9;
                    }
                }
                ais.advanceElement();
                continue;
            }
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding informServiceCentreRequest: Parameter deliveryOutcomeIndicator is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.additionalAbsentSubscriberDiagnosticSM = (int)ais.readInteger();
                        continue block9;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, 0, 16);
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InformServiceCentreRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.storedMSISDN != null) {
            ((ISDNAddressStringImpl)this.storedMSISDN).encodeAll(asnOs);
        }
        if (this.mwStatus != null) {
            ((MWStatusImpl)this.mwStatus).encodeAll(asnOs);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
        }
        try {
            if (this.absentSubscriberDiagnosticSM != null) {
                asnOs.writeInteger(this.absentSubscriberDiagnosticSM.intValue());
            }
            if (this.additionalAbsentSubscriberDiagnosticSM != null) {
                asnOs.writeInteger(2, 0, this.additionalAbsentSubscriberDiagnosticSM.intValue());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding InformServiceCentreRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding InformServiceCentreRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("InformServiceCentreRequest [");
        if (this.getMAPDialog() != null) {
            sb.append("DialogId=").append(this.getMAPDialog().getLocalDialogId());
        }
        if (this.storedMSISDN != null) {
            sb.append(", storedMSISDN=");
            sb.append(this.storedMSISDN.toString());
        }
        if (this.mwStatus != null) {
            sb.append(", mwStatus=");
            sb.append(this.mwStatus.toString());
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer.toString());
        }
        if (this.absentSubscriberDiagnosticSM != null) {
            sb.append(", absentSubscriberDiagnosticSM=");
            sb.append(this.absentSubscriberDiagnosticSM.toString());
        }
        if (this.additionalAbsentSubscriberDiagnosticSM != null) {
            sb.append(", additionalAbsentSubscriberDiagnosticSM=");
            sb.append(this.additionalAbsentSubscriberDiagnosticSM.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

