/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.DomainType;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.RequestedInfo;
import org.mobicents.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;

public class RequestedInfoImpl
implements RequestedInfo,
MAPAsnPrimitive {
    public static final int _ID_locationInformation = 0;
    public static final int _ID_subscriberState = 1;
    public static final int _ID_extensionContainer = 2;
    public static final int _ID_currentLocation = 3;
    public static final int _ID_requestedDomain = 4;
    public static final int _ID_imei = 6;
    public static final int _ID_msclassmark = 5;
    public static final int _ID_mnpRequestedInfo = 7;
    public static final String _PrimitiveName = "RequestedInfo";
    private boolean locationInformation;
    private boolean subscriberState;
    private MAPExtensionContainer extensionContainer;
    private boolean currentLocation;
    private DomainType requestedDomain;
    private boolean imei;
    private boolean msClassmark;
    private boolean mnpRequestedInfo;

    public RequestedInfoImpl() {
    }

    public RequestedInfoImpl(boolean locationInformation, boolean subscriberState, MAPExtensionContainer extensionContainer, boolean currentLocation, DomainType requestedDomain, boolean imei, boolean msClassmark, boolean mnpRequestedInfo) {
        this.locationInformation = locationInformation;
        this.subscriberState = subscriberState;
        this.extensionContainer = extensionContainer;
        this.currentLocation = currentLocation;
        this.requestedDomain = requestedDomain;
        this.imei = imei;
        this.msClassmark = msClassmark;
        this.mnpRequestedInfo = mnpRequestedInfo;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RequestedInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RequestedInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding RequestedInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding RequestedInfo: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        this.locationInformation = false;
        this.subscriberState = false;
        this.extensionContainer = null;
        this.currentLocation = false;
        this.requestedDomain = null;
        this.imei = false;
        this.msClassmark = false;
        this.mnpRequestedInfo = false;
        block10: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.locationInformation = Boolean.TRUE;
                        continue block10;
                    }
                    case 1: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.subscriberState = Boolean.TRUE;
                        continue block10;
                    }
                    case 2: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensionContainer = new MAPExtensionContainerImpl();
                        ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                        continue block10;
                    }
                    case 3: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.currentLocation = Boolean.TRUE;
                        continue block10;
                    }
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.requestedDomain = DomainType.getInstance(i1);
                        continue block10;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.msClassmark = Boolean.TRUE;
                        continue block10;
                    }
                    case 6: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.imei = Boolean.TRUE;
                        continue block10;
                    }
                    case 7: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding RequestedInfo: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        ais.readNull();
                        this.mnpRequestedInfo = Boolean.TRUE;
                        continue block10;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding RequestedInfo: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.locationInformation) {
                asnOs.writeNull(2, 0);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter locationInformation: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter locationInformation: ", e);
        }
        try {
            if (this.subscriberState) {
                asnOs.writeNull(2, 1);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter subscriberState: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter subscriberState: ", e);
        }
        if (this.extensionContainer != null) {
            ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
        }
        try {
            if (this.currentLocation) {
                asnOs.writeNull(2, 3);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter currentLocation: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter currentLocation: ", e);
        }
        try {
            if (this.requestedDomain != null) {
                asnOs.writeInteger(2, 4, this.requestedDomain.getType());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter requestedDomain: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter requestedDomain: ", e);
        }
        try {
            if (this.imei) {
                asnOs.writeNull(2, 6);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter imei: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter imei: ", e);
        }
        try {
            if (this.msClassmark) {
                asnOs.writeNull(2, 5);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter msClassmark: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter msClassmark: ", e);
        }
        try {
            if (this.mnpRequestedInfo) {
                asnOs.writeNull(2, 7);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding parameter mnpRequestedInfo: ", e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding parameter mnpRequestedInfo: ", e);
        }
    }

    public boolean getLocationInformation() {
        return this.locationInformation;
    }

    public boolean getSubscriberState() {
        return this.subscriberState;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public boolean getCurrentLocation() {
        return this.currentLocation;
    }

    public DomainType getRequestedDomain() {
        return this.requestedDomain;
    }

    public boolean getImei() {
        return this.imei;
    }

    public boolean getMsClassmark() {
        return this.msClassmark;
    }

    public boolean getMnpRequestedInfo() {
        return this.mnpRequestedInfo;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.locationInformation) {
            sb.append(", locationInformation");
        }
        if (this.subscriberState) {
            sb.append(", subscriberState");
        }
        if (this.extensionContainer != null) {
            sb.append(", extensionContainer=");
            sb.append(this.extensionContainer);
        }
        if (this.currentLocation) {
            sb.append(", currentLocation");
        }
        if (this.requestedDomain != null) {
            sb.append(", requestedDomain=");
            sb.append((Object)this.requestedDomain);
        }
        if (this.imei) {
            sb.append(", imei");
        }
        if (this.msClassmark) {
            sb.append(", msClassmark");
        }
        if (this.mnpRequestedInfo) {
            sb.append(", mnpRequestedInfo");
        }
        sb.append("]");
        return sb.toString();
    }
}

