/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.parameter;

import java.nio.ByteBuffer;
import javolution.text.TextBuilder;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.LocalRKIdentifierImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.RegistrationStatusImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.RoutingContextImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.LocalRKIdentifier;
import org.mobicents.protocols.ss7.m3ua.parameter.RegistrationResult;
import org.mobicents.protocols.ss7.m3ua.parameter.RegistrationStatus;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;

public class RegistrationResultImpl
extends ParameterImpl
implements RegistrationResult {
    private LocalRKIdentifier localRKId;
    private RegistrationStatus status;
    private RoutingContext rc;
    private ByteBuffer buffer = ByteBuffer.allocate(24);
    private byte[] value;

    public RegistrationResultImpl(byte[] data) {
        this.tag = (short)520;
        block5: for (int pos = 0; pos < data.length; pos += pos % 4) {
            short tag = (short)((data[pos] & 0xFF) << 8 | data[pos + 1] & 0xFF);
            short len = (short)((data[pos + 2] & 0xFF) << 8 | data[pos + 3] & 0xFF);
            byte[] value = new byte[len - 4];
            System.arraycopy(data, pos + 4, value, 0, value.length);
            pos += len;
            switch (tag) {
                case 522: {
                    this.localRKId = new LocalRKIdentifierImpl(value);
                    continue block5;
                }
                case 6: {
                    this.rc = new RoutingContextImpl(value);
                    continue block5;
                }
                case 530: {
                    this.status = new RegistrationStatusImpl(value);
                }
            }
        }
    }

    public RegistrationResultImpl(LocalRKIdentifier localRKId, RegistrationStatus status, RoutingContext rc) {
        this.tag = (short)520;
        this.localRKId = localRKId;
        this.status = status;
        this.rc = rc;
        this.encode();
    }

    private void encode() {
        ((LocalRKIdentifierImpl)this.localRKId).write(this.buffer);
        ((RoutingContextImpl)this.rc).write(this.buffer);
        ((RegistrationStatusImpl)this.status).write(this.buffer);
        this.value = this.buffer.array();
    }

    @Override
    protected byte[] getValue() {
        return this.value;
    }

    @Override
    public LocalRKIdentifier getLocalRKIdentifier() {
        return this.localRKId;
    }

    @Override
    public RegistrationStatus getRegistrationStatus() {
        return this.status;
    }

    @Override
    public RoutingContext getRoutingContext() {
        return this.rc;
    }

    public String toString() {
        TextBuilder tb = TextBuilder.newInstance();
        tb.append("RegistrationResult(");
        if (this.localRKId != null) {
            tb.append(this.localRKId.toString());
        }
        if (this.status != null) {
            tb.append(this.status.toString());
        }
        if (this.rc != null) {
            tb.append(this.rc.toString());
        }
        tb.append(")");
        return tb.toString();
    }
}

