/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl.message;

import java.nio.ByteBuffer;
import org.mobicents.protocols.ss7.m3ua.impl.message.M3UAMessageImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPDownAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPDownImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPUpAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.ASPUpImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.HeartbeatAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.aspsm.HeartbeatImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPActiveAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPActiveImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPInactiveAckImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.asptm.ASPInactiveImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.mgmt.ErrorImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.mgmt.NotifyImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.DeregistrationRequestImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.DeregistrationResponseImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.RegistrationRequestImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.rkm.RegistrationResponseImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationAvailableImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationRestrictedImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationStateAuditImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationUPUnavailableImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.DestinationUnavailableImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.ssnm.SignallingCongestionImpl;
import org.mobicents.protocols.ss7.m3ua.impl.message.transfer.PayloadDataImpl;
import org.mobicents.protocols.ss7.m3ua.message.MessageFactory;

public class MessageFactoryImpl
implements MessageFactory {
    private byte[] header = new byte[8];
    private byte[] params;
    private int pos = 0;
    private boolean isHeaderReady = false;
    private int length;
    private M3UAMessageImpl message;

    @Override
    public M3UAMessageImpl createMessage(int messageClass, int messageType) {
        switch (messageClass) {
            case 1: {
                switch (messageType) {
                    case 1: {
                        return new PayloadDataImpl();
                    }
                }
                break;
            }
            case 2: {
                switch (messageType) {
                    case 1: {
                        return new DestinationUnavailableImpl();
                    }
                    case 2: {
                        return new DestinationAvailableImpl();
                    }
                    case 3: {
                        return new DestinationStateAuditImpl();
                    }
                    case 4: {
                        return new SignallingCongestionImpl();
                    }
                    case 5: {
                        return new DestinationUPUnavailableImpl();
                    }
                    case 6: {
                        return new DestinationRestrictedImpl();
                    }
                }
                break;
            }
            case 3: {
                switch (messageType) {
                    case 1: {
                        return new ASPUpImpl();
                    }
                    case 4: {
                        return new ASPUpAckImpl();
                    }
                    case 2: {
                        return new ASPDownImpl();
                    }
                    case 5: {
                        return new ASPDownAckImpl();
                    }
                    case 3: {
                        return new HeartbeatImpl();
                    }
                    case 6: {
                        return new HeartbeatAckImpl();
                    }
                }
                break;
            }
            case 4: {
                switch (messageType) {
                    case 1: {
                        return new ASPActiveImpl();
                    }
                    case 3: {
                        return new ASPActiveAckImpl();
                    }
                    case 2: {
                        return new ASPInactiveImpl();
                    }
                    case 4: {
                        return new ASPInactiveAckImpl();
                    }
                }
                break;
            }
            case 9: {
                switch (messageType) {
                    case 1: {
                        return new RegistrationRequestImpl();
                    }
                    case 2: {
                        return new RegistrationResponseImpl();
                    }
                    case 3: {
                        return new DeregistrationRequestImpl();
                    }
                    case 4: {
                        return new DeregistrationResponseImpl();
                    }
                }
            }
            case 0: {
                switch (messageType) {
                    case 0: {
                        return new ErrorImpl();
                    }
                    case 1: {
                        return new NotifyImpl();
                    }
                }
            }
        }
        return null;
    }

    @Override
    public M3UAMessageImpl createMessage(ByteBuffer buffer) {
        int len;
        if (!this.isHeaderReady) {
            len = Math.min(this.header.length - this.pos, buffer.remaining());
            buffer.get(this.header, this.pos, len);
            this.pos += len;
            boolean bl = this.isHeaderReady = this.pos == this.header.length;
            if (!this.isHeaderReady) {
                return null;
            }
            int messageClass = this.header[2] & 0xFF;
            int messageType = this.header[3] & 0xFF;
            this.message = this.createMessage(messageClass, messageType);
            this.length = ((this.header[4] & 0xFF) << 24 | (this.header[5] & 0xFF) << 16 | (this.header[6] & 0xFF) << 8 | this.header[7] & 0xFF) - 8;
            if (this.length == 0) {
                this.pos = 0;
                this.isHeaderReady = false;
                return this.message;
            }
            this.params = new byte[this.length];
            this.pos = 0;
        }
        if (!buffer.hasRemaining()) {
            return null;
        }
        len = Math.min(this.params.length - this.pos, buffer.remaining());
        buffer.get(this.params, this.pos, len);
        this.pos += len;
        if (this.pos < this.params.length) {
            return null;
        }
        this.message.decode(this.params);
        this.isHeaderReady = false;
        this.pos = 0;
        return this.message;
    }

    @Override
    public M3UAMessageImpl createSctpMessage(byte[] buffer) {
        if (buffer.length < 8) {
            return null;
        }
        int messageClass = buffer[2] & 0xFF;
        int messageType = buffer[3] & 0xFF;
        M3UAMessageImpl messageTemp = this.createMessage(messageClass, messageType);
        int dataLen = ((buffer[4] & 0xFF) << 24 | (buffer[5] & 0xFF) << 16 | (buffer[6] & 0xFF) << 8 | buffer[7] & 0xFF) - 8;
        if (buffer.length >= dataLen - 8) {
            messageTemp.decode(buffer, 8);
        }
        return messageTemp;
    }
}

