/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.isup;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.isup.OriginalCalledNumberCap;
import org.mobicents.protocols.ss7.cap.primitives.CAPAsnPrimitive;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.OriginalCalledNumberImpl;
import org.mobicents.protocols.ss7.isup.message.parameter.OriginalCalledNumber;

public class OriginalCalledNumberCapImpl
implements OriginalCalledNumberCap,
CAPAsnPrimitive {
    public static final String _PrimitiveName = "OriginalCalledNumberCap";
    private static final String ISUP_ORIGINAL_CALLED_NUMBER_XML = "isupOriginalCalledNumber";
    private byte[] data;
    protected static final XMLFormat<OriginalCalledNumberCapImpl> ORIGINAL_CALLED_NUMBER_CAP_XML = new XMLFormat<OriginalCalledNumberCapImpl>(OriginalCalledNumberCapImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, OriginalCalledNumberCapImpl originalCalledNumber) throws XMLStreamException {
            try {
                originalCalledNumber.setOriginalCalledNumber(xml.get(OriginalCalledNumberCapImpl.ISUP_ORIGINAL_CALLED_NUMBER_XML, OriginalCalledNumberImpl.class));
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }

        @Override
        public void write(OriginalCalledNumberCapImpl originalCalledNumber, XMLFormat.OutputElement xml) throws XMLStreamException {
            try {
                xml.add((OriginalCalledNumberImpl)originalCalledNumber.getOriginalCalledNumber(), OriginalCalledNumberCapImpl.ISUP_ORIGINAL_CALLED_NUMBER_XML, OriginalCalledNumberImpl.class);
            }
            catch (CAPException e) {
                throw new XMLStreamException(e);
            }
        }
    };

    public OriginalCalledNumberCapImpl() {
    }

    public OriginalCalledNumberCapImpl(byte[] data) {
        this.data = data;
    }

    public OriginalCalledNumberCapImpl(OriginalCalledNumber originalCalledNumber) throws CAPException {
        this.setOriginalCalledNumber(originalCalledNumber);
    }

    public void setOriginalCalledNumber(OriginalCalledNumber originalCalledNumber) throws CAPException {
        if (originalCalledNumber == null) {
            throw new CAPException("The originalCalledNumber parameter must not be null");
        }
        try {
            this.data = ((OriginalCalledNumberImpl)originalCalledNumber).encode();
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when encoding originalCalledNumber: " + e.getMessage(), e);
        }
    }

    public byte[] getData() {
        return this.data;
    }

    public OriginalCalledNumber getOriginalCalledNumber() throws CAPException {
        if (this.data == null) {
            throw new CAPException("The data has not been filled");
        }
        try {
            OriginalCalledNumberImpl ocn = new OriginalCalledNumberImpl();
            ocn.decode(this.data);
            return ocn;
        }
        catch (ParameterException e) {
            throw new CAPException("ParameterException when decoding OriginalCalledNumber: " + e.getMessage(), e);
        }
    }

    public int getTag() throws CAPException {
        return 4;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding OriginalCalledNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding OriginalCalledNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding OriginalCalledNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding OriginalCalledNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding OriginalCalledNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (CAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding OriginalCalledNumberCap: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.data = ansIS.readOctetStringData(length);
        if (this.data.length < 2 || this.data.length > 10) {
            throw new CAPParsingComponentException("Error while decoding OriginalCalledNumberCap: data must be from 2 to 10 bytes length, found: " + this.data.length, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding OriginalCalledNumberCap: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.data == null) {
            throw new CAPException("data field must not be null");
        }
        if (this.data.length < 2 && this.data.length > 10) {
            throw new CAPException("data field length must be from 2 to 10");
        }
        asnOs.writeOctetStringData(this.data);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.data != null) {
            sb.append("data=[");
            sb.append(this.printDataArr(this.data));
            sb.append("]");
            try {
                OriginalCalledNumber ocn = this.getOriginalCalledNumber();
                sb.append(", ");
                sb.append(ocn.toString());
            }
            catch (CAPException cAPException) {
                // empty catch block
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

