/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map;

import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.api.MAPApplicationContext;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPServiceBase;
import org.mobicents.protocols.ss7.map.api.dialog.MAPDialogState;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.dialog.Reason;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.errors.MAPErrorMessageImpl;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.api.MessageType;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.Parameter;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;

public abstract class MAPDialogImpl
implements MAPDialog {
    private static final Logger logger = Logger.getLogger(MAPDialogImpl.class);
    protected Dialog tcapDialog = null;
    protected MAPProviderImpl mapProviderImpl = null;
    protected MAPServiceBase mapService = null;
    protected MAPApplicationContext appCntx;
    protected AddressString destReference;
    protected AddressString origReference;
    protected MAPExtensionContainer extContainer = null;
    protected AddressString receivedOrigReference;
    protected AddressString receivedDestReference;
    protected MAPExtensionContainer receivedExtensionContainer;
    protected MAPDialogState state = MAPDialogState.IDLE;
    protected boolean eriStyle;
    protected AddressString eriMsisdn;
    protected AddressString eriVlrNo;
    private boolean returnMessageOnError = false;
    protected MessageType tcapMessageType;
    protected DelayedAreaState delayedAreaState;

    protected MAPDialogImpl(MAPApplicationContext appCntx, Dialog tcapDialog, MAPProviderImpl mapProviderImpl, MAPServiceBase mapService, AddressString origReference, AddressString destReference) {
        this.appCntx = appCntx;
        this.tcapDialog = tcapDialog;
        this.mapProviderImpl = mapProviderImpl;
        this.mapService = mapService;
        this.destReference = destReference;
        this.origReference = origReference;
    }

    public void setReturnMessageOnError(boolean val) {
        this.returnMessageOnError = val;
    }

    public boolean getReturnMessageOnError() {
        return this.returnMessageOnError;
    }

    public SccpAddress getLocalAddress() {
        return this.tcapDialog.getLocalAddress();
    }

    public void setLocalAddress(SccpAddress localAddress) {
        this.tcapDialog.setLocalAddress(localAddress);
    }

    public SccpAddress getRemoteAddress() {
        return this.tcapDialog.getRemoteAddress();
    }

    public void setRemoteAddress(SccpAddress remoteAddress) {
        this.tcapDialog.setRemoteAddress(remoteAddress);
    }

    public MessageType getTCAPMessageType() {
        return this.tcapMessageType;
    }

    public int getNetworkId() {
        return this.tcapDialog.getNetworkId();
    }

    public void setNetworkId(int networkId) {
        this.tcapDialog.setNetworkId(networkId);
    }

    public void keepAlive() {
        this.tcapDialog.keepAlive();
    }

    public Long getLocalDialogId() {
        return this.tcapDialog.getLocalDialogId();
    }

    public Long getRemoteDialogId() {
        return this.tcapDialog.getRemoteDialogId();
    }

    public MAPServiceBase getService() {
        return this.mapService;
    }

    public Dialog getTcapDialog() {
        return this.tcapDialog;
    }

    public void release() {
        this.setState(MAPDialogState.EXPUNGED);
        if (this.tcapDialog != null) {
            this.tcapDialog.release();
        }
    }

    public void setExtentionContainer(MAPExtensionContainer extContainer) {
        this.extContainer = extContainer;
    }

    public AddressString getReceivedOrigReference() {
        return this.receivedOrigReference;
    }

    public MAPExtensionContainer getReceivedExtensionContainer() {
        return this.receivedExtensionContainer;
    }

    public AddressString getReceivedDestReference() {
        return this.receivedDestReference;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void abort(MAPUserAbortChoice mapUserAbortChoice) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().getDialogLock().lock();
            if (this.getState() == MAPDialogState.EXPUNGED || this.getState() == MAPDialogState.IDLE) {
                this.setState(MAPDialogState.EXPUNGED);
                return;
            }
            this.mapProviderImpl.fireTCAbortUser(this.getTcapDialog(), mapUserAbortChoice, this.extContainer, this.getReturnMessageOnError());
            this.extContainer = null;
            this.setState(MAPDialogState.EXPUNGED);
        }
        finally {
            this.getTcapDialog().getDialogLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refuse(Reason reason) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().getDialogLock().lock();
            if (this.getState() != MAPDialogState.INITIAL_RECEIVED) {
                throw new MAPException("Refuse can be called in the Dialog InitialReceived state");
            }
            this.mapProviderImpl.fireTCAbortRefused(this.getTcapDialog(), reason, this.extContainer, this.getReturnMessageOnError());
            this.extContainer = null;
            this.setState(MAPDialogState.EXPUNGED);
        }
        finally {
            this.getTcapDialog().getDialogLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void close(boolean prearrangedEnd) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().getDialogLock().lock();
            switch (this.tcapDialog.getState()) {
                case InitialReceived: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.mapProviderImpl.fireTCEnd(this.getTcapDialog(), true, prearrangedEnd, acn, this.extContainer, this.getReturnMessageOnError());
                    this.extContainer = null;
                    this.setState(MAPDialogState.EXPUNGED);
                    return;
                }
                case Active: {
                    this.mapProviderImpl.fireTCEnd(this.getTcapDialog(), false, prearrangedEnd, null, null, this.getReturnMessageOnError());
                    this.setState(MAPDialogState.EXPUNGED);
                    return;
                }
                case Idle: {
                    throw new MAPException("Awaiting TC-BEGIN to be sent, can not send another dialog initiating primitive!");
                }
                case InitialSent: {
                    throw new MAPException("Awaiting TC-BEGIN response, can not send another dialog initiating primitive!");
                }
                case Expunged: {
                    throw new MAPException("Dialog has been terminated, can not send primitives!");
                }
            }
            return;
        }
        finally {
            this.getTcapDialog().getDialogLock().unlock();
        }
    }

    public void closeDelayed(boolean prearrangedEnd) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        if (this.delayedAreaState == null) {
            this.close(prearrangedEnd);
        } else if (prearrangedEnd) {
            switch (this.delayedAreaState) {
                case No: 
                case Continue: 
                case End: {
                    this.delayedAreaState = DelayedAreaState.PrearrangedEnd;
                }
            }
        } else {
            switch (this.delayedAreaState) {
                case No: 
                case Continue: {
                    this.delayedAreaState = DelayedAreaState.End;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void send() throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().getDialogLock().lock();
            switch (this.tcapDialog.getState()) {
                case Idle: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.setState(MAPDialogState.INITIAL_SENT);
                    this.mapProviderImpl.fireTCBegin(this.getTcapDialog(), acn, this.destReference, this.origReference, this.extContainer, this.eriStyle, this.eriMsisdn, this.eriVlrNo, this.getReturnMessageOnError());
                    this.extContainer = null;
                    return;
                }
                case Active: {
                    this.mapProviderImpl.fireTCContinue(this.getTcapDialog(), false, null, null, this.getReturnMessageOnError());
                    return;
                }
                case InitialReceived: {
                    ApplicationContextName acn1 = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    this.mapProviderImpl.fireTCContinue(this.getTcapDialog(), true, acn1, this.extContainer, this.getReturnMessageOnError());
                    this.extContainer = null;
                    this.setState(MAPDialogState.ACTIVE);
                    return;
                }
                case InitialSent: {
                    throw new MAPException("Awaiting TC-BEGIN response, can not send another dialog initiating primitive!");
                }
                case Expunged: {
                    throw new MAPException("Dialog has been terminated, can not send primitives!");
                }
            }
            return;
        }
        finally {
            this.getTcapDialog().getDialogLock().unlock();
        }
    }

    public void sendDelayed() throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        if (this.delayedAreaState == null) {
            this.send();
        } else {
            switch (this.delayedAreaState) {
                case No: {
                    this.delayedAreaState = DelayedAreaState.Continue;
                }
            }
        }
    }

    public MAPApplicationContext getApplicationContext() {
        return this.appCntx;
    }

    public MAPDialogState getState() {
        return this.state;
    }

    protected synchronized void setState(MAPDialogState newState) {
        if (this.state == MAPDialogState.EXPUNGED) {
            return;
        }
        this.state = newState;
    }

    public void processInvokeWithoutAnswer(Long invokeId) {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        this.tcapDialog.processInvokeWithoutAnswer(invokeId);
    }

    public void sendInvokeComponent(Invoke invoke) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.tcapDialog.sendComponent(invoke);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), e);
        }
    }

    public void sendReturnResultComponent(ReturnResult returnResult) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.tcapDialog.sendComponent(returnResult);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), e);
        }
    }

    public void sendReturnResultLastComponent(ReturnResultLast returnResultLast) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.tcapDialog.sendComponent(returnResultLast);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), e);
        }
    }

    public void sendErrorComponent(Long invokeId, MAPErrorMessage mem) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        MAPErrorMessageImpl mapErrorMessage = (MAPErrorMessageImpl)mem;
        ReturnError returnError = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCReturnErrorRequest();
        try {
            returnError.setInvokeId(invokeId);
            ErrorCode ec = TcapFactory.createErrorCode();
            ec.setLocalErrorCode(mapErrorMessage.getErrorCode());
            returnError.setErrorCode(ec);
            AsnOutputStream aos = new AsnOutputStream();
            mapErrorMessage.encodeData(aos);
            byte[] buf = aos.toByteArray();
            if (buf.length != 0) {
                Parameter p = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createParameter();
                p.setTagClass(mapErrorMessage.getTagClass());
                p.setPrimitive(mapErrorMessage.getIsPrimitive());
                p.setTag(mapErrorMessage.getTag());
                p.setData(buf);
                returnError.setParameter(p);
            }
            this.tcapDialog.sendComponent(returnError);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), e);
        }
    }

    public void sendRejectComponent(Long invokeId, Problem problem) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        Reject reject = this.mapProviderImpl.getTCAPProvider().getComponentPrimitiveFactory().createTCRejectRequest();
        try {
            reject.setInvokeId(invokeId);
            reject.setProblem(problem);
            this.tcapDialog.sendComponent(reject);
        }
        catch (TCAPSendException e) {
            throw new MAPException(e.getMessage(), e);
        }
    }

    public void resetInvokeTimer(Long invokeId) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return;
        }
        try {
            this.getTcapDialog().resetTimer(invokeId);
        }
        catch (TCAPException e) {
            throw new MAPException("TCAPException occure: " + e.getMessage(), e);
        }
    }

    public boolean cancelInvocation(Long invokeId) throws MAPException {
        if (this.tcapDialog.getPreviewMode()) {
            return false;
        }
        try {
            return this.getTcapDialog().cancelInvocation(invokeId);
        }
        catch (TCAPException e) {
            throw new MAPException("TCAPException occure: " + e.getMessage(), e);
        }
    }

    public Object getUserObject() {
        return this.tcapDialog.getUserObject();
    }

    public void setUserObject(Object userObject) {
        this.tcapDialog.setUserObject(userObject);
    }

    public int getMaxUserDataLength() {
        return this.getTcapDialog().getMaxUserDataLength();
    }

    public int getMessageUserDataLengthOnSend() throws MAPException {
        try {
            switch (this.tcapDialog.getState()) {
                case Idle: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCBeginRequest tb = this.mapProviderImpl.encodeTCBegin(this.getTcapDialog(), acn, this.destReference, this.origReference, this.extContainer, this.eriStyle, this.eriMsisdn, this.eriVlrNo);
                    return this.tcapDialog.getDataLength(tb);
                }
                case Active: {
                    TCContinueRequest tc = this.mapProviderImpl.encodeTCContinue(this.getTcapDialog(), false, null, null);
                    return this.tcapDialog.getDataLength(tc);
                }
                case InitialReceived: {
                    ApplicationContextName acn1 = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCContinueRequest tc = this.mapProviderImpl.encodeTCContinue(this.getTcapDialog(), true, acn1, this.extContainer);
                    return this.tcapDialog.getDataLength(tc);
                }
            }
        }
        catch (TCAPSendException e) {
            throw new MAPException("TCAPSendException when getMessageUserDataLengthOnSend", e);
        }
        throw new MAPException("Bad TCAP Dialog state: " + (Object)((Object)this.tcapDialog.getState()));
    }

    public int getMessageUserDataLengthOnClose(boolean prearrangedEnd) throws MAPException {
        try {
            switch (this.tcapDialog.getState()) {
                case InitialReceived: {
                    ApplicationContextName acn = this.mapProviderImpl.getTCAPProvider().getDialogPrimitiveFactory().createApplicationContextName(this.appCntx.getOID());
                    TCEndRequest te = this.mapProviderImpl.encodeTCEnd(this.getTcapDialog(), true, prearrangedEnd, acn, this.extContainer);
                    return this.tcapDialog.getDataLength(te);
                }
                case Active: {
                    TCEndRequest te = this.mapProviderImpl.encodeTCEnd(this.getTcapDialog(), false, prearrangedEnd, null, null);
                    return this.tcapDialog.getDataLength(te);
                }
            }
        }
        catch (TCAPSendException e) {
            throw new MAPException("TCAPSendException when getMessageUserDataLengthOnSend", e);
        }
        throw new MAPException("Bad TCAP Dialog state: " + (Object)((Object)this.tcapDialog.getState()));
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("MAPDialog: LocalDialogId=").append(this.getLocalDialogId()).append(" RemoteDialogId=").append(this.getRemoteDialogId()).append(" MAPDialogState=").append((Object)this.getState()).append(" MAPApplicationContext=").append(this.appCntx).append(" TCAPDialogState=").append((Object)this.tcapDialog.getState());
        return sb.toString();
    }

    public void addEricssonData(AddressString eriMsisdn, AddressString vlrNo) {
        this.eriStyle = true;
        this.eriMsisdn = eriMsisdn;
        this.eriVlrNo = vlrNo;
    }

    public long getStartTimeDialog() {
        return this.tcapDialog.getStartTimeDialog();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static enum DelayedAreaState {
        No,
        Continue,
        End,
        PrearrangedEnd;

    }
}

