/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tools.traceparser;

import java.io.FileInputStream;
import java.io.IOException;
import org.restcomm.protocols.ss7.tools.traceparser.ProcessControl;
import org.restcomm.protocols.ss7.tools.traceparser.TraceParserUtil;
import org.restcomm.protocols.ss7.tools.traceparser.TraceReaderDriver;
import org.restcomm.protocols.ss7.tools.traceparser.TraceReaderDriverBase;
import org.restcomm.protocols.ss7.tools.traceparser.TraceReaderException;
import org.restcomm.protocols.ss7.tools.traceparser.TraceReaderListener;

public class TraceReaderDriverSimpleSeq
extends TraceReaderDriverBase
implements TraceReaderDriver {
    public TraceReaderDriverSimpleSeq(ProcessControl processControl, String fileName) {
        super(processControl, fileName);
    }

    @Override
    public void startTraceFile() throws TraceReaderException {
        if (this.listeners.size() == 0) {
            throw new TraceReaderException("TraceReaderListener list is empty");
        }
        this.isStarted = true;
        FileInputStream fis = null;
        try {
            if (this.processControl.checkNeedInterrupt()) {
                return;
            }
            fis = new FileInputStream(this.fileName);
            while (fis.available() > 0) {
                int b2;
                if (this.processControl.checkNeedInterrupt()) {
                    return;
                }
                int b1 = fis.read();
                int length = b1 + ((b2 = fis.read()) << 8);
                byte[] bb = new byte[length];
                int rb = fis.read(bb);
                if (rb < length) {
                    throw new TraceReaderException("Not enouph data in the file for reading a message");
                }
                byte[] bufMsg = new byte[length + 3];
                System.arraycopy(bb, 0, bufMsg, 3, length);
                bufMsg[0] = 0;
                bufMsg[1] = 0;
                bufMsg[2] = 63;
                for (TraceReaderListener ls : this.listeners) {
                    TraceParserUtil.parceLegacyMtp3(bufMsg, this.listeners);
                }
            }
        }
        catch (Throwable e) {
            this.loger.error("General exception: " + e.getMessage());
            e.printStackTrace();
            throw new TraceReaderException("General exception: " + e.getMessage(), e);
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

