/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.DialogAPDUType;
import org.restcomm.protocols.ss7.tcap.asn.DialogUniAPDU;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.ProtocolVersion;
import org.restcomm.protocols.ss7.tcap.asn.TcapFactory;
import org.restcomm.protocols.ss7.tcap.asn.UserInformation;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class DialogUniAPDUImpl
implements DialogUniAPDU {
    private ApplicationContextName acn;
    private UserInformation ui;
    private boolean doNotSendProtocolVersion = false;

    @Override
    public void setDoNotSendProtocolVersion(boolean val) {
        this.doNotSendProtocolVersion = val;
    }

    @Override
    public ApplicationContextName getApplicationContextName() {
        return this.acn;
    }

    @Override
    public int getProtocolVersion() {
        return 1;
    }

    @Override
    public UserInformation getUserInformation() {
        return this.ui;
    }

    @Override
    public void setApplicationContextName(ApplicationContextName acn) {
        this.acn = acn;
    }

    @Override
    public void setUserInformation(UserInformation ui) {
        this.ui = ui;
    }

    @Override
    public DialogAPDUType getType() {
        return DialogAPDUType.UniDirectional;
    }

    @Override
    public boolean isUniDirectional() {
        return false;
    }

    public String toString() {
        return "DialogUniAPDU[acn=" + this.acn + ", ui=" + this.ui + "]";
    }

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag == 0 && localAis.getTagClass() == 2) {
                TcapFactory.createProtocolVersion(localAis);
                tag = localAis.readTag();
            }
            if (tag != 1 || localAis.getTagClass() != 2) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogUniAPDU.application-context-name: bad tag or tagClass, found tag=" + tag + ", tagClass=" + localAis.getTagClass());
            }
            this.acn = TcapFactory.createApplicationContextName(localAis);
            if (localAis.available() > 0) {
                tag = localAis.readTag();
                if (tag != 30 || localAis.getTagClass() != 2) {
                    throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogUniAPDU.user-information: bad tag or tagClass, found tag=" + tag + ", tagClass=" + localAis.getTagClass());
                }
                this.ui = TcapFactory.createUserInformation(localAis);
            }
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding DialogUniAPDU: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding DialogUniAPDU: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.acn == null) {
            throw new EncodeException("Error encoding DialogUniAPDU: Application Context Name must not be null");
        }
        try {
            aos.writeTag(1, false, 0);
            int pos = aos.StartContentDefiniteLength();
            if (!this.doNotSendProtocolVersion) {
                ProtocolVersion pv = TcapFactory.createProtocolVersion();
                pv.encode(aos);
            }
            this.acn.encode(aos);
            if (this.ui != null) {
                this.ui.encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding DialogUniAPDU: " + e.getMessage(), e);
        }
    }
}

