/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap;

import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.tcap.DialogImpl;
import org.restcomm.protocols.ss7.tcap.PreviewDialogDataKey;
import org.restcomm.protocols.ss7.tcap.TCAPProviderImpl;
import org.restcomm.protocols.ss7.tcap.TCAPStackImpl;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.InvokeImpl;

public class PreviewDialogData {
    private static final Logger logger = Logger.getLogger(PreviewDialogData.class);
    private ApplicationContextName lastACN;
    private InvokeImpl[] operationsSentA;
    private InvokeImpl[] operationsSentB;
    private Object upperDialog;
    private PreviewDialogDataKey prevewDialogDataKey1;
    private PreviewDialogDataKey prevewDialogDataKey2;
    private ReentrantLock dialogLock = new ReentrantLock();
    private Future idleTimerFuture;
    private ScheduledExecutorService executor;
    private TCAPProviderImpl provider;
    private long idleTaskTimeout;
    private Long dialogId;

    public PreviewDialogData(TCAPProviderImpl provider, Long dialogId) {
        this.provider = provider;
        this.dialogId = dialogId;
        TCAPStackImpl stack = provider.getStack();
        this.idleTaskTimeout = stack.getDialogIdleTimeout();
        this.executor = provider._EXECUTOR;
    }

    public ApplicationContextName getLastACN() {
        return this.lastACN;
    }

    public Long getDialogId() {
        return this.dialogId;
    }

    public InvokeImpl[] getOperationsSentA() {
        return this.operationsSentA;
    }

    public InvokeImpl[] getOperationsSentB() {
        return this.operationsSentB;
    }

    public Object getUpperDialog() {
        return this.upperDialog;
    }

    public void setLastACN(ApplicationContextName val) {
        this.lastACN = val;
    }

    public void setOperationsSentA(InvokeImpl[] val) {
        this.operationsSentA = val;
    }

    public void setOperationsSentB(InvokeImpl[] val) {
        this.operationsSentB = val;
    }

    public void setUpperDialog(Object val) {
        this.upperDialog = val;
    }

    protected PreviewDialogDataKey getPrevewDialogDataKey1() {
        return this.prevewDialogDataKey1;
    }

    protected PreviewDialogDataKey getPrevewDialogDataKey2() {
        return this.prevewDialogDataKey2;
    }

    protected void setPrevewDialogDataKey1(PreviewDialogDataKey val) {
        this.prevewDialogDataKey1 = val;
    }

    protected void setPrevewDialogDataKey2(PreviewDialogDataKey val) {
        this.prevewDialogDataKey2 = val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startIdleTimer() {
        try {
            this.dialogLock.lock();
            if (this.idleTimerFuture != null) {
                throw new IllegalStateException();
            }
            IdleTimerTask t = new IdleTimerTask();
            t.pdd = this;
            this.idleTimerFuture = this.executor.schedule(t, this.idleTaskTimeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopIdleTimer() {
        try {
            this.dialogLock.lock();
            if (this.idleTimerFuture != null) {
                this.idleTimerFuture.cancel(false);
                this.idleTimerFuture = null;
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void restartIdleTimer() {
        try {
            this.dialogLock.lock();
            this.stopIdleTimer();
            this.startIdleTimer();
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    private class IdleTimerTask
    implements Runnable {
        PreviewDialogData pdd;

        private IdleTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                PreviewDialogData.this.dialogLock.lock();
                DialogImpl dlg = (DialogImpl)PreviewDialogData.this.provider.getPreviewDialog(PreviewDialogData.this.prevewDialogDataKey1, null, null, null, 0);
                PreviewDialogData.this.provider.timeout(dlg);
                PreviewDialogData.this.provider.removePreviewDialog(dlg);
            }
            finally {
                PreviewDialogData.this.dialogLock.unlock();
            }
        }
    }
}

