/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.router;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javolution.text.TextBuilder;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import javolution.xml.XMLObjectReader;
import javolution.xml.XMLObjectWriter;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRule;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.restcomm.protocols.ss7.sccp.Router;
import org.restcomm.protocols.ss7.sccp.SccpStack;
import org.restcomm.protocols.ss7.sccp.impl.router.LongMessageRuleImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.LongMessageRuleMap;
import org.restcomm.protocols.ss7.sccp.impl.router.Mtp3DestinationImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.Mtp3DestinationMap;
import org.restcomm.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPointImpl;
import org.restcomm.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPointMap;
import org.restcomm.protocols.ss7.sccp.impl.router.SccpRouterXMLBinding;

public class RouterImpl
implements Router {
    private static final Logger logger = Logger.getLogger(RouterImpl.class);
    private static final String SCCP_ROUTER_PERSIST_DIR_KEY = "sccprouter.persist.dir";
    private static final String USER_DIR_KEY = "user.dir";
    private static final String PERSIST_FILE_NAME = "sccprouter3.xml";
    private static final String LONG_MESSAGE_RULE = "longMessageRule";
    private static final String MTP3_SERVICE_ACCESS_POINT = "sap";
    private final TextBuilder persistFile = TextBuilder.newInstance();
    protected static final SccpRouterXMLBinding binding = new SccpRouterXMLBinding();
    private static final String TAB_INDENT = "\t";
    private static final String CLASS_ATTRIBUTE = "type";
    private String persistDir = null;
    private LongMessageRuleMap<Integer, LongMessageRule> longMessageRules = new LongMessageRuleMap();
    private Mtp3ServiceAccessPointMap<Integer, Mtp3ServiceAccessPoint> saps = new Mtp3ServiceAccessPointMap();
    private final String name;
    private final SccpStack sccpStack;

    public RouterImpl(String name, SccpStack sccpStack) {
        this.name = name;
        this.sccpStack = sccpStack;
        binding.setClassAttribute(CLASS_ATTRIBUTE);
        binding.setAlias(Mtp3DestinationMap.class, "mtp3DestinationMap");
    }

    public String getName() {
        return this.name;
    }

    public String getPersistDir() {
        return this.persistDir;
    }

    public void setPersistDir(String persistDir) {
        this.persistDir = persistDir;
    }

    public void start() {
        this.persistFile.clear();
        if (this.persistDir != null) {
            this.persistFile.append(this.persistDir).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        } else {
            this.persistFile.append(System.getProperty(SCCP_ROUTER_PERSIST_DIR_KEY, System.getProperty(USER_DIR_KEY))).append(File.separator).append(this.name).append("_").append(PERSIST_FILE_NAME);
        }
        logger.info(String.format("SCCP Router configuration file path %s", this.persistFile.toString()));
        this.load();
        logger.info("Started SCCP Router");
    }

    public void stop() {
        this.store();
    }

    public LongMessageRule findLongMessageRule(int dpc) {
        FastCollection.Record e = this.longMessageRules.head();
        FastMap.Entry end = this.longMessageRules.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            LongMessageRule rule = (LongMessageRule)((FastMap.Entry)e).getValue();
            if (!rule.matches(dpc)) continue;
            return rule;
        }
        return null;
    }

    public Mtp3ServiceAccessPoint findMtp3ServiceAccessPoint(int dpc, int sls) {
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (!sap.matches(dpc, sls)) continue;
            return sap;
        }
        return null;
    }

    public Mtp3ServiceAccessPoint findMtp3ServiceAccessPoint(int dpc, int sls, int networkId) {
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (!sap.matches(dpc, sls) || sap.getNetworkId() != networkId) continue;
            return sap;
        }
        return null;
    }

    public Mtp3ServiceAccessPoint findMtp3ServiceAccessPointForIncMes(int localPC, int remotePC, String localGtDigits) {
        Mtp3ServiceAccessPoint sap;
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (sap.getLocalGtDigits() == null || sap.getLocalGtDigits().length() <= 0 || sap.getOpc() != localPC || !sap.matches(remotePC) || localGtDigits == null || !localGtDigits.equals(sap.getLocalGtDigits())) continue;
            return sap;
        }
        e = this.saps.head();
        end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (sap.getLocalGtDigits() != null && sap.getLocalGtDigits().length() != 0 || sap.getOpc() != localPC || !sap.matches(remotePC)) continue;
            return sap;
        }
        return null;
    }

    @Override
    public LongMessageRule getLongMessageRule(int id) {
        return (LongMessageRule)this.longMessageRules.get(id);
    }

    @Override
    public Mtp3ServiceAccessPoint getMtp3ServiceAccessPoint(int id) {
        return (Mtp3ServiceAccessPoint)this.saps.get(id);
    }

    @Override
    public boolean spcIsLocal(int spc) {
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            if (sap.getOpc() != spc) continue;
            return true;
        }
        return false;
    }

    @Override
    public Map<Integer, LongMessageRule> getLongMessageRules() {
        HashMap<Integer, LongMessageRule> longMessageRulesTmp = new HashMap<Integer, LongMessageRule>();
        longMessageRulesTmp.putAll(this.longMessageRules);
        return longMessageRulesTmp;
    }

    @Override
    public Map<Integer, Mtp3ServiceAccessPoint> getMtp3ServiceAccessPoints() {
        HashMap<Integer, Mtp3ServiceAccessPoint> sapsTmp = new HashMap<Integer, Mtp3ServiceAccessPoint>();
        sapsTmp.putAll(this.saps);
        return sapsTmp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        if (this.getLongMessageRule(id) != null) {
            throw new Exception("Long message rule already exists");
        }
        LongMessageRuleImpl longMessageRule = new LongMessageRuleImpl(firstSpc, lastSpc, ruleType);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll(this.longMessageRules);
            newLongMessageRule.put(id, longMessageRule);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyLongMessageRule(int id, int firstSpc, int lastSpc, LongMessageRuleType ruleType) throws Exception {
        if (this.getLongMessageRule(id) == null) {
            throw new Exception(String.format("Long message rule doesn't exist on stack=%s", this.name));
        }
        LongMessageRuleImpl longMessageRule = new LongMessageRuleImpl(firstSpc, lastSpc, ruleType);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll(this.longMessageRules);
            newLongMessageRule.put(id, longMessageRule);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyLongMessageRule(int id, Integer firstSpc, Integer lastSpc, LongMessageRuleType ruleType) throws Exception {
        LongMessageRule oldLmr = this.getLongMessageRule(id);
        if (oldLmr == null) {
            throw new Exception(String.format("Long message rule doesn't exist on stack=%s", this.name));
        }
        if (firstSpc == null) {
            firstSpc = oldLmr.getFirstSpc();
        }
        if (lastSpc == null) {
            lastSpc = oldLmr.getLastSpc();
        }
        if (ruleType == null) {
            ruleType = oldLmr.getLongMessageRuleType();
        }
        LongMessageRuleImpl longMessageRule = new LongMessageRuleImpl(firstSpc, lastSpc, ruleType);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll(this.longMessageRules);
            newLongMessageRule.put(id, longMessageRule);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeLongMessageRule(int id) throws Exception {
        if (this.getLongMessageRule(id) == null) {
            throw new Exception(String.format("Long message rule doesn't exist on stack=%s", this.name));
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            LongMessageRuleMap newLongMessageRule = new LongMessageRuleMap();
            newLongMessageRule.putAll(this.longMessageRules);
            newLongMessageRule.remove(id);
            this.longMessageRules = newLongMessageRule;
            this.store();
        }
    }

    @Override
    public void addMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        sap.addMtp3Destination(destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
        this.store();
    }

    @Override
    public void modifyMtp3Destination(int sapId, int destId, int firstDpc, int lastDpc, int firstSls, int lastSls, int slsMask) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        sap.modifyMtp3Destination(destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
        this.store();
    }

    @Override
    public void modifyMtp3Destination(int sapId, int destId, Integer firstDpc, Integer lastDpc, Integer firstSls, Integer lastSls, Integer slsMask) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        Mtp3DestinationImpl dest = (Mtp3DestinationImpl)sap.getMtp3Destination(destId);
        if (dest == null) {
            throw new Exception(String.format("Destination definition doesn't exist on stack=%s", this.name));
        }
        if (firstDpc == null) {
            firstDpc = dest.getFirstDpc();
        }
        if (lastDpc == null) {
            lastDpc = dest.getLastDpc();
        }
        if (firstSls == null) {
            firstSls = dest.getFirstSls();
        }
        if (lastSls == null) {
            lastSls = dest.getLastSls();
        }
        if (slsMask == null) {
            slsMask = dest.getSlsMask();
        }
        sap.modifyMtp3Destination(destId, firstDpc, lastDpc, firstSls, lastSls, slsMask);
        this.store();
    }

    @Override
    public void removeMtp3Destination(int sapId, int destId) throws Exception {
        Mtp3ServiceAccessPoint sap = this.getMtp3ServiceAccessPoint(sapId);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        sap.removeMtp3Destination(destId);
        this.store();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni, int networkId, String localGtDigits) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) != null) {
            throw new Exception("Service access point already exists");
        }
        if (this.sccpStack.getMtp3UserPart(mtp3Id) == null) {
            throw new Exception("Mtp3UserPart doesn't exist");
        }
        if (localGtDigits != null && (localGtDigits.equals("null") || localGtDigits.equals(""))) {
            localGtDigits = null;
        }
        Mtp3ServiceAccessPointImpl sap = new Mtp3ServiceAccessPointImpl(mtp3Id, opc, ni, this.name, networkId, localGtDigits);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll(this.saps);
            newSap.put(id, sap);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyMtp3ServiceAccessPoint(int id, int mtp3Id, int opc, int ni, int networkId, String localGtDigits) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        if (this.sccpStack.getMtp3UserPart(mtp3Id) == null) {
            throw new Exception("Mtp3UserPart doesn't exist");
        }
        if (localGtDigits != null && (localGtDigits.equals("null") || localGtDigits.equals(""))) {
            localGtDigits = null;
        }
        Mtp3ServiceAccessPointImpl sap = new Mtp3ServiceAccessPointImpl(mtp3Id, opc, ni, this.name, networkId, localGtDigits);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll(this.saps);
            newSap.put(id, sap);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void modifyMtp3ServiceAccessPoint(int id, Integer mtp3Id, Integer opc, Integer ni, Integer networkId, String localGtDigits) throws Exception {
        Mtp3ServiceAccessPointImpl sap = (Mtp3ServiceAccessPointImpl)this.getMtp3ServiceAccessPoint(id);
        if (sap == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        if (mtp3Id != null && this.sccpStack.getMtp3UserPart(mtp3Id) == null) {
            throw new Exception("Mtp3UserPart doesn't exist");
        }
        if (localGtDigits != null && (localGtDigits.equals("null") || localGtDigits.equals(""))) {
            localGtDigits = null;
        }
        if (mtp3Id == null) {
            mtp3Id = sap.getMtp3Id();
        }
        if (opc == null) {
            opc = sap.getOpc();
        }
        if (ni == null) {
            ni = sap.getNi();
        }
        if (networkId == null) {
            networkId = sap.getNetworkId();
        }
        if (localGtDigits == null) {
            localGtDigits = sap.getLocalGtDigits();
        }
        Mtp3ServiceAccessPointImpl newSap = new Mtp3ServiceAccessPointImpl(mtp3Id, opc, ni, this.name, networkId, localGtDigits);
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSaps = new Mtp3ServiceAccessPointMap();
            newSaps.putAll(this.saps);
            newSaps.put(id, newSap);
            this.saps = newSaps;
            this.store();
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeMtp3ServiceAccessPoint(int id) throws Exception {
        if (this.getMtp3ServiceAccessPoint(id) == null) {
            throw new Exception(String.format("Service access point doesn't exist on stack=%s", this.name));
        }
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            Mtp3ServiceAccessPointMap newSap = new Mtp3ServiceAccessPointMap();
            newSap.putAll(this.saps);
            newSap.remove(id);
            this.saps = newSap;
            this.store();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllResourses() {
        RouterImpl routerImpl = this;
        synchronized (routerImpl) {
            if (this.longMessageRules.size() == 0 && this.saps.size() == 0) {
                return;
            }
            this.longMessageRules = new LongMessageRuleMap();
            this.saps = new Mtp3ServiceAccessPointMap();
            this.store();
        }
    }

    public void store() {
        try {
            XMLObjectWriter writer = XMLObjectWriter.newInstance(new FileOutputStream(this.persistFile.toString()));
            writer.setBinding(binding);
            writer.setIndentation(TAB_INDENT);
            writer.write(this.longMessageRules, LONG_MESSAGE_RULE, LongMessageRuleMap.class);
            writer.write(this.saps, MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
            writer.close();
        }
        catch (Exception e) {
            logger.error("Error while persisting the Rule state in file", e);
        }
    }

    public void load() {
        try {
            File f = new File(this.persistFile.toString());
            if (f.exists()) {
                this.loadVer4(this.persistFile.toString());
            } else {
                String s1 = this.persistFile.toString().replace("3.xml", "2.xml");
                f = new File(s1);
                if (f.exists()) {
                    this.loadVer3(s1);
                    this.store();
                    f.delete();
                } else {
                    s1 = this.persistFile.toString().replace("3.xml", ".xml");
                    f = new File(s1);
                    if (f.exists() && !this.loadVer1(s1)) {
                        this.loadVer2(s1);
                    }
                    this.store();
                    f.delete();
                }
            }
        }
        catch (XMLStreamException ex) {
            ex.printStackTrace();
            logger.error(String.format("Failed to load the SS7 configuration file. \n%s", ex.getMessage()));
        }
        catch (FileNotFoundException e) {
            logger.warn(String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
        catch (IOException e) {
            logger.error(String.format("Failed to load the SS7 configuration file. \n%s", e.getMessage()));
        }
    }

    private boolean loadVer1(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.parameter.NoGlobalTitle\"", "type=\"NoGlobalTitle\"");
        s2 = s2.replace("type=\"rule\"", "");
        s2 = s2.replace("pattern type=\"org.restcomm.protocols.ss7.sccp.parameter.SccpAddress\"", "patternSccpAddress");
        s2 = s2.replace("ai type=\"org.restcomm.protocols.ss7.indicator.AddressIndicator\" ai=", "ai value=");
        s2 = s2.replace("gt type=\"org.restcomm.protocols.ss7.sccp.parameter.", "gt type=\"");
        s2 = s2.replace("Key type=\"java.lang.Integer\"", "id");
        s2 = s2.replace("Value", "value");
        s2 = s2.replace("/pattern", "/patternSccpAddress");
        s2 = s2.replace("value type=\"org.restcomm.protocols.ss7.sccp.parameter.SccpAddress\"", "sccpAddress");
        s2 = s2.replace("</value>\r\n</primaryAddress>", "</sccpAddress>\r\n</primaryAddress>");
        s2 = s2.replace("</value>\n</primaryAddress>", "</sccpAddress>\n</primaryAddress>");
        s2 = s2.replace("</value>\r\n</backupAddress>", "</sccpAddress>\r\n</backupAddress>");
        s2 = s2.replace("</value>\n</backupAddress>", "</sccpAddress>\n</backupAddress>");
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.parameter.", "type=\"");
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.impl.router.Mtp3ServiceAccessPoint\"", "");
        s2 = s2.replace("javolution.util.FastMap", "mtp3DestinationMap");
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.impl.router.Mtp3Destination\"", "");
        StringReader sr = new StringReader(s2);
        XMLObjectReader reader = XMLObjectReader.newInstance(sr);
        reader.setBinding(binding);
        XMLBinding binding2 = new XMLBinding();
        binding2.setClassAttribute(CLASS_ATTRIBUTE);
        String BACKUP_ADDRESS_V2 = "backupAddress";
        String ROUTING_ADDRESS_V2 = "primaryAddress";
        this.longMessageRules = reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class);
        this.saps = reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            ((Mtp3ServiceAccessPointImpl)sap).setStackName(this.name);
        }
        reader.close();
        return true;
    }

    private void loadVer2(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        s2 = s2.replace("type=\"org.restcomm.protocols.ss7.sccp.parameter.NoGlobalTitle\"", "type=\"NoGlobalTitle\"");
        StringReader sr = new StringReader(s2);
        XMLObjectReader reader = XMLObjectReader.newInstance(sr);
        String ROUTING_ADDRESS_V2 = "primaryAddress";
        String BACKUP_ADDRESS_V2 = "backupAddress";
        reader.setBinding(binding);
        this.longMessageRules = reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class);
        this.saps = reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            ((Mtp3ServiceAccessPointImpl)sap).setStackName(this.name);
        }
        reader.close();
    }

    protected void loadVer3(String fn) throws XMLStreamException, IOException {
        String s1;
        BufferedReader br = new BufferedReader(new InputStreamReader(new FileInputStream(fn)));
        StringBuilder sb = new StringBuilder();
        while ((s1 = br.readLine()) != null) {
            sb.append(s1);
            sb.append("\n");
        }
        br.close();
        String s2 = sb.toString();
        int i1 = s2.indexOf("<rule");
        int i2 = s2.indexOf("<routingAddress/>");
        if (i2 < 0) {
            i2 = s2.indexOf("</routingAddress>");
        }
        if (i1 <= 0 || i2 <= 0 || i1 >= i2) {
            return;
        }
        String s3 = s2.substring(0, i1) + s2.substring(i2 + 17);
        StringReader sr = new StringReader(s3);
        XMLObjectReader reader = XMLObjectReader.newInstance(sr);
        reader.setBinding(binding);
        this.loadVer4(reader);
    }

    protected void loadVer4(String fn) throws XMLStreamException, FileNotFoundException {
        XMLObjectReader reader = XMLObjectReader.newInstance(new FileInputStream(fn));
        reader.setBinding(binding);
        this.loadVer4(reader);
    }

    protected void loadVer4(XMLObjectReader reader) throws XMLStreamException {
        this.longMessageRules = reader.read(LONG_MESSAGE_RULE, LongMessageRuleMap.class);
        this.saps = reader.read(MTP3_SERVICE_ACCESS_POINT, Mtp3ServiceAccessPointMap.class);
        FastCollection.Record e = this.saps.head();
        FastMap.Entry end = this.saps.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            Mtp3ServiceAccessPoint sap = (Mtp3ServiceAccessPoint)((FastMap.Entry)e).getValue();
            ((Mtp3ServiceAccessPointImpl)sap).setStackName(this.name);
        }
        reader.close();
    }
}

