/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SequenceNumberImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ReceiveSequenceNumber;
import org.restcomm.protocols.ss7.sccp.parameter.SequenceNumber;

public class ReceiveSequenceNumberImpl
extends AbstractParameter
implements ReceiveSequenceNumber {
    private SequenceNumber value = new SequenceNumberImpl(0);

    public ReceiveSequenceNumberImpl() {
    }

    public ReceiveSequenceNumberImpl(SequenceNumber value) {
        this.value = value;
    }

    @Override
    public int getValue() {
        return this.value.getValue();
    }

    @Override
    public SequenceNumber getNumber() {
        return this.value;
    }

    public void setNumber(SequenceNumber value) {
        this.value = value;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        this.value = new SequenceNumberImpl(0);
        try {
            if (in.read() != 1) {
                throw new ParseException();
            }
            this.value = new SequenceNumberImpl((byte)(in.read() >> 1 & 0x7F));
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    @Override
    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            os.write(1);
            os.write(this.value.getValue() << 1 & 0xFE);
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    @Override
    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        if (b.length < 1) {
            throw new ParseException();
        }
        this.value = new SequenceNumberImpl((byte)(b[0] >> 1 & 0x7F));
    }

    @Override
    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)(this.value.getValue() << 1 & 0xFE)};
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReceiveSequenceNumberImpl that = (ReceiveSequenceNumberImpl)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value.getValue();
    }

    public String toString() {
        return new StringBuffer().append("ReceiveSequenceNumber [").append("value=").append(this.value.getValue()).append("]").toString();
    }
}

