/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResult;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnReferencedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ResetCauseImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpConnRsrMessage;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ResetCause;

public class SccpConnRsrMessageImpl
extends SccpConnReferencedMessageImpl
implements SccpConnRsrMessage {
    protected ResetCause resetCause;

    public SccpConnRsrMessageImpl(int sls, int localSsn) {
        super(0, 13, sls, localSsn);
    }

    protected SccpConnRsrMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(0, 13, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public ResetCause getResetCause() {
        return this.resetCause;
    }

    @Override
    public void setResetCause(ResetCause value) {
        this.resetCause = value;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            in.read(buffer);
            ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.sourceLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ResetCauseImpl cause = new ResetCauseImpl();
            cause.decode(buffer, factory, sccpProtocolVersion);
            this.resetCause = cause;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.sourceLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.SourceLocalReferenceNumberMissing, null, null, null);
            }
            if (this.resetCause == null) {
                return new EncodingResultData(EncodingResult.ResetCauseMissing, null, null, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(8);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] slr = ((LocalReferenceImpl)this.sourceLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] cause = ((ResetCauseImpl)this.resetCause).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(slr);
            out.write(cause);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sccp Msg [Type=Rsr");
        sb.append(" networkId=");
        sb.append(this.networkId);
        sb.append(" sls=");
        sb.append(this.sls);
        sb.append(" incomingOpc=");
        sb.append(this.incomingOpc);
        sb.append(" incomingDpc=");
        sb.append(this.incomingDpc);
        sb.append(" outgoingDpc=");
        sb.append(this.outgoingDpc);
        sb.append(" sourceLR=");
        if (this.sourceLocalReferenceNumber != null) {
            sb.append(this.sourceLocalReferenceNumber.getValue());
        }
        sb.append(" destLR=");
        if (this.destinationLocalReferenceNumber != null) {
            sb.append(this.destinationLocalReferenceNumber.getValue());
        }
        sb.append(" resetCause=");
        if (this.resetCause != null) {
            sb.append((Object)this.resetCause.getValue());
        }
        sb.append(" isMtpOriginated=");
        sb.append(this.isMtpOriginated);
        sb.append("]");
        return sb.toString();
    }
}

