/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResult;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnReferencedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.CreditImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ProtocolClassImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SequencingSegmentingImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpConnItMessage;
import org.restcomm.protocols.ss7.sccp.parameter.Credit;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;
import org.restcomm.protocols.ss7.sccp.parameter.SequenceNumber;
import org.restcomm.protocols.ss7.sccp.parameter.SequencingSegmenting;

public class SccpConnItMessageImpl
extends SccpConnReferencedMessageImpl
implements SccpConnItMessage {
    protected ProtocolClass protocolClass;
    protected SequencingSegmenting sequencingSegmenting;
    protected Credit credit;

    public SccpConnItMessageImpl(int sls, int localSsn) {
        super(0, 16, sls, localSsn);
    }

    public SccpConnItMessageImpl(int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(0, 16, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public ProtocolClass getProtocolClass() {
        return this.protocolClass;
    }

    @Override
    public void setProtocolClass(ProtocolClass value) {
        this.protocolClass = value;
    }

    @Override
    public SequencingSegmenting getSequencingSegmenting() {
        return this.sequencingSegmenting;
    }

    @Override
    public void setSequencingSegmenting(SequencingSegmenting value) {
        this.sequencingSegmenting = value;
    }

    @Override
    public Credit getCredit() {
        return this.credit;
    }

    @Override
    public void setCredit(Credit value) {
        this.credit = value;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            in.read(buffer);
            ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.sourceLocalReferenceNumber = ref;
            buffer = new byte[1];
            in.read(buffer);
            ProtocolClassImpl protocol = new ProtocolClassImpl();
            protocol.decode(buffer, factory, sccpProtocolVersion);
            this.protocolClass = protocol;
            if (protocol.getProtocolClass() != 2) {
                buffer = new byte[2];
                in.read(buffer);
                SequencingSegmentingImpl sequencing = new SequencingSegmentingImpl();
                sequencing.decode(buffer, factory, sccpProtocolVersion);
                this.sequencingSegmenting = sequencing;
                buffer = new byte[1];
                in.read(buffer);
                CreditImpl cred = new CreditImpl();
                cred.decode(buffer, factory, sccpProtocolVersion);
                this.credit = cred;
            }
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.sourceLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.SourceLocalReferenceNumberMissing, null, null, null);
            }
            if (this.protocolClass == null) {
                return new EncodingResultData(EncodingResult.ProtocolClassMissing, null, null, null);
            }
            if (this.sequencingSegmenting == null) {
                return new EncodingResultData(EncodingResult.SequencingSegmentingMissing, null, null, null);
            }
            if (this.credit == null) {
                return new EncodingResultData(EncodingResult.CreditMissing, null, null, null);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(11);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] slr = ((LocalReferenceImpl)this.sourceLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] proto = ((ProtocolClassImpl)this.protocolClass).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] seq = ((SequencingSegmentingImpl)this.sequencingSegmenting).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] cred = ((CreditImpl)this.credit).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(slr);
            out.write(proto);
            out.write(seq);
            out.write(cred);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    public boolean isMoreData() {
        return this.sequencingSegmenting.isMoreData();
    }

    public void setMoreData(boolean moreData) {
        if (this.sequencingSegmenting == null) {
            this.sequencingSegmenting = new SequencingSegmentingImpl();
        }
        this.sequencingSegmenting.setMoreData(moreData);
    }

    public void setSequencing(SequenceNumber sendSequenceNumber, SequenceNumber receiveSequenceNumber) {
        if (this.sequencingSegmenting == null) {
            this.sequencingSegmenting = new SequencingSegmentingImpl();
        }
        this.sequencingSegmenting.setSendSequenceNumber(sendSequenceNumber);
        this.sequencingSegmenting.setReceiveSequenceNumber(receiveSequenceNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sccp Msg [Type=IT");
        sb.append(" networkId=");
        sb.append(this.networkId);
        sb.append(" sls=");
        sb.append(this.sls);
        sb.append(" incomingOpc=");
        sb.append(this.incomingOpc);
        sb.append(" incomingDpc=");
        sb.append(this.incomingDpc);
        sb.append(" outgoingDpc=");
        sb.append(this.outgoingDpc);
        sb.append(" sourceLR=");
        if (this.sourceLocalReferenceNumber != null) {
            sb.append(this.sourceLocalReferenceNumber.getValue());
        }
        sb.append(" destLR=");
        if (this.destinationLocalReferenceNumber != null) {
            sb.append(this.destinationLocalReferenceNumber.getValue());
        }
        sb.append(" protocolClass=");
        if (this.protocolClass != null) {
            sb.append(this.protocolClass.getProtocolClass());
        }
        sb.append(" sequencingSegmenting=");
        if (this.sequencingSegmenting != null) {
            sb.append(this.sequencingSegmenting);
        }
        sb.append(" credit=");
        if (this.credit != null) {
            sb.append(this.credit.getValue());
        }
        sb.append(" isMtpOriginated=");
        sb.append(this.isMtpOriginated);
        sb.append("]");
        return sb.toString();
    }
}

