/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.message;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResult;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.LocalReferenceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.SequencingSegmentingImpl;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.message.SccpConnDt2Message;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SequenceNumber;
import org.restcomm.protocols.ss7.sccp.parameter.SequencingSegmenting;

public class SccpConnDt2MessageImpl
extends SccpConnSegmentableMessageImpl
implements SccpConnDt2Message {
    protected SequencingSegmenting sequencingSegmenting;

    public SccpConnDt2MessageImpl(int maxDataLen, int sls, int localSsn) {
        super(maxDataLen, 7, sls, localSsn);
    }

    protected SccpConnDt2MessageImpl(int maxDataLen, int incomingOpc, int incomingDpc, int incomingSls, int networkId) {
        super(maxDataLen, 7, incomingOpc, incomingDpc, incomingSls, networkId);
    }

    @Override
    public SequencingSegmenting getSequencingSegmenting() {
        return this.sequencingSegmenting;
    }

    @Override
    public void setSequencingSegmenting(SequencingSegmenting sequencingSegmenting) {
        this.sequencingSegmenting = sequencingSegmenting;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            byte[] buffer = new byte[3];
            in.read(buffer);
            LocalReferenceImpl ref = new LocalReferenceImpl();
            ref.decode(buffer, factory, sccpProtocolVersion);
            this.destinationLocalReferenceNumber = ref;
            buffer = new byte[2];
            in.read(buffer);
            SequencingSegmentingImpl sequencing = new SequencingSegmentingImpl();
            sequencing.decode(buffer, factory, sccpProtocolVersion);
            this.sequencingSegmenting = sequencing;
            int dataPointer = in.read() & 0xFF;
            in.mark(in.available());
            in.skip(dataPointer - 1);
            int len = in.read() & 0xFF;
            buffer = new byte[len];
            in.read(buffer);
            this.userData = buffer;
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public EncodingResultData encode(SccpStackImpl sccpStackImpl, LongMessageRuleType longMessageRuleType, int maxMtp3UserDataLength, Logger logger, boolean removeSPC, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            int fieldsLen;
            int availLen;
            if (this.type == 0) {
                return new EncodingResultData(EncodingResult.MessageTypeMissing, null, null, null);
            }
            if (this.destinationLocalReferenceNumber == null) {
                return new EncodingResultData(EncodingResult.DestinationLocalReferenceNumberMissing, null, null, null);
            }
            if (this.sequencingSegmenting == null) {
                return new EncodingResultData(EncodingResult.SequencingSegmentingMissing, null, null, null);
            }
            if (this.userData == null) {
                return new EncodingResultData(EncodingResult.DataMissed, null, null, null);
            }
            byte[] bf = new byte[]{};
            if (this.userData != null) {
                bf = this.userData;
            }
            if ((availLen = maxMtp3UserDataLength - (fieldsLen = 8)) > 256) {
                availLen = 256;
            }
            if (bf.length > availLen) {
                if (logger.isEnabledFor(Level.WARN)) {
                    logger.warn(String.format("Failure when sending a DT2 message: message is too long. SccpMessageSegment=%s", this));
                }
                return new EncodingResultData(EncodingResult.ReturnFailure, null, null, ReturnCauseValue.SEG_NOT_SUPPORTED);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream(fieldsLen + bf.length);
            byte[] dlr = ((LocalReferenceImpl)this.destinationLocalReferenceNumber).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            byte[] seq = ((SequencingSegmentingImpl)this.sequencingSegmenting).encode(sccpStackImpl.isRemoveSpc(), sccpStackImpl.getSccpProtocolVersion());
            out.write(this.type);
            out.write(dlr);
            out.write(seq);
            int len = 1;
            out.write(len);
            out.write((byte)bf.length);
            out.write(bf);
            return new EncodingResultData(EncodingResult.Success, out.toByteArray(), null, null);
        }
        catch (IOException e) {
            throw new ParseException(e);
        }
    }

    @Override
    public boolean isMoreData() {
        return this.sequencingSegmenting.isMoreData();
    }

    @Override
    public void setMoreData(boolean moreData) {
        if (this.sequencingSegmenting == null) {
            this.sequencingSegmenting = new SequencingSegmentingImpl();
        }
        this.sequencingSegmenting.setMoreData(moreData);
    }

    public void setSequencing(SequenceNumber sendSequenceNumber, SequenceNumber receiveSequenceNumber) {
        if (this.sequencingSegmenting == null) {
            this.sequencingSegmenting = new SequencingSegmentingImpl();
        }
        this.sequencingSegmenting.setSendSequenceNumber(sendSequenceNumber);
        this.sequencingSegmenting.setReceiveSequenceNumber(receiveSequenceNumber);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Sccp Msg [Type=DT2");
        sb.append(" networkId=");
        sb.append(this.networkId);
        sb.append(" sls=");
        sb.append(this.sls);
        sb.append(" incomingOpc=");
        sb.append(this.incomingOpc);
        sb.append(" incomingDpc=");
        sb.append(this.incomingDpc);
        sb.append(" outgoingDpc=");
        sb.append(this.outgoingDpc);
        sb.append(" DataLen=");
        if (this.userData != null) {
            sb.append(this.userData.length);
        }
        sb.append(" destLR=");
        if (this.destinationLocalReferenceNumber != null) {
            sb.append(this.destinationLocalReferenceNumber.getValue());
        }
        sb.append(" sequencingSegmenting=");
        if (this.sequencingSegmenting != null) {
            sb.append(this.sequencingSegmenting);
        }
        sb.append(" isMtpOriginated=");
        sb.append(this.isMtpOriginated);
        sb.append("]");
        return sb.toString();
    }
}

