/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import org.restcomm.protocols.ss7.sccp.SccpConnection;
import org.restcomm.protocols.ss7.sccp.SccpListener;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionWithCouplingImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingControl;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnItMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.ProtocolClass;

public class SccpConnectionImpl
extends SccpConnectionWithCouplingImpl
implements SccpConnection {
    public SccpConnectionImpl(int localSsn, LocalReference localReference, ProtocolClass protocol, SccpStackImpl stack, SccpRoutingControl sccpRoutingControl) {
        super(stack.newSls(), localSsn, localReference, protocol, stack, sccpRoutingControl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveMessage(SccpConnMessage message) throws Exception {
        try {
            this.connectionLock.lock();
            super.receiveMessage(message);
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void sendMessage(SccpConnMessage message) throws Exception {
        try {
            this.connectionLock.lock();
            super.sendMessage(message);
        }
        finally {
            this.connectionLock.unlock();
        }
    }

    @Override
    protected void callListenerOnData(byte[] data) {
        SccpListener listener = this.getListener();
        if (listener != null) {
            listener.onData(this, data);
        }
    }

    @Override
    public void prepareMessageForSending(SccpConnSegmentableMessageImpl message) {
    }

    @Override
    protected void prepareMessageForSending(SccpConnItMessageImpl message) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("SccpConnection[");
        this.fillSccpConnectionFields(sb);
        sb.append("]");
        return sb.toString();
    }

    protected void fillSccpConnectionFields(StringBuilder sb) {
        LocalReference lr = this.getLocalReference();
        LocalReference rr = this.getRemoteReference();
        ProtocolClass pClass = this.getProtocolClass();
        sb.append("localReference=");
        if (lr != null) {
            sb.append(lr.getValue());
        } else {
            sb.append("null");
        }
        sb.append(", remoteReference=");
        if (rr != null) {
            sb.append(rr.getValue());
        } else {
            sb.append("null");
        }
        sb.append(", localSsn=");
        sb.append(this.getLocalSsn());
        sb.append(", remoteSsn=");
        sb.append(this.remoteSsn);
        sb.append(", remoteDpc=");
        sb.append(this.remoteDpc);
        sb.append(", state=");
        sb.append((Object)this.getState());
        sb.append(", protocolClass=");
        if (pClass != null) {
            sb.append(this.getProtocolClass().getProtocolClass());
        } else {
            sb.append("null");
        }
        if (this.isAwaitSegments()) {
            sb.append(", awaitSegments");
        }
        if (this.isCouplingEnabled()) {
            sb.append(", couplingEnabled");
        }
    }

    public static class ConnectionNotAvailableException
    extends IllegalStateException {
        public ConnectionNotAvailableException(String message) {
            super(message);
        }
    }
}

