/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.APNConfiguration;
import org.restcomm.protocols.ss7.map.api.service.mobility.subscriberManagement.APNConfigurationProfile;
import org.restcomm.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.restcomm.protocols.ss7.map.primitives.SequenceBase;
import org.restcomm.protocols.ss7.map.service.mobility.subscriberManagement.APNConfigurationImpl;

public class APNConfigurationProfileImpl
extends SequenceBase
implements APNConfigurationProfile {
    private static final int _TAG_ePSDataList = 1;
    private static final int _TAG_extensionContainer = 2;
    private int defaultContext;
    private boolean completeDataListIncluded;
    private ArrayList<APNConfiguration> ePSDataList;
    private MAPExtensionContainer extensionContainer;

    public APNConfigurationProfileImpl() {
        super("APNConfigurationProfile");
    }

    public APNConfigurationProfileImpl(int defaultContext, boolean completeDataListIncluded, ArrayList<APNConfiguration> ePSDataList, MAPExtensionContainer extensionContainer) {
        super("APNConfigurationProfile");
        this.defaultContext = defaultContext;
        this.completeDataListIncluded = completeDataListIncluded;
        this.ePSDataList = ePSDataList;
        this.extensionContainer = extensionContainer;
    }

    @Override
    public int getDefaultContext() {
        return this.defaultContext;
    }

    @Override
    public boolean getCompleteDataListIncluded() {
        return this.completeDataListIncluded;
    }

    @Override
    public ArrayList<APNConfiguration> getEPSDataList() {
        return this.ePSDataList;
    }

    @Override
    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.defaultContext = -1;
        this.completeDataListIncluded = false;
        this.ePSDataList = null;
        this.extensionContainer = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (tag != 2 || ais.getTagClass() != 0 || !ais.isTagPrimitive()) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".defaultContext: bad tag, tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.defaultContext = (int)ais.readInteger();
                    break;
                }
                default: {
                    switch (ais.getTagClass()) {
                        case 0: {
                            switch (tag) {
                                case 5: {
                                    if (!ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".completeDataListIncluded: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    ais.readNull();
                                    this.completeDataListIncluded = true;
                                    break block0;
                                }
                            }
                            ais.advanceElement();
                            break block0;
                        }
                        case 2: {
                            switch (tag) {
                                case 1: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ePSDataList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.ePSDataList = new ArrayList();
                                    AsnInputStream ais2 = ais.readSequenceStream();
                                    while (ais2.available() != 0) {
                                        int tag2 = ais2.readTag();
                                        if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": bad tag or tagClass or is primitive when decoding ePSDataList", MAPParsingComponentExceptionReason.MistypedParameter);
                                        }
                                        APNConfigurationImpl elem = new APNConfigurationImpl();
                                        elem.decodeAll(ais2);
                                        this.ePSDataList.add(elem);
                                        if (this.ePSDataList.size() >= 1 && this.ePSDataList.size() <= 50) continue;
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ePSDataList: elements count must be from 1 to 50, found: " + this.ePSDataList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    break;
                                }
                                case 2: {
                                    if (ais.isTagPrimitive()) {
                                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                    }
                                    this.extensionContainer = new MAPExtensionContainerImpl();
                                    ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                    break;
                                }
                                default: {
                                    ais.advanceElement();
                                    break;
                                }
                            }
                            break block0;
                        }
                        default: {
                            ais.advanceElement();
                        }
                    }
                }
            }
            ++num;
        }
        if (this.defaultContext == -1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament defaultContext is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        if (this.ePSDataList == null) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parament ePSDataList is mandatory but does not found", MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.ePSDataList == null) {
            throw new MAPException("Error while encoding" + this._PrimitiveName + ": ePSDataList must not be null");
        }
        if (this.ePSDataList.size() < 1 || this.ePSDataList.size() > 50) {
            throw new MAPException("Error while encoding " + this._PrimitiveName + ": Parameter ePSDataList size must be from 1 to 50, found: " + this.ePSDataList.size());
        }
        try {
            asnOs.writeInteger(this.defaultContext);
            if (this.completeDataListIncluded) {
                asnOs.writeNull();
            }
            asnOs.writeTag(2, false, 1);
            int pos = asnOs.StartContentDefiniteLength();
            for (APNConfiguration be : this.ePSDataList) {
                APNConfigurationImpl bee = (APNConfigurationImpl)be;
                bee.encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs, 2, 2);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName + " [");
        sb.append("defaultContext=");
        sb.append(this.defaultContext);
        sb.append(", ");
        if (this.completeDataListIncluded) {
            sb.append("completeDataListIncluded, ");
        }
        if (this.ePSDataList != null) {
            sb.append("ePSDataList=[");
            boolean firstItem = true;
            for (APNConfiguration be : this.ePSDataList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(" ");
        }
        sb.append("]");
        return sb.toString();
    }
}

