/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.locationManagement;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.primitives.LAIFixedLength;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.LAC;
import org.restcomm.protocols.ss7.map.api.service.mobility.locationManagement.LocationArea;
import org.restcomm.protocols.ss7.map.primitives.LAIFixedLengthImpl;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.service.mobility.locationManagement.LACImpl;

public class LocationAreaImpl
implements LocationArea,
MAPAsnPrimitive {
    public static final int _TAG_laiFixedLength = 0;
    public static final int _TAG_lac = 1;
    public static final String _PrimitiveName = "LocationArea";
    private LAIFixedLength laiFixedLength;
    private LAC lac;

    public LocationAreaImpl() {
    }

    public LocationAreaImpl(LAIFixedLength laiFixedLength) {
        this.laiFixedLength = laiFixedLength;
    }

    public LocationAreaImpl(LAC lac) {
        this.lac = lac;
    }

    @Override
    public LAIFixedLength getLAIFixedLength() {
        return this.laiFixedLength;
    }

    @Override
    public LAC getLAC() {
        return this.lac;
    }

    @Override
    public int getTag() throws MAPException {
        if (this.laiFixedLength != null) {
            return 0;
        }
        return 1;
    }

    @Override
    public int getTagClass() {
        return 2;
    }

    @Override
    public boolean getIsPrimitive() {
        return true;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LocationArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LocationArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding LocationArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding LocationArea: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ais, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.laiFixedLength = null;
        this.lac = null;
        int tag = ais.getTag();
        if (ais.getTagClass() != 2 || !ais.isTagPrimitive()) {
            throw new MAPParsingComponentException("Error while decoding LocationArea: Primitive has bad tag class or is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (tag) {
            case 0: {
                this.laiFixedLength = new LAIFixedLengthImpl();
                ((LAIFixedLengthImpl)this.laiFixedLength).decodeData(ais, length);
                break;
            }
            case 1: {
                this.lac = new LACImpl();
                ((LACImpl)this.lac).decodeData(ais, length);
                break;
            }
            default: {
                throw new MAPParsingComponentException("Error while decoding LocationArea: bad choice tag", MAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding LocationArea: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.laiFixedLength == null && this.lac == null || this.laiFixedLength != null && this.lac != null) {
            throw new MAPException("Error while decoding LocationArea: One and only one choice must be selected");
        }
        if (this.laiFixedLength != null) {
            ((LAIFixedLengthImpl)this.laiFixedLength).encodeData(asnOs);
        } else {
            ((LACImpl)this.lac).encodeData(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.laiFixedLength != null) {
            sb.append(this.laiFixedLength.toString());
            sb.append(", ");
        }
        if (this.lac != null) {
            sb.append(this.lac.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

