/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.map.api.MAPException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentException;
import org.restcomm.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.AuthenticationQuintuplet;
import org.restcomm.protocols.ss7.map.api.service.mobility.authentication.QuintupletList;
import org.restcomm.protocols.ss7.map.primitives.MAPAsnPrimitive;
import org.restcomm.protocols.ss7.map.service.mobility.authentication.AuthenticationQuintupletImpl;

public class QuintupletListImpl
implements QuintupletList,
MAPAsnPrimitive {
    public static final String _PrimitiveName = "QuintupletList";
    private ArrayList<AuthenticationQuintuplet> quintupletList;

    public QuintupletListImpl() {
    }

    public QuintupletListImpl(ArrayList<AuthenticationQuintuplet> quintupletList) {
        this.quintupletList = quintupletList;
    }

    @Override
    public ArrayList<AuthenticationQuintuplet> getAuthenticationQuintuplets() {
        return this.quintupletList;
    }

    @Override
    public int getTag() throws MAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding QuintupletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding QuintupletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding QuintupletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding QuintupletList: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.quintupletList = new ArrayList();
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding QuintupletList: Parameter AuthenticationQuintuplet is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AuthenticationQuintupletImpl at = new AuthenticationQuintupletImpl();
                        at.decodeAll(ais);
                        this.quintupletList.add(at);
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.quintupletList.size() < 1 || this.quintupletList.size() > 5) {
            throw new MAPParsingComponentException("Error while decoding QuintupletList: quintupletList size must be from 1 to 5, found:" + this.quintupletList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, false, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding QuintupletList: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        if (this.quintupletList == null || this.quintupletList.size() < 1 || this.quintupletList.size() > 5) {
            throw new MAPException("QuintupletList list must contains from 1 to 5 elemets");
        }
        for (AuthenticationQuintuplet at : this.quintupletList) {
            ((AuthenticationQuintupletImpl)at).encodeAll(asnOs);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("QuintupletList [");
        if (this.quintupletList != null) {
            for (AuthenticationQuintuplet at : this.quintupletList) {
                if (at == null) continue;
                sb.append(at.toString());
                sb.append(", ");
            }
        }
        sb.append("]");
        return sb.toString();
    }
}

