/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.m3ua.impl.oam;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javolution.util.FastCollection;
import javolution.util.FastMap;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.m3ua.As;
import org.restcomm.protocols.ss7.m3ua.AspFactory;
import org.restcomm.protocols.ss7.m3ua.ExchangeType;
import org.restcomm.protocols.ss7.m3ua.Functionality;
import org.restcomm.protocols.ss7.m3ua.IPSPType;
import org.restcomm.protocols.ss7.m3ua.RouteAs;
import org.restcomm.protocols.ss7.m3ua.impl.AsImpl;
import org.restcomm.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.restcomm.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.restcomm.protocols.ss7.m3ua.impl.parameter.ParameterFactoryImpl;
import org.restcomm.protocols.ss7.m3ua.parameter.NetworkAppearance;
import org.restcomm.protocols.ss7.m3ua.parameter.ParameterFactory;
import org.restcomm.protocols.ss7.m3ua.parameter.RoutingContext;
import org.restcomm.protocols.ss7.m3ua.parameter.TrafficModeType;
import org.restcomm.protocols.ss7.mtp.RoutingLabelFormat;
import org.restcomm.ss7.management.console.ShellExecutor;

public class M3UAShellExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(M3UAShellExecutor.class);
    private FastMap<String, M3UAManagementImpl> m3uaManagements = new FastMap();
    private M3UAManagementImpl m3uaManagement;
    protected ParameterFactory parameterFactory = new ParameterFactoryImpl();

    public Map<String, M3UAManagementImpl> getM3uaManagements() {
        return this.m3uaManagements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setM3uaManagements(Map<String, M3UAManagementImpl> m3uaManagementsTemp) {
        if (m3uaManagementsTemp != null) {
            M3UAShellExecutor m3UAShellExecutor = this;
            synchronized (m3UAShellExecutor) {
                FastMap<String, M3UAManagementImpl> newM3uaManagements = new FastMap<String, M3UAManagementImpl>();
                newM3uaManagements.putAll(m3uaManagementsTemp);
                this.m3uaManagements = newM3uaManagements;
            }
        }
    }

    private void setDefaultValue() {
        if (this.m3uaManagement == null) {
            Map.Entry<String, M3UAManagementImpl> m3uaManagementsTmp = this.m3uaManagements.entrySet().iterator().next();
            this.m3uaManagement = m3uaManagementsTmp.getValue();
        }
    }

    private String createAs(String[] args) throws Exception {
        if (args.length < 5 || args.length > 19) {
            return "Invalid Command";
        }
        String asName = args[3];
        if (asName == null) {
            return "Invalid Command";
        }
        Functionality functionlaity = Functionality.getFunctionality(args[4]);
        ExchangeType exchangeType = null;
        IPSPType ipspType = null;
        RoutingContext rc = null;
        TrafficModeType trafficModeType = null;
        NetworkAppearance na = null;
        if (functionlaity == null) {
            return "Invalid Command";
        }
        int count = 5;
        int minAspActiveForLoadbalance = 1;
        while (count < args.length) {
            String key;
            if ((key = args[count++]) == null) {
                return "Invalid Command";
            }
            if (key.equals("mode")) {
                if ((exchangeType = ExchangeType.getExchangeType(args[count++])) != null) continue;
                return "Invalid Command";
            }
            if (key.equals("ipspType")) {
                ipspType = IPSPType.getIPSPType(args[count++]);
                continue;
            }
            if (key.equals("rc")) {
                long rcLong = Long.parseLong(args[count++]);
                rc = this.parameterFactory.createRoutingContext(new long[]{rcLong});
                continue;
            }
            if (key.equals("traffic-mode")) {
                trafficModeType = this.getTrafficModeType(args[count++]);
                continue;
            }
            if (key.equals("network-appearance")) {
                na = this.parameterFactory.createNetworkAppearance(Long.parseLong(args[count++]));
                continue;
            }
            if (key.equals("min-asp")) {
                minAspActiveForLoadbalance = Integer.parseInt(args[count++]);
                continue;
            }
            if (key.equals("stackname")) {
                String m3uaStackName;
                M3UAManagementImpl m3uaManagementImpl;
                if ((m3uaManagementImpl = this.m3uaManagements.get(m3uaStackName = args[count++])) == null) {
                    return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
                }
                this.m3uaManagement = m3uaManagementImpl;
                continue;
            }
            return "Invalid Command";
        }
        this.setDefaultValue();
        As asImpl = this.m3uaManagement.createAs(asName, functionlaity, exchangeType, ipspType, rc, trafficModeType, minAspActiveForLoadbalance, na);
        return String.format("Successfully created AS name=%s on stack=%s", asImpl.getName(), this.m3uaManagement.getName());
    }

    private String destroyAs(String[] args) throws Exception {
        if (args.length < 4) {
            return "Invalid Command";
        }
        String asName = args[3];
        if (asName == null) {
            return "Invalid Command";
        }
        String m3uaStackName = null;
        if (args.length > 4) {
            if (!args[4].equals("stackname")) {
                return "Invalid Command";
            }
            m3uaStackName = args[5];
            M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
            if (m3uaManagementtmp == null) {
                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
            }
            this.m3uaManagement = m3uaManagementtmp;
        } else {
            this.setDefaultValue();
        }
        AsImpl asImpl = this.m3uaManagement.destroyAs(asName);
        return String.format("Successfully destroyed AS name=%s from stack=%s", asName, this.m3uaManagement.getName());
    }

    private String addAspToAs(String[] args) throws Exception {
        if (args.length < 5) {
            return "Invalid Command";
        }
        if (args[3] == null || args[4] == null) {
            return "Invalid Command";
        }
        if (args.length > 5) {
            if (!args[5].equals("stackname")) {
                return "Invalid Command";
            }
            String m3uaStackName = args[6];
            M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
            if (m3uaManagementtmp == null) {
                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
            }
            this.m3uaManagement = m3uaManagementtmp;
        } else {
            this.setDefaultValue();
        }
        this.m3uaManagement.assignAspToAs(args[3], args[4]);
        return String.format("Successfully added ASP name=%s to AS name=%s on stack=%s", args[4], args[3], this.m3uaManagement.getName());
    }

    private String removeAspFromAs(String[] args) throws Exception {
        if (args.length < 5) {
            return "Invalid Command";
        }
        if (args[3] == null || args[4] == null) {
            return "Invalid Command";
        }
        if (args.length > 5) {
            if (!args[5].equals("stackname")) {
                return "Invalid Command";
            }
            String m3uaStackName = args[6];
            M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
            if (m3uaManagementtmp == null) {
                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
            }
            this.m3uaManagement = m3uaManagementtmp;
        } else {
            this.setDefaultValue();
        }
        this.m3uaManagement.unassignAspFromAs(args[3], args[4]);
        return String.format("Successfully removed ASP name=%s from AS name=%s on stack=%s", args[4], args[3], this.m3uaManagement.getName());
    }

    private TrafficModeType getTrafficModeType(String mode) {
        int iMode = -1;
        if (mode == null) {
            return null;
        }
        if (mode.equals("loadshare")) {
            iMode = 2;
        } else if (mode.equals("override")) {
            iMode = 1;
        } else if (mode.equals("broadcast")) {
            iMode = 3;
        } else {
            return null;
        }
        return this.parameterFactory.createTrafficModeType(iMode);
    }

    private String showAspFactories(String[] args) {
        String m3uaStackName = null;
        if (args.length > 3) {
            if (!args[3].equals("stackname")) {
                return "Invalid Command";
            }
            m3uaStackName = args[4];
            M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
            if (m3uaManagementtmp == null) {
                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
            }
            this.m3uaManagement = m3uaManagementtmp;
        } else {
            this.setDefaultValue();
        }
        List<AspFactory> aspfactories = this.m3uaManagement.getAspfactories();
        if (aspfactories.size() == 0) {
            return String.format("No ASP defined yet for stack=%s", this.m3uaManagement.getName());
        }
        StringBuffer sb = new StringBuffer();
        for (AspFactory aspFactory : aspfactories) {
            AspFactoryImpl aspFactoryImpl = (AspFactoryImpl)aspFactory;
            sb.append("\n");
            aspFactoryImpl.show(sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String showRoutes(String[] args) {
        if (args.length > 3) {
            if (!args[3].equals("stackname")) {
                return "Invalid Command";
            }
            String m3uaStackName = args[4];
            M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
            if (m3uaManagementtmp == null) {
                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
            }
            this.m3uaManagement = m3uaManagementtmp;
        } else {
            this.setDefaultValue();
        }
        Map<String, RouteAs> route = this.m3uaManagement.getRoute();
        if (route.size() == 0) {
            return String.format("No Route defined yet for stack=%s", this.m3uaManagement.getName());
        }
        StringBuffer sb = new StringBuffer();
        Set<String> keys = route.keySet();
        for (String key : keys) {
            RouteAs routeAs = route.get(key);
            As[] asList = routeAs.getAsArray();
            sb.append("\n");
            sb.append(key);
            sb.append("        ");
            sb.append(routeAs.getTrafficModeType());
            sb.append("        ");
            for (int i = 0; i < asList.length; ++i) {
                As asImpl = asList[i];
                if (asImpl == null) continue;
                sb.append(asImpl.getName());
                sb.append(",");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private String showAs(String[] args) {
        if (args.length > 3) {
            if (!args[3].equals("stackname")) {
                return "Invalid Command";
            }
            String m3uaStackName = args[4];
            M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
            if (m3uaManagementtmp == null) {
                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
            }
            this.m3uaManagement = m3uaManagementtmp;
        } else {
            this.setDefaultValue();
        }
        List<As> appServers = this.m3uaManagement.getAppServers();
        if (appServers.size() == 0) {
            return String.format("No AS defined yet for stack=%s", this.m3uaManagement.getName());
        }
        StringBuffer sb = new StringBuffer();
        for (As as : appServers) {
            AsImpl asImpl = (AsImpl)as;
            sb.append("\n");
            asImpl.show(sb);
            sb.append("\n");
        }
        return sb.toString();
    }

    private String executeM3UA(String[] args) {
        try {
            if (args.length < 2 || args.length > 19) {
                return "Invalid Command";
            }
            if (args[1] == null) {
                return "Invalid Command";
            }
            if (args[1].equals("as")) {
                String rasCmd = args[2];
                if (rasCmd == null) {
                    return "Invalid Command";
                }
                if (rasCmd.equals("create")) {
                    return this.createAs(args);
                }
                if (rasCmd.equals("destroy")) {
                    return this.destroyAs(args);
                }
                if (rasCmd.equals("add")) {
                    return this.addAspToAs(args);
                }
                if (rasCmd.equals("remove")) {
                    return this.removeAspFromAs(args);
                }
                if (rasCmd.equals("show")) {
                    return this.showAs(args);
                }
                return "Invalid Command";
            }
            if (args[1].equals("asp")) {
                if (args.length < 3 || args.length > 11) {
                    return "Invalid Command";
                }
                String raspCmd = args[2];
                if (raspCmd == null) {
                    return "Invalid Command";
                }
                if (raspCmd.equals("create")) {
                    if (args.length < 5) {
                        return "Invalid Command";
                    }
                    String aspname = args[3];
                    String assocName = args[4];
                    if (aspname == null || assocName == null) {
                        return "Invalid Command";
                    }
                    AspFactory factory = null;
                    long aspid = -1L;
                    boolean isHeartBeatEnabled = false;
                    if (args.length > 5) {
                        int count = 5;
                        while (count < args.length) {
                            String key;
                            if ((key = args[count++]) == null) {
                                return "Invalid Command";
                            }
                            if (key.equals("aspid")) {
                                aspid = Long.parseLong(args[count++]);
                                continue;
                            }
                            if (key.equals("heartbeat")) {
                                isHeartBeatEnabled = Boolean.parseBoolean(args[count++]);
                                continue;
                            }
                            if (key.equals("stackname")) {
                                String m3uaStackName;
                                M3UAManagementImpl m3uaManagementImpl;
                                if ((m3uaManagementImpl = this.m3uaManagements.get(m3uaStackName = args[count++])) == null) {
                                    return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
                                }
                                this.m3uaManagement = m3uaManagementImpl;
                                continue;
                            }
                            return "Invalid Command";
                        }
                    }
                    this.setDefaultValue();
                    factory = aspid == -1L ? this.m3uaManagement.createAspFactory(aspname, assocName, isHeartBeatEnabled) : this.m3uaManagement.createAspFactory(aspname, assocName, aspid, isHeartBeatEnabled);
                    return String.format("Successfully created ASP name=%s on stack=%s", factory.getName(), this.m3uaManagement.getName());
                }
                if (raspCmd.equals("destroy")) {
                    if (args.length < 4 || args.length > 6) {
                        return "Invalid Command";
                    }
                    String aspName = args[3];
                    String m3uaStackName = null;
                    if (args.length > 4) {
                        if (!args[4].equals("stackname")) {
                            return "Invalid Command";
                        }
                        m3uaStackName = args[5];
                        M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
                        if (m3uaManagementtmp == null) {
                            return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
                        }
                        this.m3uaManagement = m3uaManagementtmp;
                    } else {
                        this.setDefaultValue();
                    }
                    this.m3uaManagement.destroyAspFactory(aspName);
                    return String.format("Successfully destroyed ASP name=%s from stack=%s", aspName, this.m3uaManagement.getName());
                }
                if (raspCmd.equals("show")) {
                    return this.showAspFactories(args);
                }
                if (raspCmd.equals("start")) {
                    if (args.length < 4) {
                        return "Invalid Command";
                    }
                    String aspName = args[3];
                    String m3uaStackName = null;
                    if (args.length > 4) {
                        if (!args[4].equals("stackname")) {
                            return "Invalid Command";
                        }
                        m3uaStackName = args[5];
                        M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
                        if (m3uaManagementtmp == null) {
                            return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
                        }
                        this.m3uaManagement = m3uaManagementtmp;
                    } else {
                        this.setDefaultValue();
                    }
                    this.m3uaManagement.startAsp(aspName);
                    return String.format("Successfully started ASP name=%s on stack=%s", aspName, this.m3uaManagement.getName());
                }
                if (raspCmd.equals("stop")) {
                    if (args.length < 4) {
                        return "Invalid Command";
                    }
                    String aspName = args[3];
                    String m3uaStackName = null;
                    if (args.length > 4) {
                        if (!args[4].equals("stackname")) {
                            return "Invalid Command";
                        }
                        m3uaStackName = args[5];
                        M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
                        if (m3uaManagementtmp == null) {
                            return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
                        }
                        this.m3uaManagement = m3uaManagementtmp;
                    } else {
                        this.setDefaultValue();
                    }
                    this.m3uaManagement.stopAsp(aspName);
                    return String.format("Successfully stopped ASP name=%s on stack=%s", aspName, this.m3uaManagement.getName());
                }
                return "Invalid Command";
            }
            if (args[1].equals("route")) {
                String routeCmd = args[2];
                if (routeCmd == null) {
                    return "Invalid Command";
                }
                if (routeCmd.equals("add")) {
                    if (args.length < 5 || args.length > 11) {
                        return "Invalid Command";
                    }
                    int count = 3;
                    String asName = args[count++];
                    int dpc = -1;
                    int opc = -1;
                    int si = -1;
                    int trafficMode = 2;
                    if (asName == null) {
                        return "Invalid Command";
                    }
                    dpc = Integer.parseInt(args[count++]);
                    opc = Integer.parseInt(args[count++]);
                    si = Integer.parseInt(args[count++]);
                    count = 7;
                    while (count < args.length) {
                        String key;
                        if ((key = args[count++]) == null) {
                            return "Invalid Command";
                        }
                        if (key.equals("trafficmode")) {
                            trafficMode = Integer.parseInt(args[count++]);
                            continue;
                        }
                        if (key.equals("stackname")) {
                            String m3uaStackName;
                            M3UAManagementImpl m3uaManagementImpl;
                            if ((m3uaManagementImpl = this.m3uaManagements.get(m3uaStackName = args[count++])) == null) {
                                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
                            }
                            this.m3uaManagement = m3uaManagementImpl;
                            continue;
                        }
                        return "Invalid Command";
                    }
                    this.setDefaultValue();
                    this.m3uaManagement.addRoute(dpc, opc, si, asName, trafficMode);
                    return String.format("AS=%s successfully added as route for DPC=%d on stack=%s", asName, dpc, this.m3uaManagement.getName());
                }
                if (routeCmd.equals("remove")) {
                    if (args.length < 5 || args.length > 9) {
                        return "Invalid Command";
                    }
                    int count = 3;
                    String asName = args[count++];
                    int dpc = -1;
                    int opc = -1;
                    int si = -1;
                    if (asName == null) {
                        return "Invalid Command";
                    }
                    dpc = Integer.parseInt(args[count++]);
                    opc = Integer.parseInt(args[count++]);
                    si = Integer.parseInt(args[count++]);
                    if (args.length > 7) {
                        if (!args[7].equals("stackname")) {
                            return "Invalid Command";
                        }
                        String m3uaStackName = args[8];
                        M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
                        if (m3uaManagementtmp == null) {
                            return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
                        }
                        this.m3uaManagement = m3uaManagementtmp;
                    } else {
                        this.setDefaultValue();
                    }
                    this.m3uaManagement.removeRoute(dpc, opc, si, asName);
                    return String.format("Successfully removed AS=%s as route for DPC=%d on stack=%s", asName, dpc, this.m3uaManagement.getName());
                }
                if (routeCmd.equals("show")) {
                    return this.showRoutes(args);
                }
            } else {
                if (args[1].equals("set")) {
                    return this.manageSet(args);
                }
                if (args[1].equals("get")) {
                    return this.manageGet(args);
                }
            }
            return "Invalid Command";
        }
        catch (Exception e) {
            logger.error(String.format("Error while executing comand %s", Arrays.toString(args)), e);
            return e.getMessage();
        }
        catch (Throwable t) {
            logger.error(String.format("Error while executing comand %s", Arrays.toString(args)), t);
            return t.getMessage();
        }
    }

    private String manageSet(String[] options) throws Exception {
        if (options.length < 4 || options.length > 6) {
            return "Invalid Command";
        }
        if (options.length > 4) {
            if (!options[4].equals("stackname")) {
                return "Invalid Command";
            }
            String m3uaStackName = options[5];
            M3UAManagementImpl m3uaManagementtmp = this.m3uaManagements.get(m3uaStackName);
            if (m3uaManagementtmp == null) {
                return String.format("No M3UA management bean found for passed name=%s", m3uaStackName);
            }
            this.m3uaManagement = m3uaManagementtmp;
        } else {
            this.setDefaultValue();
        }
        String parName = options[2].toLowerCase();
        if (parName.equals("heartbeattime")) {
            int val = Integer.parseInt(options[3]);
            this.m3uaManagement.setHeartbeatTime(val);
        } else if (parName.equals("statisticsenabled")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.m3uaManagement.setStatisticsEnabled(val);
        } else if (parName.equals("routingkeymanagementenabled")) {
            boolean val = Boolean.parseBoolean(options[3]);
            this.m3uaManagement.setRoutingKeyManagementEnabled(val);
        } else if (parName.equals("routinglabelformat")) {
            String vals = options[3];
            RoutingLabelFormat rlf = Enum.valueOf(RoutingLabelFormat.class, vals);
            this.m3uaManagement.setRoutingLabelFormat(rlf);
        } else if (parName.equals("uselsbforlinksetselection")) {
            Boolean valb = Boolean.parseBoolean(options[3]);
            this.m3uaManagement.setUseLsbForLinksetSelection(valb);
        } else {
            return "Invalid Command";
        }
        return String.format("Parameter has been successfully set on stack=%s", this.m3uaManagement.getName());
    }

    private String manageGet(String[] options) throws Exception {
        if (options.length < 2) {
            return "Invalid Command";
        }
        if (options.length == 3) {
            this.setDefaultValue();
            String parName = options[2].toLowerCase();
            StringBuilder sb = new StringBuilder();
            sb.append("stack=").append(this.m3uaManagement.getName()).append(" ");
            sb.append(options[2]);
            sb.append(" = ");
            if (parName.equals("maxsequencenumber")) {
                sb.append(this.m3uaManagement.getMaxSequenceNumber());
            } else if (parName.equals("maxasforroute")) {
                sb.append(this.m3uaManagement.getMaxAsForRoute());
            } else if (parName.equals("heartbeattime")) {
                sb.append(this.m3uaManagement.getHeartbeatTime());
            } else if (parName.equals("statisticsenabled")) {
                sb.append(this.m3uaManagement.getStatisticsEnabled());
            } else if (parName.equals("routingkeymanagementenabled")) {
                sb.append(this.m3uaManagement.getRoutingKeyManagementEnabled());
            } else if (parName.equals("routinglabelformat")) {
                sb.append((Object)this.m3uaManagement.getRoutingLabelFormat());
            } else if (parName.equals("uselsbforlinksetselection")) {
                sb.append(this.m3uaManagement.isUseLsbForLinksetSelection());
            } else if (parName.equals("deliverymessagethreadcount")) {
                sb.append(this.m3uaManagement.getDeliveryMessageThreadCount());
            } else {
                return "Invalid Command";
            }
            return sb.toString();
        }
        StringBuilder sb = new StringBuilder();
        FastCollection.Record e = this.m3uaManagements.head();
        FastMap.Entry<String, M3UAManagementImpl> end = this.m3uaManagements.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            M3UAManagementImpl managementImplTmp = (M3UAManagementImpl)((FastMap.Entry)e).getValue();
            String stackname = (String)((FastMap.Entry)e).getKey();
            sb.append("Properties for ");
            sb.append(stackname);
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("maxsequencenumber = ");
            sb.append(managementImplTmp.getMaxSequenceNumber());
            sb.append("\n");
            sb.append("maxasforroute = ");
            sb.append(managementImplTmp.getMaxAsForRoute());
            sb.append("\n");
            sb.append("heartbeattime = ");
            sb.append(managementImplTmp.getHeartbeatTime());
            sb.append("\n");
            sb.append("statisticsenabled = ");
            sb.append(managementImplTmp.getStatisticsEnabled());
            sb.append("\n");
            sb.append("routingkeymanagementenabled = ");
            sb.append(managementImplTmp.getRoutingKeyManagementEnabled());
            sb.append("\n");
            sb.append("routinglabelformat = ");
            sb.append((Object)managementImplTmp.getRoutingLabelFormat());
            sb.append("\n");
            sb.append("uselsbforlinksetselection = ");
            sb.append(managementImplTmp.isUseLsbForLinksetSelection());
            sb.append("\n");
            sb.append("deliverymessagethreadcount = ");
            sb.append(managementImplTmp.getDeliveryMessageThreadCount());
            sb.append("\n");
            sb.append("*******************");
            sb.append("\n");
            sb.append("\n");
        }
        return sb.toString();
    }

    public String execute(String[] args) {
        if (args[0].equals("m3ua")) {
            return this.executeM3UA(args);
        }
        return "Invalid Command";
    }

    public boolean handles(String command) {
        return command.startsWith("m3ua");
    }
}

