/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tools.traceparser;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import javolution.util.FastMap;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.ss7.cap.CAPDialogImpl;
import org.mobicents.protocols.ss7.cap.CAPProviderImpl;
import org.mobicents.protocols.ss7.cap.api.CAPDialog;
import org.mobicents.protocols.ss7.cap.api.CAPDialogListener;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessage;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPGeneralAbortReason;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPGprsReferenceNumber;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.cap.api.dialog.CAPUserAbortReason;
import org.mobicents.protocols.ss7.cap.api.errors.CAPErrorMessage;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ActivityTestRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ActivityTestResponse;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ApplyChargingReportRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ApplyChargingRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.AssistRequestInstructionsRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CAPServiceCircuitSwitchedCallListener;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CallGapRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CallInformationReportRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CallInformationRequestRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CancelRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CollectInformationRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ConnectRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ConnectToResourceRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ContinueRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ContinueWithArgumentRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.DisconnectForwardConnectionRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.DisconnectForwardConnectionWithArgumentRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.DisconnectLegRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.DisconnectLegResponse;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.EstablishTemporaryConnectionRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.EventReportBCSMRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.FurnishChargingInformationRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.InitialDPRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.InitiateCallAttemptRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.InitiateCallAttemptResponse;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.MoveLegRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.MoveLegResponse;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.PlayAnnouncementRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.PromptAndCollectUserInformationRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.PromptAndCollectUserInformationResponse;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ReleaseCallRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.RequestReportBCSMEventRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.ResetTimerRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.SendChargingInformationRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.SpecializedResourceReportRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ActivityTestGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ActivityTestGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingReportGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ApplyChargingReportGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.CAPServiceGprsListener;
import org.mobicents.protocols.ss7.cap.api.service.gprs.CancelGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ConnectGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ContinueGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EntityReleasedGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EntityReleasedGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EventReportGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.EventReportGPRSResponse;
import org.mobicents.protocols.ss7.cap.api.service.gprs.FurnishChargingInformationGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.InitialDpGprsRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ReleaseGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.RequestReportGPRSEventRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.ResetTimerGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.gprs.SendChargingInformationGPRSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.CAPServiceSmsListener;
import org.mobicents.protocols.ss7.cap.api.service.sms.ConnectSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.ContinueSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.EventReportSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.FurnishChargingInformationSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.InitialDPSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.ReleaseSMSRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.RequestReportSMSEventRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.ResetTimerSMSRequest;
import org.mobicents.protocols.ss7.isup.CircuitManager;
import org.mobicents.protocols.ss7.isup.ISUPEvent;
import org.mobicents.protocols.ss7.isup.ISUPListener;
import org.mobicents.protocols.ss7.isup.ISUPTimeoutEvent;
import org.mobicents.protocols.ss7.isup.impl.CircuitManagerImpl;
import org.mobicents.protocols.ss7.isup.impl.ISUPProviderImpl;
import org.mobicents.protocols.ss7.isup.impl.ISUPStackImpl;
import org.mobicents.protocols.ss7.map.MAPDialogImpl;
import org.mobicents.protocols.ss7.map.MAPProviderImpl;
import org.mobicents.protocols.ss7.map.api.MAPDialog;
import org.mobicents.protocols.ss7.map.api.MAPDialogListener;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessage;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortProviderReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPAbortSource;
import org.mobicents.protocols.ss7.map.api.dialog.MAPNoticeProblemDiagnostic;
import org.mobicents.protocols.ss7.map.api.dialog.MAPRefuseReason;
import org.mobicents.protocols.ss7.map.api.dialog.MAPUserAbortChoice;
import org.mobicents.protocols.ss7.map.api.errors.MAPErrorMessage;
import org.mobicents.protocols.ss7.map.api.primitives.AddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.callhandling.IstCommandRequest;
import org.mobicents.protocols.ss7.map.api.service.callhandling.IstCommandResponse;
import org.mobicents.protocols.ss7.map.api.service.callhandling.MAPServiceCallHandlingListener;
import org.mobicents.protocols.ss7.map.api.service.callhandling.ProvideRoamingNumberRequest;
import org.mobicents.protocols.ss7.map.api.service.callhandling.ProvideRoamingNumberResponse;
import org.mobicents.protocols.ss7.map.api.service.callhandling.SendRoutingInformationRequest;
import org.mobicents.protocols.ss7.map.api.service.callhandling.SendRoutingInformationResponse;
import org.mobicents.protocols.ss7.map.api.service.lsm.MAPServiceLsmListener;
import org.mobicents.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.lsm.ProvideSubscriberLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSRequest;
import org.mobicents.protocols.ss7.map.api.service.lsm.SendRoutingInfoForLCSResponse;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberLocationReportRequest;
import org.mobicents.protocols.ss7.map.api.service.lsm.SubscriberLocationReportResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.MAPServiceMobilityListener;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.SendAuthenticationInfoResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.ForwardCheckSSIndicationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.ResetRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.faultRecovery.RestoreDataResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.imei.CheckImeiResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.CancelLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.PurgeMSResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.SendIdentificationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateGprsLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.locationManagement.UpdateLocationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeRequest_Mobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.oam.ActivateTraceModeResponse_Mobility;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.AnyTimeInterrogationResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.ProvideSubscriberInfoResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.DeleteSubscriberDataResponse;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.InsertSubscriberDataResponse;
import org.mobicents.protocols.ss7.map.api.service.oam.ActivateTraceModeRequest_Oam;
import org.mobicents.protocols.ss7.map.api.service.oam.ActivateTraceModeResponse_Oam;
import org.mobicents.protocols.ss7.map.api.service.oam.MAPServiceOamListener;
import org.mobicents.protocols.ss7.map.api.service.oam.SendImsiRequest;
import org.mobicents.protocols.ss7.map.api.service.oam.SendImsiResponse;
import org.mobicents.protocols.ss7.map.api.service.pdpContextActivation.MAPServicePdpContextActivationListener;
import org.mobicents.protocols.ss7.map.api.service.pdpContextActivation.SendRoutingInfoForGprsRequest;
import org.mobicents.protocols.ss7.map.api.service.pdpContextActivation.SendRoutingInfoForGprsResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.AlertServiceCentreResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.InformServiceCentreRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MAPServiceSmsListener;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MoForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.MtForwardShortMessageResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.NoteSubscriberPresentRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReadyForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReadyForSMResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.ReportSMDeliveryStatusResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMRequest;
import org.mobicents.protocols.ss7.map.api.service.sms.SendRoutingInfoForSMResponse;
import org.mobicents.protocols.ss7.map.api.service.sms.SmsSignalInfo;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ActivateSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ActivateSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.DeactivateSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.DeactivateSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.EraseSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.EraseSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.GetPasswordRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.GetPasswordResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.InterrogateSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.InterrogateSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.MAPServiceSupplementaryListener;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.ProcessUnstructuredSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterPasswordRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterPasswordResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.RegisterSSResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSNotifyResponse;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSRequest;
import org.mobicents.protocols.ss7.map.api.service.supplementary.UnstructuredSSResponse;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsCommandTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsDeliverReportTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsDeliverTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsStatusReportTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsSubmitTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.SmsTpdu;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserData;
import org.mobicents.protocols.ss7.map.dialog.MAPOpenInfoImpl;
import org.mobicents.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.mobicents.protocols.ss7.mtp.Mtp3UserPart;
import org.mobicents.protocols.ss7.mtp.RoutingLabelFormat;
import org.mobicents.protocols.ss7.sccp.impl.SccpStackImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.mobicents.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.mobicents.protocols.ss7.sccp.message.ParseException;
import org.mobicents.protocols.ss7.sccp.parameter.GlobalTitle;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.sccp.parameter.Segmentation;
import org.mobicents.protocols.ss7.scheduler.Clock;
import org.mobicents.protocols.ss7.scheduler.DefaultClock;
import org.mobicents.protocols.ss7.scheduler.Scheduler;
import org.mobicents.protocols.ss7.statistics.api.LongValue;
import org.mobicents.protocols.ss7.tcap.DialogImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPCounterProvider;
import org.mobicents.protocols.ss7.tcap.api.TCAPProvider;
import org.mobicents.protocols.ss7.tcap.api.TCListener;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCNoticeIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCPAbortIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUniIndication;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortIndication;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.DialogRequestAPDU;
import org.mobicents.protocols.ss7.tcap.asn.Encodable;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.Utils;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.OperationCode;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResult;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultLast;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.mobicents.protocols.ss7.tools.traceparser.DialogImplWrapper;
import org.mobicents.protocols.ss7.tools.traceparser.Mtp3UserPartProxy;
import org.mobicents.protocols.ss7.tools.traceparser.ParseProtocol;
import org.mobicents.protocols.ss7.tools.traceparser.ProcessControl;
import org.mobicents.protocols.ss7.tools.traceparser.SccpProviderWrapper;
import org.mobicents.protocols.ss7.tools.traceparser.Ss7ParseParameters;
import org.mobicents.protocols.ss7.tools.traceparser.TCAPProviderImplWrapper;
import org.mobicents.protocols.ss7.tools.traceparser.TCAPStackImplWrapper;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderDriver;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderDriverActerna;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderDriverHexStream;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderDriverPcap;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderDriverSimpleSeq;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderException;
import org.mobicents.protocols.ss7.tools.traceparser.TraceReaderListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SS7TraceParser
implements TraceReaderListener,
MAPDialogListener,
CAPDialogListener,
TCListener,
Runnable,
ProcessControl,
MAPServiceMobilityListener,
MAPServiceCallHandlingListener,
MAPServiceOamListener,
MAPServicePdpContextActivationListener,
MAPServiceSupplementaryListener,
MAPServiceSmsListener,
MAPServiceLsmListener,
CAPServiceCircuitSwitchedCallListener,
CAPServiceGprsListener,
CAPServiceSmsListener,
ISUPListener {
    private Ss7ParseParameters par;
    private Thread t;
    private boolean taskIsFinished = false;
    private boolean needInterrupt = false;
    private String errorMessage = null;
    private PrintWriter pw;
    private DialogImpl curTcapDialog;
    private int msgCount;
    private String persistDir;
    private TraceReaderDriver driver;
    private TCAPProviderImplWrapper tcapProvider;
    private TCAPStackImplWrapper tcapStack;
    private TCAPCounterProvider tcapCntProv;
    private SccpProviderWrapper sccpProvider;
    private SccpStackImpl sccpStack = new SccpStackImpl("TraceParserSccpStack");
    private MAPProviderImpl mapProvider;
    private CAPProviderImpl capProvider;
    private MessageFactoryImpl msgFact;
    private Scheduler scheduler;
    private ISUPProviderImpl isupProvider;
    private ISUPStackImpl isupStack;
    private Map<Integer, Map<Long, DialogImplWrapper>> dialogs = new HashMap<Integer, Map<Long, DialogImplWrapper>>();
    private long dialogEnumerator = 0L;
    private long tcapLogMsg = 0L;
    private ArrayList<String> msgDetailBuffer = new ArrayList();
    private ArrayList<DialogMessage> lstDialogMessageChainSource = new ArrayList();
    HashMap<MessageReassemblyProcess, XUnitDataDef> xLst = new HashMap();
    SccpDataMessageImpl sccpMessage;

    public SS7TraceParser(String persistDir, Ss7ParseParameters par) {
        this.persistDir = persistDir;
        this.par = par;
    }

    public void parse() {
        this.t = new Thread(this);
        this.t.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block47: {
            block46: {
                block43: {
                    block44: {
                        String filePath = this.par.getSourceFilePath();
                        switch (this.par.getFileTypeN()) {
                            case Acterna: {
                                this.driver = new TraceReaderDriverActerna(this, filePath);
                                break;
                            }
                            case SimpleSeq: {
                                this.driver = new TraceReaderDriverSimpleSeq(this, filePath);
                                break;
                            }
                            case Pcap: {
                                this.driver = new TraceReaderDriverPcap(this, filePath);
                                break;
                            }
                            case HexStream: {
                                this.driver = new TraceReaderDriverHexStream(this, filePath);
                                break;
                            }
                            default: {
                                this.setFinishedState("Unknown TraceReaderDriver: " + (Object)((Object)this.par.getFileTypeN()));
                                return;
                            }
                        }
                        try {
                            try {
                                if (this.checkNeedInterrupt()) {
                                    Object var5_2 = null;
                                    if (this.pw != null) {
                                        this.pw.close();
                                    }
                                    if (this.mapProvider != null) {
                                        this.mapProvider.stop();
                                    }
                                    if (this.capProvider == null) break block43;
                                    break block44;
                                }
                                String logFileName = this.par.getMsgLogFilePath();
                                if (logFileName != null && !logFileName.equals("")) {
                                    try {
                                        FileOutputStream fos = new FileOutputStream(logFileName);
                                        this.pw = new PrintWriter(fos);
                                    }
                                    catch (Exception e) {
                                        e.printStackTrace();
                                        this.setFinishedState("Exception while opening th message log file:\nFileName=" + logFileName + "\nMessage=" + e.getMessage());
                                        Object var5_3 = null;
                                        if (this.pw != null) {
                                            this.pw.close();
                                        }
                                        if (this.mapProvider != null) {
                                            this.mapProvider.stop();
                                        }
                                        if (this.capProvider != null) {
                                            this.capProvider.stop();
                                        }
                                        if (this.tcapStack != null) {
                                            this.tcapStack.stop();
                                        }
                                        if (this.driver == null) return;
                                        this.driver.removeTraceListener(this);
                                        return;
                                    }
                                }
                                this.xLst.clear();
                                if (this.par.getParseProtocol() == ParseProtocol.Map || this.par.getParseProtocol() == ParseProtocol.Cap) {
                                    this.sccpProvider = new SccpProviderWrapper(this.sccpStack);
                                    this.msgFact = new MessageFactoryImpl(this.sccpStack);
                                    this.tcapStack = new TCAPStackImplWrapper(this.sccpProvider, 1);
                                    this.tcapStack.setPersistDir(this.persistDir);
                                    this.tcapStack.setPreviewMode(true);
                                    this.tcapProvider = (TCAPProviderImplWrapper)this.tcapStack.getProvider();
                                    this.tcapProvider.addTCListener(this);
                                    this.tcapStack.start();
                                    this.tcapStack.setMaxDialogs(100000);
                                    this.tcapStack.setStatisticsEnabled(true);
                                    this.tcapCntProv = this.tcapStack.getCounterProvider();
                                    this.tcapCntProv.getOutgoingDialogsPerApplicatioContextName("a1");
                                    this.tcapCntProv.getIncomingDialogsPerApplicatioContextName("a1");
                                    this.tcapCntProv.getOutgoingInvokesPerOperationCode("a1");
                                    this.tcapCntProv.getIncomingInvokesPerOperationCode("a1");
                                    this.tcapCntProv.getOutgoingErrorsPerErrorCode("a1");
                                    this.tcapCntProv.getIncomingErrorsPerErrorCode("a1");
                                    this.tcapCntProv.getOutgoingRejectPerProblem("a1");
                                    this.tcapCntProv.getIncomingRejectPerProblem("a1");
                                    if (this.par.getParseProtocol() == ParseProtocol.Map) {
                                        this.mapProvider = new MAPProviderImpl("Trace-Parser", this.tcapProvider);
                                        this.mapProvider.getMAPServiceMobility().acivate();
                                        this.mapProvider.getMAPServiceCallHandling().acivate();
                                        this.mapProvider.getMAPServiceOam().acivate();
                                        this.mapProvider.getMAPServicePdpContextActivation().acivate();
                                        this.mapProvider.getMAPServiceSupplementary().acivate();
                                        this.mapProvider.getMAPServiceSms().acivate();
                                        this.mapProvider.getMAPServiceLsm().acivate();
                                        this.mapProvider.getMAPServiceLsm().acivate();
                                        this.mapProvider.addMAPDialogListener(this);
                                        this.mapProvider.getMAPServiceMobility().addMAPServiceListener(this);
                                        this.mapProvider.getMAPServiceCallHandling().addMAPServiceListener(this);
                                        this.mapProvider.getMAPServiceOam().addMAPServiceListener(this);
                                        this.mapProvider.getMAPServicePdpContextActivation().addMAPServiceListener(this);
                                        this.mapProvider.getMAPServiceSupplementary().addMAPServiceListener(this);
                                        this.mapProvider.getMAPServiceSms().addMAPServiceListener(this);
                                        this.mapProvider.getMAPServiceLsm().addMAPServiceListener(this);
                                        this.mapProvider.start();
                                    } else {
                                        this.capProvider = new CAPProviderImpl("Trace-Parser", (TCAPProvider)this.tcapProvider);
                                        this.capProvider.getCAPServiceCircuitSwitchedCall().acivate();
                                        this.capProvider.getCAPServiceGprs().acivate();
                                        this.capProvider.getCAPServiceSms().acivate();
                                        this.capProvider.getCAPServiceCircuitSwitchedCall().addCAPServiceListener((CAPServiceCircuitSwitchedCallListener)this);
                                        this.capProvider.getCAPServiceGprs().addCAPServiceListener((CAPServiceGprsListener)this);
                                        this.capProvider.getCAPServiceSms().addCAPServiceListener((CAPServiceSmsListener)this);
                                        this.capProvider.start();
                                        this.capProvider.addCAPDialogListener((CAPDialogListener)this);
                                    }
                                } else {
                                    this.scheduler = new Scheduler();
                                    DefaultClock clock = new DefaultClock();
                                    this.scheduler.setClock((Clock)clock);
                                    this.isupStack = new ISUPStackImpl(this.scheduler, 1, 2, false);
                                    this.isupProvider = (ISUPProviderImpl)this.isupStack.getIsupProvider();
                                    this.isupStack.setMtp3UserPart((Mtp3UserPart)new Mtp3UserPartProxy());
                                    this.isupStack.setCircuitManager((CircuitManager)new CircuitManagerImpl());
                                    this.scheduler.start();
                                    this.isupStack.start();
                                    this.isupProvider.addListener((ISUPListener)this);
                                }
                                this.driver.addTraceListener(this);
                                if (this.checkNeedInterrupt()) {
                                    break block46;
                                }
                                this.driver.startTraceFile();
                                this.setFinishedState(null);
                                break block47;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                this.setFinishedState("Exception while parsing: " + e.getMessage());
                                Object var5_6 = null;
                                if (this.pw != null) {
                                    this.pw.close();
                                }
                                if (this.mapProvider != null) {
                                    this.mapProvider.stop();
                                }
                                if (this.capProvider != null) {
                                    this.capProvider.stop();
                                }
                                if (this.tcapStack != null) {
                                    this.tcapStack.stop();
                                }
                                if (this.driver == null) return;
                                this.driver.removeTraceListener(this);
                                return;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var5_7 = null;
                            if (this.pw != null) {
                                this.pw.close();
                            }
                            if (this.mapProvider != null) {
                                this.mapProvider.stop();
                            }
                            if (this.capProvider != null) {
                                this.capProvider.stop();
                            }
                            if (this.tcapStack != null) {
                                this.tcapStack.stop();
                            }
                            if (this.driver == null) throw throwable;
                            this.driver.removeTraceListener(this);
                            throw throwable;
                        }
                    }
                    this.capProvider.stop();
                }
                if (this.tcapStack != null) {
                    this.tcapStack.stop();
                }
                if (this.driver == null) return;
                this.driver.removeTraceListener(this);
                return;
            }
            Object var5_4 = null;
            if (this.pw != null) {
                this.pw.close();
            }
            if (this.mapProvider != null) {
                this.mapProvider.stop();
            }
            if (this.capProvider != null) {
                this.capProvider.stop();
            }
            if (this.tcapStack != null) {
                this.tcapStack.stop();
            }
            if (this.driver == null) return;
            this.driver.removeTraceListener(this);
            return;
        }
        Object var5_5 = null;
        if (this.pw != null) {
            this.pw.close();
        }
        if (this.mapProvider != null) {
            this.mapProvider.stop();
        }
        if (this.capProvider != null) {
            this.capProvider.stop();
        }
        if (this.tcapStack != null) {
            this.tcapStack.stop();
        }
        if (this.driver == null) return;
        this.driver.removeTraceListener(this);
    }

    public void uppendStringLongPull(StringBuilder sb, Map<String, LongValue> data, String title) {
        sb.append("\n");
        sb.append(title);
        sb.append("\n");
        for (String s : data.keySet()) {
            LongValue lv = data.get(s);
            sb.append(s);
            sb.append("\t");
            sb.append(lv.getValue());
            sb.append("\n");
        }
    }

    public String getStatisticData() {
        StringBuilder sb = new StringBuilder();
        if (this.tcapCntProv != null) {
            sb.append("TCAP counters --------");
            sb.append("\n");
            sb.append("\n");
            sb.append("TcUniReceivedCount : \t" + this.tcapCntProv.getTcUniReceivedCount());
            sb.append("\n");
            sb.append("TcBeginReceivedCount : \t" + this.tcapCntProv.getTcBeginReceivedCount());
            sb.append("\n");
            sb.append("TcContinueReceivedCount : \t" + this.tcapCntProv.getTcContinueReceivedCount());
            sb.append("\n");
            sb.append("TcEndReceivedCount : \t" + this.tcapCntProv.getTcEndReceivedCount());
            sb.append("\n");
            sb.append("TcPAbortReceivedCount : \t" + this.tcapCntProv.getTcPAbortReceivedCount());
            sb.append("\n");
            sb.append("TcUserAbortReceivedCount : \t" + this.tcapCntProv.getTcUserAbortReceivedCount());
            sb.append("\n");
            sb.append("InvokeReceivedCount : \t" + this.tcapCntProv.getInvokeReceivedCount());
            sb.append("\n");
            sb.append("ReturnResultReceivedCount : \t" + this.tcapCntProv.getReturnResultReceivedCount());
            sb.append("\n");
            sb.append("ReturnResultLastReceivedCount : \t" + this.tcapCntProv.getReturnResultLastReceivedCount());
            sb.append("\n");
            sb.append("ReturnErrorReceivedCount : \t" + this.tcapCntProv.getReturnErrorReceivedCount());
            sb.append("\n");
            sb.append("RejectReceivedCount : \t" + this.tcapCntProv.getRejectReceivedCount());
            sb.append("\n");
            sb.append("AllEstablishedDialogsCount : \t" + this.tcapCntProv.getAllEstablishedDialogsCount());
            sb.append("\n");
            this.uppendStringLongPull(sb, this.tcapCntProv.getIncomingDialogsPerApplicatioContextName("a1"), "IncomingDialogsPerApplicatioContextName");
            this.uppendStringLongPull(sb, this.tcapCntProv.getIncomingInvokesPerOperationCode("a1"), "IncomingInvokesPerOperationCode");
            this.uppendStringLongPull(sb, this.tcapCntProv.getIncomingErrorsPerErrorCode("a1"), "IncomingErrorsPerErrorCode");
            this.uppendStringLongPull(sb, this.tcapCntProv.getIncomingRejectPerProblem("a1"), "IncomingRejectPerProblem");
        }
        return sb.toString();
    }

    private void setFinishedState(String errorMessage) {
        if (this.par.getMessageChainFilePath() != null) {
            ArrayList<DialogMessageChain> lst1 = new ArrayList<DialogMessageChain>();
            FastMap<Long, DialogMessageChain> lst11 = new FastMap<Long, DialogMessageChain>();
            for (DialogMessage dm : this.lstDialogMessageChainSource) {
                DialogMessageChain dmc = (DialogMessageChain)lst11.get(dm.dialogId1);
                if (dmc == null && dm.dialogId2 != 0L) {
                    dmc = (DialogMessageChain)lst11.get(dm.dialogId2);
                }
                if (dmc == null) {
                    dmc = new DialogMessageChain();
                    lst1.add(dmc);
                }
                dmc.setDialogId(dm.dialogId1);
                dmc.setDialogId(dm.dialogId2);
                lst11.put(dmc.dialogId1, dmc);
                if (dmc.dialogId2 != 0L) {
                    lst11.put(dmc.dialogId2, dmc);
                }
                dmc.addDialogMessage(dm);
            }
            FastMap<DialogMessageChain, DialogMessageChain> lst2 = new FastMap<DialogMessageChain, DialogMessageChain>();
            try {
                for (DialogMessageChain dmc : lst1) {
                    if (!dmc.checkFullDialog()) continue;
                    DialogMessageChain dmc2 = (DialogMessageChain)lst2.get(dmc);
                    if (dmc2 == null) {
                        dmc2 = dmc;
                        lst2.put(dmc, dmc);
                    }
                    dmc2.addChainCount();
                }
            }
            catch (Throwable e) {
                int g = 0;
                ++g;
                e.printStackTrace();
            }
            try {
                FileOutputStream fos = new FileOutputStream(this.par.getMessageChainFilePath());
                this.pw = new PrintWriter(fos);
                for (DialogMessageChain dmc : lst2.values()) {
                    this.pw.append(dmc.toString());
                    this.pw.append("\n");
                }
                this.pw.close();
                fos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (errorMessage != null) {
            this.errorMessage = errorMessage;
        }
        this.taskIsFinished = true;
    }

    @Override
    public void ss7Message(int si, int ni, int priority, int opc, int dpc, int sls, byte[] data) throws TraceReaderException {
        ++this.msgCount;
        if (this.msgCount == 328628) {
            int fff = 0;
            ++fff;
        }
        if (data == null || data.length < 3) {
            throw new TraceReaderException("Too little data in the raw data");
        }
        try {
            ByteArrayInputStream in0 = new ByteArrayInputStream(data);
            DataInputStream in = new DataInputStream(in0);
            int type = in.readUnsignedByte();
            try {
                SccpMessageImpl msg = this.msgFact.createMessage(type, opc, dpc, sls, in, this.par.getSccpProtocolVersion(), 0);
                if (msg == null || !(msg instanceof SccpDataMessageImpl)) {
                    return;
                }
                this.onMessage((SccpDataMessageImpl)msg, 0);
            }
            catch (ParseException pe) {
                throw new TraceReaderException(pe);
            }
        }
        catch (IOException e) {
            throw new TraceReaderException("IOException: " + e.getMessage(), e);
        }
    }

    private void printIsupMsgData() {
        for (String s : this.msgDetailBuffer) {
            this.pw.print("--- ");
            this.pw.print(s);
            this.pw.println();
        }
        this.pw.println();
        this.pw.println();
        this.pw.flush();
    }

    public void onMessage(SccpDataMessageImpl message, int seqControl) {
        this.sccpMessage = message;
        try {
            this.msgDetailBuffer.clear();
            this.curTcapDialog = null;
            byte[] data = message.getData();
            SccpAddress localAddress = message.getCalledPartyAddress();
            SccpAddress remoteAddress = message.getCallingPartyAddress();
            Segmentation sgm = message.getSegmentation();
            if (sgm != null) {
                if (sgm.isFirstSegIndication()) {
                    if (sgm.getRemainingSegments() > 0) {
                        MessageReassemblyProcess mrp = new MessageReassemblyProcess(sgm.getSegmentationLocalRef(), message.getCallingPartyAddress());
                        XUnitDataDef dd = new XUnitDataDef();
                        dd.remainingSegm = sgm.getRemainingSegments();
                        dd.dLst.add(data);
                        this.xLst.put(mrp, dd);
                        return;
                    }
                } else {
                    MessageReassemblyProcess mrp = new MessageReassemblyProcess(sgm.getSegmentationLocalRef(), message.getCallingPartyAddress());
                    XUnitDataDef dd = this.xLst.get(mrp);
                    if (dd == null) {
                        return;
                    }
                    --dd.remainingSegm;
                    if (dd.remainingSegm != sgm.getRemainingSegments()) {
                        return;
                    }
                    dd.dLst.add(data);
                    if (dd.remainingSegm > 0) {
                        return;
                    }
                    this.xLst.remove(mrp);
                    ByteArrayOutputStream stm = new ByteArrayOutputStream();
                    for (byte[] buf : dd.dLst) {
                        stm.write(buf);
                    }
                    data = stm.toByteArray();
                }
            }
            message.setData(data);
            if (this.par.getMessageChainFilePath() != null) {
                DialogMessage dm = new DialogMessage();
                dm.opc = message.getIncomingOpc();
                dm.dpc = message.getIncomingDpc();
                dm.callingSsn = message.getCallingPartyAddress().getSubsystemNumber();
                dm.calledSsn = message.getCalledPartyAddress().getSubsystemNumber();
                GlobalTitle gt = message.getCallingPartyAddress().getGlobalTitle();
                if (gt != null) {
                    dm.callingPA = gt.getDigits();
                }
                if ((gt = message.getCalledPartyAddress().getGlobalTitle()) != null) {
                    dm.calledPA = gt.getDigits();
                }
                byte[] dataT = message.getData();
                AsnInputStream ais2 = new AsnInputStream(dataT);
                int tag2 = ais2.readTag();
                switch (tag2) {
                    case 2: {
                        Encodable tbm2;
                        dm.tcapMessage = "TC-BEGIN";
                        try {
                            tbm2 = TcapFactory.createTCBeginMessage(ais2);
                            dm.dialogId1 = Utils.decodeTransactionId(tbm2.getOriginatingTransactionId());
                        }
                        catch (Exception tbm2) {}
                        break;
                    }
                    case 5: {
                        dm.tcapMessage = "TC-CONTINUE";
                        try {
                            TCContinueMessage tcm = TcapFactory.createTCContinueMessage(ais2);
                            dm.dialogId1 = Utils.decodeTransactionId(tcm.getOriginatingTransactionId());
                            dm.dialogId2 = Utils.decodeTransactionId(tcm.getDestinationTransactionId());
                        }
                        catch (Exception tcm) {}
                        break;
                    }
                    case 4: {
                        Encodable tbm2;
                        dm.tcapMessage = "TC-END";
                        try {
                            tbm2 = TcapFactory.createTCEndMessage(ais2);
                            dm.dialogId1 = Utils.decodeTransactionId(tbm2.getDestinationTransactionId());
                        }
                        catch (Exception tbm) {}
                        break;
                    }
                    case 7: {
                        Encodable tbm2;
                        dm.tcapMessage = "TC-ABORT";
                        try {
                            tbm2 = TcapFactory.createTCAbortMessage(ais2);
                            dm.dialogId1 = Utils.decodeTransactionId(tbm2.getDestinationTransactionId());
                            break;
                        }
                        catch (Exception tbm) {
                            // empty catch block
                        }
                    }
                }
                dm.messageNum = this.msgCount;
                this.lstDialogMessageChainSource.add(dm);
            }
            if (this.par.getOpcDpcFilter() != null) {
                boolean inSet = false;
                for (Integer I1 : this.par.getOpcDpcFilter()) {
                    if (I1 == null) continue;
                    int i1 = I1;
                    if (message.getIncomingOpc() != i1 && message.getIncomingDpc() != i1) continue;
                    inSet = true;
                    break;
                }
                if (inSet) {
                    this.tcapProvider.onMessage(message);
                }
            } else {
                this.tcapProvider.onMessage(message);
            }
            if (this.curTcapDialog == null || this.curTcapDialog.getPrevewDialogData() == null || this.curTcapDialog.getPrevewDialogData().getUpperDialog() == null) {
                return;
            }
            AsnInputStream ais = new AsnInputStream(data);
            AsnInputStream aisMsg = new AsnInputStream(data);
            int tag = ais.readTag();
            switch (tag) {
                case 5: {
                    if (this.pw == null) break;
                    TCContinueMessage tcm = TcapFactory.createTCContinueMessage(ais);
                    long originatingTransactionId = Utils.decodeTransactionId(tcm.getOriginatingTransactionId());
                    long destinationTransactionId = Utils.decodeTransactionId(tcm.getDestinationTransactionId());
                    if (!this.CheckTransactionIdFilter(this.curTcapDialog.getApplicationContextName())) {
                        return;
                    }
                    if (!this.CheckDialogIdFilter(destinationTransactionId, originatingTransactionId)) {
                        return;
                    }
                    this.pw.print("TC-CONTINUE: ");
                    this.printAddresses(message, originatingTransactionId, destinationTransactionId);
                    if (this.par.getTcapMsgData()) {
                        this.LogDataTag(aisMsg, "Continue", tcm.getComponent(), this.curTcapDialog.getApplicationContextName(), tcm.getDialogPortion());
                    }
                    this.printMsgData();
                    break;
                }
                case 2: {
                    if (this.pw == null) break;
                    TCBeginMessage tcb = TcapFactory.createTCBeginMessage(ais);
                    long originatingTransactionId = Utils.decodeTransactionId(tcb.getOriginatingTransactionId());
                    if (!this.CheckTransactionIdFilter(this.curTcapDialog.getApplicationContextName())) {
                        return;
                    }
                    if (!this.CheckDialogIdFilter(originatingTransactionId, originatingTransactionId)) {
                        return;
                    }
                    this.pw.print("TC-BEGIN: ");
                    this.printAddresses(message, originatingTransactionId, -1L);
                    if (this.par.getTcapMsgData()) {
                        this.LogDataTag(aisMsg, "Begin", tcb.getComponent(), this.curTcapDialog.getApplicationContextName(), tcb.getDialogPortion());
                    }
                    this.printMsgData();
                    break;
                }
                case 4: {
                    if (this.pw == null) break;
                    TCEndMessage teb = TcapFactory.createTCEndMessage(ais);
                    long destinationTransactionId = Utils.decodeTransactionId(teb.getDestinationTransactionId());
                    if (!this.CheckTransactionIdFilter(this.curTcapDialog.getApplicationContextName())) {
                        return;
                    }
                    if (!this.CheckDialogIdFilter(destinationTransactionId, destinationTransactionId)) {
                        return;
                    }
                    this.pw.print("TC-END: ");
                    this.printAddresses(message, -1L, destinationTransactionId);
                    if (this.par.getTcapMsgData()) {
                        this.LogDataTag(aisMsg, "End", teb.getComponent(), this.curTcapDialog.getApplicationContextName(), teb.getDialogPortion());
                    }
                    this.printMsgData();
                    break;
                }
                case 7: {
                    if (this.pw == null) break;
                    TCAbortMessage tub = TcapFactory.createTCAbortMessage(ais);
                    long destinationTransactionId = Utils.decodeTransactionId(tub.getDestinationTransactionId());
                    if (!this.CheckTransactionIdFilter(this.curTcapDialog.getApplicationContextName())) {
                        return;
                    }
                    if (!this.CheckDialogIdFilter(destinationTransactionId, destinationTransactionId)) {
                        return;
                    }
                    this.pw.print("TC-ABORT: ");
                    this.printAddresses(message, -1L, destinationTransactionId);
                    if (this.par.getTcapMsgData()) {
                        this.LogDataTag(aisMsg, "Abort", null, this.curTcapDialog.getApplicationContextName(), tub.getDialogPortion());
                    }
                    this.printMsgData();
                    this.pw.println();
                    this.pw.flush();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void onMessageX(SccpDataMessageImpl message, int seqControl) {
    }

    private void printMsgData() {
        for (String s : this.msgDetailBuffer) {
            this.pw.print("--- ");
            this.pw.print(s);
            this.pw.println();
        }
        this.pw.println();
        this.pw.println();
        this.pw.flush();
    }

    private void printAddresses(SccpDataMessageImpl message, long originationTransactionId, long destinationTransactionId) {
        this.pw.print("OPC=" + message.getIncomingOpc() + ", DPC=" + message.getIncomingDpc());
        if (originationTransactionId != -1L) {
            this.pw.print(", originationTransactionId=" + originationTransactionId);
        }
        if (destinationTransactionId != -1L) {
            this.pw.print(", destinationTransactionId=" + destinationTransactionId);
        }
        this.pw.println();
        if (message.getCalledPartyAddress() != null) {
            this.pw.print("CalledPartyAddress=" + message.getCalledPartyAddress().toString());
        }
        if (message.getCallingPartyAddress() != null) {
            this.pw.print(", CallingPartyAddress=" + message.getCallingPartyAddress().toString());
        }
    }

    private boolean CheckDialogIdFilter(long originatingTransactionId, long destinationTransactionId) {
        Long dialogIdFilter = this.par.getDialogIdFilter();
        Long dialogIdFilter2 = this.par.getDialogIdFilter2();
        if (dialogIdFilter == null && dialogIdFilter2 == null) {
            return true;
        }
        if (dialogIdFilter != null && (dialogIdFilter == originatingTransactionId || dialogIdFilter == destinationTransactionId)) {
            return true;
        }
        return dialogIdFilter2 != null && (dialogIdFilter2 == originatingTransactionId || dialogIdFilter2 == destinationTransactionId);
    }

    private boolean CheckTransactionIdFilter(ApplicationContextName acn) {
        Integer applicationContextFilter = this.par.getApplicationContextFilter();
        if (applicationContextFilter == null) {
            return true;
        }
        if (acn == null || acn.getOid().length != 8) {
            return false;
        }
        return acn.getOid()[6] == (long)applicationContextFilter.intValue();
    }

    private void LogDataTag(AsnInputStream aisMsg, String name, Component[] comp, ApplicationContextName acn, DialogPortion dp) {
        try {
            aisMsg.readTag();
            aisMsg.readLength();
            int pos = aisMsg.position();
            aisMsg.position(0);
            byte[] buf = new byte[pos];
            aisMsg.read(buf);
            this.writeDataArray(name + " tag+length: ", buf);
            while (aisMsg.available() > 0) {
                int newPos;
                pos = aisMsg.position();
                int tag = aisMsg.readTag();
                String ttl = "???";
                switch (tag) {
                    case 8: {
                        ttl = "OrigTransactionId";
                        break;
                    }
                    case 9: {
                        ttl = "DestTransactionId";
                        break;
                    }
                    case 10: {
                        ttl = "P-AbortCause";
                        break;
                    }
                    case 11: {
                        ttl = "DialogPortion";
                        break;
                    }
                    case 12: {
                        ttl = "ComponentPortion";
                    }
                }
                int length = aisMsg.readLength();
                if (length == -1) {
                    aisMsg.readIndefinite();
                    newPos = aisMsg.position();
                } else {
                    newPos = aisMsg.position() + length;
                }
                aisMsg.position(pos);
                buf = new byte[newPos - pos];
                aisMsg.read(buf);
                this.writeDataArray(ttl + ": ", buf);
                if (tag == 11 && this.par.getDetailedDialog()) {
                    this.LogDialog(dp, buf);
                }
                if (tag != 12 || !this.par.getDetailedComponents()) continue;
                this.LogComponents(comp, acn, buf);
            }
            this.pw.println();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.pw.println();
            this.pw.print("Exception parsing TCAP msg");
            this.pw.print(e.getMessage());
        }
    }

    private void writeDataArray(String title, byte[] data) {
        this.pw.println();
        this.pw.print(title);
        boolean i1 = false;
        for (byte b : data) {
            if (!i1) {
                i1 = true;
            } else {
                this.pw.print(",");
            }
            this.pw.print(" ");
            if (b < 0) {
                this.pw.print("(byte)");
            }
            this.pw.print(b & 0xFF);
        }
    }

    private void LogDialog(DialogPortion dp, byte[] logData) {
        block7: {
            AsnInputStream ais = new AsnInputStream(logData);
            try {
                DialogRequestAPDU req;
                UserInformation userInfo;
                int tag = ais.readTag();
                int length = ais.readLength();
                tag = ais.readTag();
                length = ais.readLength();
                int pos = ais.position();
                ais.position(0);
                byte[] buf = new byte[pos];
                ais.read(buf);
                this.writeDataArray("\tDialogPort+External tags: ", buf);
                tag = ais.readTag();
                long[] oid = ais.readObjectIdentifier();
                int pos2 = ais.position();
                ais.position(pos);
                buf = new byte[pos2 - pos];
                ais.read(buf);
                this.writeDataArray("\tExternal OId: ", buf);
                tag = ais.readTag();
                length = ais.readLength();
                int pos3 = ais.position();
                ais.position(pos2);
                buf = new byte[pos3 - pos2];
                ais.read(buf);
                this.writeDataArray("\tExternal Asn tag: ", buf);
                buf = new byte[ais.available()];
                ais.read(buf);
                this.writeDataArray("\t\tDialogAPDU_" + dp.getDialogAPDU().getType().toString(), buf);
                DialogAPDU apdu = dp.getDialogAPDU();
                if (!(apdu instanceof DialogRequestAPDU) || (userInfo = (req = (DialogRequestAPDU)apdu).getUserInformation()) == null || this.par.getParseProtocol() != ParseProtocol.Map) break block7;
                try {
                    byte[] asnData = userInfo.getEncodeType();
                    AsnInputStream aisx = new AsnInputStream(asnData);
                    int tagx = aisx.readTag();
                    if (tagx == 0) {
                        MAPOpenInfoImpl mapOpenInfoImpl = new MAPOpenInfoImpl();
                        mapOpenInfoImpl.decodeAll(aisx);
                        AddressString destReference = mapOpenInfoImpl.getDestReference();
                        AddressString origReference = mapOpenInfoImpl.getOrigReference();
                        if (destReference != null) {
                            this.pw.println();
                            this.pw.print("DestReference: " + destReference);
                        }
                        if (origReference != null) {
                            this.pw.println();
                            this.pw.print("OrigReference: " + origReference);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void LogComponents(Component[] comp, ApplicationContextName acn, byte[] logData) {
        this.pw.println();
        this.pw.print("\tAcn: ");
        if (acn != null) {
            if (acn.getOid().length == 8 && acn.getOid()[0] == 0L && acn.getOid()[1] == 4L && acn.getOid()[2] == 0L && acn.getOid()[3] == 0L && acn.getOid()[4] == 1L && acn.getOid()[5] == 0L) {
                this.pw.print(acn.getOid()[6] + "-" + acn.getOid()[7]);
            } else {
                boolean first = true;
                for (long i1 : acn.getOid()) {
                    this.pw.print(i1);
                    if (first) {
                        first = false;
                        continue;
                    }
                    this.pw.print(".");
                }
            }
        } else {
            this.pw.print("???");
        }
        this.pw.print("\tComponents: ");
        if (comp != null) {
            boolean i1 = false;
            block10: for (Component c : comp) {
                if (!i1) {
                    i1 = true;
                } else {
                    this.pw.print(", ");
                }
                this.pw.print((Object)c.getType());
                this.pw.print(":");
                switch (c.getType()) {
                    case Invoke: {
                        Invoke inv = (Invoke)c;
                        this.LogOperationCode(inv.getOperationCode());
                        continue block10;
                    }
                    case ReturnResult: {
                        ReturnResult rr = (ReturnResult)c;
                        this.LogOperationCode(rr.getOperationCode());
                        continue block10;
                    }
                    case ReturnResultLast: {
                        ReturnResultLast rrl = (ReturnResultLast)c;
                        this.LogOperationCode(rrl.getOperationCode());
                        continue block10;
                    }
                    case ReturnError: {
                        ReturnError re = (ReturnError)c;
                        this.pw.print(re.getErrorCode());
                        continue block10;
                    }
                    case Reject: {
                        Reject rej = (Reject)c;
                        this.pw.print(rej.getClass());
                    }
                }
            }
        }
        if (logData != null) {
            try {
                AsnInputStream ais = new AsnInputStream(logData);
                this.LogSequence(ais, 1, "Components");
            }
            catch (Exception e) {
                e.printStackTrace();
                this.pw.println();
                this.pw.print("Exception parsing TCAP components");
                this.pw.print(e.getMessage());
            }
        }
    }

    private String LodSequenceName(int dep, int tag, int tagClass, int ind, String parent) {
        if (dep == 1) {
            switch (tag) {
                case 1: {
                    return "Invoke";
                }
                case 2: {
                    return "ReturnResultLast";
                }
                case 3: {
                    return "ReturnError";
                }
                case 4: {
                    return "Reject";
                }
                case 7: {
                    return "ReturnResult";
                }
            }
        }
        if (dep == 2) {
            if (ind == 0) {
                return "invokeId";
            }
            if (tag == 2 && tagClass == 0) {
                return "operationCode";
            }
            if (tag == 0 && tagClass == 2) {
                if (parent.equals("Invoke")) {
                    return "linkedId";
                }
                return "GeneralProblem";
            }
            if (tag == 1 && tagClass == 2) {
                return "InvokeProblem";
            }
            if (tag == 2 && tagClass == 2) {
                return "ReturnResultProblem";
            }
            if (tag == 3 && tagClass == 2) {
                return "ReturnErrorProblem";
            }
            if ((parent.equals("ReturnResultLast") || parent.equals("ReturnResult")) && tag == 16) {
                return "ReturnResultData";
            }
            if (parent.equals("ReturnError") && ind == 0) {
                return "ErrorCode";
            }
            return "Parameter";
        }
        if (dep == 3 && parent.equals("ReturnResultData")) {
            if (tag == 2 && tagClass == 0) {
                return "operationCode";
            }
            return "Parameter";
        }
        return "";
    }

    private void LogSequence(AsnInputStream ais, int dep, String name) throws IOException, AsnException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < dep; ++i) {
            sb.append("\t");
        }
        String pref = sb.toString();
        int pos = ais.position();
        int tag = ais.readTag();
        int length = ais.readLength();
        int newPos = ais.position();
        byte[] buf = new byte[newPos - pos];
        ais.position(pos);
        ais.read(buf);
        this.writeDataArray(pref + name + ": tag+length: ", buf);
        int ind = 0;
        while (ais.available() > 0) {
            boolean isConstr;
            pos = ais.position();
            tag = ais.readTag();
            length = ais.readLength();
            boolean bl = isConstr = !ais.isTagPrimitive();
            if (isConstr && length == -1) {
                ais.readSequenceData(length);
                newPos = ais.position();
            } else {
                newPos = ais.position() + length;
            }
            buf = new byte[newPos - pos];
            ais.position(pos);
            ais.read(buf);
            String name2 = this.LodSequenceName(dep, tag, ais.getTagClass(), ind, name);
            this.writeDataArray(pref + name2 + ": ", buf);
            if (isConstr) {
                AsnInputStream ais2 = new AsnInputStream(buf);
                this.LogSequence(ais2, dep + 1, name2);
            }
            ++ind;
        }
    }

    private void LogOperationCode(OperationCode op) {
        this.pw.print("OpCode=");
        if (op != null) {
            this.pw.print(op.getLocalOperationCode());
        } else {
            this.pw.print("???");
        }
    }

    @Override
    public void onDialogDelimiter(MAPDialog mapDialog) {
        try {
            mapDialog.send();
        }
        catch (MAPException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void onDialogRequest(MAPDialog mapDialog, AddressString destReference, AddressString origReference, MAPExtensionContainer extensionContainer) {
        if (((MAPDialogImpl)mapDialog).getTcapDialog() instanceof DialogImplWrapper) {
            DialogImplWrapper di = (DialogImplWrapper)((MAPDialogImpl)mapDialog).getTcapDialog();
            if (mapDialog.getApplicationContext() != null) {
                di.setAcnValue(mapDialog.getApplicationContext().getApplicationContextName().getApplicationContextCode());
                di.setAcnVersion(mapDialog.getApplicationContext().getApplicationContextVersion().getVersion());
            }
        }
    }

    @Override
    public void onDialogRequestEricsson(MAPDialog mapDialog, AddressString destReference, AddressString origReference, AddressString eriImsi, AddressString eriVlrNo) {
        DialogImplWrapper di = (DialogImplWrapper)((MAPDialogImpl)mapDialog).getTcapDialog();
        if (mapDialog.getApplicationContext() != null) {
            di.setAcnValue(mapDialog.getApplicationContext().getApplicationContextName().getApplicationContextCode());
            di.setAcnVersion(mapDialog.getApplicationContext().getApplicationContextVersion().getVersion());
        }
    }

    @Override
    public void onDialogAccept(MAPDialog mapDialog, MAPExtensionContainer extensionContainer) {
    }

    @Override
    public void onDialogReject(MAPDialog mapDialog, MAPRefuseReason refuseReason, ApplicationContextName alternativeApplicationContext, MAPExtensionContainer extensionContainer) {
    }

    @Override
    public void onDialogUserAbort(MAPDialog mapDialog, MAPUserAbortChoice userReason, MAPExtensionContainer extensionContainer) {
    }

    @Override
    public void onDialogProviderAbort(MAPDialog mapDialog, MAPAbortProviderReason abortProviderReason, MAPAbortSource abortSource, MAPExtensionContainer extensionContainer) {
    }

    @Override
    public void onDialogClose(MAPDialog mapDialog) {
    }

    @Override
    public void onDialogNotice(MAPDialog mapDialog, MAPNoticeProblemDiagnostic noticeProblemDiagnostic) {
    }

    @Override
    public void onDialogTimeout(MAPDialog mapDialog) {
        mapDialog.keepAlive();
    }

    @Override
    public boolean isFinished() {
        return this.taskIsFinished;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public void interrupt() {
        this.needInterrupt = true;
    }

    @Override
    public boolean checkNeedInterrupt() {
        if (this.needInterrupt) {
            this.errorMessage = "User break";
            this.taskIsFinished = true;
            return true;
        }
        return false;
    }

    @Override
    public int getMsgCount() {
        return this.msgCount;
    }

    public void onDialogAccept(CAPDialog arg0, CAPGprsReferenceNumber arg1) {
    }

    public void onDialogClose(CAPDialog arg0) {
    }

    public void onDialogDelimiter(CAPDialog capDialog) {
        try {
            capDialog.send();
        }
        catch (CAPException e) {
            e.printStackTrace();
        }
    }

    public void onDialogNotice(CAPDialog arg0, CAPNoticeProblemDiagnostic arg1) {
    }

    public void onDialogProviderAbort(CAPDialog arg0, PAbortCauseType arg1) {
    }

    public void onDialogRequest(CAPDialog capDialog, CAPGprsReferenceNumber arg1) {
        if (((CAPDialogImpl)capDialog).getTcapDialog() instanceof DialogImplWrapper) {
            DialogImplWrapper di = (DialogImplWrapper)((CAPDialogImpl)capDialog).getTcapDialog();
            if (capDialog.getApplicationContext() != null) {
                di.setAcnVersion(capDialog.getApplicationContext().getVersion().getVersion());
            }
        }
    }

    public void onDialogTimeout(CAPDialog capDialog) {
        capDialog.keepAlive();
    }

    public void onDialogUserAbort(CAPDialog arg0, CAPGeneralAbortReason arg1, CAPUserAbortReason arg2) {
    }

    @Override
    public void onErrorComponent(MAPDialog mapDialog, Long invokeId, MAPErrorMessage mapErrorMessage) {
        this.msgDetailBuffer.add(mapErrorMessage.toString());
    }

    @Override
    public void onRejectComponent(MAPDialog mapDialog, Long invokeId, Problem problem, boolean isLocalOriginated) {
    }

    @Override
    public void onInvokeTimeout(MAPDialog mapDialog, Long invokeId) {
    }

    private void parseSmsSignalInfo(SmsSignalInfo si, boolean isMo, boolean isMt) {
        SmsTpdu tpdu;
        if (si == null) {
            return;
        }
        if (isMo) {
            try {
                tpdu = si.decodeTpdu(true);
                this.parseSmsTpdu(tpdu);
            }
            catch (MAPException e) {
                e.printStackTrace();
            }
        }
        if (isMt) {
            try {
                tpdu = si.decodeTpdu(false);
                this.parseSmsTpdu(tpdu);
            }
            catch (MAPException e) {
                e.printStackTrace();
            }
        }
    }

    private void parseSmsTpdu(SmsTpdu tpdu) throws MAPException {
        UserData ud = null;
        switch (tpdu.getSmsTpduType()) {
            case SMS_DELIVER_REPORT: {
                SmsDeliverReportTpdu smsDeliverReportTpdu = (SmsDeliverReportTpdu)tpdu;
                break;
            }
            case SMS_SUBMIT: {
                SmsTpdu t = (SmsSubmitTpdu)tpdu;
                ud = t.getUserData();
                break;
            }
            case SMS_COMMAND: {
                SmsTpdu t = (SmsCommandTpdu)tpdu;
                break;
            }
            case SMS_DELIVER: {
                SmsTpdu t = (SmsDeliverTpdu)tpdu;
                ud = t.getUserData();
                break;
            }
            case SMS_SUBMIT_REPORT: {
                SmsTpdu t = (SmsSubmitTpdu)tpdu;
                break;
            }
            case SMS_STATUS_REPORT: {
                SmsTpdu t = (SmsStatusReportTpdu)tpdu;
            }
        }
        if (ud != null) {
            ud.decode();
            int i1 = 0;
            ++i1;
        }
    }

    @Override
    public void onForwardShortMessageRequest(ForwardShortMessageRequest forwSmInd) {
        if (forwSmInd.getSM_RP_DA().getServiceCentreAddressDA() != null) {
            this.parseSmsSignalInfo(forwSmInd.getSM_RP_UI(), true, false);
        } else {
            this.parseSmsSignalInfo(forwSmInd.getSM_RP_UI(), false, true);
        }
    }

    @Override
    public void onForwardShortMessageResponse(ForwardShortMessageResponse forwSmRespInd) {
    }

    @Override
    public void onMoForwardShortMessageRequest(MoForwardShortMessageRequest moForwSmInd) {
        this.parseSmsSignalInfo(moForwSmInd.getSM_RP_UI(), true, false);
    }

    @Override
    public void onMoForwardShortMessageResponse(MoForwardShortMessageResponse moForwSmRespInd) {
        this.parseSmsSignalInfo(moForwSmRespInd.getSM_RP_UI(), false, true);
    }

    @Override
    public void onMtForwardShortMessageRequest(MtForwardShortMessageRequest mtForwSmInd) {
        this.parseSmsSignalInfo(mtForwSmInd.getSM_RP_UI(), false, true);
    }

    @Override
    public void onMtForwardShortMessageResponse(MtForwardShortMessageResponse mtForwSmRespInd) {
        this.parseSmsSignalInfo(mtForwSmRespInd.getSM_RP_UI(), true, false);
    }

    @Override
    public void onSendRoutingInfoForSMRequest(SendRoutingInfoForSMRequest sendRoutingInfoForSMInd) {
    }

    @Override
    public void onSendRoutingInfoForSMResponse(SendRoutingInfoForSMResponse sendRoutingInfoForSMRespInd) {
    }

    @Override
    public void onReportSMDeliveryStatusRequest(ReportSMDeliveryStatusRequest reportSMDeliveryStatusInd) {
    }

    @Override
    public void onReportSMDeliveryStatusResponse(ReportSMDeliveryStatusResponse reportSMDeliveryStatusRespInd) {
    }

    @Override
    public void onInformServiceCentreRequest(InformServiceCentreRequest informServiceCentreInd) {
    }

    @Override
    public void onAlertServiceCentreRequest(AlertServiceCentreRequest alertServiceCentreInd) {
    }

    @Override
    public void onAlertServiceCentreResponse(AlertServiceCentreResponse alertServiceCentreInd) {
    }

    @Override
    public void onMAPMessage(MAPMessage msg) {
        this.msgDetailBuffer.add(msg.toString());
    }

    @Override
    public void onDialogRelease(MAPDialog arg0) {
    }

    @Override
    public void onProcessUnstructuredSSRequest(ProcessUnstructuredSSRequest arg0) {
    }

    @Override
    public void onProcessUnstructuredSSResponse(ProcessUnstructuredSSResponse arg0) {
    }

    @Override
    public void onUnstructuredSSNotifyRequest(UnstructuredSSNotifyRequest arg0) {
    }

    @Override
    public void onUnstructuredSSNotifyResponse(UnstructuredSSNotifyResponse arg0) {
    }

    @Override
    public void onUnstructuredSSRequest(UnstructuredSSRequest arg0) {
    }

    @Override
    public void onUnstructuredSSResponse(UnstructuredSSResponse arg0) {
    }

    @Override
    public void onProvideSubscriberLocationRequest(ProvideSubscriberLocationRequest arg0) {
    }

    @Override
    public void onProvideSubscriberLocationResponse(ProvideSubscriberLocationResponse arg0) {
    }

    @Override
    public void onSubscriberLocationReportRequest(SubscriberLocationReportRequest arg0) {
    }

    @Override
    public void onSubscriberLocationReportResponse(SubscriberLocationReportResponse arg0) {
    }

    public void onErrorComponent(CAPDialog arg0, Long arg1, CAPErrorMessage arg2) {
    }

    public void onInvokeTimeout(CAPDialog arg0, Long arg1) {
    }

    public void onRejectComponent(CAPDialog arg0, Long arg1, Problem arg2, boolean isLocalOriginated) {
    }

    public void onCAPMessage(CAPMessage msg) {
        this.msgDetailBuffer.add(msg.toString());
    }

    public void onDialogRelease(CAPDialog arg0) {
    }

    public void onActivityTestRequest(ActivityTestRequest arg0) {
    }

    public void onActivityTestResponse(ActivityTestResponse arg0) {
    }

    public void onApplyChargingReportRequest(ApplyChargingReportRequest arg0) {
    }

    public void onApplyChargingRequest(ApplyChargingRequest arg0) {
    }

    public void onAssistRequestInstructionsRequest(AssistRequestInstructionsRequest arg0) {
    }

    public void onCallInformationReportRequest(CallInformationReportRequest arg0) {
    }

    public void onCallGapRequest(CallGapRequest ind) {
    }

    public void onCallInformationRequestRequest(CallInformationRequestRequest arg0) {
    }

    public void onCancelRequest(CancelRequest arg0) {
    }

    public void onConnectRequest(ConnectRequest arg0) {
    }

    public void onConnectToResourceRequest(ConnectToResourceRequest arg0) {
    }

    public void onContinueRequest(ContinueRequest arg0) {
    }

    public void onDisconnectForwardConnectionRequest(DisconnectForwardConnectionRequest arg0) {
    }

    public void onEstablishTemporaryConnectionRequest(EstablishTemporaryConnectionRequest arg0) {
    }

    public void onEventReportBCSMRequest(EventReportBCSMRequest arg0) {
    }

    public void onFurnishChargingInformationRequest(FurnishChargingInformationRequest arg0) {
    }

    public void onInitialDPRequest(InitialDPRequest arg0) {
    }

    public void onPlayAnnouncementRequest(PlayAnnouncementRequest arg0) {
    }

    public void onPromptAndCollectUserInformationRequest(PromptAndCollectUserInformationRequest arg0) {
    }

    public void onPromptAndCollectUserInformationResponse(PromptAndCollectUserInformationResponse arg0) {
    }

    public void onReleaseCallRequest(ReleaseCallRequest arg0) {
    }

    public void onRequestReportBCSMEventRequest(RequestReportBCSMEventRequest arg0) {
    }

    public void onResetTimerRequest(ResetTimerRequest arg0) {
    }

    public void onSendChargingInformationRequest(SendChargingInformationRequest arg0) {
    }

    public void onSpecializedResourceReportRequest(SpecializedResourceReportRequest arg0) {
    }

    @Override
    public void onSendAuthenticationInfoRequest(SendAuthenticationInfoRequest ind) {
    }

    @Override
    public void onSendAuthenticationInfoResponse(SendAuthenticationInfoResponse ind) {
    }

    @Override
    public void onUpdateLocationRequest(UpdateLocationRequest ind) {
    }

    @Override
    public void onUpdateLocationResponse(UpdateLocationResponse ind) {
    }

    @Override
    public void onAnyTimeInterrogationRequest(AnyTimeInterrogationRequest arg0) {
    }

    @Override
    public void onAnyTimeInterrogationResponse(AnyTimeInterrogationResponse arg0) {
    }

    @Override
    public void onCheckImeiRequest(CheckImeiRequest request) {
    }

    @Override
    public void onCheckImeiResponse(CheckImeiResponse response) {
    }

    @Override
    public void onSendRoutingInfoForLCSRequest(SendRoutingInfoForLCSRequest arg0) {
    }

    @Override
    public void onSendRoutingInfoForLCSResponse(SendRoutingInfoForLCSResponse arg0) {
    }

    @Override
    public void onSendRoutingInformationRequest(SendRoutingInformationRequest arg0) {
    }

    @Override
    public void onSendRoutingInformationResponse(SendRoutingInformationResponse arg0) {
    }

    @Override
    public void onProvideRoamingNumberRequest(ProvideRoamingNumberRequest request) {
    }

    @Override
    public void onProvideRoamingNumberResponse(ProvideRoamingNumberResponse response) {
    }

    @Override
    public void onIstCommandRequest(IstCommandRequest request) {
    }

    @Override
    public void onIstCommandResponse(IstCommandResponse response) {
    }

    @Override
    public void onCancelLocationRequest(CancelLocationRequest request) {
    }

    @Override
    public void onCancelLocationResponse(CancelLocationResponse response) {
    }

    @Override
    public void onInsertSubscriberDataRequest(InsertSubscriberDataRequest request) {
    }

    @Override
    public void onInsertSubscriberDataResponse(InsertSubscriberDataResponse request) {
    }

    @Override
    public void onDialogReleased(Dialog arg0) {
    }

    @Override
    public void onDialogTimeout(Dialog arg0) {
    }

    @Override
    public void onInvokeTimeout(Invoke arg0) {
    }

    @Override
    public void onTCBegin(TCBeginIndication ind) {
        this.curTcapDialog = (DialogImpl)ind.getDialog();
    }

    @Override
    public void onTCContinue(TCContinueIndication ind) {
        this.curTcapDialog = (DialogImpl)ind.getDialog();
    }

    @Override
    public void onTCEnd(TCEndIndication ind) {
        this.curTcapDialog = (DialogImpl)ind.getDialog();
    }

    @Override
    public void onTCNotice(TCNoticeIndication arg0) {
    }

    @Override
    public void onTCPAbort(TCPAbortIndication ind) {
        this.curTcapDialog = (DialogImpl)ind.getDialog();
    }

    @Override
    public void onTCUni(TCUniIndication ind) {
        this.curTcapDialog = (DialogImpl)ind.getDialog();
    }

    @Override
    public void onTCUserAbort(TCUserAbortIndication ind) {
        this.curTcapDialog = (DialogImpl)ind.getDialog();
    }

    public void onInitialDpGprsRequest(InitialDpGprsRequest ind) {
    }

    public void onRequestReportGPRSEventRequest(RequestReportGPRSEventRequest ind) {
    }

    public void onApplyChargingGPRSRequest(ApplyChargingGPRSRequest ind) {
    }

    public void onEntityReleasedGPRSRequest(EntityReleasedGPRSRequest ind) {
    }

    public void onEntityReleasedGPRSResponse(EntityReleasedGPRSResponse ind) {
    }

    public void onConnectGPRSRequest(ConnectGPRSRequest ind) {
    }

    public void onContinueGPRSRequest(ContinueGPRSRequest ind) {
    }

    public void onReleaseGPRSRequest(ReleaseGPRSRequest ind) {
    }

    public void onResetTimerGPRSRequest(ResetTimerGPRSRequest ind) {
    }

    public void onFurnishChargingInformationGPRSRequest(FurnishChargingInformationGPRSRequest ind) {
    }

    public void onCancelGPRSRequest(CancelGPRSRequest ind) {
    }

    public void onSendChargingInformationGPRSRequest(SendChargingInformationGPRSRequest ind) {
    }

    public void onApplyChargingReportGPRSRequest(ApplyChargingReportGPRSRequest ind) {
    }

    public void onApplyChargingReportGPRSResponse(ApplyChargingReportGPRSResponse ind) {
    }

    public void onEventReportGPRSRequest(EventReportGPRSRequest ind) {
    }

    public void onEventReportGPRSResponse(EventReportGPRSResponse ind) {
    }

    public void onActivityTestGPRSRequest(ActivityTestGPRSRequest ind) {
    }

    public void onActivityTestGPRSResponse(ActivityTestGPRSResponse ind) {
    }

    @Override
    public void onSendIdentificationRequest(SendIdentificationRequest request) {
    }

    @Override
    public void onSendIdentificationResponse(SendIdentificationResponse response) {
    }

    @Override
    public void onUpdateGprsLocationRequest(UpdateGprsLocationRequest request) {
    }

    @Override
    public void onUpdateGprsLocationResponse(UpdateGprsLocationResponse response) {
    }

    public void onConnectSMSRequest(ConnectSMSRequest ind) {
    }

    public void onEventReportSMSRequest(EventReportSMSRequest ind) {
    }

    public void onFurnishChargingInformationSMSRequest(FurnishChargingInformationSMSRequest ind) {
    }

    public void onInitialDPSMSRequest(InitialDPSMSRequest ind) {
    }

    public void onReleaseSMSRequest(ReleaseSMSRequest ind) {
    }

    public void onRequestReportSMSEventRequest(RequestReportSMSEventRequest ind) {
    }

    public void onResetTimerSMSRequest(ResetTimerSMSRequest ind) {
    }

    public void onContinueSMSRequest(ContinueSMSRequest ind) {
    }

    @Override
    public void onPurgeMSRequest(PurgeMSRequest arg0) {
    }

    @Override
    public void onPurgeMSResponse(PurgeMSResponse arg0) {
    }

    public void onContinueWithArgumentRequest(ContinueWithArgumentRequest ind) {
    }

    public void onDisconnectLegRequest(DisconnectLegRequest ind) {
    }

    public void onDisconnectLegResponse(DisconnectLegResponse ind) {
    }

    public void onDisconnectForwardConnectionWithArgumentRequest(DisconnectForwardConnectionWithArgumentRequest ind) {
    }

    public void onInitiateCallAttemptRequest(InitiateCallAttemptRequest initiateCallAttemptRequest) {
    }

    public void onInitiateCallAttemptResponse(InitiateCallAttemptResponse initiateCallAttemptResponse) {
    }

    public void onMoveLegRequest(MoveLegRequest ind) {
    }

    public void onMoveLegResponse(MoveLegResponse ind) {
    }

    public void onEvent(ISUPEvent event) {
        this.msgDetailBuffer.add(event.toString());
        this.printIsupMsgData();
    }

    public void onTimeout(ISUPTimeoutEvent arg0) {
    }

    @Override
    public void onRestoreDataRequest(RestoreDataRequest arg0) {
    }

    @Override
    public void onRestoreDataResponse(RestoreDataResponse arg0) {
    }

    @Override
    public void onReadyForSMRequest(ReadyForSMRequest request) {
    }

    @Override
    public void onReadyForSMResponse(ReadyForSMResponse response) {
    }

    @Override
    public void onNoteSubscriberPresentRequest(NoteSubscriberPresentRequest request) {
    }

    @Override
    public void onRegisterSSRequest(RegisterSSRequest request) {
    }

    @Override
    public void onRegisterSSResponse(RegisterSSResponse response) {
    }

    @Override
    public void onEraseSSRequest(EraseSSRequest request) {
    }

    @Override
    public void onEraseSSResponse(EraseSSResponse response) {
    }

    @Override
    public void onActivateSSRequest(ActivateSSRequest request) {
    }

    @Override
    public void onActivateSSResponse(ActivateSSResponse response) {
    }

    @Override
    public void onDeactivateSSRequest(DeactivateSSRequest request) {
    }

    @Override
    public void onDeactivateSSResponse(DeactivateSSResponse response) {
    }

    @Override
    public void onInterrogateSSRequest(InterrogateSSRequest request) {
    }

    @Override
    public void onInterrogateSSResponse(InterrogateSSResponse response) {
    }

    @Override
    public void onSendRoutingInfoForGprsRequest(SendRoutingInfoForGprsRequest request) {
    }

    @Override
    public void onSendRoutingInfoForGprsResponse(SendRoutingInfoForGprsResponse response) {
    }

    @Override
    public void onSendImsiRequest(SendImsiRequest ind) {
    }

    @Override
    public void onSendImsiResponse(SendImsiResponse ind) {
    }

    @Override
    public void onResetRequest(ResetRequest ind) {
    }

    @Override
    public void onForwardCheckSSIndicationRequest(ForwardCheckSSIndicationRequest ind) {
    }

    @Override
    public void onProvideSubscriberInfoRequest(ProvideSubscriberInfoRequest request) {
    }

    @Override
    public void onProvideSubscriberInfoResponse(ProvideSubscriberInfoResponse response) {
    }

    @Override
    public void onDeleteSubscriberDataRequest(DeleteSubscriberDataRequest request) {
    }

    @Override
    public void onDeleteSubscriberDataResponse(DeleteSubscriberDataResponse request) {
    }

    @Override
    public void onActivateTraceModeRequest_Oam(ActivateTraceModeRequest_Oam ind) {
    }

    @Override
    public void onActivateTraceModeResponse_Oam(ActivateTraceModeResponse_Oam ind) {
    }

    @Override
    public void onActivateTraceModeRequest_Mobility(ActivateTraceModeRequest_Mobility ind) {
    }

    @Override
    public void onActivateTraceModeResponse_Mobility(ActivateTraceModeResponse_Mobility ind) {
    }

    public void onCollectInformationRequest(CollectInformationRequest arg0) {
    }

    @Override
    public void onGetPasswordRequest(GetPasswordRequest request) {
    }

    @Override
    public void onGetPasswordResponse(GetPasswordResponse response) {
    }

    @Override
    public void onRegisterPasswordRequest(RegisterPasswordRequest request) {
    }

    @Override
    public void onRegisterPasswordResponse(RegisterPasswordResponse response) {
    }

    @Override
    public void onAuthenticationFailureReportRequest(AuthenticationFailureReportRequest arg0) {
    }

    @Override
    public void onAuthenticationFailureReportResponse(AuthenticationFailureReportResponse arg0) {
    }

    public class DialogMessageChain {
        private ArrayList<DialogMessage> lst = new ArrayList();
        private int cnt;
        public long dialogId1;
        public long dialogId2;

        public void addDialogMessage(DialogMessage dm) {
            this.lst.add(dm);
        }

        public void addChainCount() {
            ++this.cnt;
        }

        public void setDialogId(long val) {
            if (this.dialogId1 == 0L) {
                this.dialogId1 = val;
                return;
            }
            if (this.dialogId1 == val) {
                return;
            }
            if (this.dialogId2 == 0L) {
                this.dialogId2 = val;
                return;
            }
        }

        public boolean checkFullDialog() {
            return true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("DialogMessageChain, cnt=");
            sb.append(this.cnt);
            sb.append(", dialogId1=");
            sb.append(this.dialogId1);
            sb.append(", dialogId2=");
            sb.append(this.dialogId2);
            for (int i1 = 0; i1 < this.lst.size(); ++i1) {
                sb.append("\n  ");
                DialogMessage ma = this.lst.get(i1);
                sb.append(ma);
            }
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DialogMessageChain)) {
                return false;
            }
            DialogMessageChain b = (DialogMessageChain)obj;
            if (this.lst.size() != b.lst.size()) {
                return false;
            }
            for (int i1 = 0; i1 < this.lst.size(); ++i1) {
                DialogMessage mb;
                DialogMessage ma = this.lst.get(i1);
                if (ma.equals(mb = b.lst.get(i1))) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            int res = 0;
            for (int i1 = 0; i1 < this.lst.size(); ++i1) {
                DialogMessage ma = this.lst.get(i1);
                res ^= ma.hashCode();
            }
            return res;
        }
    }

    public class DialogMessage {
        public int opc;
        public int dpc;
        public int callingSsn;
        public int calledSsn;
        public String callingPA;
        public String calledPA;
        public String tcapMessage;
        public long dialogId1;
        public long dialogId2;
        public int messageNum;

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("opc=");
            sb.append(this.opc);
            sb.append(", dpc=");
            sb.append(this.dpc);
            sb.append(", callingPA=");
            sb.append(this.callingPA);
            sb.append(", calledPA=");
            sb.append(this.calledPA);
            sb.append(", callingSsn=");
            sb.append(this.callingSsn);
            sb.append(", calledSsn=");
            sb.append(this.calledSsn);
            sb.append(", ");
            sb.append(this.tcapMessage);
            sb.append(", ");
            sb.append(this.messageNum);
            return sb.toString();
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof DialogMessage)) {
                return false;
            }
            DialogMessage b = (DialogMessage)obj;
            return this.opc == b.opc && this.dpc == b.dpc && this.calledPA != null && b.calledPA != null && this.calledPA.equals(b.calledPA) && this.callingPA != null && b.callingPA != null && this.callingPA.equals(b.callingPA) && this.tcapMessage != null && b.tcapMessage != null && this.tcapMessage.equals(b.tcapMessage);
        }

        public int hashCode() {
            return this.opc + this.dpc * 1000000;
        }
    }

    public class Mtp3TransferPrimitiveProxy
    extends Mtp3TransferPrimitive {
        public Mtp3TransferPrimitiveProxy(int si, int ni, int mp, int opc, int dpc, int sls, byte[] data, RoutingLabelFormat pointCodeFormat) {
            super(si, ni, mp, opc, dpc, sls, data, pointCodeFormat);
        }
    }

    public class AddrData {
        long cnt;
        int opc;
        int oSsn;
        String oAddr;
        int dpc;
        int dSsn;
        String dAddr;
    }

    private class LogData {
        public byte[] dialogPortion;
        public byte[] componentPortion;

        private LogData() {
        }
    }

    public class MessageReassemblyProcess {
        private int segmentationLocalRef;
        private SccpAddress callingPartyAddress;

        public MessageReassemblyProcess(int segmentationLocalRef, SccpAddress callingPartyAddress) {
            this.segmentationLocalRef = segmentationLocalRef;
            this.callingPartyAddress = callingPartyAddress;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (!(obj instanceof MessageReassemblyProcess)) {
                return false;
            }
            MessageReassemblyProcess x = (MessageReassemblyProcess)obj;
            if (this.segmentationLocalRef != x.segmentationLocalRef) {
                return false;
            }
            if (this.callingPartyAddress == null || x.callingPartyAddress == null) {
                return false;
            }
            return this.callingPartyAddress.equals(x.callingPartyAddress);
        }

        public int hashCode() {
            return this.segmentationLocalRef;
        }
    }

    private class XUnitDataDef {
        public int remainingSegm;
        public ArrayList<byte[]> dLst = new ArrayList();

        private XUnitDataDef() {
        }
    }
}

