/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.smstpdu;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.datacoding.NationalLanguageIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.DataCodingScheme;
import org.mobicents.protocols.ss7.map.api.smstpdu.NationalLanguageLockingShiftIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.NationalLanguageSingleShiftIdentifier;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserData;
import org.mobicents.protocols.ss7.map.api.smstpdu.UserDataHeader;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharset;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetDecodingData;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncoder;
import org.mobicents.protocols.ss7.map.datacoding.GSMCharsetEncodingData;
import org.mobicents.protocols.ss7.map.datacoding.Gsm7EncodingStyle;
import org.mobicents.protocols.ss7.map.smstpdu.DataCodingSchemeImpl;
import org.mobicents.protocols.ss7.map.smstpdu.UserDataHeaderImpl;

public class UserDataImpl
implements UserData {
    private static GSMCharset gsm7Charset = new GSMCharset("GSM", new String[0]);
    private static Charset ucs2Charset = Charset.forName("UTF-16BE");
    private DataCodingScheme dataCodingScheme;
    private Charset gsm8Charset;
    private byte[] encodedData;
    private int encodedUserDataLength;
    private boolean encodedUserDataHeaderIndicator;
    private UserDataHeader decodedUserDataHeader;
    private String decodedMessage;
    private boolean isDecoded;
    private boolean isEncoded;

    public UserDataImpl(byte[] encodedData, DataCodingScheme dataCodingScheme, int encodedUserDataLength, boolean encodedUserDataHeaderIndicator, Charset gsm8Charset) {
        this.encodedData = encodedData;
        this.encodedUserDataLength = encodedUserDataLength;
        this.encodedUserDataHeaderIndicator = encodedUserDataHeaderIndicator;
        this.dataCodingScheme = dataCodingScheme != null ? dataCodingScheme : new DataCodingSchemeImpl(0);
        this.gsm8Charset = gsm8Charset;
        this.isEncoded = true;
    }

    public UserDataImpl(String decodedMessage, DataCodingScheme dataCodingScheme, UserDataHeader decodedUserDataHeader, Charset gsm8Charset) {
        this.decodedMessage = decodedMessage;
        this.decodedUserDataHeader = decodedUserDataHeader;
        this.dataCodingScheme = dataCodingScheme != null ? dataCodingScheme : new DataCodingSchemeImpl(0);
        this.gsm8Charset = gsm8Charset;
        this.isDecoded = true;
    }

    public DataCodingScheme getDataCodingScheme() {
        return this.dataCodingScheme;
    }

    public byte[] getEncodedData() {
        return this.encodedData;
    }

    public int getEncodedUserDataLength() {
        return this.encodedUserDataLength;
    }

    public boolean getEncodedUserDataHeaderIndicator() {
        return this.encodedUserDataHeaderIndicator;
    }

    public UserDataHeader getDecodedUserDataHeader() {
        return this.decodedUserDataHeader;
    }

    public String getDecodedMessage() {
        return this.decodedMessage;
    }

    public void encode() throws MAPException {
        if (this.isEncoded) {
            return;
        }
        this.isEncoded = true;
        this.encodedData = null;
        this.encodedUserDataLength = 0;
        this.encodedUserDataHeaderIndicator = false;
        if (this.decodedMessage == null) {
            this.decodedMessage = "";
        }
        byte[] buf2 = null;
        if (this.decodedUserDataHeader != null) {
            buf2 = this.decodedUserDataHeader.getEncodedData();
            if (buf2 != null && buf2.length > 0) {
                this.encodedUserDataHeaderIndicator = true;
            } else {
                buf2 = null;
            }
        }
        if (this.dataCodingScheme.getIsCompressed()) {
            throw new MAPException("Error encoding a text in Sms UserData: compressed message is not supported yet");
        }
        switch (this.dataCodingScheme.getCharacterSet()) {
            case GSM7: {
                GSMCharset cSet = UserDataImpl.obtainGsmCharacterSet(this.decodedUserDataHeader);
                GSMCharsetEncoder encoder = (GSMCharsetEncoder)cSet.newEncoder();
                encoder.setGSMCharsetEncodingData(new GSMCharsetEncodingData(Gsm7EncodingStyle.bit7_sms_style, buf2));
                ByteBuffer bb = null;
                try {
                    bb = encoder.encode(CharBuffer.wrap(this.decodedMessage));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.encodedUserDataLength = encoder.getGSMCharsetEncodingData().getTotalSeptetCount();
                if (bb != null) {
                    this.encodedData = new byte[bb.limit()];
                    bb.get(this.encodedData);
                    break;
                }
                this.encodedData = new byte[0];
                break;
            }
            case GSM8: {
                if (this.gsm8Charset != null) {
                    ByteBuffer bb = this.gsm8Charset.encode(this.decodedMessage);
                    this.encodedData = new byte[bb.limit()];
                    bb.get(this.encodedData);
                    if (buf2 != null) {
                        byte[] tempBuf = this.encodedData;
                        this.encodedData = new byte[buf2.length + tempBuf.length];
                        System.arraycopy(buf2, 0, this.encodedData, 0, buf2.length);
                        System.arraycopy(tempBuf, 0, this.encodedData, buf2.length, tempBuf.length);
                    }
                    this.encodedUserDataLength = this.encodedData.length;
                    break;
                }
                throw new MAPException("Error encoding a text in Sms UserData: gsm8Charset is not defined for GSM8 dataCodingScheme");
            }
            case UCS2: {
                ByteBuffer bb = ucs2Charset.encode(this.decodedMessage);
                this.encodedData = new byte[bb.limit()];
                bb.get(this.encodedData);
                if (buf2 != null) {
                    byte[] tempBuf = this.encodedData;
                    this.encodedData = new byte[buf2.length + tempBuf.length];
                    System.arraycopy(buf2, 0, this.encodedData, 0, buf2.length);
                    System.arraycopy(tempBuf, 0, this.encodedData, buf2.length, tempBuf.length);
                }
                this.encodedUserDataLength = this.encodedData.length;
            }
        }
    }

    public void decode() throws MAPException {
        if (this.isDecoded) {
            return;
        }
        this.isDecoded = true;
        this.decodedUserDataHeader = null;
        this.decodedMessage = null;
        if (this.encodedData == null) {
            throw new MAPException("Error decoding a text from Sms UserData: encodedData field is null");
        }
        int offset = 0;
        if (this.encodedUserDataHeaderIndicator) {
            if (this.encodedData.length < 1) {
                return;
            }
            offset = (this.encodedData[0] & 0xFF) + 1;
            if (offset > this.encodedData.length) {
                return;
            }
            this.decodedUserDataHeader = new UserDataHeaderImpl(this.encodedData);
        }
        if (this.dataCodingScheme.getIsCompressed()) {
            int i1 = 0;
            ++i1;
        } else {
            switch (this.dataCodingScheme.getCharacterSet()) {
                case GSM7: {
                    GSMCharset cSet = UserDataImpl.obtainGsmCharacterSet(this.decodedUserDataHeader);
                    GSMCharsetDecoder decoder = (GSMCharsetDecoder)cSet.newDecoder();
                    if (offset > 0) {
                        int bitOffset = offset * 8;
                        int septetOffset = (bitOffset - 1) / 7 + 1;
                        decoder.setGSMCharsetDecodingData(new GSMCharsetDecodingData(Gsm7EncodingStyle.bit7_sms_style, this.encodedUserDataLength, septetOffset));
                    } else {
                        decoder.setGSMCharsetDecodingData(new GSMCharsetDecodingData(Gsm7EncodingStyle.bit7_sms_style, this.encodedUserDataLength, 0));
                    }
                    ByteBuffer bb = ByteBuffer.wrap(this.encodedData);
                    CharBuffer bf = null;
                    try {
                        bf = decoder.decode(bb);
                    }
                    catch (CharacterCodingException characterCodingException) {
                        // empty catch block
                    }
                    if (bf != null) {
                        this.decodedMessage = bf.toString();
                        break;
                    }
                    this.decodedMessage = "";
                    break;
                }
                case GSM8: {
                    if (this.gsm8Charset == null) break;
                    int len = this.encodedUserDataLength;
                    byte[] buf = this.encodedData;
                    if (len > buf.length) {
                        len = buf.length;
                    }
                    if (offset > 0) {
                        if (offset > len) {
                            buf = new byte[]{};
                        } else {
                            buf = new byte[len - offset];
                            System.arraycopy(this.encodedData, offset, buf, 0, len - offset);
                        }
                    }
                    ByteBuffer bb = ByteBuffer.wrap(buf);
                    CharBuffer bf = this.gsm8Charset.decode(bb);
                    this.decodedMessage = bf.toString();
                    break;
                }
                case UCS2: {
                    byte[] buf = this.encodedData;
                    int len = this.encodedUserDataLength;
                    if (len > buf.length) {
                        len = buf.length;
                    }
                    if (offset > 0) {
                        if (offset > len) {
                            buf = new byte[]{};
                        } else {
                            buf = new byte[len - offset];
                            System.arraycopy(this.encodedData, offset, buf, 0, len - offset);
                        }
                    }
                    ByteBuffer bb = ByteBuffer.wrap(buf);
                    CharBuffer bf = ucs2Charset.decode(bb);
                    this.decodedMessage = bf.toString();
                }
            }
        }
    }

    private static GSMCharset obtainGsmCharacterSet(UserDataHeader udh) {
        GSMCharset cSet = gsm7Charset;
        NationalLanguageLockingShiftIdentifier nationalLanguageLockingShift = null;
        NationalLanguageSingleShiftIdentifier nationalLanguageSingleShift = null;
        NationalLanguageIdentifier nationalLanguageLockingShiftIdentifier = null;
        NationalLanguageIdentifier nationalLanguageSingleShiftIdentifier = null;
        if (udh != null) {
            nationalLanguageLockingShift = udh.getNationalLanguageLockingShift();
            nationalLanguageSingleShift = udh.getNationalLanguageSingleShift();
            if (nationalLanguageLockingShift != null) {
                nationalLanguageLockingShiftIdentifier = nationalLanguageLockingShift.getNationalLanguageIdentifier();
            }
            if (nationalLanguageSingleShift != null) {
                nationalLanguageSingleShiftIdentifier = nationalLanguageSingleShift.getNationalLanguageIdentifier();
            }
        }
        if (nationalLanguageLockingShift != null || nationalLanguageSingleShift != null) {
            cSet = new GSMCharset("GSM", new String[0], nationalLanguageLockingShiftIdentifier, nationalLanguageSingleShiftIdentifier);
        }
        return cSet;
    }

    public static int checkEncodedDataLengthInChars(String msg, UserDataHeader udh) {
        GSMCharset cSet = UserDataImpl.obtainGsmCharacterSet(udh);
        return cSet.checkEncodedDataLengthInChars(msg);
    }

    public static String[] sliceString(String data, int charCount, UserDataHeader udh) {
        GSMCharset cSet = UserDataImpl.obtainGsmCharacterSet(udh);
        return cSet.sliceString(data, charCount);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("TP-User-Data [");
        if (this.decodedMessage == null) {
            if (this.encodedData != null) {
                sb.append(this.printDataArr(this.encodedData));
            }
        } else {
            sb.append("Msg:[");
            sb.append(this.decodedMessage);
            sb.append("]");
            if (this.decodedUserDataHeader != null) {
                sb.append("\n");
                sb.append(this.decodedUserDataHeader.toString());
            }
        }
        sb.append("]");
        return sb.toString();
    }

    private String printDataArr(byte[] arr) {
        StringBuilder sb = new StringBuilder();
        for (byte b : arr) {
            sb.append(b);
            sb.append(", ");
        }
        return sb.toString();
    }
}

