/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.EMLPPPriority;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSData;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSStatus;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSSubscriptionOption;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSStatusImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSSubscriptionOptionImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SSDataImpl
extends SequenceBase
implements SSData {
    public static final int _TAG_ss_Status = 4;
    public static final int _TAG_nbrUser = 5;
    private SSCode ssCode;
    private SSStatus ssStatus;
    private SSSubscriptionOption ssSubscriptionOption;
    private ArrayList<BasicServiceCode> basicServiceGroupList;
    private EMLPPPriority defaultPriority;
    private Integer nbrUser;

    public SSDataImpl() {
        super("SSData");
    }

    public SSDataImpl(SSCode ssCode, SSStatus ssStatus, SSSubscriptionOption ssSubscriptionOption, ArrayList<BasicServiceCode> basicServiceGroupList, EMLPPPriority defaultPriority, Integer nbrUser) {
        super("SSData");
        this.ssCode = ssCode;
        this.ssStatus = ssStatus;
        this.ssSubscriptionOption = ssSubscriptionOption;
        this.basicServiceGroupList = basicServiceGroupList;
        this.defaultPriority = defaultPriority;
        this.nbrUser = nbrUser;
    }

    @Override
    public SSCode getSsCode() {
        return this.ssCode;
    }

    @Override
    public SSStatus getSsStatus() {
        return this.ssStatus;
    }

    @Override
    public SSSubscriptionOption getSsSubscriptionOption() {
        return this.ssSubscriptionOption;
    }

    @Override
    public ArrayList<BasicServiceCode> getBasicServiceGroupList() {
        return this.basicServiceGroupList;
    }

    @Override
    public EMLPPPriority getDefaultPriority() {
        return this.defaultPriority;
    }

    @Override
    public Integer getNbrUser() {
        return this.nbrUser;
    }

    @Override
    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.ssStatus = null;
        this.ssSubscriptionOption = null;
        this.basicServiceGroupList = null;
        this.defaultPriority = null;
        this.nbrUser = null;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        block10: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 0) {
                switch (tag) {
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ssCode: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ssCode = new SSCodeImpl();
                        ((SSCodeImpl)this.ssCode).decodeAll(ais);
                        continue block10;
                    }
                    case 16: {
                        if (ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".basicServiceGroupList: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        AsnInputStream ais2 = ais.readSequenceStream();
                        this.basicServiceGroupList = new ArrayList();
                        while (ais2.available() != 0) {
                            ais2.readTag();
                            BasicServiceCodeImpl basicServiceCode = new BasicServiceCodeImpl();
                            basicServiceCode.decodeAll(ais2);
                            this.basicServiceGroupList.add(basicServiceCode);
                        }
                        if (this.basicServiceGroupList.size() >= 1 && this.basicServiceGroupList.size() <= 13) continue block10;
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Parameter forwardingFeatureList size must be from 1 to 13, found: " + this.basicServiceGroupList.size(), MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 2: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " defaultPriority: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        int i1 = (int)ais.readInteger();
                        this.defaultPriority = EMLPPPriority.getEMLPPPriority(i1);
                        continue block10;
                    }
                }
                ais.advanceElement();
                continue;
            }
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 4: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " ssStatus: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.ssStatus = new SSStatusImpl();
                        ((SSStatusImpl)this.ssStatus).decodeAll(ais);
                        continue block10;
                    }
                    case 1: 
                    case 2: {
                        this.ssSubscriptionOption = new SSSubscriptionOptionImpl();
                        ((SSSubscriptionOptionImpl)this.ssSubscriptionOption).decodeAll(ais);
                        continue block10;
                    }
                    case 5: {
                        if (!ais.isTagPrimitive()) {
                            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + " nbrUser: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.nbrUser = (int)ais.readInteger();
                        continue block10;
                    }
                }
                ais.advanceElement();
                continue;
            }
            ais.advanceElement();
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.ssCode != null) {
                ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
            }
            if (this.ssStatus != null) {
                ((SSStatusImpl)this.ssStatus).encodeAll(asnOs, 2, 4);
            }
            if (this.ssSubscriptionOption != null) {
                ((SSSubscriptionOptionImpl)this.ssSubscriptionOption).encodeAll(asnOs);
            }
            if (this.basicServiceGroupList != null) {
                try {
                    asnOs.writeTag(0, false, 16);
                    int pos = asnOs.StartContentDefiniteLength();
                    for (BasicServiceCode item : this.basicServiceGroupList) {
                        ((BasicServiceCodeImpl)item).encodeAll(asnOs);
                    }
                    asnOs.FinalizeContent(pos);
                }
                catch (AsnException e) {
                    throw new MAPException("AsnException when encoding " + this._PrimitiveName + ".callBarringFeatureList: " + e.getMessage(), e);
                }
            }
            if (this.defaultPriority != null) {
                asnOs.writeInteger(this.defaultPriority.getCode());
            }
            if (this.nbrUser != null) {
                asnOs.writeInteger(2, 5, this.nbrUser.intValue());
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode);
            sb.append(", ");
        }
        if (this.ssStatus != null) {
            sb.append("ssStatus=");
            sb.append(this.ssStatus);
            sb.append(", ");
        }
        if (this.ssSubscriptionOption != null) {
            sb.append("ssSubscriptionOption=");
            sb.append(this.ssSubscriptionOption);
            sb.append(", ");
        }
        if (this.basicServiceGroupList != null) {
            sb.append("basicServiceGroupList=[");
            boolean firstItem = true;
            for (BasicServiceCode be : this.basicServiceGroupList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(be.toString());
            }
            sb.append("], ");
        }
        if (this.defaultPriority != null) {
            sb.append("defaultPriority=");
            sb.append((Object)this.defaultPriority);
            sb.append(", ");
        }
        if (this.nbrUser != null) {
            sb.append("nbrUser=");
            sb.append(this.nbrUser);
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }
}

