/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastSet;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.mobicents.protocols.ss7.m3ua.impl.AsImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AsStateListener;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSMState;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSMStateEventHandler;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.UnknownTransitionException;

public class AsStatePenTimeout
implements FSMStateEventHandler {
    private AsImpl asImpl;
    private FSM fsm;
    private static final Logger logger = Logger.getLogger(AsStatePenTimeout.class);
    boolean inactive = false;

    public AsStatePenTimeout(AsImpl asImpl, FSM fsm) {
        this.asImpl = asImpl;
        this.fsm = fsm;
    }

    @Override
    public void onEvent(FSMState state) {
        if (logger.isEnabledFor(Priority.WARN)) {
            logger.warn(String.format("PENDING timedout for As=%s", this.asImpl.getName()));
        }
        this.asImpl.clearPendingQueue();
        this.inactive = false;
        FastCollection.Record n = this.asImpl.appServerProcs.head();
        FastCollection.Record end = this.asImpl.appServerProcs.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            AspImpl aspImpl = (AspImpl)((FastList.Node)n).getValue();
            FSM aspLocalFSM = aspImpl.getLocalFSM();
            if (AspState.getState(aspLocalFSM.getState().getName()) != AspState.INACTIVE) continue;
            try {
                this.fsm.signal("asinactive");
                this.inactive = true;
                break;
            }
            catch (UnknownTransitionException e) {
                logger.error(e.getMessage(), e);
            }
        }
        if (!this.inactive) {
            try {
                this.fsm.signal("asdown");
                this.inactive = true;
            }
            catch (UnknownTransitionException e) {
                logger.error(e.getMessage(), e);
            }
        }
        FastSet<AsStateListener> asStateListeners = this.asImpl.getAsStateListeners();
        FastCollection.Record r = asStateListeners.head();
        FastCollection.Record end2 = asStateListeners.tail();
        while ((r = r.getNext()) != end2) {
            AsStateListener asAsStateListener = asStateListeners.valueOf(r);
            try {
                asAsStateListener.onAsInActive(this.asImpl);
            }
            catch (Exception e) {
                logger.error(String.format("Error while calling AsStateListener=%s onAsInActive method for As=%s", asAsStateListener, this.asImpl));
            }
        }
    }
}

