/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.m3ua.impl;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import javolution.util.FastCollection;
import javolution.util.FastList;
import javolution.util.FastSet;
import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.m3ua.As;
import org.mobicents.protocols.ss7.m3ua.Asp;
import org.mobicents.protocols.ss7.m3ua.ExchangeType;
import org.mobicents.protocols.ss7.m3ua.Functionality;
import org.mobicents.protocols.ss7.m3ua.IPSPType;
import org.mobicents.protocols.ss7.m3ua.State;
import org.mobicents.protocols.ss7.m3ua.impl.AsState;
import org.mobicents.protocols.ss7.m3ua.impl.AsStateListener;
import org.mobicents.protocols.ss7.m3ua.impl.AsStatePenTimeout;
import org.mobicents.protocols.ss7.m3ua.impl.AspFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspImpl;
import org.mobicents.protocols.ss7.m3ua.impl.AspState;
import org.mobicents.protocols.ss7.m3ua.impl.M3UAManagementImpl;
import org.mobicents.protocols.ss7.m3ua.impl.RemAsStatePenTimeout;
import org.mobicents.protocols.ss7.m3ua.impl.SEHLocalAsStateEnterActive;
import org.mobicents.protocols.ss7.m3ua.impl.SEHLocalAsStateEnterDown;
import org.mobicents.protocols.ss7.m3ua.impl.SEHLocalAsStateEnterInactive;
import org.mobicents.protocols.ss7.m3ua.impl.SEHLocalAsStateEnterPen;
import org.mobicents.protocols.ss7.m3ua.impl.SEHPeerAsStateEnterActive;
import org.mobicents.protocols.ss7.m3ua.impl.SEHPeerAsStateEnterDown;
import org.mobicents.protocols.ss7.m3ua.impl.SEHPeerAsStateEnterInactive;
import org.mobicents.protocols.ss7.m3ua.impl.SEHPeerAsStateEnterPen;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsActToActRemAspAct;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsActToPendRemAspDwn;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsActToPendRemAspInac;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsDwnToInact;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsInactToAct;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsInactToDwn;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsInactToInact;
import org.mobicents.protocols.ss7.m3ua.impl.THLocalAsPendToAct;
import org.mobicents.protocols.ss7.m3ua.impl.THNoTrans;
import org.mobicents.protocols.ss7.m3ua.impl.THPeerAsActToActNtfyAltAspAct;
import org.mobicents.protocols.ss7.m3ua.impl.THPeerAsActToActNtfyInsAsp;
import org.mobicents.protocols.ss7.m3ua.impl.THPeerAsActToPen;
import org.mobicents.protocols.ss7.m3ua.impl.THPeerAsInActToAct;
import org.mobicents.protocols.ss7.m3ua.impl.THPeerAsInActToDwn;
import org.mobicents.protocols.ss7.m3ua.impl.THPeerAsPendToAct;
import org.mobicents.protocols.ss7.m3ua.impl.fsm.FSM;
import org.mobicents.protocols.ss7.m3ua.impl.message.MessageFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.NetworkAppearanceImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.ParameterFactoryImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.RoutingContextImpl;
import org.mobicents.protocols.ss7.m3ua.impl.parameter.TrafficModeTypeImpl;
import org.mobicents.protocols.ss7.m3ua.message.MessageFactory;
import org.mobicents.protocols.ss7.m3ua.message.transfer.PayloadData;
import org.mobicents.protocols.ss7.m3ua.parameter.NetworkAppearance;
import org.mobicents.protocols.ss7.m3ua.parameter.ParameterFactory;
import org.mobicents.protocols.ss7.m3ua.parameter.RoutingContext;
import org.mobicents.protocols.ss7.m3ua.parameter.TrafficModeType;
import org.mobicents.protocols.ss7.mtp.RoutingLabelFormat;

public class AsImpl
implements XMLSerializable,
As {
    private static final Logger logger = Logger.getLogger(AsImpl.class);
    private static final String NAME = "name";
    private static final String ROUTING_CONTEXT = "routingContext";
    private static final String NETWORK_APPEARANCE = "networkAppearance";
    private static final String TRAFFIC_MODE = "trafficMode";
    private static final String DEFAULT_TRAFFIC_MODE = "defTrafficMode";
    private static final String ASP_LIST = "asps";
    private static final String MIN_ASP_ACT_LB = "minAspActiveForLb";
    public static final String ATTRIBUTE_ASP = "asp";
    protected int minAspActiveForLb = 1;
    protected FastList<Asp> appServerProcs = new FastList();
    private FastSet<AsStateListener> asStateListeners = new FastSet();
    protected String name;
    protected RoutingContext rc;
    protected TrafficModeType trMode;
    protected TrafficModeType defaultTrafModType;
    protected ConcurrentLinkedQueue<PayloadData> penQueue = new ConcurrentLinkedQueue();
    private FSM peerFSM;
    private FSM localFSM;
    protected ParameterFactory parameterFactory = new ParameterFactoryImpl();
    protected MessageFactory messageFactory = new MessageFactoryImpl();
    protected M3UAManagementImpl m3UAManagementImpl = null;
    private Functionality functionality = null;
    private ExchangeType exchangeType = null;
    private IPSPType ipspType = null;
    private NetworkAppearance networkAppearance = null;
    private final int[] slsVsAspTable = new int[256];
    private int aspSlsMask = 7;
    private int aspSlsShiftPlaces = 0;
    protected State state = AsState.DOWN;
    protected static final XMLFormat<AsImpl> AS_XML = new XMLFormat<AsImpl>(AsImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, AsImpl asImpl) throws XMLStreamException {
            asImpl.name = xml.getAttribute(AsImpl.NAME, "");
            asImpl.minAspActiveForLb = xml.getAttribute(AsImpl.MIN_ASP_ACT_LB).toInt();
            asImpl.functionality = Functionality.getFunctionality(xml.getAttribute("functionality", ""));
            asImpl.exchangeType = ExchangeType.getExchangeType(xml.getAttribute("exchangeType", ""));
            asImpl.ipspType = IPSPType.getIPSPType(xml.getAttribute("ipspType", ""));
            asImpl.rc = xml.get(AsImpl.ROUTING_CONTEXT, RoutingContextImpl.class);
            asImpl.networkAppearance = xml.get(AsImpl.NETWORK_APPEARANCE, NetworkAppearanceImpl.class);
            asImpl.trMode = xml.get(AsImpl.TRAFFIC_MODE, TrafficModeTypeImpl.class);
            asImpl.defaultTrafModType = xml.get(AsImpl.DEFAULT_TRAFFIC_MODE, TrafficModeTypeImpl.class);
            asImpl.appServerProcs = xml.get(AsImpl.ASP_LIST, FastList.class);
            asImpl.init();
        }

        @Override
        public void write(AsImpl asImpl, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(AsImpl.NAME, asImpl.name);
            xml.setAttribute(AsImpl.MIN_ASP_ACT_LB, asImpl.minAspActiveForLb);
            xml.setAttribute("functionality", asImpl.functionality.getType());
            xml.setAttribute("exchangeType", asImpl.exchangeType.getType());
            if (asImpl.ipspType != null) {
                xml.setAttribute("ipspType", asImpl.ipspType.getType());
            }
            xml.add((RoutingContextImpl)asImpl.rc, AsImpl.ROUTING_CONTEXT, RoutingContextImpl.class);
            xml.add((NetworkAppearanceImpl)asImpl.networkAppearance, AsImpl.NETWORK_APPEARANCE, NetworkAppearanceImpl.class);
            xml.add((TrafficModeTypeImpl)asImpl.trMode, AsImpl.TRAFFIC_MODE, TrafficModeTypeImpl.class);
            xml.add((TrafficModeTypeImpl)asImpl.defaultTrafModType, AsImpl.DEFAULT_TRAFFIC_MODE, TrafficModeTypeImpl.class);
            xml.add(asImpl.appServerProcs, AsImpl.ASP_LIST, FastList.class);
        }
    };

    public AsImpl() {
    }

    public AsImpl(String name, RoutingContext rc, TrafficModeType trMode, int minAspActiveForLoadbalance, Functionality functionality, ExchangeType exchangeType, IPSPType ipspType, NetworkAppearance networkAppearance) {
        this.name = name;
        this.rc = rc;
        this.trMode = trMode;
        this.minAspActiveForLb = minAspActiveForLoadbalance;
        this.functionality = functionality;
        this.exchangeType = exchangeType;
        this.ipspType = ipspType;
        this.defaultTrafModType = this.parameterFactory.createTrafficModeType(2);
        this.networkAppearance = networkAppearance;
        this.init();
    }

    public void init() {
        switch (this.functionality) {
            case IPSP: {
                if (this.exchangeType == ExchangeType.SE) {
                    if (this.ipspType == IPSPType.CLIENT) {
                        this.initPeerFSM();
                        break;
                    }
                    this.initLocalFSM();
                    break;
                }
                this.initPeerFSM();
                this.initLocalFSM();
                break;
            }
            case AS: {
                if (this.exchangeType == ExchangeType.SE) {
                    this.initPeerFSM();
                    break;
                }
                this.initPeerFSM();
                this.initLocalFSM();
                break;
            }
            case SGW: {
                if (this.exchangeType == ExchangeType.SE) {
                    this.initLocalFSM();
                    break;
                }
                this.initPeerFSM();
                this.initLocalFSM();
            }
        }
    }

    private void initPeerFSM() {
        this.peerFSM = new FSM(this.name + "_PEER");
        this.peerFSM.createState(AsState.DOWN.toString()).setOnEnter(new SEHPeerAsStateEnterDown(this));
        this.peerFSM.createState(AsState.ACTIVE.toString()).setOnEnter(new SEHPeerAsStateEnterActive(this));
        this.peerFSM.createState(AsState.INACTIVE.toString()).setOnEnter(new SEHPeerAsStateEnterInactive(this));
        this.peerFSM.createState(AsState.PENDING.toString()).setOnTimeOut(new AsStatePenTimeout(this, this.peerFSM), 2000L).setOnEnter(new SEHPeerAsStateEnterPen(this, this.peerFSM));
        this.peerFSM.setStart(AsState.DOWN.toString());
        this.peerFSM.setEnd(AsState.DOWN.toString());
        this.peerFSM.createTransition("ntfyasinactive", AsState.DOWN.toString(), AsState.INACTIVE.toString());
        this.peerFSM.createTransition("aspdown", AsState.DOWN.toString(), AsState.DOWN.toString());
        this.peerFSM.createTransition("ntfyasactive", AsState.DOWN.toString(), AsState.ACTIVE.toString()).setHandler(new THPeerAsInActToAct(this, this.peerFSM));
        this.peerFSM.createTransition("ntfyasinactive", AsState.INACTIVE.toString(), AsState.INACTIVE.toString());
        this.peerFSM.createTransition("ntfyasactive", AsState.INACTIVE.toString(), AsState.ACTIVE.toString()).setHandler(new THPeerAsInActToAct(this, this.peerFSM));
        this.peerFSM.createTransition("aspdown", AsState.INACTIVE.toString(), AsState.DOWN.toString()).setHandler(new THPeerAsInActToDwn(this, this.peerFSM));
        this.peerFSM.createTransition("ntfyasactive", AsState.ACTIVE.toString(), AsState.ACTIVE.toString());
        this.peerFSM.createTransition("ntfyaltaspact", AsState.ACTIVE.toString(), AsState.ACTIVE.toString()).setHandler(new THPeerAsActToActNtfyAltAspAct(this, this.peerFSM));
        this.peerFSM.createTransition("ntfyinsuffasp", AsState.ACTIVE.toString(), AsState.ACTIVE.toString()).setHandler(new THPeerAsActToActNtfyInsAsp(this, this.peerFSM));
        this.peerFSM.createTransition("ntfyaspending", AsState.ACTIVE.toString(), AsState.PENDING.toString());
        this.peerFSM.createTransition("aspdown", AsState.ACTIVE.toString(), AsState.PENDING.toString()).setHandler(new THPeerAsActToPen(this, this.peerFSM));
        this.peerFSM.createTransition("asdown", AsState.PENDING.toString(), AsState.DOWN.toString());
        this.peerFSM.createTransition("asinactive", AsState.PENDING.toString(), AsState.INACTIVE.toString());
        this.peerFSM.createTransition("ntfyasactive", AsState.PENDING.toString(), AsState.ACTIVE.toString()).setHandler(new THPeerAsPendToAct(this, this.peerFSM));
        this.peerFSM.createTransition("ntfyasinactive", AsState.PENDING.toString(), AsState.INACTIVE.toString()).setHandler(new THNoTrans());
        this.peerFSM.createTransition("aspdown", AsState.PENDING.toString(), AsState.PENDING.toString()).setHandler(new THNoTrans());
    }

    private void initLocalFSM() {
        this.localFSM = new FSM(this.name + "_LOCAL");
        this.localFSM.createState(AsState.DOWN.toString()).setOnEnter(new SEHLocalAsStateEnterDown(this));
        this.localFSM.createState(AsState.ACTIVE.toString()).setOnEnter(new SEHLocalAsStateEnterActive(this));
        this.localFSM.createState(AsState.INACTIVE.toString()).setOnEnter(new SEHLocalAsStateEnterInactive(this));
        this.localFSM.createState(AsState.PENDING.toString()).setOnTimeOut(new RemAsStatePenTimeout(this, this.localFSM), 2000L).setOnEnter(new SEHLocalAsStateEnterPen(this, this.localFSM));
        this.localFSM.setStart(AsState.DOWN.toString());
        this.localFSM.setEnd(AsState.DOWN.toString());
        this.localFSM.createTransition("aspup", AsState.DOWN.toString(), AsState.INACTIVE.toString()).setHandler(new THLocalAsDwnToInact(this, this.localFSM));
        this.localFSM.createTransition("aspdown", AsState.DOWN.toString(), AsState.DOWN.toString());
        this.localFSM.createTransition("aspactive", AsState.INACTIVE.toString(), AsState.ACTIVE.toString()).setHandler(new THLocalAsInactToAct(this, this.localFSM));
        this.localFSM.createTransition("aspdown", AsState.INACTIVE.toString(), AsState.DOWN.toString()).setHandler(new THLocalAsInactToDwn(this, this.localFSM));
        this.localFSM.createTransition("aspup", AsState.INACTIVE.toString(), AsState.INACTIVE.toString()).setHandler(new THLocalAsInactToInact(this, this.localFSM));
        this.localFSM.createTransition("aspinactive", AsState.ACTIVE.toString(), AsState.PENDING.toString()).setHandler(new THLocalAsActToPendRemAspInac(this, this.localFSM));
        this.localFSM.createTransition("aspdown", AsState.ACTIVE.toString(), AsState.PENDING.toString()).setHandler(new THLocalAsActToPendRemAspDwn(this, this.localFSM));
        this.localFSM.createTransition("aspactive", AsState.ACTIVE.toString(), AsState.ACTIVE.toString()).setHandler(new THLocalAsActToActRemAspAct(this, this.localFSM));
        this.localFSM.createTransition("aspup", AsState.ACTIVE.toString(), AsState.PENDING.toString()).setHandler(new THLocalAsActToPendRemAspInac(this, this.localFSM));
        this.localFSM.createTransition("aspdown", AsState.PENDING.toString(), AsState.DOWN.toString()).setHandler(new THNoTrans());
        this.localFSM.createTransition("aspup", AsState.PENDING.toString(), AsState.INACTIVE.toString()).setHandler(new THNoTrans());
        this.localFSM.createTransition("aspactive", AsState.PENDING.toString(), AsState.ACTIVE.toString()).setHandler(new THLocalAsPendToAct(this, this.localFSM));
        this.localFSM.createTransition("asdown", AsState.PENDING.toString(), AsState.DOWN.toString());
        this.localFSM.createTransition("asinactive", AsState.PENDING.toString(), AsState.INACTIVE.toString());
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isConnected() {
        return this.isUp();
    }

    @Override
    public boolean isUp() {
        return this.state.getName().equals("ACTIVE");
    }

    @Override
    public State getState() {
        return this.state;
    }

    protected void setM3UAManagement(M3UAManagementImpl m3uaManagement) {
        this.m3UAManagementImpl = m3uaManagement;
        RoutingLabelFormat routingLabelFormat = this.m3UAManagementImpl.getRoutingLabelFormat();
        switch (this.m3UAManagementImpl.getMaxAsForRoute()) {
            case 1: 
            case 2: {
                if (this.m3UAManagementImpl.isUseLsbForLinksetSelection()) {
                    this.aspSlsMask = 254;
                    this.aspSlsShiftPlaces = 1;
                    break;
                }
                this.aspSlsMask = 127;
                this.aspSlsShiftPlaces = 0;
                break;
            }
            case 3: 
            case 4: {
                if (this.m3UAManagementImpl.isUseLsbForLinksetSelection()) {
                    this.aspSlsMask = 252;
                    this.aspSlsShiftPlaces = 2;
                    break;
                }
                this.aspSlsMask = 63;
                this.aspSlsShiftPlaces = 0;
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                if (this.m3UAManagementImpl.isUseLsbForLinksetSelection()) {
                    this.aspSlsMask = 248;
                    this.aspSlsShiftPlaces = 4;
                    break;
                }
                this.aspSlsMask = 31;
                this.aspSlsShiftPlaces = 0;
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                if (this.m3UAManagementImpl.isUseLsbForLinksetSelection()) {
                    this.aspSlsMask = 240;
                    this.aspSlsShiftPlaces = 4;
                    break;
                }
                this.aspSlsMask = 15;
                this.aspSlsShiftPlaces = 0;
                break;
            }
            default: {
                if (this.m3UAManagementImpl.isUseLsbForLinksetSelection()) {
                    this.aspSlsMask = 254;
                    this.aspSlsShiftPlaces = 1;
                    break;
                }
                this.aspSlsMask = 127;
                this.aspSlsShiftPlaces = 0;
            }
        }
    }

    protected M3UAManagementImpl getM3UAManagement() {
        return this.m3UAManagementImpl;
    }

    protected MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    protected ParameterFactory getParameterFactory() {
        return this.parameterFactory;
    }

    @Override
    public List<Asp> getAspList() {
        return this.appServerProcs.unmodifiable();
    }

    public FSM getPeerFSM() {
        return this.peerFSM;
    }

    public FSM getLocalFSM() {
        return this.localFSM;
    }

    @Override
    public RoutingContext getRoutingContext() {
        return this.rc;
    }

    @Override
    public Functionality getFunctionality() {
        return this.functionality;
    }

    @Override
    public ExchangeType getExchangeType() {
        return this.exchangeType;
    }

    @Override
    public IPSPType getIpspType() {
        return this.ipspType;
    }

    @Override
    public NetworkAppearance getNetworkAppearance() {
        return this.networkAppearance;
    }

    protected void setTrafficModeType(TrafficModeType trMode) {
        this.trMode = trMode;
    }

    @Override
    public TrafficModeType getTrafficModeType() {
        return this.trMode;
    }

    protected void setDefaultTrafficModeType() {
        this.trMode = this.defaultTrafModType;
    }

    @Override
    public TrafficModeType getDefaultTrafficModeType() {
        return this.defaultTrafModType;
    }

    protected void setMinAspActiveForLb(int lb) {
        this.minAspActiveForLb = lb;
    }

    @Override
    public int getMinAspActiveForLb() {
        return this.minAspActiveForLb;
    }

    protected void addAppServerProcess(AspImpl aspImpl) throws Exception {
        aspImpl.setAs(this);
        this.appServerProcs.add(aspImpl);
        this.resetSlsVsAspTable();
    }

    protected AspImpl removeAppServerProcess(String aspName) throws Exception {
        AspState aspPeerState;
        AspState aspLocalState;
        AspImpl aspImpl = null;
        FastCollection.Record n = this.appServerProcs.head();
        FastCollection.Record end = this.appServerProcs.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            AspImpl aspTemp = (AspImpl)((FastList.Node)n).getValue();
            if (!aspTemp.getName().equals(aspName)) continue;
            aspImpl = aspTemp;
            break;
        }
        if (aspImpl == null) {
            throw new Exception(String.format("No ASP found for given name %s", aspName));
        }
        FSM aspLocalFSM = aspImpl.getLocalFSM();
        if (aspLocalFSM != null && (aspLocalState = AspState.getState(aspLocalFSM.getState().getName())) != AspState.DOWN) {
            throw new Exception(String.format("ASP=%s local FSM is still %s. Bring it DOWN before removing from this As", aspName, aspLocalState));
        }
        FSM aspPeerFSM = aspImpl.getPeerFSM();
        if (aspPeerFSM != null && (aspPeerState = AspState.getState(aspPeerFSM.getState().getName())) != AspState.DOWN) {
            throw new Exception(String.format("ASP=%s peer FSM is still %s. Bring it DOWN before removing from this As", aspName, aspPeerState));
        }
        this.appServerProcs.remove(aspImpl);
        aspImpl.setAs(null);
        if (aspLocalFSM != null) {
            aspLocalFSM.cancel();
        }
        if (aspPeerFSM != null) {
            aspPeerFSM.cancel();
        }
        this.resetSlsVsAspTable();
        return aspImpl;
    }

    protected void write(PayloadData message) throws IOException {
        FSM fsm = null;
        boolean isASPLocalFsm = true;
        if (this.functionality == Functionality.AS || this.functionality == Functionality.SGW && this.exchangeType == ExchangeType.DE || this.functionality == Functionality.IPSP && this.ipspType == IPSPType.CLIENT || this.functionality == Functionality.IPSP && this.ipspType == IPSPType.SERVER && this.exchangeType == ExchangeType.DE) {
            fsm = this.peerFSM;
        } else {
            fsm = this.localFSM;
            isASPLocalFsm = false;
        }
        int sls = message.getData().getSLS();
        switch (AsState.getState(fsm.getState().getName())) {
            case ACTIVE: {
                boolean aspFound = false;
                int aspIndex = sls & this.aspSlsMask;
                aspIndex >>= this.aspSlsShiftPlaces;
                for (int i = 0; i < this.appServerProcs.size(); ++i) {
                    AspImpl aspTemp = (AspImpl)this.appServerProcs.get(this.slsVsAspTable[aspIndex++]);
                    FSM aspFsm = null;
                    aspFsm = isASPLocalFsm ? aspTemp.getLocalFSM() : aspTemp.getPeerFSM();
                    if (AspState.getState(aspFsm.getState().getName()) != AspState.ACTIVE) continue;
                    aspTemp.getAspFactory().write(message);
                    aspFound = true;
                    break;
                }
                if (aspFound) break;
                logger.error(String.format("Tx : no ACTIVE Asp for message=%s", message));
                break;
            }
            case PENDING: {
                if (logger.isInfoEnabled()) {
                    logger.info(String.format("Adding the PayloadData=%s to PendingQueue for AS=%s", message.toString(), this.name));
                }
                this.penQueue.add(message);
                break;
            }
            default: {
                throw new IOException(String.format("As name=%s is not ACTIVE", this.name));
            }
        }
    }

    protected void clearPendingQueue() {
        if (logger.isDebugEnabled() && this.penQueue.size() > 0) {
            logger.debug(String.format("Cleaning %d PayloadData message from pending queue of As name=%s", this.penQueue.size(), this.name));
        }
        this.penQueue.clear();
    }

    protected void sendPendingPayloadData(AspImpl aspImpl) {
        PayloadData payload = null;
        while ((payload = this.penQueue.poll()) != null) {
            aspImpl.getAspFactory().write(payload);
        }
    }

    public void show(StringBuffer sb) {
        sb.append("AS name=").append(this.name).append(" functionality=").append((Object)this.functionality).append(" mode=").append((Object)this.exchangeType);
        if (this.functionality == Functionality.IPSP) {
            sb.append(" ipspType=").append((Object)this.ipspType);
        }
        if (this.rc != null) {
            sb.append(" rc=").append(Arrays.toString(this.rc.getRoutingContexts()));
        }
        if (this.trMode != null) {
            sb.append(" trMode=").append(this.trMode.getMode());
        }
        sb.append(" defaultTrMode=").append(this.defaultTrafModType.getMode());
        if (this.networkAppearance != null) {
            sb.append(" na=").append(this.networkAppearance.getNetApp());
        }
        if (this.getLocalFSM() != null) {
            sb.append(" localFSMState=").append(this.getLocalFSM().getState());
        }
        if (this.getPeerFSM() != null) {
            sb.append(" peerFSMState=").append(this.getPeerFSM().getState());
        }
        sb.append("\n");
        sb.append("Assigned to :\n");
        FastCollection.Record n = this.appServerProcs.head();
        FastCollection.Record end = this.appServerProcs.tail();
        while ((n = ((FastList.Node)n).getNext()) != end) {
            AspImpl aspTemp = (AspImpl)((FastList.Node)n).getValue();
            AspFactoryImpl aspFactoryImpl = aspTemp.getAspFactory();
            sb.append("        ").append("ASP name=").append(aspFactoryImpl.getName()).append(" started=").append(aspFactoryImpl.getStatus());
            sb.append("\n");
        }
    }

    protected void addAsStateListener(AsStateListener listener) {
        this.asStateListeners.add(listener);
    }

    protected void removeAsStateListener(AsStateListener listener) {
        this.asStateListeners.remove(listener);
    }

    public FastSet<AsStateListener> getAsStateListeners() {
        return this.asStateListeners;
    }

    private void resetSlsVsAspTable() {
        int aspNumber = 0;
        for (int count = 0; count < 256; ++count) {
            if (aspNumber >= this.appServerProcs.size()) {
                aspNumber = 0;
            }
            this.slsVsAspTable[count] = aspNumber++;
        }
    }
}

