/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.linkset.oam;

import javolution.util.FastCollection;
import javolution.util.FastMap;
import javolution.xml.XMLBinding;
import org.mobicents.ss7.linkset.oam.Linkset;
import org.mobicents.ss7.linkset.oam.LinksetFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinksetFactoryFactory {
    private FastMap<String, LinksetFactory> linksetFactories = new FastMap();

    public void addFactory(LinksetFactory factory) {
        this.linksetFactories.put(factory.getName(), factory);
    }

    public void removeFactory(LinksetFactory factory) {
        this.linksetFactories.remove(factory);
    }

    public void loadBinding(XMLBinding binding) {
        FastCollection.Record e = this.linksetFactories.head();
        FastMap.Entry<String, LinksetFactory> end = this.linksetFactories.tail();
        while ((e = ((FastMap.Entry)e).getNext()) != end) {
            LinksetFactory linksetFactory = (LinksetFactory)((FastMap.Entry)e).getValue();
            if (linksetFactory.getLinkName() != null) {
                binding.setAlias(linksetFactory.getLinkClass(), linksetFactory.getLinkName());
            }
            if (linksetFactory.getLinksetName() == null) continue;
            binding.setAlias(linksetFactory.getLinksetClass(), linksetFactory.getLinksetName());
        }
    }

    public Linkset createLinkset(String[] options) throws Exception {
        if (options == null) {
            throw new Exception("Invalid Command");
        }
        if (options.length < 3) {
            throw new Exception("Invalid Command");
        }
        String type = options[2];
        if (type == null) {
            throw new Exception("Invalid Command");
        }
        LinksetFactory linksetFactory = this.linksetFactories.get(type);
        if (linksetFactory == null) {
            throw new Exception("Invalid Command");
        }
        return linksetFactory.createLinkset(options);
    }

    public FastMap<String, LinksetFactory> getLinksetFactories() {
        return this.linksetFactories;
    }
}

