/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.tcap;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.sccp.parameter.SccpAddress;
import org.mobicents.protocols.ss7.tcap.PrevewDialogData;
import org.mobicents.protocols.ss7.tcap.TCAPProviderImpl;
import org.mobicents.protocols.ss7.tcap.TCAPStackImpl;
import org.mobicents.protocols.ss7.tcap.api.TCAPException;
import org.mobicents.protocols.ss7.tcap.api.TCAPSendException;
import org.mobicents.protocols.ss7.tcap.api.tc.component.InvokeClass;
import org.mobicents.protocols.ss7.tcap.api.tc.component.OperationState;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.Dialog;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.TRPseudoState;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCBeginRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCContinueRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCEndRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUniRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TCUserAbortRequest;
import org.mobicents.protocols.ss7.tcap.api.tc.dialog.events.TerminationType;
import org.mobicents.protocols.ss7.tcap.asn.AbortSource;
import org.mobicents.protocols.ss7.tcap.asn.AbortSourceType;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextName;
import org.mobicents.protocols.ss7.tcap.asn.ApplicationContextNameImpl;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogAPDUType;
import org.mobicents.protocols.ss7.tcap.asn.DialogAbortAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogPortion;
import org.mobicents.protocols.ss7.tcap.asn.DialogRequestAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceProviderType;
import org.mobicents.protocols.ss7.tcap.asn.DialogServiceUserType;
import org.mobicents.protocols.ss7.tcap.asn.DialogUniAPDU;
import org.mobicents.protocols.ss7.tcap.asn.EncodeException;
import org.mobicents.protocols.ss7.tcap.asn.ErrorCodeImpl;
import org.mobicents.protocols.ss7.tcap.asn.InvokeImpl;
import org.mobicents.protocols.ss7.tcap.asn.OperationCodeImpl;
import org.mobicents.protocols.ss7.tcap.asn.ProblemImpl;
import org.mobicents.protocols.ss7.tcap.asn.Result;
import org.mobicents.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.mobicents.protocols.ss7.tcap.asn.ResultType;
import org.mobicents.protocols.ss7.tcap.asn.ReturnResultImpl;
import org.mobicents.protocols.ss7.tcap.asn.ReturnResultLastImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCAbortMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCBeginMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCContinueMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCEndMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TCUniMessageImpl;
import org.mobicents.protocols.ss7.tcap.asn.TcapFactory;
import org.mobicents.protocols.ss7.tcap.asn.UserInformation;
import org.mobicents.protocols.ss7.tcap.asn.Utils;
import org.mobicents.protocols.ss7.tcap.asn.comp.Component;
import org.mobicents.protocols.ss7.tcap.asn.comp.ComponentType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Invoke;
import org.mobicents.protocols.ss7.tcap.asn.comp.InvokeProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Problem;
import org.mobicents.protocols.ss7.tcap.asn.comp.ProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.Reject;
import org.mobicents.protocols.ss7.tcap.asn.comp.Return;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnError;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnErrorProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.ReturnResultProblemType;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCAbortMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCBeginMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCContinueMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCEndMessage;
import org.mobicents.protocols.ss7.tcap.asn.comp.TCUniMessage;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.DialogPrimitiveFactoryImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCBeginIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCContinueIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCEndIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCPAbortIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUniIndicationImpl;
import org.mobicents.protocols.ss7.tcap.tc.dialog.events.TCUserAbortIndicationImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogImpl
implements Dialog {
    private static final int _REMOVE_TIMEOUT = 30000;
    private static final Logger logger = Logger.getLogger(DialogImpl.class);
    private Object userObject;
    protected ReentrantLock dialogLock = new ReentrantLock();
    private long removeTaskTimeout = 30000L;
    private long idleTaskTimeout;
    private ApplicationContextName lastACN;
    private UserInformation lastUI;
    private Long localTransactionIdObject;
    private long localTransactionId;
    private byte[] remoteTransactionId;
    private Long remoteTransactionIdObject;
    private SccpAddress localAddress;
    private SccpAddress remoteAddress;
    private Future idleTimerFuture;
    private boolean idleTimerActionTaken = false;
    private boolean idleTimerInvoked = false;
    private TRPseudoState state = TRPseudoState.Idle;
    private boolean structured = true;
    private static final boolean _INVOKEID_TAKEN = true;
    private static final boolean _INVOKEID_FREE = false;
    private static final int _INVOKE_TABLE_SHIFT = 128;
    private boolean[] invokeIDTable = new boolean[256];
    private int freeCount = this.invokeIDTable.length;
    private int lastInvokeIdIndex = 127;
    protected InvokeImpl[] operationsSent = new InvokeImpl[this.invokeIDTable.length];
    protected InvokeImpl[] operationsSentA = new InvokeImpl[this.invokeIDTable.length];
    private Set<Long> incomingInvokeList = new HashSet<Long>();
    private ScheduledExecutorService executor;
    private List<Component> scheduledComponentList = new ArrayList<Component>();
    private TCAPProviderImpl provider;
    private int seqControl;
    private boolean dpSentInBegin = false;
    private boolean previewMode = false;
    protected PrevewDialogData prevewDialogData;
    private long startDialogTime;
    private int networkId;

    private static int getIndexFromInvokeId(Long l) {
        int tmp = l.intValue();
        return tmp + 128;
    }

    private static Long getInvokeIdFromIndex(int index) {
        int tmp = index - 128;
        return new Long(tmp);
    }

    protected DialogImpl(SccpAddress localAddress, SccpAddress remoteAddress, Long origTransactionId, boolean structured, ScheduledExecutorService executor, TCAPProviderImpl provider, int seqControl, boolean previewMode) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        if (origTransactionId != null) {
            this.localTransactionIdObject = origTransactionId;
            this.localTransactionId = origTransactionId;
        }
        this.executor = executor;
        this.provider = provider;
        this.structured = structured;
        this.seqControl = seqControl;
        this.previewMode = previewMode;
        TCAPStackImpl stack = this.provider.getStack();
        this.idleTaskTimeout = stack.getDialogIdleTimeout();
        this.startDialogTime = System.currentTimeMillis();
        this.startIdleTimer();
    }

    protected DialogImpl(SccpAddress localAddress, SccpAddress remoteAddress, int seqControl, ScheduledExecutorService executor, TCAPProviderImpl provider, PrevewDialogData pdd, boolean sideB) {
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
        this.localTransactionIdObject = pdd.getDialogId();
        this.localTransactionId = pdd.getDialogId();
        this.executor = executor;
        this.provider = provider;
        this.structured = true;
        this.seqControl = seqControl;
        this.previewMode = true;
        TCAPStackImpl stack = this.provider.getStack();
        this.idleTaskTimeout = stack.getDialogIdleTimeout();
        this.prevewDialogData = pdd;
        this.lastACN = pdd.getLastACN();
        if (sideB) {
            if (pdd.getOperationsSentA() != null) {
                this.operationsSent = pdd.getOperationsSentA();
            }
            if (pdd.getOperationsSentB() != null) {
                this.operationsSentA = pdd.getOperationsSentB();
            }
        } else {
            if (pdd.getOperationsSentA() != null) {
                this.operationsSentA = pdd.getOperationsSentA();
            }
            if (pdd.getOperationsSentB() != null) {
                this.operationsSent = pdd.getOperationsSentB();
            }
        }
        for (InvokeImpl invoke : this.operationsSent) {
            if (invoke == null) continue;
            invoke.setDialog(this);
        }
    }

    @Override
    public void release() {
        if (!this.previewMode) {
            for (int i = 0; i < this.operationsSent.length; ++i) {
                InvokeImpl invokeImpl = this.operationsSent[i];
                if (invokeImpl == null) continue;
                invokeImpl.setState(OperationState.Idle);
            }
        }
        if (this.isStructured() && this.provider.getStack().getStatisticsEnabled()) {
            long lg = System.currentTimeMillis() - this.startDialogTime;
            this.provider.getStack().getCounterProviderImpl().updateAllDialogsDuration(lg);
        }
        this.setState(TRPseudoState.Expunged);
    }

    @Override
    public Long getLocalDialogId() {
        return this.localTransactionIdObject;
    }

    @Override
    public Long getRemoteDialogId() {
        if (this.remoteTransactionId != null && this.remoteTransactionIdObject == null) {
            this.remoteTransactionIdObject = Utils.decodeTransactionId(this.remoteTransactionId);
        }
        return this.remoteTransactionIdObject;
    }

    @Override
    public Long getNewInvokeId() throws TCAPException {
        try {
            this.dialogLock.lock();
            if (this.freeCount == 0) {
                throw new TCAPException("No free invokeId");
            }
            int tryCnt = 0;
            do {
                if (++this.lastInvokeIdIndex >= this.invokeIDTable.length) {
                    this.lastInvokeIdIndex = 0;
                }
                if (this.invokeIDTable[this.lastInvokeIdIndex]) continue;
                --this.freeCount;
                this.invokeIDTable[this.lastInvokeIdIndex] = true;
                Long l = DialogImpl.getInvokeIdFromIndex(this.lastInvokeIdIndex);
                return l;
            } while (++tryCnt < 256);
            throw new TCAPException("No free invokeId");
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    @Override
    public int getNetworkId() {
        return this.networkId;
    }

    @Override
    public void setNetworkId(int networkId) {
        this.networkId = networkId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean cancelInvocation(Long invokeId) throws TCAPException {
        if (this.previewMode) {
            return false;
        }
        try {
            this.dialogLock.lock();
            int index = DialogImpl.getIndexFromInvokeId(invokeId);
            if (index < 0 || index >= this.operationsSent.length) {
                throw new TCAPException("Wrong invoke id passed.");
            }
            for (index = 0; index < this.scheduledComponentList.size(); ++index) {
                Component cr = this.scheduledComponentList.get(index);
                if (cr.getType() != ComponentType.Invoke || !cr.getInvokeId().equals(invokeId)) continue;
                this.scheduledComponentList.remove(index);
                ((InvokeImpl)cr).stopTimer();
                ((InvokeImpl)cr).setState(OperationState.Idle);
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeInvokeId(Long l) {
        try {
            this.dialogLock.lock();
            int index = DialogImpl.getIndexFromInvokeId(l);
            if (this.invokeIDTable[index]) {
                ++this.freeCount;
            }
            this.invokeIDTable[index] = false;
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    @Override
    public SccpAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    @Override
    public SccpAddress getLocalAddress() {
        return this.localAddress;
    }

    @Override
    public boolean isEstabilished() {
        return this.state == TRPseudoState.Active;
    }

    @Override
    public boolean isStructured() {
        return this.structured;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void keepAlive() {
        if (this.previewMode) {
            return;
        }
        try {
            this.dialogLock.lock();
            if (this.idleTimerInvoked) {
                this.idleTimerActionTaken = true;
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    @Override
    public ReentrantLock getDialogLock() {
        return this.dialogLock;
    }

    @Override
    public ApplicationContextName getApplicationContextName() {
        return this.lastACN;
    }

    @Override
    public UserInformation getUserInformation() {
        return this.lastUI;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addIncomingInvokeId(Long invokeId) {
        Set<Long> set = this.incomingInvokeList;
        synchronized (set) {
            if (this.incomingInvokeList.contains(invokeId)) {
                return false;
            }
            this.incomingInvokeList.add(invokeId);
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeIncomingInvokeId(Long invokeId) {
        Set<Long> set = this.incomingInvokeList;
        synchronized (set) {
            this.incomingInvokeList.remove(invokeId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TCBeginRequest event) throws TCAPSendException {
        if (this.previewMode) {
            return;
        }
        if (this.state != TRPseudoState.Idle) {
            throw new TCAPSendException("Can not send Begin in this state: " + (Object)((Object)this.state));
        }
        if (!this.isStructured()) {
            throw new TCAPSendException("Unstructured dialogs do not use Begin");
        }
        try {
            this.dialogLock.lock();
            this.idleTimerActionTaken = true;
            this.restartIdleTimer();
            TCBeginMessageImpl tcbm = (TCBeginMessageImpl)TcapFactory.createTCBeginMessage();
            if (event.getApplicationContextName() != null) {
                this.dpSentInBegin = true;
                DialogPortion dp = TcapFactory.createDialogPortion();
                dp.setUnidirectional(false);
                DialogRequestAPDU apdu = TcapFactory.createDialogAPDURequest();
                apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
                dp.setDialogAPDU(apdu);
                apdu.setApplicationContextName(event.getApplicationContextName());
                this.lastACN = event.getApplicationContextName();
                if (event.getUserInformation() != null) {
                    apdu.setUserInformation(event.getUserInformation());
                    this.lastUI = event.getUserInformation();
                }
                tcbm.setDialogPortion(dp);
                if (this.provider.getStack().getStatisticsEnabled()) {
                    String acn = ((ApplicationContextNameImpl)event.getApplicationContextName()).getStringValue();
                    this.provider.getStack().getCounterProviderImpl().updateOutgoingDialogsPerApplicatioContextName(acn);
                }
            } else if (this.provider.getStack().getStatisticsEnabled()) {
                this.provider.getStack().getCounterProviderImpl().updateOutgoingDialogsPerApplicatioContextName("");
            }
            tcbm.setOriginatingTransactionId(Utils.encodeTransactionId(this.localTransactionId));
            if (this.scheduledComponentList.size() > 0) {
                Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                this.prepareComponents(componentsToSend);
                tcbm.setComponent(componentsToSend);
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                tcbm.encode(aos);
                this.setState(TRPseudoState.InitialSent);
                if (this.provider.getStack().getStatisticsEnabled()) {
                    this.provider.getStack().getCounterProviderImpl().updateTcBeginSentCount();
                }
                this.provider.send(aos.toByteArray(), event.getReturnMessageOnError(), this.remoteAddress, this.localAddress, this.seqControl, this.networkId);
                this.scheduledComponentList.clear();
            }
            catch (Throwable e) {
                if (logger.isEnabledFor(Level.ERROR)) {
                    logger.error("Failed to send message: ", e);
                }
                throw new TCAPSendException("Failed to send TC-Begin message: " + e.getMessage(), e);
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TCContinueRequest event) throws TCAPSendException {
        block19: {
            if (this.previewMode) {
                return;
            }
            if (!this.isStructured()) {
                throw new TCAPSendException("Unstructured dialogs do not use Continue");
            }
            try {
                this.dialogLock.lock();
                if (this.state == TRPseudoState.InitialReceived) {
                    this.idleTimerActionTaken = true;
                    this.restartIdleTimer();
                    TCContinueMessageImpl tcbm = (TCContinueMessageImpl)TcapFactory.createTCContinueMessage();
                    if (event.getApplicationContextName() != null) {
                        DialogPortion dp = TcapFactory.createDialogPortion();
                        dp.setUnidirectional(false);
                        DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
                        apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
                        dp.setDialogAPDU(apdu);
                        apdu.setApplicationContextName(event.getApplicationContextName());
                        if (event.getUserInformation() != null) {
                            apdu.setUserInformation(event.getUserInformation());
                        }
                        Result res = TcapFactory.createResult();
                        res.setResultType(ResultType.Accepted);
                        ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
                        rsd.setDialogServiceUserType(DialogServiceUserType.Null);
                        apdu.setResultSourceDiagnostic(rsd);
                        apdu.setResult(res);
                        tcbm.setDialogPortion(dp);
                    }
                    tcbm.setOriginatingTransactionId(Utils.encodeTransactionId(this.localTransactionId));
                    tcbm.setDestinationTransactionId(this.remoteTransactionId);
                    if (this.scheduledComponentList.size() > 0) {
                        Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                        this.prepareComponents(componentsToSend);
                        tcbm.setComponent(componentsToSend);
                    }
                    if (event.getOriginatingAddress() != null && !event.getOriginatingAddress().equals(this.localAddress)) {
                        this.localAddress = event.getOriginatingAddress();
                    }
                    AsnOutputStream aos = new AsnOutputStream();
                    try {
                        tcbm.encode(aos);
                        if (this.provider.getStack().getStatisticsEnabled()) {
                            this.provider.getStack().getCounterProviderImpl().updateTcContinueSentCount();
                        }
                        this.provider.send(aos.toByteArray(), event.getReturnMessageOnError(), this.remoteAddress, this.localAddress, this.seqControl, this.networkId);
                        this.setState(TRPseudoState.Active);
                        this.scheduledComponentList.clear();
                        break block19;
                    }
                    catch (Exception e) {
                        if (logger.isEnabledFor(Level.ERROR)) {
                            logger.error("Failed to send message: ", e);
                        }
                        throw new TCAPSendException("Failed to send TC-Continue message: " + e.getMessage(), e);
                    }
                }
                if (this.state == TRPseudoState.Active) {
                    this.idleTimerActionTaken = true;
                    this.restartIdleTimer();
                    TCContinueMessageImpl tcbm = (TCContinueMessageImpl)TcapFactory.createTCContinueMessage();
                    tcbm.setOriginatingTransactionId(Utils.encodeTransactionId(this.localTransactionId));
                    tcbm.setDestinationTransactionId(this.remoteTransactionId);
                    if (this.scheduledComponentList.size() > 0) {
                        Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                        this.prepareComponents(componentsToSend);
                        tcbm.setComponent(componentsToSend);
                    }
                    AsnOutputStream aos = new AsnOutputStream();
                    try {
                        tcbm.encode(aos);
                        this.provider.getStack().getCounterProviderImpl().updateTcContinueSentCount();
                        this.provider.send(aos.toByteArray(), event.getReturnMessageOnError(), this.remoteAddress, this.localAddress, this.seqControl, this.networkId);
                        this.scheduledComponentList.clear();
                        break block19;
                    }
                    catch (Exception e) {
                        if (logger.isEnabledFor(Level.ERROR)) {
                            logger.error("Failed to send message: ", e);
                        }
                        throw new TCAPSendException("Failed to send TC-Continue message: " + e.getMessage(), e);
                    }
                }
                throw new TCAPSendException("Wrong state: " + (Object)((Object)this.state));
            }
            finally {
                this.dialogLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void send(TCEndRequest event) throws TCAPSendException {
        if (this.previewMode) {
            return;
        }
        if (!this.isStructured()) {
            throw new TCAPSendException("Unstructured dialogs do not use End");
        }
        try {
            Component[] componentsToSend;
            this.dialogLock.lock();
            TCEndMessageImpl tcbm = null;
            if (this.state == TRPseudoState.InitialReceived) {
                ApplicationContextName acn;
                this.idleTimerActionTaken = true;
                this.stopIdleTimer();
                tcbm = (TCEndMessageImpl)TcapFactory.createTCEndMessage();
                tcbm.setDestinationTransactionId(this.remoteTransactionId);
                if (event.getTerminationType() == TerminationType.Basic) {
                    if (this.scheduledComponentList.size() > 0) {
                        componentsToSend = new Component[this.scheduledComponentList.size()];
                        this.prepareComponents(componentsToSend);
                        tcbm.setComponent(componentsToSend);
                    }
                } else {
                    if (event.getTerminationType() != TerminationType.PreArranged) throw new TCAPSendException("Termination TYPE must be present");
                    this.scheduledComponentList.clear();
                }
                if ((acn = event.getApplicationContextName()) != null) {
                    DialogPortion dp = TcapFactory.createDialogPortion();
                    dp.setUnidirectional(false);
                    DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
                    apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
                    dp.setDialogAPDU(apdu);
                    apdu.setApplicationContextName(event.getApplicationContextName());
                    if (event.getUserInformation() != null) {
                        apdu.setUserInformation(event.getUserInformation());
                    }
                    Result res = TcapFactory.createResult();
                    res.setResultType(ResultType.Accepted);
                    ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
                    rsd.setDialogServiceUserType(DialogServiceUserType.Null);
                    apdu.setResultSourceDiagnostic(rsd);
                    apdu.setResult(res);
                    tcbm.setDialogPortion(dp);
                }
                if (event.getOriginatingAddress() != null && !event.getOriginatingAddress().equals(this.localAddress)) {
                    this.localAddress = event.getOriginatingAddress();
                }
            } else {
                if (this.state != TRPseudoState.Active) throw new TCAPSendException(String.format("State is not %s or %s: it is %s", new Object[]{TRPseudoState.Active, TRPseudoState.InitialReceived, this.state}));
                this.restartIdleTimer();
                tcbm = (TCEndMessageImpl)TcapFactory.createTCEndMessage();
                tcbm.setDestinationTransactionId(this.remoteTransactionId);
                if (event.getTerminationType() == TerminationType.Basic) {
                    if (this.scheduledComponentList.size() > 0) {
                        componentsToSend = new Component[this.scheduledComponentList.size()];
                        this.prepareComponents(componentsToSend);
                        tcbm.setComponent(componentsToSend);
                    }
                } else {
                    if (event.getTerminationType() != TerminationType.PreArranged) throw new TCAPSendException("Termination TYPE must be present");
                    this.scheduledComponentList.clear();
                }
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                tcbm.encode(aos);
                if (this.provider.getStack().getStatisticsEnabled()) {
                    this.provider.getStack().getCounterProviderImpl().updateTcEndSentCount();
                }
                this.provider.send(aos.toByteArray(), event.getReturnMessageOnError(), this.remoteAddress, this.localAddress, this.seqControl, this.networkId);
                this.scheduledComponentList.clear();
                return;
            }
            catch (Exception e) {
                if (!logger.isEnabledFor(Level.ERROR)) throw new TCAPSendException("Failed to send TC-End message: " + e.getMessage(), e);
                logger.error("Failed to send message: ", e);
                throw new TCAPSendException("Failed to send TC-End message: " + e.getMessage(), e);
            }
            finally {
                this.release();
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TCUniRequest event) throws TCAPSendException {
        if (this.previewMode) {
            return;
        }
        if (this.isStructured()) {
            throw new TCAPSendException("Structured dialogs do not use Uni");
        }
        try {
            this.dialogLock.lock();
            TCUniMessageImpl msg = (TCUniMessageImpl)TcapFactory.createTCUniMessage();
            if (event.getApplicationContextName() != null) {
                DialogPortion dp = TcapFactory.createDialogPortion();
                DialogUniAPDU apdu = TcapFactory.createDialogAPDUUni();
                apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
                apdu.setApplicationContextName(event.getApplicationContextName());
                if (event.getUserInformation() != null) {
                    apdu.setUserInformation(event.getUserInformation());
                }
                dp.setUnidirectional(true);
                dp.setDialogAPDU(apdu);
                msg.setDialogPortion(dp);
            }
            if (this.scheduledComponentList.size() > 0) {
                Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
                this.prepareComponents(componentsToSend);
                msg.setComponent(componentsToSend);
            }
            AsnOutputStream aos = new AsnOutputStream();
            try {
                msg.encode(aos);
                if (this.provider.getStack().getStatisticsEnabled()) {
                    this.provider.getStack().getCounterProviderImpl().updateTcUniSentCount();
                }
                this.provider.send(aos.toByteArray(), event.getReturnMessageOnError(), this.remoteAddress, this.localAddress, this.seqControl, this.networkId);
                this.scheduledComponentList.clear();
            }
            catch (Exception e) {
                if (logger.isEnabledFor(Level.ERROR)) {
                    logger.error("Failed to send message: ", e);
                }
                throw new TCAPSendException("Failed to send TC-Uni message: " + e.getMessage(), e);
            }
            finally {
                this.release();
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(TCUserAbortRequest event) throws TCAPSendException {
        block18: {
            if (this.previewMode) {
                return;
            }
            if (!this.isStructured()) {
                throw new TCAPSendException("Unstructured dialog can not be aborted!");
            }
            try {
                this.dialogLock.lock();
                if (this.state == TRPseudoState.InitialReceived || this.state == TRPseudoState.Active) {
                    DialogPortion dp = null;
                    if (event.getUserInformation() != null || event.getDialogServiceUserType() != null) {
                        dp = TcapFactory.createDialogPortion();
                        dp.setUnidirectional(false);
                        if (event.getDialogServiceUserType() != null) {
                            DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
                            apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
                            apdu.setApplicationContextName(event.getApplicationContextName());
                            apdu.setUserInformation(event.getUserInformation());
                            Result res = TcapFactory.createResult();
                            res.setResultType(ResultType.RejectedPermanent);
                            ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
                            rsd.setDialogServiceUserType(event.getDialogServiceUserType());
                            apdu.setResultSourceDiagnostic(rsd);
                            apdu.setResult(res);
                            dp.setDialogAPDU(apdu);
                        } else {
                            DialogAbortAPDU dapdu = TcapFactory.createDialogAPDUAbort();
                            AbortSource as = TcapFactory.createAbortSource();
                            as.setAbortSourceType(AbortSourceType.User);
                            dapdu.setAbortSource(as);
                            dapdu.setUserInformation(event.getUserInformation());
                            dp.setDialogAPDU(dapdu);
                        }
                    }
                    TCAbortMessageImpl msg = (TCAbortMessageImpl)TcapFactory.createTCAbortMessage();
                    msg.setDestinationTransactionId(this.remoteTransactionId);
                    msg.setDialogPortion(dp);
                    if (this.state == TRPseudoState.InitialReceived && event.getOriginatingAddress() != null && !event.getOriginatingAddress().equals(this.localAddress)) {
                        this.localAddress = event.getOriginatingAddress();
                    }
                    AsnOutputStream aos = new AsnOutputStream();
                    try {
                        msg.encode(aos);
                        if (this.provider.getStack().getStatisticsEnabled()) {
                            this.provider.getStack().getCounterProviderImpl().updateTcUserAbortSentCount();
                        }
                        this.provider.send(aos.toByteArray(), event.getReturnMessageOnError(), this.remoteAddress, this.localAddress, this.seqControl, this.networkId);
                        this.scheduledComponentList.clear();
                        break block18;
                    }
                    catch (Exception e) {
                        if (logger.isEnabledFor(Level.ERROR)) {
                            e.printStackTrace();
                            logger.error("Failed to send message: ", e);
                        }
                        throw new TCAPSendException("Failed to send TC-U-Abort message: " + e.getMessage(), e);
                    }
                    finally {
                        this.release();
                    }
                }
                if (this.state == TRPseudoState.InitialSent) {
                    this.release();
                }
            }
            finally {
                this.dialogLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendComponent(Component componentRequest) throws TCAPSendException {
        if (this.previewMode) {
            return;
        }
        if (this.provider.getStack().getStatisticsEnabled()) {
            switch (componentRequest.getType()) {
                case Invoke: {
                    this.provider.getStack().getCounterProviderImpl().updateInvokeSentCount();
                    Invoke inv = (Invoke)componentRequest;
                    OperationCodeImpl oc = (OperationCodeImpl)inv.getOperationCode();
                    if (oc == null) break;
                    this.provider.getStack().getCounterProviderImpl().updateOutgoingInvokesPerOperationCode(oc.getStringValue());
                    break;
                }
                case ReturnResult: {
                    this.provider.getStack().getCounterProviderImpl().updateReturnResultSentCount();
                    break;
                }
                case ReturnResultLast: {
                    this.provider.getStack().getCounterProviderImpl().updateReturnResultLastSentCount();
                    break;
                }
                case ReturnError: {
                    this.provider.getStack().getCounterProviderImpl().updateReturnErrorSentCount();
                    ReturnError re = (ReturnError)componentRequest;
                    ErrorCodeImpl ec = (ErrorCodeImpl)re.getErrorCode();
                    if (ec == null) break;
                    this.provider.getStack().getCounterProviderImpl().updateOutgoingErrorsPerErrorCode(ec.getStringValue());
                    break;
                }
                case Reject: {
                    this.provider.getStack().getCounterProviderImpl().updateRejectSentCount();
                    Reject rej = (Reject)componentRequest;
                    ProblemImpl prob = (ProblemImpl)rej.getProblem();
                    if (prob == null) break;
                    this.provider.getStack().getCounterProviderImpl().updateOutgoingRejectPerProblem(prob.getStringValue());
                }
            }
        }
        try {
            this.dialogLock.lock();
            if (componentRequest.getType() == ComponentType.Invoke) {
                InvokeImpl invoke = (InvokeImpl)componentRequest;
                int invokeIndex = DialogImpl.getIndexFromInvokeId(invoke.getInvokeId());
                if (this.operationsSent[invokeIndex] != null) {
                    throw new TCAPSendException("There is already operation with such invoke id!");
                }
                invoke.setState(OperationState.Pending);
                invoke.setDialog(this);
                if (invoke.getTimeout() == -1L) {
                    invoke.setTimeout(this.provider.getStack().getInvokeTimeout());
                }
            } else if (componentRequest.getType() != ComponentType.ReturnResult) {
                this.removeIncomingInvokeId(componentRequest.getInvokeId());
            }
            this.scheduledComponentList.add(componentRequest);
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    @Override
    public void processInvokeWithoutAnswer(Long invokeId) {
        if (this.previewMode) {
            return;
        }
        this.removeIncomingInvokeId(invokeId);
    }

    private void prepareComponents(Component[] res) {
        int index = 0;
        while (this.scheduledComponentList.size() > index) {
            Component cr = this.scheduledComponentList.get(index);
            if (cr.getType() == ComponentType.Invoke) {
                InvokeImpl in = (InvokeImpl)cr;
                this.operationsSent[DialogImpl.getIndexFromInvokeId((Long)in.getInvokeId())] = in;
                in.setState(OperationState.Sent);
            }
            res[index++] = cr;
        }
    }

    @Override
    public int getMaxUserDataLength() {
        return this.provider.getMaxUserDataLength(this.remoteAddress, this.localAddress, this.networkId);
    }

    @Override
    public int getDataLength(TCBeginRequest event) throws TCAPSendException {
        TCBeginMessageImpl tcbm = (TCBeginMessageImpl)TcapFactory.createTCBeginMessage();
        if (event.getApplicationContextName() != null) {
            DialogPortion dp = TcapFactory.createDialogPortion();
            dp.setUnidirectional(false);
            DialogRequestAPDU apdu = TcapFactory.createDialogAPDURequest();
            apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
            dp.setDialogAPDU(apdu);
            apdu.setApplicationContextName(event.getApplicationContextName());
            if (event.getUserInformation() != null) {
                apdu.setUserInformation(event.getUserInformation());
            }
            tcbm.setDialogPortion(dp);
        }
        tcbm.setOriginatingTransactionId(Utils.encodeTransactionId(this.localTransactionId));
        if (this.scheduledComponentList.size() > 0) {
            Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
            for (int index = 0; index < this.scheduledComponentList.size(); ++index) {
                componentsToSend[index] = this.scheduledComponentList.get(index);
            }
            tcbm.setComponent(componentsToSend);
        }
        AsnOutputStream aos = new AsnOutputStream();
        try {
            tcbm.encode(aos);
        }
        catch (EncodeException e) {
            if (logger.isEnabledFor(Level.ERROR)) {
                logger.error("Failed to encode message while length testing: ", e);
            }
            throw new TCAPSendException("Error encoding TCBeginRequest", e);
        }
        return aos.size();
    }

    @Override
    public int getDataLength(TCContinueRequest event) throws TCAPSendException {
        TCContinueMessageImpl tcbm = (TCContinueMessageImpl)TcapFactory.createTCContinueMessage();
        if (event.getApplicationContextName() != null) {
            DialogPortion dp = TcapFactory.createDialogPortion();
            dp.setUnidirectional(false);
            DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
            apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
            dp.setDialogAPDU(apdu);
            apdu.setApplicationContextName(event.getApplicationContextName());
            if (event.getUserInformation() != null) {
                apdu.setUserInformation(event.getUserInformation());
            }
            Result res = TcapFactory.createResult();
            res.setResultType(ResultType.Accepted);
            ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
            rsd.setDialogServiceUserType(DialogServiceUserType.Null);
            apdu.setResultSourceDiagnostic(rsd);
            apdu.setResult(res);
            tcbm.setDialogPortion(dp);
        }
        tcbm.setOriginatingTransactionId(Utils.encodeTransactionId(this.localTransactionId));
        tcbm.setDestinationTransactionId(this.remoteTransactionId);
        if (this.scheduledComponentList.size() > 0) {
            Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
            for (int index = 0; index < this.scheduledComponentList.size(); ++index) {
                componentsToSend[index] = this.scheduledComponentList.get(index);
            }
            tcbm.setComponent(componentsToSend);
        }
        AsnOutputStream aos = new AsnOutputStream();
        try {
            tcbm.encode(aos);
        }
        catch (Exception e) {
            if (logger.isEnabledFor(Level.ERROR)) {
                logger.error("Failed to encode message while length testing: ", e);
            }
            throw new TCAPSendException("Error encoding TCContinueRequest", e);
        }
        return aos.size();
    }

    @Override
    public int getDataLength(TCEndRequest event) throws TCAPSendException {
        ApplicationContextName acn;
        TCEndMessageImpl tcbm = (TCEndMessageImpl)TcapFactory.createTCEndMessage();
        tcbm.setDestinationTransactionId(this.remoteTransactionId);
        if (event.getTerminationType() == TerminationType.Basic && this.scheduledComponentList.size() > 0) {
            Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
            for (int index = 0; index < this.scheduledComponentList.size(); ++index) {
                componentsToSend[index] = this.scheduledComponentList.get(index);
            }
            tcbm.setComponent(componentsToSend);
        }
        if (this.state == TRPseudoState.InitialReceived && (acn = event.getApplicationContextName()) != null) {
            DialogPortion dp = TcapFactory.createDialogPortion();
            dp.setUnidirectional(false);
            DialogResponseAPDU apdu = TcapFactory.createDialogAPDUResponse();
            apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
            dp.setDialogAPDU(apdu);
            apdu.setApplicationContextName(event.getApplicationContextName());
            if (event.getUserInformation() != null) {
                apdu.setUserInformation(event.getUserInformation());
            }
            Result res = TcapFactory.createResult();
            res.setResultType(ResultType.Accepted);
            ResultSourceDiagnostic rsd = TcapFactory.createResultSourceDiagnostic();
            rsd.setDialogServiceUserType(DialogServiceUserType.Null);
            apdu.setResultSourceDiagnostic(rsd);
            apdu.setResult(res);
            tcbm.setDialogPortion(dp);
        }
        AsnOutputStream aos = new AsnOutputStream();
        try {
            tcbm.encode(aos);
        }
        catch (Exception e) {
            if (logger.isEnabledFor(Level.ERROR)) {
                logger.error("Failed to encode message while length testing: ", e);
            }
            throw new TCAPSendException("Error encoding TCEndRequest", e);
        }
        return aos.size();
    }

    @Override
    public int getDataLength(TCUniRequest event) throws TCAPSendException {
        TCUniMessageImpl msg = (TCUniMessageImpl)TcapFactory.createTCUniMessage();
        if (event.getApplicationContextName() != null) {
            DialogPortion dp = TcapFactory.createDialogPortion();
            DialogUniAPDU apdu = TcapFactory.createDialogAPDUUni();
            apdu.setDoNotSendProtocolVersion(this.provider.getStack().getDoNotSendProtocolVersion());
            apdu.setApplicationContextName(event.getApplicationContextName());
            if (event.getUserInformation() != null) {
                apdu.setUserInformation(event.getUserInformation());
            }
            dp.setUnidirectional(true);
            dp.setDialogAPDU(apdu);
            msg.setDialogPortion(dp);
        }
        if (this.scheduledComponentList.size() > 0) {
            Component[] componentsToSend = new Component[this.scheduledComponentList.size()];
            for (int index = 0; index < this.scheduledComponentList.size(); ++index) {
                componentsToSend[index] = this.scheduledComponentList.get(index);
            }
            msg.setComponent(componentsToSend);
        }
        AsnOutputStream aos = new AsnOutputStream();
        try {
            msg.encode(aos);
        }
        catch (Exception e) {
            if (logger.isEnabledFor(Level.ERROR)) {
                logger.error("Failed to encode message while length testing: ", e);
            }
            throw new TCAPSendException("Error encoding TCUniRequest", e);
        }
        return aos.size();
    }

    void setRemoteTransactionId(byte[] remoteTransactionId) {
        this.remoteTransactionId = remoteTransactionId;
    }

    @Override
    public void setLocalAddress(SccpAddress localAddress) {
        this.localAddress = localAddress;
    }

    @Override
    public void setRemoteAddress(SccpAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void processUni(TCUniMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) {
        try {
            this.dialogLock.lock();
            try {
                this.setRemoteAddress(remoteAddress);
                this.setLocalAddress(localAddress);
                TCUniIndicationImpl tcUniIndication = (TCUniIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createUniIndication(this);
                tcUniIndication.setDestinationAddress(localAddress);
                tcUniIndication.setOriginatingAddress(remoteAddress);
                Component[] comps = msg.getComponent();
                tcUniIndication.setComponents(comps);
                this.processRcvdComp(comps);
                if (msg.getDialogPortion() != null) {
                    DialogPortion dp = msg.getDialogPortion();
                    DialogUniAPDU apdu = (DialogUniAPDU)dp.getDialogAPDU();
                    this.lastACN = apdu.getApplicationContextName();
                    this.lastUI = apdu.getUserInformation();
                    tcUniIndication.setApplicationContextName(this.lastACN);
                    tcUniIndication.setUserInformation(this.lastUI);
                }
                this.provider.deliver(this, tcUniIndication);
            }
            finally {
                this.release();
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    private void processRcvdComp(Component[] comps) {
        if (this.provider.getStack().getStatisticsEnabled()) {
            block7: for (Component comp : comps) {
                switch (comp.getType()) {
                    case Invoke: {
                        this.provider.getStack().getCounterProviderImpl().updateInvokeReceivedCount();
                        Invoke inv = (Invoke)comp;
                        OperationCodeImpl oc = (OperationCodeImpl)inv.getOperationCode();
                        if (oc == null) continue block7;
                        this.provider.getStack().getCounterProviderImpl().updateIncomingInvokesPerOperationCode(oc.getStringValue());
                        continue block7;
                    }
                    case ReturnResult: {
                        this.provider.getStack().getCounterProviderImpl().updateReturnResultReceivedCount();
                        continue block7;
                    }
                    case ReturnResultLast: {
                        this.provider.getStack().getCounterProviderImpl().updateReturnResultLastReceivedCount();
                        continue block7;
                    }
                    case ReturnError: {
                        this.provider.getStack().getCounterProviderImpl().updateReturnErrorReceivedCount();
                        ReturnError re = (ReturnError)comp;
                        ErrorCodeImpl ec = (ErrorCodeImpl)re.getErrorCode();
                        if (ec == null) continue block7;
                        this.provider.getStack().getCounterProviderImpl().updateIncomingErrorsPerErrorCode(ec.getStringValue());
                        continue block7;
                    }
                    case Reject: {
                        Reject rej = (Reject)comp;
                        if (rej.isLocalOriginated()) continue block7;
                        this.provider.getStack().getCounterProviderImpl().updateRejectReceivedCount();
                        ProblemImpl prob = (ProblemImpl)rej.getProblem();
                        if (prob == null) continue block7;
                        this.provider.getStack().getCounterProviderImpl().updateIncomingRejectPerProblem(prob.getStringValue());
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processBegin(TCBeginMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) {
        TCBeginIndicationImpl tcBeginIndication = null;
        try {
            this.dialogLock.lock();
            if (!this.previewMode) {
                if (this.state != TRPseudoState.Idle) {
                    if (logger.isEnabledFor(Level.ERROR)) {
                        logger.error("Received Begin primitive, but state is not: " + (Object)((Object)TRPseudoState.Idle) + ". Dialog: " + this);
                    }
                    this.sendAbnormalDialog();
                    return;
                }
                this.restartIdleTimer();
            }
            this.setRemoteAddress(remoteAddress);
            this.setLocalAddress(localAddress);
            this.setRemoteTransactionId(msg.getOriginatingTransactionId());
            tcBeginIndication = (TCBeginIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createBeginIndication(this);
            tcBeginIndication.setDestinationAddress(localAddress);
            tcBeginIndication.setOriginatingAddress(remoteAddress);
            DialogPortion dialogPortion = msg.getDialogPortion();
            if (dialogPortion != null) {
                DialogAPDU apdu = dialogPortion.getDialogAPDU();
                if (apdu.getType() != DialogAPDUType.Request) {
                    if (logger.isEnabledFor(Level.ERROR)) {
                        logger.error("Received non-Request APDU: " + (Object)((Object)apdu.getType()) + ". Dialog: " + this);
                    }
                    this.sendAbnormalDialog();
                    return;
                }
                DialogRequestAPDU requestAPDU = (DialogRequestAPDU)apdu;
                this.lastACN = requestAPDU.getApplicationContextName();
                this.lastUI = requestAPDU.getUserInformation();
                tcBeginIndication.setApplicationContextName(this.lastACN);
                tcBeginIndication.setUserInformation(this.lastUI);
            }
            if (this.provider.getStack().getStatisticsEnabled()) {
                if (tcBeginIndication.getApplicationContextName() != null) {
                    String acn = ((ApplicationContextNameImpl)tcBeginIndication.getApplicationContextName()).getStringValue();
                    this.provider.getStack().getCounterProviderImpl().updateIncomingDialogsPerApplicatioContextName(acn);
                } else {
                    this.provider.getStack().getCounterProviderImpl().updateIncomingDialogsPerApplicatioContextName("");
                }
            }
            tcBeginIndication.setComponents(this.processOperationsState(msg.getComponent()));
            if (!this.previewMode) {
                this.setState(TRPseudoState.InitialReceived);
            }
            this.provider.deliver(this, tcBeginIndication);
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processContinue(TCContinueMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) {
        block19: {
            TCContinueIndicationImpl tcContinueIndication = null;
            try {
                this.dialogLock.lock();
                if (this.previewMode) {
                    DialogAPDU apdu;
                    tcContinueIndication = (TCContinueIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createContinueIndication(this);
                    this.setRemoteTransactionId(msg.getOriginatingTransactionId());
                    DialogPortion dialogPortion = msg.getDialogPortion();
                    if (dialogPortion != null && (apdu = dialogPortion.getDialogAPDU()).getType() == DialogAPDUType.Response) {
                        DialogResponseAPDU responseAPDU = (DialogResponseAPDU)apdu;
                        if (!responseAPDU.getApplicationContextName().equals(this.lastACN)) {
                            this.lastACN = responseAPDU.getApplicationContextName();
                        }
                        if (responseAPDU.getUserInformation() != null) {
                            this.lastUI = responseAPDU.getUserInformation();
                        }
                        tcContinueIndication.setApplicationContextName(responseAPDU.getApplicationContextName());
                        tcContinueIndication.setUserInformation(responseAPDU.getUserInformation());
                    }
                    tcContinueIndication.setOriginatingAddress(remoteAddress);
                    tcContinueIndication.setComponents(this.processOperationsState(msg.getComponent()));
                    this.provider.deliver(this, tcContinueIndication);
                    break block19;
                }
                if (this.state == TRPseudoState.InitialSent) {
                    this.restartIdleTimer();
                    tcContinueIndication = (TCContinueIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createContinueIndication(this);
                    this.setRemoteAddress(remoteAddress);
                    this.setRemoteTransactionId(msg.getOriginatingTransactionId());
                    tcContinueIndication.setOriginatingAddress(remoteAddress);
                    DialogPortion dialogPortion = msg.getDialogPortion();
                    if (dialogPortion != null) {
                        DialogAPDU apdu = dialogPortion.getDialogAPDU();
                        if (apdu.getType() != DialogAPDUType.Response) {
                            if (logger.isEnabledFor(Level.ERROR)) {
                                logger.error("Received non-Response APDU: " + (Object)((Object)apdu.getType()) + ". Dialog: " + this);
                            }
                            this.sendAbnormalDialog();
                            return;
                        }
                        DialogResponseAPDU responseAPDU = (DialogResponseAPDU)apdu;
                        if (!responseAPDU.getApplicationContextName().equals(this.lastACN)) {
                            this.lastACN = responseAPDU.getApplicationContextName();
                        }
                        if (responseAPDU.getUserInformation() != null) {
                            this.lastUI = responseAPDU.getUserInformation();
                        }
                        tcContinueIndication.setApplicationContextName(responseAPDU.getApplicationContextName());
                        tcContinueIndication.setUserInformation(responseAPDU.getUserInformation());
                    } else if (this.dpSentInBegin) {
                        this.sendAbnormalDialog();
                        return;
                    }
                    tcContinueIndication.setOriginatingAddress(remoteAddress);
                    tcContinueIndication.setComponents(this.processOperationsState(msg.getComponent()));
                    this.setState(TRPseudoState.Active);
                    this.provider.deliver(this, tcContinueIndication);
                    break block19;
                }
                if (this.state == TRPseudoState.Active) {
                    this.restartIdleTimer();
                    tcContinueIndication = (TCContinueIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createContinueIndication(this);
                    tcContinueIndication.setOriginatingAddress(remoteAddress);
                    tcContinueIndication.setComponents(this.processOperationsState(msg.getComponent()));
                    this.provider.deliver(this, tcContinueIndication);
                    break block19;
                }
                if (logger.isEnabledFor(Level.ERROR)) {
                    logger.error("Received Continue primitive, but state is not proper: " + (Object)((Object)this.state) + ", Dialog: " + this);
                }
                this.sendAbnormalDialog();
                return;
            }
            finally {
                this.dialogLock.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processEnd(TCEndMessage msg, SccpAddress localAddress, SccpAddress remoteAddress) {
        TCEndIndicationImpl tcEndIndication = null;
        try {
            this.dialogLock.lock();
            try {
                if (this.previewMode) {
                    DialogAPDU apdu;
                    tcEndIndication = (TCEndIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createEndIndication(this);
                    DialogPortion dialogPortion = msg.getDialogPortion();
                    if (dialogPortion != null && (apdu = dialogPortion.getDialogAPDU()).getType() == DialogAPDUType.Response) {
                        DialogResponseAPDU responseAPDU = (DialogResponseAPDU)apdu;
                        if (!responseAPDU.getApplicationContextName().equals(this.lastACN)) {
                            this.lastACN = responseAPDU.getApplicationContextName();
                        }
                        if (responseAPDU.getUserInformation() != null) {
                            this.lastUI = responseAPDU.getUserInformation();
                        }
                        tcEndIndication.setApplicationContextName(responseAPDU.getApplicationContextName());
                        tcEndIndication.setUserInformation(responseAPDU.getUserInformation());
                    }
                    tcEndIndication.setComponents(this.processOperationsState(msg.getComponent()));
                    this.provider.deliver(this, tcEndIndication);
                } else {
                    DialogPortion dialogPortion;
                    this.restartIdleTimer();
                    tcEndIndication = (TCEndIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createEndIndication(this);
                    if (this.state == TRPseudoState.InitialSent) {
                        this.setRemoteAddress(remoteAddress);
                        tcEndIndication.setOriginatingAddress(remoteAddress);
                    }
                    if ((dialogPortion = msg.getDialogPortion()) != null) {
                        DialogAPDU apdu = dialogPortion.getDialogAPDU();
                        if (apdu.getType() != DialogAPDUType.Response) {
                            if (logger.isEnabledFor(Level.ERROR)) {
                                logger.error("Received non-Response APDU: " + (Object)((Object)apdu.getType()) + ". Dialog: " + this);
                            }
                            return;
                        }
                        DialogResponseAPDU responseAPDU = (DialogResponseAPDU)apdu;
                        if (!responseAPDU.getApplicationContextName().equals(this.lastACN)) {
                            this.lastACN = responseAPDU.getApplicationContextName();
                        }
                        if (responseAPDU.getUserInformation() != null) {
                            this.lastUI = responseAPDU.getUserInformation();
                        }
                        tcEndIndication.setApplicationContextName(responseAPDU.getApplicationContextName());
                        tcEndIndication.setUserInformation(responseAPDU.getUserInformation());
                    }
                    tcEndIndication.setComponents(this.processOperationsState(msg.getComponent()));
                    this.provider.deliver(this, tcEndIndication);
                }
            }
            finally {
                this.release();
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processAbort(TCAbortMessage msg, SccpAddress localAddress2, SccpAddress remoteAddress2) {
        try {
            this.dialogLock.lock();
            try {
                PAbortCauseType type;
                Boolean IsAareApdu = false;
                Boolean IsAbrtApdu = false;
                ApplicationContextName acn = null;
                Result result = null;
                ResultSourceDiagnostic resultSourceDiagnostic = null;
                AbortSource abrtSrc = null;
                UserInformation userInfo = null;
                DialogPortion dp = msg.getDialogPortion();
                if (dp != null) {
                    DialogAPDU apdu = dp.getDialogAPDU();
                    if (apdu != null && apdu.getType() == DialogAPDUType.Abort) {
                        IsAbrtApdu = true;
                        DialogAbortAPDU abortApdu = (DialogAbortAPDU)apdu;
                        abrtSrc = abortApdu.getAbortSource();
                        userInfo = abortApdu.getUserInformation();
                    }
                    if (apdu != null && apdu.getType() == DialogAPDUType.Response) {
                        IsAareApdu = true;
                        DialogResponseAPDU resptApdu = (DialogResponseAPDU)apdu;
                        acn = resptApdu.getApplicationContextName();
                        result = resptApdu.getResult();
                        resultSourceDiagnostic = resptApdu.getResultSourceDiagnostic();
                        userInfo = resptApdu.getUserInformation();
                    }
                }
                if ((type = msg.getPAbortCause()) == null) {
                    if (abrtSrc != null && abrtSrc.getAbortSourceType() == AbortSourceType.Provider) {
                        type = PAbortCauseType.AbnormalDialogue;
                    }
                    if (resultSourceDiagnostic != null && resultSourceDiagnostic.getDialogServiceProviderType() != null) {
                        type = resultSourceDiagnostic.getDialogServiceProviderType() == DialogServiceProviderType.NoCommonDialogPortion ? PAbortCauseType.NoCommonDialoguePortion : PAbortCauseType.NoReasonGiven;
                    }
                }
                if (type != null) {
                    TCPAbortIndicationImpl tcAbortIndication = (TCPAbortIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createPAbortIndication(this);
                    tcAbortIndication.setPAbortCause(type);
                    this.provider.deliver(this, tcAbortIndication);
                } else {
                    TCUserAbortIndicationImpl tcUAbortIndication = (TCUserAbortIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createUAbortIndication(this);
                    if (IsAareApdu.booleanValue()) {
                        tcUAbortIndication.SetAareApdu();
                    }
                    if (IsAbrtApdu.booleanValue()) {
                        tcUAbortIndication.SetAbrtApdu();
                    }
                    tcUAbortIndication.setUserInformation(userInfo);
                    tcUAbortIndication.setAbortSource(abrtSrc);
                    tcUAbortIndication.setApplicationContextName(acn);
                    tcUAbortIndication.setResultSourceDiagnostic(resultSourceDiagnostic);
                    if (this.state == TRPseudoState.InitialSent) {
                        this.setRemoteAddress(this.remoteAddress);
                        tcUAbortIndication.setOriginatingAddress(this.remoteAddress);
                    }
                    this.provider.deliver(this, tcUAbortIndication);
                }
            }
            finally {
                this.release();
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendAbnormalDialog() {
        if (this.previewMode) {
            return;
        }
        TCPAbortIndicationImpl tcAbortIndication = null;
        try {
            this.dialogLock.lock();
            try {
                block10: {
                    DialogPortion dp = TcapFactory.createDialogPortion();
                    dp.setUnidirectional(false);
                    DialogAbortAPDU dapdu = TcapFactory.createDialogAPDUAbort();
                    AbortSource as = TcapFactory.createAbortSource();
                    as.setAbortSourceType(AbortSourceType.Provider);
                    dapdu.setAbortSource(as);
                    dp.setDialogAPDU(dapdu);
                    TCAbortMessageImpl msg = (TCAbortMessageImpl)TcapFactory.createTCAbortMessage();
                    msg.setDestinationTransactionId(this.remoteTransactionId);
                    msg.setDialogPortion(dp);
                    AsnOutputStream aos = new AsnOutputStream();
                    try {
                        msg.encode(aos);
                        if (this.provider.getStack().getStatisticsEnabled()) {
                            this.provider.getStack().getCounterProviderImpl().updateTcPAbortSentCount();
                        }
                        this.provider.send(aos.toByteArray(), false, this.remoteAddress, this.localAddress, this.seqControl, this.networkId);
                    }
                    catch (Exception e) {
                        if (!logger.isEnabledFor(Level.ERROR)) break block10;
                        logger.error("Failed to send message: ", e);
                    }
                }
                tcAbortIndication = (TCPAbortIndicationImpl)((DialogPrimitiveFactoryImpl)this.provider.getDialogPrimitiveFactory()).createPAbortIndication(this);
                tcAbortIndication.setPAbortCause(PAbortCauseType.AbnormalDialogue);
                this.provider.deliver(this, tcAbortIndication);
            }
            finally {
                this.release();
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    protected Component[] processOperationsState(Component[] components) {
        if (components == null) {
            return null;
        }
        ArrayList<Component> resultingIndications = new ArrayList<Component>();
        block9: for (Component ci : components) {
            Long invokeId = ci.getType() == ComponentType.Invoke ? ((InvokeImpl)ci).getLinkedId() : ci.getInvokeId();
            InvokeImpl invoke = null;
            int index = 0;
            if (invokeId != null) {
                index = DialogImpl.getIndexFromInvokeId(invokeId);
                invoke = this.operationsSent[index];
            }
            switch (ci.getType()) {
                case Invoke: {
                    ProblemImpl p;
                    if (invokeId != null && invoke == null) {
                        logger.error(String.format("Rx : %s but no sent Invoke for linkedId exists", ci));
                        p = new ProblemImpl();
                        p.setInvokeProblemType(InvokeProblemType.UnrechognizedLinkedID);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    if (invoke != null) {
                        ((InvokeImpl)ci).setLinkedInvoke(invoke);
                    }
                    if (this.previewMode) {
                        resultingIndications.add(ci);
                        index = DialogImpl.getIndexFromInvokeId(ci.getInvokeId());
                        this.operationsSentA[index] = (InvokeImpl)ci;
                        ((InvokeImpl)ci).setDialog(this);
                        ((InvokeImpl)ci).setState(OperationState.Sent);
                        continue block9;
                    }
                    if (!this.addIncomingInvokeId(ci.getInvokeId())) {
                        logger.error(String.format("Rx : %s but there is already Invoke with this invokeId", ci));
                        p = new ProblemImpl();
                        p.setInvokeProblemType(InvokeProblemType.DuplicateInvokeID);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    resultingIndications.add(ci);
                    continue block9;
                }
                case ReturnResult: {
                    ProblemImpl p;
                    if (invoke == null) {
                        logger.error(String.format("Rx : %s but there is no corresponding Invoke", ci));
                        p = new ProblemImpl();
                        p.setReturnResultProblemType(ReturnResultProblemType.UnrecognizedInvokeID);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    if (invoke.getInvokeClass() != InvokeClass.Class1 && invoke.getInvokeClass() != InvokeClass.Class3) {
                        logger.error(String.format("Rx : %s but Invoke class is not 1 or 3", ci));
                        p = new ProblemImpl();
                        p.setReturnResultProblemType(ReturnResultProblemType.ReturnResultUnexpected);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    resultingIndications.add(ci);
                    Return rri = (ReturnResultImpl)ci;
                    if (((ReturnResultImpl)rri).getOperationCode() != null) continue block9;
                    ((ReturnResultImpl)rri).setOperationCode(invoke.getOperationCode());
                    continue block9;
                }
                case ReturnResultLast: {
                    Return rri;
                    ProblemImpl p;
                    if (invoke == null) {
                        logger.error(String.format("Rx : %s but there is no corresponding Invoke", ci));
                        p = new ProblemImpl();
                        p.setType(ProblemType.ReturnResult);
                        p.setReturnResultProblemType(ReturnResultProblemType.UnrecognizedInvokeID);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    if (invoke.getInvokeClass() != InvokeClass.Class1 && invoke.getInvokeClass() != InvokeClass.Class3) {
                        logger.error(String.format("Rx : %s but Invoke class is not 1 or 3", ci));
                        p = new ProblemImpl();
                        p.setReturnResultProblemType(ReturnResultProblemType.ReturnResultUnexpected);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    invoke.onReturnResultLast();
                    if (invoke.isSuccessReported()) {
                        resultingIndications.add(ci);
                    }
                    if (((ReturnResultLastImpl)(rri = (ReturnResultLastImpl)ci)).getOperationCode() != null) continue block9;
                    ((ReturnResultLastImpl)rri).setOperationCode(invoke.getOperationCode());
                    continue block9;
                }
                case ReturnError: {
                    ProblemImpl p;
                    if (invoke == null) {
                        logger.error(String.format("Rx : %s but there is no corresponding Invoke", ci));
                        p = new ProblemImpl();
                        p.setReturnErrorProblemType(ReturnErrorProblemType.UnrecognizedInvokeID);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    if (invoke.getInvokeClass() != InvokeClass.Class1 && invoke.getInvokeClass() != InvokeClass.Class2) {
                        logger.error(String.format("Rx : %s but Invoke class is not 1 or 2", ci));
                        p = new ProblemImpl();
                        p.setReturnErrorProblemType(ReturnErrorProblemType.ReturnErrorUnexpected);
                        this.addReject(resultingIndications, ci.getInvokeId(), p);
                        continue block9;
                    }
                    invoke.onError();
                    if (!invoke.isErrorReported()) continue block9;
                    resultingIndications.add(ci);
                    continue block9;
                }
                case Reject: {
                    Reject rej = (Reject)ci;
                    if (invoke != null) {
                        Problem problem = rej.getProblem();
                        if (!rej.isLocalOriginated() && problem.getInvokeProblemType() != null) {
                            invoke.onReject();
                        }
                    }
                    if (rej.isLocalOriginated() && this.isStructured()) {
                        try {
                            this.sendComponent(rej);
                        }
                        catch (TCAPSendException e) {
                            logger.error("TCAPSendException when sending Reject component : Dialog: " + this, e);
                        }
                    }
                    resultingIndications.add(ci);
                    continue block9;
                }
                default: {
                    resultingIndications.add(ci);
                }
            }
        }
        components = new Component[resultingIndications.size()];
        components = resultingIndications.toArray(components);
        this.processRcvdComp(components);
        return components;
    }

    private void addReject(List<Component> resultingIndications, Long invokeId, Problem p) {
        try {
            Reject rej = TcapFactory.createComponentReject();
            rej.setLocalOriginated(true);
            rej.setInvokeId(invokeId);
            rej.setProblem(p);
            resultingIndications.add(rej);
            if (this.isStructured()) {
                this.sendComponent(rej);
            }
        }
        catch (TCAPSendException e) {
            logger.error(String.format("Error sending Reject component", e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setState(TRPseudoState newState) {
        try {
            this.dialogLock.lock();
            if (this.state == TRPseudoState.Expunged) {
                return;
            }
            this.state = newState;
            if (newState == TRPseudoState.Expunged) {
                this.stopIdleTimer();
                this.provider.release(this);
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startIdleTimer() {
        if (!this.structured) {
            return;
        }
        if (this.previewMode) {
            return;
        }
        try {
            this.dialogLock.lock();
            if (this.idleTimerFuture != null) {
                throw new IllegalStateException();
            }
            IdleTimerTask t = new IdleTimerTask();
            t.d = this;
            this.idleTimerFuture = this.executor.schedule(t, this.idleTaskTimeout, TimeUnit.MILLISECONDS);
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopIdleTimer() {
        if (!this.structured) {
            return;
        }
        try {
            this.dialogLock.lock();
            if (this.idleTimerFuture != null) {
                this.idleTimerFuture.cancel(false);
                this.idleTimerFuture = null;
            }
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    private void restartIdleTimer() {
        this.stopIdleTimer();
        this.startIdleTimer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationEnded(InvokeImpl tcInvokeRequestImpl) {
        try {
            this.dialogLock.lock();
            int index = DialogImpl.getIndexFromInvokeId(tcInvokeRequestImpl.getInvokeId());
            this.freeInvokeId(tcInvokeRequestImpl.getInvokeId());
            this.operationsSent[index] = null;
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void operationTimedOut(InvokeImpl invoke) {
        try {
            this.dialogLock.lock();
            int index = DialogImpl.getIndexFromInvokeId(invoke.getInvokeId());
            this.freeInvokeId(invoke.getInvokeId());
            this.operationsSent[index] = null;
        }
        finally {
            this.dialogLock.unlock();
        }
        this.provider.operationTimedOut(invoke);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resetTimer(Long invokeId) throws TCAPException {
        try {
            this.dialogLock.lock();
            int index = DialogImpl.getIndexFromInvokeId(invokeId);
            InvokeImpl invoke = this.operationsSent[index];
            if (invoke == null) {
                throw new TCAPException("No operation with this ID");
            }
            invoke.startTimer();
        }
        finally {
            this.dialogLock.unlock();
        }
    }

    @Override
    public TRPseudoState getState() {
        return this.state;
    }

    @Override
    public Object getUserObject() {
        return this.userObject;
    }

    @Override
    public void setUserObject(Object userObject) {
        this.userObject = userObject;
    }

    @Override
    public boolean getPreviewMode() {
        return this.previewMode;
    }

    public PrevewDialogData getPrevewDialogData() {
        return this.prevewDialogData;
    }

    public String toString() {
        return super.toString() + ": Local[" + this.getLocalDialogId() + "] Remote[" + this.getRemoteDialogId() + "], LocalAddress[" + this.localAddress + "] RemoteAddress[" + this.remoteAddress + "]";
    }

    private class IdleTimerTask
    implements Runnable {
        DialogImpl d;

        private IdleTimerTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                DialogImpl.this.dialogLock.lock();
                this.d.idleTimerFuture = null;
                this.d.idleTimerActionTaken = false;
                this.d.idleTimerInvoked = true;
                DialogImpl.this.provider.timeout(this.d);
                if (this.d.idleTimerActionTaken) {
                    DialogImpl.this.startIdleTimer();
                } else {
                    this.d.release();
                }
            }
            finally {
                this.d.idleTimerInvoked = false;
                DialogImpl.this.dialogLock.unlock();
            }
        }
    }
}

