/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.sccp.impl.router;

import javolution.xml.XMLFormat;
import javolution.xml.XMLSerializable;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.sccp.impl.router.LongMessageRuleType;

public class LongMessageRule
implements XMLSerializable {
    private static final String FIRST_SPC = "firstSpc";
    private static final String LAST_SPC = "lastSpc";
    private static final String RULE_TYPE = "ruleType";
    private int firstSpc;
    private int lastSpc;
    private LongMessageRuleType ruleType;
    protected static final XMLFormat<LongMessageRule> XML = new XMLFormat<LongMessageRule>(LongMessageRule.class){

        @Override
        public void write(LongMessageRule ai, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(LongMessageRule.FIRST_SPC, ai.firstSpc);
            xml.setAttribute(LongMessageRule.LAST_SPC, ai.lastSpc);
            xml.setAttribute(LongMessageRule.RULE_TYPE, ai.ruleType.toString());
        }

        @Override
        public void read(XMLFormat.InputElement xml, LongMessageRule ai) throws XMLStreamException {
            ai.firstSpc = xml.getAttribute(LongMessageRule.FIRST_SPC).toInt();
            ai.lastSpc = xml.getAttribute(LongMessageRule.LAST_SPC).toInt();
            String ruleT = xml.getAttribute(LongMessageRule.RULE_TYPE).toString();
            ai.ruleType = LongMessageRuleType.valueOf(ruleT);
        }
    };

    public LongMessageRule() {
    }

    public LongMessageRule(int firstSpc, int lastSpc, LongMessageRuleType ruleType) {
        this.firstSpc = firstSpc;
        this.lastSpc = lastSpc;
        this.ruleType = ruleType;
    }

    public LongMessageRuleType getLongMessageRuleType() {
        return this.ruleType;
    }

    public int getFirstSpc() {
        return this.firstSpc;
    }

    public int getLastSpc() {
        return this.lastSpc;
    }

    public boolean matches(int dpc) {
        return dpc >= this.firstSpc && dpc <= this.lastSpc;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("firstSpc=").append(this.firstSpc).append(", lastSpc=").append(this.lastSpc).append(", ruleType=").append((Object)this.ruleType);
        return sb.toString();
    }
}

