/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.mtp;

import java.util.Arrays;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.mtp.Mtp3;
import org.mobicents.protocols.ss7.mtp.util.MTPUtility;

public class RoutingLabel {
    private static final Logger logger = Logger.getLogger(RoutingLabel.class);
    private byte[] mtp3Header;

    public RoutingLabel(int opc, int dpc, int sls, int si, int ssi) {
        this.mtp3Header = new byte[5];
        MTPUtility.writeRoutingLabel(this.mtp3Header, si, ssi, sls, dpc, opc);
    }

    public RoutingLabel(byte[] buffer) {
        if (buffer == null || buffer.length < 5) {
            throw new IllegalArgumentException();
        }
        this.mtp3Header = buffer;
    }

    public RoutingLabel() {
        this.mtp3Header = new byte[5];
    }

    public void setBackRouteHeader(byte[] data) {
        int thisPointCode = Mtp3.dpc(data, 1);
        int remotePointCode = Mtp3.opc(data, 1);
        int sls = Mtp3.sls(data, 1);
        int si = Mtp3.si(data);
        int ssi = Mtp3.ssi(data);
        MTPUtility.writeRoutingLabel(this.mtp3Header, si, ssi, sls, remotePointCode, thisPointCode);
        if (logger.isInfoEnabled()) {
            logger.info("DPC[" + remotePointCode + "] OPC[" + thisPointCode + "] SLS[" + sls + "] SI[" + si + "] SSI[" + ssi + "] Label" + Arrays.toString(this.mtp3Header));
        }
    }

    public byte[] getBackRouteHeader() {
        return this.mtp3Header;
    }
}

