/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.authentication;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPMessageType;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.primitives.IMSI;
import org.mobicents.protocols.ss7.map.api.primitives.ISDNAddressString;
import org.mobicents.protocols.ss7.map.api.primitives.MAPExtensionContainer;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AccessType;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.AuthenticationFailureReportRequest;
import org.mobicents.protocols.ss7.map.api.service.mobility.authentication.FailureCause;
import org.mobicents.protocols.ss7.map.primitives.IMSIImpl;
import org.mobicents.protocols.ss7.map.primitives.ISDNAddressStringImpl;
import org.mobicents.protocols.ss7.map.primitives.MAPExtensionContainerImpl;
import org.mobicents.protocols.ss7.map.service.mobility.MobilityMessageImpl;

public class AuthenticationFailureReportRequestImpl
extends MobilityMessageImpl
implements AuthenticationFailureReportRequest {
    protected static final int _TAG_vlrNumber = 0;
    protected static final int _TAG_sgsnNumber = 1;
    public static final String _PrimitiveName = "AuthenticationFailureReportRequest";
    private IMSI imsi;
    private FailureCause failureCause;
    private MAPExtensionContainer extensionContainer;
    private Boolean reAttempt;
    private AccessType accessType;
    private byte[] rand;
    private ISDNAddressString vlrNumber;
    private ISDNAddressString sgsnNumber;

    public AuthenticationFailureReportRequestImpl() {
    }

    public AuthenticationFailureReportRequestImpl(IMSI imsi, FailureCause failureCause, MAPExtensionContainer extensionContainer, Boolean reAttempt, AccessType accessType, byte[] rand, ISDNAddressString vlrNumber, ISDNAddressString sgsnNumber) {
        this.imsi = imsi;
        this.failureCause = failureCause;
        this.extensionContainer = extensionContainer;
        this.reAttempt = reAttempt;
        this.accessType = accessType;
        this.rand = rand;
        this.vlrNumber = vlrNumber;
        this.sgsnNumber = sgsnNumber;
    }

    public MAPMessageType getMessageType() {
        return MAPMessageType.authenticationFailureReport_Request;
    }

    public int getOperationCode() {
        return 15;
    }

    public IMSI getImsi() {
        return this.imsi;
    }

    public FailureCause getFailureCause() {
        return this.failureCause;
    }

    public MAPExtensionContainer getExtensionContainer() {
        return this.extensionContainer;
    }

    public Boolean getReAttempt() {
        return this.reAttempt;
    }

    public AccessType getAccessType() {
        return this.accessType;
    }

    public byte[] getRand() {
        return this.rand;
    }

    public ISDNAddressString getVlrNumber() {
        return this.vlrNumber;
    }

    public ISDNAddressString getSgsnNumber() {
        return this.sgsnNumber;
    }

    public int getTag() throws MAPException {
        return 16;
    }

    public int getTagClass() {
        return 0;
    }

    public boolean getIsPrimitive() {
        return false;
    }

    public void decodeAll(AsnInputStream ansIS) throws MAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationFailureReportRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationFailureReportRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws MAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new MAPParsingComponentException("IOException when decoding AuthenticationFailureReportRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new MAPParsingComponentException("AsnException when decoding AuthenticationFailureReportRequest: " + e.getMessage(), e, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.imsi = null;
        this.failureCause = null;
        this.extensionContainer = null;
        this.reAttempt = null;
        this.accessType = null;
        this.rand = null;
        this.vlrNumber = null;
        this.sgsnNumber = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.imsi: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.imsi = new IMSIImpl();
                    ((IMSIImpl)this.imsi).decodeAll(ais);
                    break;
                }
                case 1: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 10) {
                        throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.failureCause: Parameter 1 bad tag class or tag or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    int vali = (int)ais.readInteger();
                    this.failureCause = FailureCause.getInstance(vali);
                    break;
                }
                default: {
                    int vali;
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 0: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.vlrNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.vlrNumber = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.vlrNumber).decodeAll(ais);
                                break block0;
                            }
                            case 1: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.sgsnNumber: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.sgsnNumber = new ISDNAddressStringImpl();
                                ((ISDNAddressStringImpl)this.sgsnNumber).decodeAll(ais);
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    if (ais.getTagClass() == 0) {
                        switch (tag) {
                            case 16: {
                                if (ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.extensionContainer: Parameter is primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.extensionContainer = new MAPExtensionContainerImpl();
                                ((MAPExtensionContainerImpl)this.extensionContainer).decodeAll(ais);
                                break;
                            }
                            case 1: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.reAttempt: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.reAttempt = ais.readBoolean();
                                break;
                            }
                            case 10: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.accessType: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                vali = (int)ais.readInteger();
                                this.accessType = AccessType.getInstance(vali);
                                break;
                            }
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.rand: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.rand = ais.readOctetString();
                                if (this.rand != null && this.rand.length == 16) break block0;
                                throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest.rand: Expected size is 16, received size: " + (this.rand == null ? 0 : this.rand.length), MAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            default: {
                                ais.advanceElement();
                                break;
                            }
                        }
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 2) {
            throw new MAPParsingComponentException("Error while decoding AuthenticationFailureReportRequest: Needs at least 2 mandatory parameters, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws MAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws MAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AuthenticationFailureReportRequest: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.imsi == null || this.failureCause == null) {
                throw new MAPException("IMSI and failureCause parameters must not be null");
            }
            ((IMSIImpl)this.imsi).encodeAll(asnOs);
            asnOs.writeInteger(0, 10, this.failureCause.getCode());
            if (this.extensionContainer != null) {
                ((MAPExtensionContainerImpl)this.extensionContainer).encodeAll(asnOs);
            }
            if (this.reAttempt != null) {
                asnOs.writeBoolean(this.reAttempt);
            }
            if (this.accessType != null) {
                asnOs.writeInteger(0, 10, this.accessType.getCode());
            }
            if (this.rand != null) {
                if (this.rand.length != 16) {
                    throw new MAPException("rand parameter must have length 16, found: " + this.rand.length);
                }
                asnOs.writeOctetString(0, 4, this.rand);
            }
            if (this.vlrNumber != null) {
                ((ISDNAddressStringImpl)this.vlrNumber).encodeAll(asnOs, 2, 0);
            }
            if (this.sgsnNumber != null) {
                ((ISDNAddressStringImpl)this.sgsnNumber).encodeAll(asnOs, 2, 1);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding AuthenticationFailureReportRequest: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding AuthenticationFailureReportRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        if (this.imsi != null) {
            sb.append("imsi=");
            sb.append(this.imsi.toString());
            sb.append(", ");
        }
        if (this.failureCause != null) {
            sb.append("failureCause=");
            sb.append(this.failureCause.toString());
            sb.append(", ");
        }
        if (this.extensionContainer != null) {
            sb.append("extensionContainer=");
            sb.append(this.extensionContainer.toString());
            sb.append(", ");
        }
        if (this.reAttempt != null) {
            sb.append("reAttempt=");
            sb.append(this.reAttempt.toString());
            sb.append(", ");
        }
        if (this.accessType != null) {
            sb.append("accessType=");
            sb.append(this.accessType.toString());
            sb.append(", ");
        }
        if (this.rand != null) {
            sb.append("rand=[");
            this.ArrayToString(this.rand);
            sb.append("], ");
        }
        if (this.vlrNumber != null) {
            sb.append("vlrNumber=");
            sb.append(this.vlrNumber.toString());
            sb.append(", ");
        }
        if (this.sgsnNumber != null) {
            sb.append("sgsnNumber=");
            sb.append(this.sgsnNumber.toString());
            sb.append(", ");
        }
        sb.append("]");
        return sb.toString();
    }

    private String ArrayToString(byte[] array) {
        StringBuilder sb = new StringBuilder();
        boolean i1 = false;
        for (byte b : array) {
            if (!i1) {
                i1 = true;
            } else {
                sb.append(", ");
            }
            sb.append(b);
        }
        return sb.toString();
    }
}

