/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.util;

import java.io.UnsupportedEncodingException;

public class BcdHelper {
    public static String getBinString(byte[] bytes) {
        String result = "";
        for (byte b : bytes) {
            result = result + Integer.toBinaryString((b & 0xFF) + 256).substring(1);
            result = result + " ";
        }
        return result;
    }

    public static char convertTelcoCharToHexDigit(char ch) {
        switch (ch) {
            case '*': {
                return 'b';
            }
            case '#': {
                return 'c';
            }
        }
        return ch;
    }

    public static String convertTelcoCharsToHexDigits(String telcoDigits) {
        char[] chars;
        StringBuilder sb = new StringBuilder();
        for (char c : chars = telcoDigits.toCharArray()) {
            sb.append(BcdHelper.convertTelcoCharToHexDigit(c));
        }
        return sb.toString();
    }

    public static String convertHexByteToTelcoChar(byte byteValue) {
        switch (byteValue) {
            case 11: {
                return "*";
            }
            case 12: {
                return "#";
            }
        }
        return String.format("%1x", byteValue);
    }

    public static byte[] encodeHexStringToBCD(String hexString) {
        int noOfDigits = (hexString = hexString.toLowerCase()).length();
        boolean isOdd = noOfDigits % 2 != 0;
        int noOfBytes = noOfDigits / 2;
        if (isOdd) {
            ++noOfBytes;
        }
        byte[] bcdDigits = new byte[noOfBytes];
        char[] chars = hexString.toCharArray();
        int digit = -1;
        for (int i = 0; i < noOfDigits; ++i) {
            digit = Character.digit(BcdHelper.convertTelcoCharToHexDigit(chars[i]), 16);
            byte tmpByte = (byte)digit;
            if (i % 2 == 0) {
                bcdDigits[i / 2] = tmpByte;
                continue;
            }
            int n = i / 2;
            bcdDigits[n] = (byte)(bcdDigits[n] | (byte)(tmpByte << 4));
        }
        return bcdDigits;
    }

    public static String bcdToHexString(int encodingScheme, byte bcdByte) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        byte leftNibble = (byte)(bcdByte & 0xF0);
        leftNibble = (byte)(leftNibble >>> 4);
        leftNibble = (byte)(leftNibble & 0xF);
        byte rightNibble = (byte)(bcdByte & 0xF);
        switch (encodingScheme) {
            case 0: 
            case 1: {
                sb.append(BcdHelper.convertHexByteToTelcoChar(rightNibble));
                sb.append(BcdHelper.convertHexByteToTelcoChar(leftNibble));
                break;
            }
            default: {
                throw new UnsupportedEncodingException("Specified GenericDigits encoding: " + encodingScheme + " is unsupported");
            }
        }
        return sb.toString();
    }

    public static String bcdDecodeToHexString(int encodingScheme, byte[] bcdBytes) throws UnsupportedEncodingException {
        StringBuilder sb = new StringBuilder();
        for (byte b : bcdBytes) {
            sb.append(BcdHelper.bcdToHexString(encodingScheme, b));
        }
        if (1 == encodingScheme) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }
}

