/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.isup.impl.message.parameter;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.mobicents.protocols.ss7.isup.ParameterException;
import org.mobicents.protocols.ss7.isup.impl.message.parameter.AbstractISUPParameter;
import org.mobicents.protocols.ss7.isup.message.parameter.TransitNetworkSelection;

public class TransitNetworkSelectionImpl
extends AbstractISUPParameter
implements TransitNetworkSelection {
    protected static final Logger logger = Logger.getLogger(TransitNetworkSelectionImpl.class);
    private String address;
    private int typeOfNetworkIdentification;
    private int networkIdentificationPlan;
    protected int oddFlag;
    public static final int _FLAG_ODD = 1;

    public TransitNetworkSelectionImpl(String address, int typeOfNetworkIdentification, int networkIdentificationPlan) {
        this.setAddress(address);
        this.typeOfNetworkIdentification = typeOfNetworkIdentification;
        this.networkIdentificationPlan = networkIdentificationPlan;
    }

    public TransitNetworkSelectionImpl(byte[] b) throws ParameterException {
        this.decode(b);
    }

    public TransitNetworkSelectionImpl() {
    }

    public byte[] encode() throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header");
        }
        int count = this.encodeHeader(bos);
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header, write count: " + count);
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding body");
        }
        count += this.encodeDigits(bos);
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding digits, write count: " + count);
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            out.write(bos.toByteArray());
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
        return out.toByteArray();
    }

    public int encode(ByteArrayOutputStream out) throws ParameterException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header");
        }
        int count = this.encodeHeader(bos);
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding header, write count: " + count);
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding body");
        }
        count += this.encodeDigits(bos);
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Encoding digits, write count: " + count);
        }
        try {
            out.write(bos.toByteArray());
        }
        catch (IOException e) {
            throw new ParameterException(e);
        }
        return count;
    }

    public int decode(byte[] b) throws ParameterException {
        ByteArrayInputStream bis = new ByteArrayInputStream(b);
        return this.decode(bis);
    }

    protected int decode(ByteArrayInputStream bis) throws ParameterException {
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Decoding header");
        }
        int count = this.decodeHeader(bis);
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Decoding header, read count: " + count);
            logger.debug("[" + this.getClass().getSimpleName() + "]Decoding body");
        }
        count += this.decodeDigits(bis);
        if (logger.isDebugEnabled()) {
            logger.debug("[" + this.getClass().getSimpleName() + "]Decoding digits, read count: " + count);
        }
        return count;
    }

    public int encodeDigits(ByteArrayOutputStream bos) {
        boolean isOdd = this.oddFlag == 1;
        byte b = 0;
        int count = !isOdd ? this.address.length() : this.address.length() - 1;
        int bytesCount = 0;
        for (int i = 0; i < count - 1; i += 2) {
            String ds1 = this.address.substring(i, i + 1);
            String ds2 = this.address.substring(i + 1, i + 2);
            int d1 = Integer.parseInt(ds1, 16);
            int d2 = Integer.parseInt(ds2, 16);
            b = (byte)(d2 << 4 | d1);
            bos.write(b);
            ++bytesCount;
        }
        if (isOdd) {
            String ds1 = this.address.substring(count, count + 1);
            int d = Integer.parseInt(ds1);
            b = (byte)(d & 0xF);
            bos.write(b);
            ++bytesCount;
        }
        return bytesCount;
    }

    public int decodeDigits(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int count = 0;
        this.address = "";
        byte b = 0;
        while (bis.available() - 1 > 0) {
            b = (byte)bis.read();
            int d1 = b & 0xF;
            int d2 = (b & 0xF0) >> 4;
            this.address = this.address + Integer.toHexString(d1) + Integer.toHexString(d2);
        }
        b = (byte)(bis.read() & 0xFF);
        this.address = this.address + Integer.toHexString(b & 0xF);
        if (this.oddFlag != 1) {
            this.address = this.address + Integer.toHexString((b & 0xF0) >> 4);
        }
        return count;
    }

    public int decodeHeader(ByteArrayInputStream bis) throws ParameterException {
        if (bis.available() == 0) {
            throw new ParameterException("No more data to read.");
        }
        int b = bis.read() & 0xFF;
        this.oddFlag = (b & 0x80) >> 7;
        this.setTypeOfNetworkIdentification(b >> 4);
        this.setNetworkIdentificationPlan(b);
        return 1;
    }

    public int encodeHeader(ByteArrayOutputStream bos) {
        boolean isOdd;
        int b = this.networkIdentificationPlan & 0xF;
        b |= (this.typeOfNetworkIdentification & 7) << 4;
        boolean bl = isOdd = this.oddFlag == 1;
        if (isOdd) {
            b |= 0x80;
        }
        bos.write(b);
        return 1;
    }

    public int getTypeOfNetworkIdentification() {
        return this.typeOfNetworkIdentification;
    }

    public void setTypeOfNetworkIdentification(int typeOfNetworkIdentification) {
        this.typeOfNetworkIdentification = typeOfNetworkIdentification & 7;
    }

    public int getNetworkIdentificationPlan() {
        return this.networkIdentificationPlan;
    }

    public void setNetworkIdentificationPlan(int networkIdentificationPlan) {
        this.networkIdentificationPlan = networkIdentificationPlan & 0xF;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String address) {
        this.address = address;
        this.oddFlag = this.address.length() % 2;
    }

    public boolean isOddFlag() {
        return this.oddFlag == 1;
    }

    public int getCode() {
        return 35;
    }
}

