/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.inap.primitives;

import java.io.IOException;
import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.inap.api.INAPException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentException;
import org.mobicents.protocols.ss7.inap.api.INAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.inap.api.primitives.LegID;
import org.mobicents.protocols.ss7.inap.api.primitives.LegType;
import org.mobicents.protocols.ss7.inap.primitives.INAPAsnPrimitive;

public class LegIDImpl
implements LegID,
INAPAsnPrimitive {
    public static final int _ID_sendingSideID = 0;
    public static final int _ID_receivingSideID = 1;
    private static final String SENDING_SIDE_ID = "sendingSideID";
    private static final String RECEIVING_SIDE_ID = "receivingSideID";
    private static final String DEFAULT_STRING_VALUE = null;
    public static final String _PrimitiveName = "LegID";
    private LegType sendingSideID;
    private LegType receivingSideID;
    protected static final XMLFormat<LegIDImpl> LEG_ID_XML = new XMLFormat<LegIDImpl>(LegIDImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, LegIDImpl legId) throws XMLStreamException {
            String receivingSideID;
            String sendingSideID = xml.getAttribute(LegIDImpl.SENDING_SIDE_ID, DEFAULT_STRING_VALUE);
            if (sendingSideID != null) {
                legId.sendingSideID = Enum.valueOf(LegType.class, sendingSideID);
            }
            if ((receivingSideID = xml.getAttribute(LegIDImpl.RECEIVING_SIDE_ID, DEFAULT_STRING_VALUE)) != null) {
                legId.receivingSideID = Enum.valueOf(LegType.class, receivingSideID);
            }
        }

        @Override
        public void write(LegIDImpl legId, XMLFormat.OutputElement xml) throws XMLStreamException {
            if (legId.sendingSideID != null) {
                xml.setAttribute(LegIDImpl.SENDING_SIDE_ID, legId.sendingSideID.toString());
            }
            if (legId.receivingSideID != null) {
                xml.setAttribute(LegIDImpl.RECEIVING_SIDE_ID, legId.receivingSideID.toString());
            }
        }
    };

    public LegIDImpl() {
    }

    public LegIDImpl(boolean isSendingSideID, LegType legID) {
        if (isSendingSideID) {
            this.sendingSideID = legID;
        } else {
            this.receivingSideID = legID;
        }
    }

    public LegType getSendingSideID() {
        return this.sendingSideID;
    }

    public LegType getReceivingSideID() {
        return this.receivingSideID;
    }

    public int getTag() throws INAPException {
        if (this.sendingSideID != null) {
            return 0;
        }
        return 1;
    }

    public int getTagClass() {
        return 2;
    }

    public boolean getIsPrimitive() {
        return true;
    }

    public void decodeAll(AsnInputStream ansIS) throws INAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new INAPParsingComponentException("IOException when decoding LegID: " + e.getMessage(), e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new INAPParsingComponentException("AsnException when decoding LegID: " + e.getMessage(), e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void decodeData(AsnInputStream ansIS, int length) throws INAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new INAPParsingComponentException("IOException when decoding LegID: " + e.getMessage(), e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new INAPParsingComponentException("AsnException when decoding LegID: " + e.getMessage(), e, INAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream asnIS, int length) throws INAPParsingComponentException, IOException, AsnException {
        if (asnIS.getTagClass() != 2 || !asnIS.isTagPrimitive()) {
            throw new INAPParsingComponentException("Error while decoding LegID: bad tag class or is not primitive: TagClass=" + asnIS.getTagClass(), INAPParsingComponentExceptionReason.MistypedParameter);
        }
        switch (asnIS.getTag()) {
            case 0: {
                byte[] buf = asnIS.readOctetStringData(length);
                if (buf.length != 1) {
                    throw new INAPParsingComponentException("Error while decoding LegID: sendingSideID length must be 1 but it equals " + buf.length, INAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.sendingSideID = LegType.getInstance(buf[0]);
                if (this.sendingSideID != null) break;
                throw new INAPParsingComponentException("Error while decoding LegID: sendingSideID value must be 1 or 2 it equals " + buf[0], INAPParsingComponentExceptionReason.MistypedParameter);
            }
            case 1: {
                byte[] buf = asnIS.readOctetStringData(length);
                if (buf.length != 1) {
                    throw new INAPParsingComponentException("Error while decoding LegID: sendingSideID length must be 1 but it equals " + buf.length, INAPParsingComponentExceptionReason.MistypedParameter);
                }
                this.receivingSideID = LegType.getInstance(buf[0]);
                if (this.receivingSideID != null) break;
                throw new INAPParsingComponentException("Error while decoding LegID: sendingSideID value must be 1 or 2 it equals " + buf[0], INAPParsingComponentExceptionReason.MistypedParameter);
            }
            default: {
                throw new INAPParsingComponentException("Error while decoding LegID: bad tag : tag=" + asnIS.getTag(), INAPParsingComponentExceptionReason.MistypedParameter);
            }
        }
    }

    public void encodeAll(AsnOutputStream asnOs) throws INAPException {
        this.encodeAll(asnOs, 2, this.getTag());
    }

    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws INAPException {
        try {
            asnOs.writeTag(tagClass, true, tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new INAPException("AsnException when encoding LegID: " + e.getMessage(), e);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws INAPException {
        if (this.sendingSideID == null && this.receivingSideID == null || this.sendingSideID != null && this.receivingSideID != null) {
            throw new INAPException("Error while encoding the LegID: one of sendingSideID or receivingSideID (not both) must not be empty");
        }
        byte[] buf = new byte[]{this.sendingSideID != null ? (byte)this.sendingSideID.getCode() : (byte)this.receivingSideID.getCode()};
        asnOs.writeOctetStringData(buf);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("LegID [");
        if (this.sendingSideID != null) {
            sb.append("sendingSideID=");
            sb.append((Object)this.sendingSideID);
        }
        if (this.receivingSideID != null) {
            sb.append("receivingSideID=");
            sb.append((Object)this.receivingSideID);
        }
        sb.append("]");
        return sb.toString();
    }
}

