/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.primitives.SendingSideID;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.CallInformationRequestRequest;
import org.mobicents.protocols.ss7.cap.api.service.circuitSwitchedCall.primitive.RequestedInformationType;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.primitives.SendingSideIDImpl;
import org.mobicents.protocols.ss7.cap.service.circuitSwitchedCall.CircuitSwitchedCallMessageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CallInformationRequestRequestImpl
extends CircuitSwitchedCallMessageImpl
implements CallInformationRequestRequest {
    public static final int _ID_requestedInformationTypeList = 0;
    public static final int _ID_extensions = 2;
    public static final int _ID_legID = 3;
    public static final String _PrimitiveName = "CallInformationRequestRequestIndication";
    private ArrayList<RequestedInformationType> requestedInformationTypeList;
    private CAPExtensions extensions;
    private SendingSideID legID;

    public CallInformationRequestRequestImpl() {
    }

    public CallInformationRequestRequestImpl(ArrayList<RequestedInformationType> requestedInformationTypeList, CAPExtensions extensions, SendingSideID legID) {
        this.requestedInformationTypeList = requestedInformationTypeList;
        this.extensions = extensions;
        this.legID = legID;
    }

    @Override
    public CAPMessageType getMessageType() {
        return CAPMessageType.callInformationRequest_Request;
    }

    @Override
    public int getOperationCode() {
        return 45;
    }

    @Override
    public ArrayList<RequestedInformationType> getRequestedInformationTypeList() {
        return this.requestedInformationTypeList;
    }

    @Override
    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    @Override
    public SendingSideID getLegID() {
        return this.legID;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CallInformationRequestRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CallInformationRequestRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding CallInformationRequestRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding CallInformationRequestRequestIndication: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException {
        this.requestedInformationTypeList = null;
        this.extensions = null;
        this.legID = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        this.requestedInformationTypeList = new ArrayList();
                        AsnInputStream ais2 = ais.readSequenceStream();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (tag2 != 10 || ais2.getTagClass() != 0 || !ais2.isTagPrimitive()) {
                                throw new CAPParsingComponentException("Error while decoding CallInformationRequestRequestIndication: bad RequestedInformationType tag or tagClass or RequestedInformationType is not primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            int i1 = (int)ais2.readInteger();
                            RequestedInformationType el = RequestedInformationType.getInstance(i1);
                            if (el == null) {
                                throw new CAPParsingComponentException("Error while decoding CallInformationRequestRequestIndication: bad RequestedInformationType value", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            this.requestedInformationTypeList.add(el);
                        }
                        break;
                    }
                    case 2: {
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    case 3: {
                        AsnInputStream ais2 = ais.readSequenceStream();
                        ais2.readTag();
                        this.legID = new SendingSideIDImpl();
                        ((SendingSideIDImpl)this.legID).decodeAll(ais2);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.requestedInformationTypeList == null) {
            throw new CAPParsingComponentException("Error while decoding CallInformationRequestRequestIndication: Parameter requestedInformationTypeList is mandatory parameters, but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CallInformationRequestRequestIndication: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream aos) throws CAPException {
        if (this.requestedInformationTypeList == null) {
            throw new CAPException("Error while encoding CallInformationRequestRequestIndication: requestedInformationTypeList must not be null");
        }
        if (this.requestedInformationTypeList.size() < 1 || this.requestedInformationTypeList.size() > 4) {
            throw new CAPException("Error while encoding CallInformationRequestRequestIndication: requestedInformationTypeList size must be from 1 to 4");
        }
        try {
            aos.writeTag(2, false, 0);
            int pos = aos.StartContentDefiniteLength();
            for (RequestedInformationType ri : this.requestedInformationTypeList) {
                aos.writeInteger(0, 10, ri.getCode());
            }
            aos.FinalizeContent(pos);
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(aos, 2, 2);
            }
            if (this.legID != null) {
                aos.writeTag(2, false, 3);
                pos = aos.StartContentDefiniteLength();
                ((SendingSideIDImpl)this.legID).encodeAll(aos);
                aos.FinalizeContent(pos);
            }
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding CallInformationRequestRequestIndication: " + e.getMessage(), e);
        }
        catch (IOException e) {
            throw new CAPException("IOException when encoding CallInformationRequestRequestIndication: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(_PrimitiveName);
        sb.append(" [");
        this.addInvokeIdInfo(sb);
        if (this.requestedInformationTypeList != null) {
            sb.append(", requestedInformationTypeList=[");
            boolean firstItem = true;
            for (RequestedInformationType ri : this.requestedInformationTypeList) {
                if (firstItem) {
                    firstItem = false;
                } else {
                    sb.append(", ");
                }
                sb.append(ri.toString());
            }
            sb.append("]");
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        if (this.legID != null) {
            sb.append(", legID=");
            sb.append(this.legID.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

