/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.ss7.linkset.oam;

import org.apache.log4j.Logger;
import org.mobicents.ss7.linkset.oam.LinksetManager;
import org.mobicents.ss7.management.console.ShellExecutor;

public class LinksetExecutor
implements ShellExecutor {
    private static final Logger logger = Logger.getLogger(LinksetExecutor.class);
    private LinksetManager linksetManager = null;

    public LinksetManager getLinksetManager() {
        return this.linksetManager;
    }

    public void setLinksetManager(LinksetManager linksetManager) {
        this.linksetManager = linksetManager;
    }

    public String execute(String[] options) {
        if (this.linksetManager == null) {
            logger.warn("LinksetManager not set. Command will not be executed ");
            return "Server Error";
        }
        try {
            if (options == null || options.length < 2) {
                return "Invalid Command";
            }
            String firstOption = options[1];
            if (firstOption == null) {
                return "Invalid Command";
            }
            if (firstOption.compareTo("show") == 0) {
                return this.linksetManager.showLinkset(options);
            }
            if (firstOption.compareTo("create") == 0) {
                return this.linksetManager.createLinkset(options);
            }
            if (firstOption.compareTo("delete") == 0) {
                return this.linksetManager.deleteLinkset(options);
            }
            if (firstOption.compareTo("activate") == 0) {
                return this.linksetManager.activateLinkset(options);
            }
            if (firstOption.compareTo("deactivate") == 0) {
                return this.linksetManager.deactivateLinkset(options);
            }
            if (firstOption.compareTo("link") == 0) {
                if (options.length < 3) {
                    return "Invalid Command";
                }
                firstOption = options[2];
                if (firstOption == null) {
                    return "Invalid Command";
                }
                if (firstOption.compareTo("create") == 0) {
                    return this.linksetManager.createLink(options);
                }
                if (firstOption.compareTo("delete") == 0) {
                    return this.linksetManager.deleteLink(options);
                }
                if (firstOption.compareTo("deactivate") == 0) {
                    return this.linksetManager.deactivateLink(options);
                }
                if (firstOption.compareTo("activate") == 0) {
                    return this.linksetManager.activateLink(options);
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while executing command ", e);
            return e.toString();
        }
        catch (Throwable t) {
            return t.toString();
        }
        return "Invalid Command";
    }

    public boolean handles(String command) {
        return command.startsWith("linkset");
    }
}

