/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.supplementary;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberManagement.BasicServiceCode;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSCode;
import org.mobicents.protocols.ss7.map.api.service.supplementary.SSForBSCode;
import org.mobicents.protocols.ss7.map.primitives.SequenceBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberManagement.BasicServiceCodeImpl;
import org.mobicents.protocols.ss7.map.service.supplementary.SSCodeImpl;

public class SSForBSCodeImpl
extends SequenceBase
implements SSForBSCode {
    public static final int _ID_longFTNSupported = 4;
    private SSCode ssCode;
    private BasicServiceCode basicService;
    private boolean longFtnSupported;

    public SSForBSCodeImpl() {
        super("SSForBSCode");
    }

    public SSForBSCodeImpl(SSCode ssCode, BasicServiceCode basicService, boolean longFtnSupported) {
        super("SSForBSCode");
        this.ssCode = ssCode;
        this.basicService = basicService;
        this.longFtnSupported = longFtnSupported;
    }

    public SSCode getSsCode() {
        return this.ssCode;
    }

    public BasicServiceCode getBasicService() {
        return this.basicService;
    }

    public boolean getLongFtnSupported() {
        return this.longFtnSupported;
    }

    protected void _decode(AsnInputStream asnIS, int length) throws MAPParsingComponentException, IOException, AsnException {
        this.ssCode = null;
        this.basicService = null;
        this.longFtnSupported = false;
        AsnInputStream ais = asnIS.readSequenceStreamData(length);
        int num = 0;
        while (ais.available() != 0) {
            int tag = ais.readTag();
            block0 : switch (num) {
                case 0: {
                    if (ais.getTagClass() != 0 || !ais.isTagPrimitive() || tag != 4) {
                        throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".ssCode: Parameter 0 bad tag or tag class or not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    this.ssCode = new SSCodeImpl();
                    ((SSCodeImpl)this.ssCode).decodeAll(ais);
                    break;
                }
                default: {
                    if (ais.getTagClass() == 2) {
                        switch (tag) {
                            case 2: 
                            case 3: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".basicService: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                this.basicService = new BasicServiceCodeImpl();
                                ((BasicServiceCodeImpl)this.basicService).decodeAll(ais);
                                break block0;
                            }
                            case 4: {
                                if (!ais.isTagPrimitive()) {
                                    throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ".longFtnSupported: Parameter is not primitive", MAPParsingComponentExceptionReason.MistypedParameter);
                                }
                                ais.readNull();
                                this.longFtnSupported = true;
                                break block0;
                            }
                        }
                        ais.advanceElement();
                        break;
                    }
                    ais.advanceElement();
                }
            }
            ++num;
        }
        if (num < 1) {
            throw new MAPParsingComponentException("Error while decoding " + this._PrimitiveName + ": Needs at least 1 mandatory parameter, found " + num, MAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    public void encodeData(AsnOutputStream asnOs) throws MAPException {
        try {
            if (this.ssCode == null) {
                throw new MAPException("ssCode parameter must not be null");
            }
            ((SSCodeImpl)this.ssCode).encodeAll(asnOs);
            if (this.basicService != null) {
                ((BasicServiceCodeImpl)this.basicService).encodeAll(asnOs);
            }
            if (this.longFtnSupported) {
                asnOs.writeNull(2, 4);
            }
        }
        catch (IOException e) {
            throw new MAPException("IOException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new MAPException("AsnException when encoding " + this._PrimitiveName + ": " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        if (this.ssCode != null) {
            sb.append("ssCode=");
            sb.append(this.ssCode);
            sb.append(", ");
        }
        if (this.basicService != null) {
            sb.append("basicService=");
            sb.append(this.basicService);
            sb.append(", ");
        }
        if (this.longFtnSupported) {
            sb.append("longFtnSupported, ");
        }
        sb.append("]");
        return sb.toString();
    }
}

