/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation;

import javolution.xml.XMLFormat;
import javolution.xml.stream.XMLStreamException;
import org.mobicents.protocols.ss7.map.api.MAPException;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.GeodeticInformation;
import org.mobicents.protocols.ss7.map.api.service.mobility.subscriberInformation.TypeOfShape;
import org.mobicents.protocols.ss7.map.primitives.OctetStringBase;
import org.mobicents.protocols.ss7.map.service.mobility.subscriberInformation.GeographicalInformationImpl;

public class GeodeticInformationImpl
extends OctetStringBase
implements GeodeticInformation {
    private static final String SCREENING_AND_PRESENTATION_INDICATORS = "screeningAndPresentationIndicators";
    private static final String TYPE_OF_SHAPE = "typeOfShape";
    private static final String LATITUDE = "latitude";
    private static final String LONGITUDE = "longitude";
    private static final String UNCERTAINTY = "uncertainty";
    private static final String CONFIDENCE = "confidence";
    private static final String DEFAULT_STRING_VALUE = null;
    private static final double DEFAULT_DOUBLE_VALUE = 0.0;
    private static final int DEFAULT_INT_VALUE = 0;
    protected static final XMLFormat<GeodeticInformationImpl> GEODETIC_INFORMATION_XML = new XMLFormat<GeodeticInformationImpl>(GeodeticInformationImpl.class){

        @Override
        public void read(XMLFormat.InputElement xml, GeodeticInformationImpl geodeticInformation) throws XMLStreamException {
            int sapi = xml.getAttribute(GeodeticInformationImpl.SCREENING_AND_PRESENTATION_INDICATORS, 0);
            String str = xml.getAttribute(GeodeticInformationImpl.TYPE_OF_SHAPE, DEFAULT_STRING_VALUE);
            TypeOfShape tos = null;
            if (str != null) {
                tos = Enum.valueOf(TypeOfShape.class, str);
            }
            double lat = xml.getAttribute(GeodeticInformationImpl.LATITUDE, 0.0);
            double lng = xml.getAttribute(GeodeticInformationImpl.LONGITUDE, 0.0);
            double unc = xml.getAttribute(GeodeticInformationImpl.UNCERTAINTY, 0.0);
            int conf = xml.getAttribute(GeodeticInformationImpl.CONFIDENCE, 0);
            try {
                geodeticInformation.setData(sapi, tos, lat, lng, unc, conf);
            }
            catch (MAPException e) {
                throw new XMLStreamException("MAPException when deserializing GeodeticInformationImpl", e);
            }
        }

        @Override
        public void write(GeodeticInformationImpl geodeticInformation, XMLFormat.OutputElement xml) throws XMLStreamException {
            xml.setAttribute(GeodeticInformationImpl.SCREENING_AND_PRESENTATION_INDICATORS, geodeticInformation.getScreeningAndPresentationIndicators());
            if (geodeticInformation.getTypeOfShape() != null) {
                xml.setAttribute(GeodeticInformationImpl.TYPE_OF_SHAPE, geodeticInformation.getTypeOfShape().toString());
            }
            xml.setAttribute(GeodeticInformationImpl.LATITUDE, geodeticInformation.getLatitude());
            xml.setAttribute(GeodeticInformationImpl.LONGITUDE, geodeticInformation.getLongitude());
            xml.setAttribute(GeodeticInformationImpl.UNCERTAINTY, geodeticInformation.getUncertainty());
            xml.setAttribute(GeodeticInformationImpl.CONFIDENCE, geodeticInformation.getConfidence());
        }
    };

    public GeodeticInformationImpl() {
        super(10, 10, "GeodeticInformation");
    }

    public GeodeticInformationImpl(byte[] data) {
        super(10, 10, "GeodeticInformation", data);
    }

    public GeodeticInformationImpl(int screeningAndPresentationIndicators, TypeOfShape typeOfShape, double latitude, double longitude, double uncertainty, int confidence) throws MAPException {
        super(10, 10, "GeodeticInformation");
        this.setData(screeningAndPresentationIndicators, typeOfShape, latitude, longitude, uncertainty, confidence);
    }

    public void setData(int screeningAndPresentationIndicators, TypeOfShape typeOfShape, double latitude, double longitude, double uncertainty, int confidence) throws MAPException {
        if (typeOfShape != TypeOfShape.EllipsoidPointWithUncertaintyCircle) {
            throw new MAPException("typeOfShape parameter for GeographicalInformation can be only \" ellipsoid point with uncertainty circle\"");
        }
        this.data = new byte[10];
        this.data[0] = (byte)screeningAndPresentationIndicators;
        this.data[1] = (byte)(typeOfShape.getCode() << 4);
        GeographicalInformationImpl.encodeLatitude(this.data, 2, latitude);
        GeographicalInformationImpl.encodeLongitude(this.data, 5, longitude);
        this.data[8] = (byte)GeographicalInformationImpl.encodeUncertainty(uncertainty);
        this.data[9] = (byte)confidence;
    }

    public byte[] getData() {
        return this.data;
    }

    public int getScreeningAndPresentationIndicators() {
        if (this.data == null || this.data.length != 10) {
            return 0;
        }
        return this.data[0];
    }

    public TypeOfShape getTypeOfShape() {
        if (this.data == null || this.data.length != 10) {
            return null;
        }
        return TypeOfShape.getInstance((this.data[1] & 0xFF) >> 4);
    }

    public double getLatitude() {
        if (this.data == null || this.data.length != 10) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeLatitude(this.data, 2);
    }

    public double getLongitude() {
        if (this.data == null || this.data.length != 10) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeLongitude(this.data, 5);
    }

    public double getUncertainty() {
        if (this.data == null || this.data.length != 10) {
            return 0.0;
        }
        return GeographicalInformationImpl.decodeUncertainty(this.data[8]);
    }

    public int getConfidence() {
        if (this.data == null || this.data.length != 10) {
            return 0;
        }
        return this.data[9];
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this._PrimitiveName);
        sb.append(" [");
        sb.append("ScreeningAndPresentationIndicators=");
        sb.append(this.getScreeningAndPresentationIndicators());
        sb.append(", TypeOfShape=");
        sb.append((Object)this.getTypeOfShape());
        sb.append(", Latitude=");
        sb.append(this.getLatitude());
        sb.append(", Longitude=");
        sb.append(this.getLongitude());
        sb.append(", Uncertainty=");
        sb.append(this.getUncertainty());
        sb.append(", Confidence=");
        sb.append(this.getConfidence());
        sb.append("]");
        return sb.toString();
    }
}

