/*
 * Decompiled with CFR 0.152.
 */
package org.mobicents.protocols.ss7.cap.service.sms;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.mobicents.protocols.ss7.cap.api.CAPException;
import org.mobicents.protocols.ss7.cap.api.CAPMessageType;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentException;
import org.mobicents.protocols.ss7.cap.api.CAPParsingComponentExceptionReason;
import org.mobicents.protocols.ss7.cap.api.primitives.CAPExtensions;
import org.mobicents.protocols.ss7.cap.api.service.sms.RequestReportSMSEventRequest;
import org.mobicents.protocols.ss7.cap.api.service.sms.primitive.SMSEvent;
import org.mobicents.protocols.ss7.cap.primitives.CAPExtensionsImpl;
import org.mobicents.protocols.ss7.cap.service.sms.SmsMessageImpl;
import org.mobicents.protocols.ss7.cap.service.sms.primitive.SMSEventImpl;
import org.mobicents.protocols.ss7.map.api.MAPParsingComponentException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RequestReportSMSEventRequestImpl
extends SmsMessageImpl
implements RequestReportSMSEventRequest {
    public static final String _PrimitiveName = "RequestReportSMSEventRequest";
    public static final int _ID_smsEvents = 0;
    public static final int _ID_extensions = 10;
    private ArrayList<SMSEvent> smsEvents;
    private CAPExtensions extensions;

    public RequestReportSMSEventRequestImpl(ArrayList<SMSEvent> smsEvents, CAPExtensions extensions) {
        this.smsEvents = smsEvents;
        this.extensions = extensions;
    }

    public RequestReportSMSEventRequestImpl() {
    }

    @Override
    public ArrayList<SMSEvent> getSMSEvents() {
        return this.smsEvents;
    }

    @Override
    public CAPExtensions getExtensions() {
        return this.extensions;
    }

    @Override
    public CAPMessageType getMessageType() {
        return CAPMessageType.requestReportSMSEvent_Request;
    }

    @Override
    public int getOperationCode() {
        return 63;
    }

    @Override
    public int getTag() throws CAPException {
        return 16;
    }

    @Override
    public int getTagClass() {
        return 0;
    }

    @Override
    public boolean getIsPrimitive() {
        return false;
    }

    @Override
    public void decodeAll(AsnInputStream ansIS) throws CAPParsingComponentException {
        try {
            int length = ansIS.readLength();
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding RequestReportSMSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding RequestReportSMSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding RequestReportSMSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void decodeData(AsnInputStream ansIS, int length) throws CAPParsingComponentException {
        try {
            this._decode(ansIS, length);
        }
        catch (IOException e) {
            throw new CAPParsingComponentException("IOException when decoding RequestReportSMSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (AsnException e) {
            throw new CAPParsingComponentException("AsnException when decoding RequestReportSMSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
        catch (MAPParsingComponentException e) {
            throw new CAPParsingComponentException("MAPParsingComponentException when decoding RequestReportSMSEventRequest: " + e.getMessage(), e, CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    private void _decode(AsnInputStream ansIS, int length) throws CAPParsingComponentException, IOException, AsnException, MAPParsingComponentException {
        this.smsEvents = null;
        this.extensions = null;
        AsnInputStream ais = ansIS.readSequenceStreamData(length);
        block4: while (ais.available() != 0) {
            int tag = ais.readTag();
            if (ais.getTagClass() == 2) {
                switch (tag) {
                    case 0: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding RequestReportSMSEventRequest.smsEvents: Parameter gprsEvent is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        SMSEventImpl event = null;
                        AsnInputStream ais2 = ais.readSequenceStream();
                        this.smsEvents = new ArrayList();
                        while (ais2.available() != 0) {
                            int tag2 = ais2.readTag();
                            if (tag2 != 16 || ais2.getTagClass() != 0 || ais2.isTagPrimitive()) {
                                throw new CAPParsingComponentException("Error while decoding RequestReportSMSEventRequestsmsEvents: bad tag or tagClass or is primitive ", CAPParsingComponentExceptionReason.MistypedParameter);
                            }
                            event = new SMSEventImpl();
                            event.decodeAll(ais2);
                            this.smsEvents.add(event);
                        }
                        if (this.smsEvents.size() >= 1 && this.smsEvents.size() <= 10) continue block4;
                        throw new CAPParsingComponentException("Error while decoding RequestReportSMSEventRequest: Parameter smsEvents size must be from 1 to 10, found: " + this.smsEvents.size(), CAPParsingComponentExceptionReason.MistypedParameter);
                    }
                    case 10: {
                        if (ais.isTagPrimitive()) {
                            throw new CAPParsingComponentException("Error while decoding RequestReportSMSEventRequest.extensions: Parameter is primitive", CAPParsingComponentExceptionReason.MistypedParameter);
                        }
                        this.extensions = new CAPExtensionsImpl();
                        ((CAPExtensionsImpl)this.extensions).decodeAll(ais);
                        break;
                    }
                    default: {
                        ais.advanceElement();
                        break;
                    }
                }
                continue;
            }
            ais.advanceElement();
        }
        if (this.smsEvents == null) {
            throw new CAPParsingComponentException("Error while decoding RequestReportSMSEventRequest: parameter smsEvents is mandatory but not found", CAPParsingComponentExceptionReason.MistypedParameter);
        }
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs) throws CAPException {
        this.encodeAll(asnOs, this.getTagClass(), this.getTag());
    }

    @Override
    public void encodeAll(AsnOutputStream asnOs, int tagClass, int tag) throws CAPException {
        try {
            asnOs.writeTag(tagClass, this.getIsPrimitive(), tag);
            int pos = asnOs.StartContentDefiniteLength();
            this.encodeData(asnOs);
            asnOs.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding RequestReportSMSEventRequest: " + e.getMessage(), e);
        }
    }

    @Override
    public void encodeData(AsnOutputStream asnOs) throws CAPException {
        if (this.smsEvents == null) {
            throw new CAPException("Error while encoding RequestReportSMSEventRequest: gprsEvent must not be null");
        }
        if (this.smsEvents.size() < 1 || this.smsEvents.size() > 10) {
            throw new CAPException("Error while encoding RequestReportSMSEventRequest: Parameter gprsEvent size must be from 1 to 10, found: " + this.smsEvents.size());
        }
        try {
            asnOs.writeTag(2, false, 0);
            int pos = asnOs.StartContentDefiniteLength();
            for (SMSEvent event : this.smsEvents) {
                ((SMSEventImpl)event).encodeAll(asnOs);
            }
            asnOs.FinalizeContent(pos);
            if (this.extensions != null) {
                ((CAPExtensionsImpl)this.extensions).encodeAll(asnOs, 2, 10);
            }
        }
        catch (AsnException e) {
            throw new CAPException("AsnException when encoding RequestReportSMSEventRequest: " + e.getMessage(), e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("RequestReportSMSEventRequest [");
        this.addInvokeIdInfo(sb);
        if (this.smsEvents != null) {
            sb.append(", smsEvents=[");
            boolean i1 = false;
            for (SMSEvent evt : this.smsEvents) {
                if (!i1) {
                    i1 = true;
                } else {
                    sb.append(", ");
                }
                sb.append("smsEvent=");
                sb.append(evt.toString());
            }
            sb.append("]");
        }
        if (this.extensions != null) {
            sb.append(", extensions=");
            sb.append(this.extensions.toString());
        }
        sb.append("]");
        return sb.toString();
    }
}

