/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.ss7.congestion;

import java.io.Serializable;
import org.restcomm.ss7.congestion.BaseCongestionMonitor;
import org.restcomm.ss7.congestion.CongestionTicketImpl;
import org.restcomm.ss7.congestion.MemoryCongestionMonitor;

public class MemoryCongestionMonitorImpl
extends BaseCongestionMonitor
implements MemoryCongestionMonitor,
Serializable {
    private static final String SOURCE = "MEMORY";
    private double maxMemory;
    private volatile double percentageOfMemoryUsed;
    private volatile int memoryAlarmLevel = 0;
    private double[] memoryThreshold = new double[]{77.0, 87.0, 97.0};
    private double[] backToNormalMemoryThreshold = new double[]{72.0, 82.0, 92.0};
    protected double calculatedAllocatedMemory;
    protected double calculatedFreeMemory;
    protected double calculatedTotalFreeMemory;

    public MemoryCongestionMonitorImpl() {
        this.maxMemory = (double)Runtime.getRuntime().maxMemory() / 1024.0;
    }

    public void setBackToNormalMemoryThreshold1(double backToNormalMemoryThreshold1) {
        if (Math.abs(this.backToNormalMemoryThreshold[0] - backToNormalMemoryThreshold1) > 0.001 && logger.isInfoEnabled()) {
            logger.info("MemoryCongestionMonitor: Back To Normal Memory threshold 1 set to " + backToNormalMemoryThreshold1 + "%");
        }
        this.backToNormalMemoryThreshold[0] = backToNormalMemoryThreshold1;
    }

    public void setBackToNormalMemoryThreshold2(double backToNormalMemoryThreshold2) {
        if (Math.abs(this.backToNormalMemoryThreshold[1] - backToNormalMemoryThreshold2) > 0.001 && logger.isInfoEnabled()) {
            logger.info("MemoryCongestionMonitor: Back To Normal Memory threshold 2 set to " + backToNormalMemoryThreshold2 + "%");
        }
        this.backToNormalMemoryThreshold[1] = backToNormalMemoryThreshold2;
    }

    public void setBackToNormalMemoryThreshold3(double backToNormalMemoryThreshold3) {
        if (Math.abs(this.backToNormalMemoryThreshold[2] - backToNormalMemoryThreshold3) > 0.001 && logger.isInfoEnabled()) {
            logger.info("MemoryCongestionMonitor: Back To Normal Memory threshold 3 set to " + backToNormalMemoryThreshold3 + "%");
        }
        this.backToNormalMemoryThreshold[2] = backToNormalMemoryThreshold3;
    }

    public double getBackToNormalMemoryThreshold1() {
        return this.backToNormalMemoryThreshold[0];
    }

    public double getBackToNormalMemoryThreshold2() {
        return this.backToNormalMemoryThreshold[1];
    }

    public double getBackToNormalMemoryThreshold3() {
        return this.backToNormalMemoryThreshold[2];
    }

    public void setMemoryThreshold1(double memoryThreshold1) {
        if (Math.abs(this.memoryThreshold[0] - memoryThreshold1) > 0.001 && logger.isInfoEnabled()) {
            logger.info("MemoryCongestionMonitor: Memory threshold 1 set to " + memoryThreshold1 + "%");
        }
        this.memoryThreshold[0] = memoryThreshold1;
    }

    public void setMemoryThreshold2(double memoryThreshold2) {
        if (Math.abs(this.memoryThreshold[1] - memoryThreshold2) > 0.001 && logger.isInfoEnabled()) {
            logger.info("MemoryCongestionMonitor: Memory threshold 2 set to " + memoryThreshold2 + "%");
        }
        this.memoryThreshold[1] = memoryThreshold2;
    }

    public void setMemoryThreshold3(double memoryThreshold3) {
        if (Math.abs(this.memoryThreshold[2] - memoryThreshold3) > 0.001 && logger.isInfoEnabled()) {
            logger.info("MemoryCongestionMonitor: Memory threshold 3 set to " + memoryThreshold3 + "%");
        }
        this.memoryThreshold[2] = memoryThreshold3;
    }

    public double getMemoryThreshold1() {
        return this.memoryThreshold[0];
    }

    public double getMemoryThreshold2() {
        return this.memoryThreshold[1];
    }

    public double getMemoryThreshold3() {
        return this.memoryThreshold[2];
    }

    @Override
    public void monitor() {
        Runtime runtime = Runtime.getRuntime();
        double allocatedMemory = (double)runtime.totalMemory() / 1024.0;
        double freeMemory = (double)runtime.freeMemory() / 1024.0;
        double totalFreeMemory = freeMemory + (this.maxMemory - allocatedMemory);
        this.calculatedAllocatedMemory = allocatedMemory;
        this.calculatedFreeMemory = freeMemory;
        this.calculatedTotalFreeMemory = totalFreeMemory;
        this.percentageOfMemoryUsed = 100.0 - totalFreeMemory / this.maxMemory * 100.0;
        super.applyNewValue(this.memoryAlarmLevel, this.percentageOfMemoryUsed, this.memoryThreshold, this.backToNormalMemoryThreshold, true);
    }

    @Override
    protected CongestionTicketImpl generateTicket() {
        return new CongestionTicketImpl(SOURCE, this.memoryAlarmLevel);
    }

    @Override
    public String getSource() {
        return SOURCE;
    }

    @Override
    public int getAlarmLevel() {
        return this.memoryAlarmLevel;
    }

    @Override
    protected void setAlarmLevel(int val) {
        this.memoryAlarmLevel = val;
    }

    @Override
    public double getMemoryThreshold_1() {
        return this.memoryThreshold[0];
    }

    @Override
    public double getMemoryThreshold_2() {
        return this.memoryThreshold[1];
    }

    @Override
    public double getMemoryThreshold_3() {
        return this.memoryThreshold[2];
    }

    @Override
    public void setMemoryThreshold_1(double value) throws Exception {
        this.memoryThreshold[0] = value;
    }

    @Override
    public void setMemoryThreshold_2(double value) throws Exception {
        this.memoryThreshold[1] = value;
    }

    @Override
    public void setMemoryThreshold_3(double value) throws Exception {
        this.memoryThreshold[2] = value;
    }

    @Override
    public double getBackToNormalMemoryThreshold_1() {
        return this.backToNormalMemoryThreshold[0];
    }

    @Override
    public double getBackToNormalMemoryThreshold_2() {
        return this.backToNormalMemoryThreshold[1];
    }

    @Override
    public double getBackToNormalMemoryThreshold_3() {
        return this.backToNormalMemoryThreshold[2];
    }

    @Override
    public void setBackToNormalMemoryThreshold_1(double value) throws Exception {
        this.backToNormalMemoryThreshold[0] = value;
    }

    @Override
    public void setBackToNormalMemoryThreshold_2(double value) throws Exception {
        this.backToNormalMemoryThreshold[1] = value;
    }

    @Override
    public void setBackToNormalMemoryThreshold_3(double value) throws Exception {
        this.backToNormalMemoryThreshold[2] = value;
    }

    @Override
    protected String getAlarmDescription() {
        StringBuilder sb = new StringBuilder();
        sb.append("maxMemory=");
        sb.append(this.maxMemory);
        sb.append(", allocatedMemory=");
        sb.append(this.calculatedAllocatedMemory);
        sb.append(", freeMemory=");
        sb.append(this.calculatedFreeMemory);
        sb.append(", totalFreeMemory=");
        sb.append(this.calculatedTotalFreeMemory);
        sb.append(",  percentageOfMemoryUsed=");
        sb.append(this.percentageOfMemoryUsed);
        return sb.toString();
    }
}

