/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.ArrayList;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.DialogPortion;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.TcapFactory;
import org.restcomm.protocols.ss7.tcap.asn.comp.Component;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCBeginMessage;

public class TCBeginMessageImpl
implements TCBeginMessage {
    private static final String _OCTET_STRING_ENCODE = "US-ASCII";
    private byte[] originatingTransactionId;
    private DialogPortion dp;
    private Component[] component;

    @Override
    public Component[] getComponent() {
        return this.component;
    }

    @Override
    public DialogPortion getDialogPortion() {
        return this.dp;
    }

    @Override
    public byte[] getOriginatingTransactionId() {
        return this.originatingTransactionId;
    }

    @Override
    public void setComponent(Component[] c) {
        this.component = c;
    }

    @Override
    public void setDialogPortion(DialogPortion dp) {
        this.dp = dp;
    }

    @Override
    public void setOriginatingTransactionId(byte[] t) {
        this.originatingTransactionId = t;
    }

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 8 || localAis.getTagClass() != 1) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Begin: Expected OriginatingTransactionId, found tag: " + tag);
            }
            this.originatingTransactionId = localAis.readOctetString();
            block7: while (true) {
                if (localAis.available() == 0) {
                    return;
                }
                tag = localAis.readTag();
                if (localAis.isTagPrimitive() || localAis.getTagClass() != 1) {
                    throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Begin: DialogPortion and Component portion must be constructive and has tag class CLASS_APPLICATION");
                }
                switch (tag) {
                    case 11: {
                        this.dp = TcapFactory.createDialogPortion(localAis);
                        continue block7;
                    }
                    case 12: {
                        Component c;
                        AsnInputStream compAis = localAis.readSequenceStream();
                        ArrayList<Component> cps = new ArrayList<Component>();
                        while (compAis.available() > 0 && (c = TcapFactory.createComponent(compAis)) != null) {
                            cps.add(c);
                        }
                        this.component = new Component[cps.size()];
                        this.component = cps.toArray(this.component);
                        continue block7;
                    }
                }
                break;
            }
            throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Begin: DialogPortion and Componebt parsing: bad tag - " + tag);
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding TC-Begin: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding TC-Begin: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        try {
            aos.writeTag(1, false, 2);
            int pos = aos.StartContentDefiniteLength();
            aos.writeOctetString(1, 8, this.originatingTransactionId);
            if (this.dp != null) {
                this.dp.encode(aos);
            }
            if (this.component != null) {
                aos.writeTag(1, false, 12);
                int pos2 = aos.StartContentDefiniteLength();
                for (Component c : this.component) {
                    c.encode(aos);
                }
                aos.FinalizeContent(pos2);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding TC-Begin: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding TC-Begin: " + e.getMessage(), e);
        }
    }
}

