/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.DialogPortion;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.TcapFactory;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;
import org.restcomm.protocols.ss7.tcap.asn.comp.TCAbortMessage;

public class TCAbortMessageImpl
implements TCAbortMessage {
    private static final String _OCTET_STRING_ENCODE = "US-ASCII";
    private byte[] destTxId;
    private PAbortCauseType type;
    private DialogPortion dp;

    @Override
    public byte[] getDestinationTransactionId() {
        return this.destTxId;
    }

    @Override
    public DialogPortion getDialogPortion() {
        return this.dp;
    }

    @Override
    public PAbortCauseType getPAbortCause() {
        return this.type;
    }

    @Override
    public void setDestinationTransactionId(byte[] t) {
        this.destTxId = t;
    }

    @Override
    public void setDialogPortion(DialogPortion dp) {
        this.dp = dp;
        this.type = null;
    }

    @Override
    public void setPAbortCause(PAbortCauseType t) {
        this.type = t;
        this.dp = null;
    }

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag != 9 || localAis.getTagClass() != 1) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Abort: Expected DestinationTransactionId, found tag: " + tag);
            }
            this.destTxId = localAis.readOctetString();
            if (localAis.available() == 0) {
                return;
            }
            tag = localAis.readTag();
            if (localAis.getTagClass() != 1) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Abort: DialogPortion and P-AbortCause portion must has tag class CLASS_APPLICATION");
            }
            switch (tag) {
                case 11: {
                    if (localAis.isTagPrimitive()) {
                        throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-End: DialogPortion must be constructive");
                    }
                    this.dp = TcapFactory.createDialogPortion(localAis);
                    break;
                }
                case 10: {
                    this.type = PAbortCauseType.getFromInt((int)localAis.readInteger());
                    break;
                }
                default: {
                    throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Abort: bad tag while parsing DialogPortion and P-AbortCause portion: " + tag);
                }
            }
            if (localAis.available() > 0) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding TC-Abort: too mych data");
            }
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding TC-Abort: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding TC-Abort: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        try {
            aos.writeTag(1, false, 7);
            int pos = aos.StartContentDefiniteLength();
            aos.writeOctetString(1, 9, this.destTxId);
            if (this.type != null) {
                aos.writeInteger(1, 10, this.type.getType());
            } else if (this.dp != null) {
                this.dp.encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (IOException e) {
            throw new EncodeException("IOException while encoding TC-Abort: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding TC-Abort: " + e.getMessage(), e);
        }
    }
}

