/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import java.util.Arrays;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.comp.ErrorCode;
import org.restcomm.protocols.ss7.tcap.asn.comp.ErrorCodeType;
import org.restcomm.protocols.ss7.tcap.asn.comp.GeneralProblemType;

public class ErrorCodeImpl
implements ErrorCode {
    private ErrorCodeType type;
    private Long localErrorCode;
    private long[] globalErrorCode;

    public void setErrorCodeType(ErrorCodeType type) {
        this.type = type;
    }

    @Override
    public void setLocalErrorCode(Long localErrorCode) {
        this.localErrorCode = localErrorCode;
        this.globalErrorCode = null;
        this.type = ErrorCodeType.Local;
    }

    @Override
    public void setGlobalErrorCode(long[] globalErrorCode) {
        this.localErrorCode = null;
        this.globalErrorCode = globalErrorCode;
        this.type = ErrorCodeType.Global;
    }

    @Override
    public Long getLocalErrorCode() {
        return this.localErrorCode;
    }

    @Override
    public long[] getGlobalErrorCode() {
        return this.globalErrorCode;
    }

    @Override
    public ErrorCodeType getErrorType() {
        return this.type;
    }

    public String getStringValue() {
        if (this.localErrorCode != null) {
            return this.localErrorCode.toString();
        }
        if (this.globalErrorCode != null) {
            return Arrays.toString(this.globalErrorCode);
        }
        return "empty";
    }

    public String toString() {
        if (this.localErrorCode != null) {
            return "ErrorCode[errorType=Local, data=" + this.localErrorCode.toString() + "]";
        }
        if (this.globalErrorCode != null) {
            return "ErrorCode[errorType=Global, data=" + Arrays.toString(this.globalErrorCode) + "]";
        }
        return "ErrorCode[empty]";
    }

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        block5: {
            try {
                if (this.type == ErrorCodeType.Global) {
                    this.globalErrorCode = ais.readObjectIdentifier();
                    break block5;
                }
                if (this.type == ErrorCodeType.Local) {
                    this.localErrorCode = ais.readInteger();
                    break block5;
                }
                throw new ParseException(null, GeneralProblemType.MistypedComponent);
            }
            catch (IOException e) {
                e.printStackTrace();
                throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "IOException while parsing ErrorCode: " + e.getMessage(), e);
            }
            catch (AsnException e) {
                e.printStackTrace();
                throw new ParseException(null, GeneralProblemType.BadlyStructuredComponent, "AsnException while parsing ErrorCode: " + e.getMessage(), e);
            }
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        block6: {
            if (this.localErrorCode == null && this.globalErrorCode == null) {
                throw new EncodeException("Error code: No error code set!");
            }
            try {
                if (this.type == ErrorCodeType.Local) {
                    aos.writeInteger(this.localErrorCode);
                    break block6;
                }
                if (this.type == ErrorCodeType.Global) {
                    aos.writeObjectIdentifier(this.globalErrorCode);
                    break block6;
                }
                throw new EncodeException();
            }
            catch (IOException e) {
                throw new EncodeException(e);
            }
            catch (AsnException e) {
                throw new EncodeException(e);
            }
        }
    }
}

