/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.tcap.asn;

import java.io.IOException;
import org.mobicents.protocols.asn.AsnException;
import org.mobicents.protocols.asn.AsnInputStream;
import org.mobicents.protocols.asn.AsnOutputStream;
import org.restcomm.protocols.ss7.tcap.asn.ApplicationContextName;
import org.restcomm.protocols.ss7.tcap.asn.DialogAPDUType;
import org.restcomm.protocols.ss7.tcap.asn.DialogResponseAPDU;
import org.restcomm.protocols.ss7.tcap.asn.EncodeException;
import org.restcomm.protocols.ss7.tcap.asn.ParseException;
import org.restcomm.protocols.ss7.tcap.asn.ProtocolVersion;
import org.restcomm.protocols.ss7.tcap.asn.ProtocolVersionImpl;
import org.restcomm.protocols.ss7.tcap.asn.Result;
import org.restcomm.protocols.ss7.tcap.asn.ResultSourceDiagnostic;
import org.restcomm.protocols.ss7.tcap.asn.TcapFactory;
import org.restcomm.protocols.ss7.tcap.asn.UserInformation;
import org.restcomm.protocols.ss7.tcap.asn.comp.PAbortCauseType;

public class DialogResponseAPDUImpl
implements DialogResponseAPDU {
    private ApplicationContextName acn;
    private Result result;
    private ResultSourceDiagnostic diagnostic;
    private ProtocolVersion protocolVersion = new ProtocolVersionImpl();
    private boolean doNotSendProtocolVersion = false;
    private UserInformation ui;

    @Override
    public void setDoNotSendProtocolVersion(boolean val) {
        this.doNotSendProtocolVersion = val;
    }

    @Override
    public ApplicationContextName getApplicationContextName() {
        return this.acn;
    }

    @Override
    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    @Override
    public UserInformation getUserInformation() {
        return this.ui;
    }

    @Override
    public void setApplicationContextName(ApplicationContextName acn) {
        this.acn = acn;
    }

    @Override
    public void setUserInformation(UserInformation ui) {
        this.ui = ui;
    }

    @Override
    public Result getResult() {
        return this.result;
    }

    @Override
    public ResultSourceDiagnostic getResultSourceDiagnostic() {
        return this.diagnostic;
    }

    @Override
    public void setResult(Result acn) {
        this.result = acn;
    }

    @Override
    public void setResultSourceDiagnostic(ResultSourceDiagnostic acn) {
        this.diagnostic = acn;
    }

    @Override
    public DialogAPDUType getType() {
        return DialogAPDUType.Response;
    }

    @Override
    public boolean isUniDirectional() {
        return false;
    }

    public String toString() {
        return "DialogResponseAPDU[acn=" + this.acn + ", result=" + this.result + ", diagnostic=" + this.diagnostic + ", ui=" + this.ui + "]";
    }

    @Override
    public void decode(AsnInputStream ais) throws ParseException {
        try {
            AsnInputStream localAis = ais.readSequenceStream();
            int tag = localAis.readTag();
            if (tag == 0 && localAis.getTagClass() == 2) {
                this.protocolVersion = TcapFactory.createProtocolVersion(localAis);
                tag = localAis.readTag();
            }
            if (tag != 1 || localAis.getTagClass() != 2) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogResponseAPDU.application-context-name: bad tag or tagClass, found tag=" + tag + ", tagClass=" + localAis.getTagClass());
            }
            this.acn = TcapFactory.createApplicationContextName(localAis);
            tag = localAis.readTag();
            if (tag != 2) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Expected Result tag, found: " + tag);
            }
            this.result = TcapFactory.createResult(localAis);
            tag = localAis.readTag();
            if (tag != 3) {
                throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Expected Result Source Diagnotstic tag, found: " + tag);
            }
            this.diagnostic = TcapFactory.createResultSourceDiagnostic(localAis);
            if (localAis.available() > 0) {
                tag = localAis.readTag();
                if (tag != 30 || localAis.getTagClass() != 2) {
                    throw new ParseException(PAbortCauseType.IncorrectTxPortion, null, "Error decoding DialogResponseAPDU.user-information: bad tag or tagClass, found tag=" + tag + ", tagClass=" + localAis.getTagClass());
                }
                this.ui = TcapFactory.createUserInformation(localAis);
            }
        }
        catch (IOException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "IOException while decoding DialogResponseAPDU: " + e.getMessage(), e);
        }
        catch (AsnException e) {
            throw new ParseException(PAbortCauseType.BadlyFormattedTxPortion, null, "AsnException while decoding DialogResponseAPDU: " + e.getMessage(), e);
        }
    }

    @Override
    public void encode(AsnOutputStream aos) throws EncodeException {
        if (this.acn == null) {
            throw new EncodeException("Error encoding DialogResponseAPDU: Application Context Name must not be null");
        }
        if (this.result == null) {
            throw new EncodeException("Error encoding DialogResponseAPDU: Result must not be null");
        }
        if (this.diagnostic == null) {
            throw new EncodeException("Error encoding DialogResponseAPDU: Result-source-diagnostic must not be null");
        }
        try {
            aos.writeTag(1, false, 1);
            int pos = aos.StartContentDefiniteLength();
            if (!this.doNotSendProtocolVersion) {
                this.protocolVersion.encode(aos);
            }
            this.acn.encode(aos);
            this.result.encode(aos);
            this.diagnostic.encode(aos);
            if (this.ui != null) {
                this.ui.encode(aos);
            }
            aos.FinalizeContent(pos);
        }
        catch (AsnException e) {
            throw new EncodeException("AsnException while encoding DialogResponseAPDU: " + e.getMessage(), e);
        }
    }
}

