/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl.parameter;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.restcomm.protocols.ss7.sccp.SccpProtocolVersion;
import org.restcomm.protocols.ss7.sccp.impl.parameter.AbstractParameter;
import org.restcomm.protocols.ss7.sccp.message.ParseException;
import org.restcomm.protocols.ss7.sccp.parameter.ErrorCause;
import org.restcomm.protocols.ss7.sccp.parameter.ErrorCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.ParameterFactory;

public class ErrorCauseImpl
extends AbstractParameter
implements ErrorCause {
    private ErrorCauseValue value;
    private int digValue;

    public ErrorCauseImpl() {
        this.value = ErrorCauseValue.UNQUALIFIED;
        this.digValue = this.value.getValue();
    }

    public ErrorCauseImpl(ErrorCauseValue value) {
        this.value = value;
        if (value != null) {
            this.digValue = value.getValue();
        }
    }

    public ErrorCauseImpl(int digValue) {
        this.digValue = digValue;
        this.value = ErrorCauseValue.getInstance(digValue);
    }

    @Override
    public ErrorCauseValue getValue() {
        return this.value;
    }

    @Override
    public int getDigitalValue() {
        return this.digValue;
    }

    @Override
    public void decode(InputStream in, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            if (in.read() != 1) {
                throw new ParseException();
            }
            this.digValue = in.read();
            this.value = ErrorCauseValue.getInstance(this.digValue);
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    @Override
    public void encode(OutputStream os, boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        try {
            os.write(1);
            os.write(this.digValue);
        }
        catch (IOException ioe) {
            throw new ParseException(ioe);
        }
    }

    @Override
    public void decode(byte[] b, ParameterFactory factory, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        if (b.length < 1) {
            throw new ParseException();
        }
        this.digValue = b[0];
        this.value = ErrorCauseValue.getInstance(this.digValue);
    }

    @Override
    public byte[] encode(boolean removeSpc, SccpProtocolVersion sccpProtocolVersion) throws ParseException {
        return new byte[]{(byte)this.digValue};
    }

    public String toString() {
        if (this.value != null) {
            return new StringBuffer().append("ErrorCause [").append("value=").append((Object)this.value).append("]").toString();
        }
        return new StringBuffer().append("ErrorCause [").append("digValue=").append(this.digValue).append("]").toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ErrorCauseImpl that = (ErrorCauseImpl)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.digValue;
    }
}

