/*
 * Decompiled with CFR 0.152.
 */
package org.restcomm.protocols.ss7.sccp.impl;

import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javolution.util.FastMap;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.restcomm.protocols.ss7.indicator.RoutingIndicator;
import org.restcomm.protocols.ss7.mtp.Mtp3TransferPrimitive;
import org.restcomm.protocols.ss7.mtp.Mtp3TransferPrimitiveFactory;
import org.restcomm.protocols.ss7.mtp.Mtp3UserPart;
import org.restcomm.protocols.ss7.sccp.LongMessageRule;
import org.restcomm.protocols.ss7.sccp.LongMessageRuleType;
import org.restcomm.protocols.ss7.sccp.Mtp3ServiceAccessPoint;
import org.restcomm.protocols.ss7.sccp.RemoteSignalingPointCode;
import org.restcomm.protocols.ss7.sccp.RemoteSubSystem;
import org.restcomm.protocols.ss7.sccp.SccpConnection;
import org.restcomm.protocols.ss7.sccp.SccpListener;
import org.restcomm.protocols.ss7.sccp.impl.SccpConnectionImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpManagement;
import org.restcomm.protocols.ss7.sccp.impl.SccpProviderImpl;
import org.restcomm.protocols.ss7.sccp.impl.SccpRoutingCtxInterface;
import org.restcomm.protocols.ss7.sccp.impl.SccpStackImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.EncodingResultData;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageFactoryImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.MessageUtil;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpAddressedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnAkMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnCrefMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt1MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnDt2MessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnErrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnItMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnReferencedMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRlcMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRlsdMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRscMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnRsrMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpConnSegmentableMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpDataMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.message.SccpNoticeMessageImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ErrorCauseImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ImportanceImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ParameterFactoryImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.RefusalCauseImpl;
import org.restcomm.protocols.ss7.sccp.impl.parameter.ReleaseCauseImpl;
import org.restcomm.protocols.ss7.sccp.message.SccpConnMessage;
import org.restcomm.protocols.ss7.sccp.message.SccpDataMessage;
import org.restcomm.protocols.ss7.sccp.message.SccpMessage;
import org.restcomm.protocols.ss7.sccp.message.SccpNoticeMessage;
import org.restcomm.protocols.ss7.sccp.parameter.ErrorCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.GlobalTitle;
import org.restcomm.protocols.ss7.sccp.parameter.LocalReference;
import org.restcomm.protocols.ss7.sccp.parameter.RefusalCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.ReleaseCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCause;
import org.restcomm.protocols.ss7.sccp.parameter.ReturnCauseValue;
import org.restcomm.protocols.ss7.sccp.parameter.SccpAddress;

public class SccpRoutingControl
implements SccpRoutingCtxInterface {
    private final Logger logger;
    private SccpStackImpl sccpStackImpl = null;
    private SccpProviderImpl sccpProviderImpl = null;
    private SccpManagement sccpManagement = null;
    private MessageFactoryImpl messageFactory;
    private ConcurrentHashMap<Integer, AtomicInteger> opcSscCounters = new ConcurrentHashMap();
    private long lastCongAnnounseTime;

    public SccpRoutingControl(SccpProviderImpl sccpProviderImpl, SccpStackImpl sccpStackImpl) {
        this.messageFactory = sccpStackImpl.messageFactory;
        this.sccpProviderImpl = sccpProviderImpl;
        this.sccpStackImpl = sccpStackImpl;
        this.logger = Logger.getLogger(SccpRoutingControl.class.getCanonicalName() + "-" + this.sccpStackImpl.name);
    }

    public SccpManagement getSccpManagement() {
        return this.sccpManagement;
    }

    public void setSccpManagement(SccpManagement sccpManagement) {
        this.sccpManagement = sccpManagement;
    }

    public void start() {
    }

    public void stop() {
    }

    protected void routeMssgFromMtp(SccpAddressedMessageImpl msg) throws Exception {
        if (this.sccpStackImpl.isPreviewMode()) {
            int ssn = msg.getCalledPartyAddress().getSubsystemNumber();
            if (ssn == 1) {
                return;
            }
            FastMap<Integer, SccpListener> lstListn = this.sccpProviderImpl.getAllSccpListeners();
            for (Map.Entry<Integer, SccpListener> val : lstListn.entrySet()) {
                SccpListener listener = val.getValue();
                if (!(msg instanceof SccpDataMessage)) continue;
                this.deliverMessageToSccpUser(listener, (SccpDataMessage)((Object)msg));
            }
            return;
        }
        int subsystemNumber = msg.getCalledPartyAddress().getSubsystemNumber();
        Integer congestionLevel = this.sccpProviderImpl.getCongestionSsn().get(subsystemNumber);
        if (congestionLevel != null) {
            AtomicInteger aCounter;
            int inOpc = msg.getIncomingOpc();
            if (congestionLevel > 0) {
                if (subsystemNumber != 1 && msg instanceof SccpDataMessage) {
                    aCounter = this.opcSscCounters.get(inOpc);
                    if (aCounter == null) {
                        this.opcSscCounters.put(inOpc, new AtomicInteger(0));
                        this.sccpManagement.receivedForCongestionUser(msg, subsystemNumber, congestionLevel);
                    } else if (aCounter.incrementAndGet() % 8 == 0) {
                        this.sccpManagement.receivedForCongestionUser(msg, subsystemNumber, congestionLevel);
                        aCounter.compareAndSet(Integer.MAX_VALUE, 0);
                    }
                }
            } else if (congestionLevel == 0 && (aCounter = this.opcSscCounters.get(inOpc)) != null) {
                aCounter.set(0);
            }
        }
        SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
        RoutingIndicator ri = calledPartyAddress.getAddressIndicator().getRoutingIndicator();
        switch (ri) {
            case ROUTING_BASED_ON_DPC_AND_SSN: {
                int ssn = msg.getCalledPartyAddress().getSubsystemNumber();
                if (ssn == 1) {
                    if (msg instanceof SccpDataMessage) {
                        this.sccpManagement.onManagementMessage((SccpDataMessage)((Object)msg));
                    }
                    return;
                }
                SccpListener listener = this.sccpProviderImpl.getSccpListener(ssn);
                if (listener == null) {
                    this.sccpManagement.recdMsgForProhibitedSsn(msg, ssn);
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Received SccpMessage=%s from MTP but the SSN is not available for local routing", msg));
                    }
                    this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE, RefusalCauseValue.SUBSYSTEM_FAILURE);
                    return;
                }
                try {
                    if (msg instanceof SccpDataMessage) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(String.format("Local deliver : SCCP Data Message=%s", msg.toString()));
                        }
                        this.deliverMessageToSccpUser(listener, (SccpDataMessage)((Object)msg));
                        break;
                    }
                    if (msg instanceof SccpNoticeMessage) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(String.format("Local deliver : SCCP Notice Message=%s", msg.toString()));
                        }
                        listener.onNotice((SccpNoticeMessage)((Object)msg));
                        break;
                    }
                    if (!(msg instanceof SccpConnCrMessageImpl)) break;
                    this.processIncCR(msg);
                }
                catch (Exception e) {
                    if (!this.logger.isEnabledFor(Level.WARN)) break;
                    this.logger.warn(String.format("Exception from the listener side when delivering SccpData to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), e);
                }
                break;
            }
            case ROUTING_BASED_ON_GLOBAL_TITLE: {
                this.sccpStackImpl.ss7ExtSccpDetailedInterface.translationFunction(this, msg);
                break;
            }
            default: {
                this.logger.error(String.format("Invalid Routing Indicator received for message=%s from MTP3", msg));
            }
        }
    }

    protected void routeMssgFromMtpConn(SccpConnMessage msg) throws Exception {
        LocalReference ref = MessageUtil.getDln(msg);
        SccpConnectionImpl conn = this.sccpStackImpl.getConnection(ref);
        if (conn == null) {
            return;
        }
        int ssn = conn.getLocalSsn();
        SccpListener listener = conn.getListener();
        if (!(listener != null || conn.isCouplingEnabled() || msg instanceof SccpConnRlsdMessageImpl || msg instanceof SccpConnRlcMessageImpl)) {
            this.sccpManagement.recdMsgForProhibitedSsn(msg, ssn);
            if (this.logger.isEnabledFor(Level.WARN)) {
                this.logger.warn(String.format("Received SccpMessage=%s from MTP but the SSN is not available for local routing", msg));
            }
            this.sendSccpErrorConn(msg, ReleaseCauseValue.SUBSYSTEM_FAILURE);
            return;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(String.format("Local deliver : SCCP Message=%s", msg.toString()));
        }
        this.processCoMessages(msg, conn, listener);
    }

    protected void routeMssgFromSccpUser(SccpAddressedMessageImpl msg) throws Exception {
        if (this.sccpStackImpl.isPreviewMode()) {
            return;
        }
        if (msg instanceof SccpAddressedMessageImpl) {
            this.routeAddressed(msg);
        } else {
            this.routeConn((SccpConnMessage)((Object)msg));
        }
    }

    public void routeMssgFromSccpUserConn(SccpConnMessage msg) throws Exception {
        if (this.sccpStackImpl.isPreviewMode()) {
            return;
        }
        if (msg instanceof SccpAddressedMessageImpl) {
            this.routeAddressed((SccpAddressedMessageImpl)((Object)msg));
        } else {
            this.routeConn(msg);
        }
    }

    protected void send(SccpAddressedMessageImpl message) throws Exception {
        int dpc = message.getOutgoingDpc();
        int sls = message.getSls();
        RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(dpc);
        int currentRestrictionLevel = remoteSpc.getCurrentRestrictionLevel();
        int msgImportance = 8;
        if (message instanceof SccpDataMessageImpl) {
            msgImportance = 5;
        }
        if (message instanceof SccpNoticeMessageImpl) {
            msgImportance = 3;
        }
        if (this.sccpStackImpl.isCongControl_blockingOutgoungSccpMessages() && msgImportance < currentRestrictionLevel) {
            long curTime = System.currentTimeMillis();
            if (this.lastCongAnnounseTime + 1000L < curTime) {
                this.lastCongAnnounseTime = curTime;
                this.logger.warn(String.format("Outgoing congestion control: SCCP: SccpMessage for sending=%s was dropped because of congestion level %d to dpc %d", message, currentRestrictionLevel, dpc));
            }
            this.sendSccpError(message, ReturnCauseValue.NETWORK_CONGESTION, RefusalCauseValue.SUBSYSTEM_CONGESTION);
            return;
        }
        Mtp3ServiceAccessPoint sap = this.sccpStackImpl.router.findMtp3ServiceAccessPoint(dpc, sls, message.getNetworkId());
        if (sap == null) {
            if (this.logger.isEnabledFor(Level.WARN)) {
                this.logger.warn(String.format("SccpMessage for sending=%s but no matching dpc=%d & sls=%d SAP found", message, dpc, sls));
            }
            this.sendSccpError(message, ReturnCauseValue.SCCP_FAILURE, RefusalCauseValue.SCCP_FAILURE);
            return;
        }
        Mtp3UserPart mup = this.sccpStackImpl.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            if (this.logger.isEnabledFor(Level.WARN)) {
                this.logger.warn(String.format("SccpMessage for sending=%s but no matching Mtp3UserPart found for Id=%d", message, sap.getMtp3Id()));
            }
            this.sendSccpError(message, ReturnCauseValue.SCCP_FAILURE, RefusalCauseValue.SCCP_FAILURE);
            return;
        }
        LongMessageRule lmr = this.sccpStackImpl.router.findLongMessageRule(dpc);
        LongMessageRuleType lmrt = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
        if (lmr != null) {
            lmrt = lmr.getLongMessageRuleType();
        }
        EncodingResultData erd = message.encode(this.sccpStackImpl, lmrt, mup.getMaxUserDataLength(dpc), this.logger, this.sccpStackImpl.isRemoveSpc(), this.sccpStackImpl.getSccpProtocolVersion());
        switch (erd.getEncodingResult()) {
            case Success: {
                Mtp3TransferPrimitiveFactory factory = mup.getMtp3TransferPrimitiveFactory();
                if (erd.getSolidData() != null) {
                    Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, sls, erd.getSolidData());
                    mup.sendMessage(msg);
                } else {
                    for (byte[] bf : erd.getSegementedData()) {
                        Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, sls, bf);
                        mup.sendMessage(msg);
                    }
                }
                return;
            }
            case ReturnFailure: {
                this.sendSccpError(message, erd.getReturnCause(), RefusalCauseValue.SUBSYSTEM_FAILURE);
                return;
            }
        }
        String em = String.format("Error %s when encoding a SccpMessage\n%s", erd.getEncodingResult().toString(), message.toString());
        if (this.logger.isEnabledFor(Level.WARN)) {
            this.logger.warn(em);
        }
        throw new IOException(em);
    }

    public ReleaseCauseValue sendConn(SccpConnMessage connMessage) throws Exception {
        SccpMessageImpl message = (SccpMessageImpl)((Object)connMessage);
        int dpc = message.getOutgoingDpc();
        int sls = message.getSls();
        RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(dpc);
        int currentRestrictionLevel = remoteSpc.getCurrentRestrictionLevel();
        int msgImportance = this.updateImportance(connMessage);
        if (this.sccpStackImpl.isCongControl_blockingOutgoungSccpMessages() && msgImportance < currentRestrictionLevel) {
            long curTime = System.currentTimeMillis();
            if (this.lastCongAnnounseTime + 1000L < curTime) {
                this.lastCongAnnounseTime = curTime;
                this.logger.warn(String.format("Outgoing congestion control: SCCP: SccpMessage for sending=%s was dropped because of congestion level %d to dpc %d", message, currentRestrictionLevel, dpc));
            }
            return ReleaseCauseValue.SUBSYSTEM_CONGESTION;
        }
        Mtp3ServiceAccessPoint sap = this.sccpStackImpl.router.findMtp3ServiceAccessPoint(dpc, sls, message.getNetworkId());
        if (sap == null) {
            if (this.logger.isEnabledFor(Level.WARN)) {
                this.logger.warn(String.format("SccpMessage for sending=%s but no matching dpc=%d & sls=%d SAP found", message, dpc, sls));
            }
            return ReleaseCauseValue.SCCP_FAILURE;
        }
        Mtp3UserPart mup = this.sccpStackImpl.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            if (this.logger.isEnabledFor(Level.WARN)) {
                this.logger.warn(String.format("SccpMessage for sending=%s but no matching Mtp3UserPart found for Id=%d", message, sap.getMtp3Id()));
            }
            return ReleaseCauseValue.SCCP_FAILURE;
        }
        LongMessageRuleType lmrt = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
        EncodingResultData erd = message.encode(this.sccpStackImpl, lmrt, mup.getMaxUserDataLength(dpc), this.logger, this.sccpStackImpl.isRemoveSpc(), this.sccpStackImpl.getSccpProtocolVersion());
        switch (erd.getEncodingResult()) {
            case Success: {
                Mtp3TransferPrimitiveFactory factory = mup.getMtp3TransferPrimitiveFactory();
                Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, sls, erd.getSolidData());
                mup.sendMessage(msg);
                return null;
            }
            case ReturnFailure: {
                return ReleaseCauseValue.SUBSYSTEM_FAILURE;
            }
        }
        String em = String.format("Error %s when encoding a SccpMessage\n%s", erd.getEncodingResult().toString(), message.toString());
        if (this.logger.isEnabledFor(Level.WARN)) {
            this.logger.warn(em);
        }
        throw new IOException(em);
    }

    private int updateImportance(SccpConnMessage connMessage) {
        if (connMessage instanceof SccpConnCrMessageImpl) {
            SccpConnCrMessageImpl cr = (SccpConnCrMessageImpl)connMessage;
            cr.setImportance(new ImportanceImpl(3));
            return cr.getImportance().getValue();
        }
        if (connMessage instanceof SccpConnSegmentableMessageImpl) {
            return 5;
        }
        return 8;
    }

    protected ReturnCauseValue sendManagementMessage(SccpDataMessageImpl message) throws Exception {
        int dpc = message.getOutgoingDpc();
        Mtp3ServiceAccessPoint sap = this.sccpStackImpl.router.findMtp3ServiceAccessPoint(dpc, 0);
        if (sap == null) {
            if (this.logger.isEnabledFor(Level.WARN)) {
                this.logger.warn(String.format("Sccp management message for sending=%s but no matching dpc=%d SAP found", message, dpc));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        Mtp3UserPart mup = this.sccpStackImpl.getMtp3UserPart(sap.getMtp3Id());
        if (mup == null) {
            if (this.logger.isEnabledFor(Level.WARN)) {
                this.logger.warn(String.format("Sccp management message for sending=%s but no matching Mtp3UserPart found for Id=%d", message, sap.getMtp3Id()));
            }
            return ReturnCauseValue.SCCP_FAILURE;
        }
        LongMessageRuleType lmrt = LongMessageRuleType.LONG_MESSAGE_FORBBIDEN;
        EncodingResultData erd = message.encode(this.sccpStackImpl, lmrt, mup.getMaxUserDataLength(dpc), this.logger, this.sccpStackImpl.isRemoveSpc(), this.sccpStackImpl.getSccpProtocolVersion());
        switch (erd.getEncodingResult()) {
            case Success: {
                Mtp3TransferPrimitiveFactory factory = mup.getMtp3TransferPrimitiveFactory();
                if (erd.getSolidData() == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Sccp management message for sending=%s was encoded with segments, it is forbidded", message));
                    }
                    return ReturnCauseValue.SCCP_FAILURE;
                }
                Mtp3TransferPrimitive msg = factory.createMtp3TransferPrimitive(3, sap.getNi(), 0, sap.getOpc(), dpc, 0, erd.getSolidData());
                mup.sendMessage(msg);
                return null;
            }
            case ReturnFailure: {
                return erd.getReturnCause();
            }
        }
        String em = String.format("Error %s when encoding a SccpMessage\n%s", erd.getEncodingResult().toString(), message.toString());
        if (this.logger.isEnabledFor(Level.WARN)) {
            this.logger.warn(em);
        }
        throw new IOException(em);
    }

    @Override
    public void routeAddressed(SccpAddressedMessageImpl msg) throws Exception {
        block40: {
            SccpAddress calledPartyAddress = msg.getCalledPartyAddress();
            int dpc = calledPartyAddress.getSignalingPointCode();
            int ssn = calledPartyAddress.getSubsystemNumber();
            GlobalTitle gt = calledPartyAddress.getGlobalTitle();
            if (calledPartyAddress.getAddressIndicator().isPCPresent()) {
                if (this.sccpStackImpl.router.spcIsLocal(dpc)) {
                    if (ssn > 0) {
                        if (ssn == 1) {
                            if (msg instanceof SccpDataMessage) {
                                this.sccpManagement.onManagementMessage((SccpDataMessage)((Object)msg));
                            }
                            return;
                        }
                        SccpListener listener = this.sccpProviderImpl.getSccpListener(ssn);
                        if (listener == null) {
                            if (this.logger.isEnabledFor(Level.WARN)) {
                                this.logger.warn(String.format("Received SccpMessage=%s for routing but the SSN is not available for local routing", msg));
                            }
                            this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE, RefusalCauseValue.SUBSYSTEM_FAILURE);
                            return;
                        }
                        try {
                            if (msg instanceof SccpDataMessage) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(String.format("Local deliver : SCCP Data Message=%s", msg.toString()));
                                }
                                this.deliverMessageToSccpUser(listener, (SccpDataMessage)((Object)msg));
                            } else if (msg instanceof SccpNoticeMessage) {
                                if (this.logger.isDebugEnabled()) {
                                    this.logger.debug(String.format("Local deliver : SCCP Notice Message=%s", msg.toString()));
                                }
                                listener.onNotice((SccpNoticeMessage)((Object)msg));
                            } else if (msg instanceof SccpConnCrMessageImpl) {
                                msg.setIsIncoming(true);
                                this.processIncCR(msg);
                            }
                            break block40;
                        }
                        catch (Exception e) {
                            if (this.logger.isEnabledFor(Level.WARN)) {
                                this.logger.warn(String.format("Exception from the listener side when delivering SccpData to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), e);
                            }
                            break block40;
                        }
                    }
                    if (gt != null) {
                        if (calledPartyAddress.isTranslated()) {
                            this.logger.error(String.format("Droping message. Received SCCPMessage=%s for routing but CalledPartyAddress is already translated once", msg));
                            this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE, RefusalCauseValue.SCCP_FAILURE);
                            return;
                        }
                        this.sccpStackImpl.ss7ExtSccpDetailedInterface.translationFunction(this, msg);
                    } else {
                        this.logger.error(String.format("Received SCCPMessage=%s for routing, but neither SSN nor GT present", msg));
                        this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE, RefusalCauseValue.NO_TRANSLATION_FOR_AN_ADDRESS_OF_SUCH_NATURE);
                    }
                } else {
                    RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(dpc);
                    if (remoteSpc == null) {
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Received SccpMessage=%s for routing but no Remote Signaling Pointcode = %d resource defined ", msg, dpc));
                        }
                        this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE, RefusalCauseValue.SCCP_FAILURE);
                        return;
                    }
                    if (remoteSpc.isRemoteSpcProhibited()) {
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Received SccpMessage=%s for routing but Remote Signaling Pointcode = %d is prohibited", msg, dpc));
                        }
                        this.sendSccpError(msg, ReturnCauseValue.MTP_FAILURE, RefusalCauseValue.DESTINATION_INACCESSIBLE);
                        return;
                    }
                    if (ssn > 1) {
                        if (calledPartyAddress.getAddressIndicator().getRoutingIndicator() == RoutingIndicator.ROUTING_BASED_ON_DPC_AND_SSN) {
                            RemoteSubSystem remoteSsn = this.sccpStackImpl.getSccpResource().getRemoteSsn(dpc, calledPartyAddress.getSubsystemNumber());
                            if (remoteSsn == null) {
                                if (this.logger.isEnabledFor(Level.WARN)) {
                                    this.logger.warn(String.format("Received SCCPMessage=%s for routing, but no Remote SubSystem = %d resource defined ", msg, calledPartyAddress.getSubsystemNumber()));
                                }
                                this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE, RefusalCauseValue.SCCP_FAILURE);
                                return;
                            }
                            if (remoteSsn.isRemoteSsnProhibited()) {
                                if (this.logger.isEnabledFor(Level.WARN)) {
                                    this.logger.warn(String.format("Routing of Sccp Message=%s failed as Remote SubSystem = %d is prohibited ", msg, calledPartyAddress.getSubsystemNumber()));
                                }
                                this.sendSccpError(msg, ReturnCauseValue.SUBSYSTEM_FAILURE, RefusalCauseValue.SUBSYSTEM_FAILURE);
                                return;
                            }
                        }
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(String.format("Tx : SCCP Message=%s", msg.toString()));
                        }
                        this.sendMessageToMtp(msg);
                    } else if (gt != null) {
                        if (this.logger.isDebugEnabled()) {
                            this.logger.debug(String.format("Tx : SCCP Message=%s", msg.toString()));
                        }
                        this.sendMessageToMtp(msg);
                    } else {
                        this.logger.error(String.format("Received SCCPMessage=%s for routing, but neither SSN nor GT present", msg));
                        this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE, RefusalCauseValue.NO_TRANSLATION_FOR_AN_ADDRESS_OF_SUCH_NATURE);
                    }
                }
            } else {
                if (gt == null) {
                    if (this.logger.isEnabledFor(Level.WARN)) {
                        this.logger.warn(String.format("Received SccpMessage=%s for routing from local SCCP user part but no pointcode and no GT or SSN included", msg, dpc));
                    }
                    this.sendSccpError(msg, ReturnCauseValue.NO_TRANSLATION_FOR_NATURE, RefusalCauseValue.NO_TRANSLATION_FOR_AN_ADDRESS_OF_SUCH_NATURE);
                    return;
                }
                if (calledPartyAddress.isTranslated()) {
                    this.logger.error(String.format("Droping message. Received SCCPMessage=%s for Routing , but CalledPartyAddress is already translated once", msg));
                    this.sendSccpError(msg, ReturnCauseValue.SCCP_FAILURE, RefusalCauseValue.SCCP_FAILURE);
                    return;
                }
                this.sccpStackImpl.ss7ExtSccpDetailedInterface.translationFunction(this, msg);
            }
        }
    }

    private void routeConn(SccpConnMessage msg) throws Exception {
        LocalReference ref = MessageUtil.getSln(msg);
        SccpConnectionImpl conn = this.sccpStackImpl.getConnection(ref);
        if (conn == null) {
            this.logger.error(String.format("Dropping message. Received SCCPMessage=%s for routing but can't find connection by local reference %s in this message", msg, ref));
            return;
        }
        Integer dpc = conn.getRemoteDpc();
        if (dpc == null) {
            this.logger.error(String.format("Dropping message. Received SCCPMessage=%s for routing but can't find remote DPC", msg));
            return;
        }
        if (this.sccpStackImpl.router.spcIsLocal(dpc)) {
            ((SccpMessageImpl)((Object)msg)).setIsIncoming(true);
            this.deliverMessageToSccpUser(null, msg);
        } else {
            RemoteSignalingPointCode remoteSpc = this.sccpStackImpl.getSccpResource().getRemoteSpcByPC(dpc);
            if (remoteSpc == null) {
                if (this.logger.isEnabledFor(Level.WARN)) {
                    this.logger.warn(String.format("Received SccpMessage=%s for routing but no Remote Signaling Pointcode = %d resource defined ", msg, dpc));
                }
                this.sendSccpErrorConn(msg, ReleaseCauseValue.SCCP_FAILURE);
                return;
            }
            if (remoteSpc.isRemoteSpcProhibited()) {
                if (this.logger.isEnabledFor(Level.WARN)) {
                    this.logger.warn(String.format("Received SccpMessage=%s for routing but Remote Signaling Pointcode = %d is prohibited", msg, dpc));
                }
                this.sendSccpErrorConn(msg, ReleaseCauseValue.MTP_FAILURE);
                return;
            }
            Integer ssn = conn.getRemoteSsn();
            if (ssn == null || ssn > 0) {
                if (ssn != null && ssn > 1) {
                    RemoteSubSystem remoteSsn = this.sccpStackImpl.getSccpResource().getRemoteSsn(dpc, ssn);
                    if (remoteSsn == null) {
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Received SCCPMessage=%s for routing, but no Remote SubSystem = %d resource defined ", msg, ssn));
                        }
                        this.sendSccpErrorConn(msg, ReleaseCauseValue.SCCP_FAILURE);
                        return;
                    }
                    if (remoteSsn.isRemoteSsnProhibited()) {
                        if (this.logger.isEnabledFor(Level.WARN)) {
                            this.logger.warn(String.format("Routing of Sccp Message=%s failed as Remote SubSystem = %d is prohibited ", msg, ssn));
                        }
                        this.sendSccpErrorConn(msg, ReleaseCauseValue.SUBSYSTEM_FAILURE);
                        return;
                    }
                }
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(String.format("Tx : SCCP Message=%s", msg.toString()));
                }
                this.sendMessageToMtpConn(msg);
            } else {
                this.logger.error(String.format("Received SCCPMessage=%s for routing, but neither SSN nor GT present", msg));
                this.sendSccpErrorConn(msg, ReleaseCauseValue.SCCP_FAILURE);
            }
        }
    }

    private void deliverMessageToSccpUser(SccpListener listener, SccpMessage msg) {
        if (msg.getIsMtpOriginated() && msg instanceof SccpDataMessage) {
            listener.onMessage((SccpDataMessage)msg);
        } else {
            int seqControl = msg.getSls();
            SccpTransferDeliveryHandler hdl = new SccpTransferDeliveryHandler(msg, listener);
            this.sccpStackImpl.msgDeliveryExecutors[this.sccpStackImpl.slsTable[seqControl &= this.sccpStackImpl.slsFilter]].execute(hdl);
        }
    }

    protected void sendMessageToMtp(SccpAddressedMessageImpl msg) throws Exception {
        msg.setOutgoingDpc(msg.getCalledPartyAddress().getSignalingPointCode());
        this.send(msg);
    }

    protected void sendMessageToMtpConn(SccpConnMessage message) throws Exception {
        if (message instanceof SccpConnCrMessageImpl) {
            throw new IllegalArgumentException();
        }
        SccpMessageImpl msg = (SccpMessageImpl)((Object)message);
        LocalReference sln = MessageUtil.getSln(message);
        SccpConnectionImpl conn = this.sccpStackImpl.getConnection(sln);
        msg.setOutgoingDpc(conn.getRemoteDpc());
        ReleaseCauseValue er = this.sendConn(message);
        if (er != null) {
            this.sendSccpErrorConn(message, er);
        }
    }

    @Override
    public void sendSccpError(SccpAddressedMessageImpl msg, ReturnCauseValue returnCauseInt, RefusalCauseValue refusalCauseInt) throws Exception {
        block21: {
            Object ans = null;
            if (!(msg instanceof SccpConnCrMessageImpl)) {
                if (!msg.getReturnMessageOnError()) {
                    return;
                }
                ReturnCause returnCause = ((ParameterFactoryImpl)this.sccpProviderImpl.getParameterFactory()).createReturnCause(returnCauseInt);
                if (msg instanceof SccpDataMessageImpl) {
                    SccpDataMessageImpl msgData = (SccpDataMessageImpl)msg;
                    ans = (SccpNoticeMessageImpl)this.messageFactory.createNoticeMessage(msg.getType(), returnCause, msg.getCallingPartyAddress(), msg.getCalledPartyAddress(), msgData.getData(), msgData.getHopCounter(), msgData.getImportance());
                }
            } else {
                SccpConnCrMessageImpl msgCr = (SccpConnCrMessageImpl)msg;
                SccpConnCrefMessageImpl answer = new SccpConnCrefMessageImpl(msgCr.getSls(), msgCr.getOriginLocalSsn());
                answer.setDestinationLocalReferenceNumber(msgCr.getSourceLocalReferenceNumber());
                if (msgCr.getCallingPartyAddress() != null) {
                    answer.setCalledPartyAddress(msgCr.getCallingPartyAddress());
                }
                answer.setRefusalCause(new RefusalCauseImpl(refusalCauseInt));
                answer.setImportance(msgCr.getImportance());
                if (msg.getIncomingOpc() != -1) {
                    answer.setOutgoingDpc(msgCr.getIncomingOpc());
                } else {
                    answer.setOutgoingDpc(msgCr.getCalledPartyAddress().getSignalingPointCode());
                }
                ans = answer;
            }
            if (ans != null) {
                if (msg.getIsMtpOriginated()) {
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format("sendSccpError to a remote user: SCCP Message=%s", ans.toString()));
                    }
                    if (ans instanceof SccpAddressedMessageImpl) {
                        this.routeAddressed((SccpAddressedMessageImpl)ans);
                    } else {
                        this.routeConn((SccpConnMessage)ans);
                    }
                } else {
                    SccpListener listener;
                    if (this.logger.isDebugEnabled()) {
                        this.logger.debug(String.format("sendSccpError to a local user: SCCP Message=%s", ans.toString()));
                    }
                    if ((listener = this.sccpProviderImpl.getSccpListener(msg.getOriginLocalSsn())) != null) {
                        if (!(msg instanceof SccpConnCrMessageImpl)) {
                            try {
                                listener.onNotice((SccpNoticeMessage)ans);
                            }
                            catch (Exception e) {
                                if (this.logger.isEnabledFor(Level.WARN)) {
                                    this.logger.warn(String.format("Exception from the listener side when delivering SccpNotice to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), e);
                                }
                                break block21;
                            }
                        }
                        try {
                            SccpConnectionImpl conn = this.sccpStackImpl.getConnection(((SccpConnCrMessageImpl)msg).getSourceLocalReferenceNumber());
                            listener.onDisconnectIndication((SccpConnection)conn, ((SccpConnCrefMessageImpl)ans).getRefusalCause(), new byte[0]);
                        }
                        catch (Exception e) {
                            if (!this.logger.isEnabledFor(Level.WARN)) break block21;
                            this.logger.warn(String.format("Exception from the listener side when delivering CREF message to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), e);
                        }
                    }
                }
            }
        }
    }

    private void sendSccpErrorConn(SccpConnMessage msg, ReleaseCauseValue cause) throws Exception {
        if (msg instanceof SccpConnRlsdMessageImpl) {
            return;
        }
        LocalReference ref = !msg.getIsIncoming() ? MessageUtil.getSln(msg) : MessageUtil.getDln(msg);
        SccpConnectionImpl conn = this.sccpStackImpl.getConnection(ref);
        conn.disconnect(new ReleaseCauseImpl(cause), new byte[0]);
    }

    private void processIncCR(SccpAddressedMessageImpl msg) throws Exception {
        SccpConnCrMessageImpl msgCr = (SccpConnCrMessageImpl)msg;
        SccpConnectionImpl conn = this.sccpStackImpl.newConnection(msgCr.getCalledPartyAddress().getSubsystemNumber(), msgCr.getProtocolClass());
        if (msgCr.getCallingPartyAddress() != null) {
            conn.remoteSsn = msgCr.getCallingPartyAddress().getSubsystemNumber();
        }
        conn.receiveMessage(msgCr);
        conn.getListener().onConnectIndication(conn, msgCr.getCalledPartyAddress(), msgCr.getCallingPartyAddress(), msgCr.getProtocolClass(), msgCr.getCredit(), msgCr.getUserData(), msgCr.getImportance());
    }

    private void processCoMessages(SccpConnMessage msg, SccpConnectionImpl conn, SccpListener listener) {
        block45: {
            try {
                if (msg instanceof SccpConnCcMessageImpl) {
                    conn.receiveMessage(msg);
                    if (listener != null) {
                        listener.onConnectConfirm(conn, ((SccpConnCcMessageImpl)msg).getUserData());
                    }
                } else if (msg instanceof SccpConnRlsdMessageImpl) {
                    if (!this.checkSourceLocalReferenceNumber(msg, conn)) {
                        conn.sendErr(new ErrorCauseImpl(ErrorCauseValue.LRN_MISMATCH_INCONSISTENT_SOURCE_LRN));
                        return;
                    }
                    SccpConnRlsdMessageImpl rlsd = (SccpConnRlsdMessageImpl)msg;
                    if (!conn.isCouplingEnabled()) {
                        if (listener != null) {
                            listener.onDisconnectIndication((SccpConnection)conn, rlsd.getReleaseCause(), rlsd.getUserData());
                        }
                        conn.receiveMessage(msg);
                        this.sccpStackImpl.removeConnection(conn.getLocalReference());
                    } else {
                        conn.receiveMessage(msg);
                    }
                } else if (msg instanceof SccpConnRlcMessageImpl) {
                    if (!this.checkSourceLocalReferenceNumber(msg, conn)) {
                        this.logger.error(String.format("Dropping message. Received SCCPMessage=%s but source LRN doesn't match remote LRN stored for connection", msg));
                        return;
                    }
                    if (!conn.isCouplingEnabled()) {
                        this.sccpStackImpl.removeConnection(conn.getLocalReference());
                        if (listener != null) {
                            listener.onDisconnectConfirm(conn);
                        }
                    } else {
                        conn.receiveMessage(msg);
                    }
                } else if (msg instanceof SccpConnCrefMessageImpl) {
                    SccpConnCrefMessageImpl cref = (SccpConnCrefMessageImpl)msg;
                    if (!conn.isCouplingEnabled()) {
                        this.sccpStackImpl.removeConnection(conn.getLocalReference());
                        listener.onDisconnectIndication((SccpConnection)conn, cref.getRefusalCause(), cref.getUserData());
                    } else {
                        conn.receiveMessage(msg);
                    }
                } else if (msg instanceof SccpConnRsrMessageImpl) {
                    if (!this.checkSourceLocalReferenceNumber(msg, conn)) {
                        conn.sendErr(new ErrorCauseImpl(ErrorCauseValue.LRN_MISMATCH_INCONSISTENT_SOURCE_LRN));
                        return;
                    }
                    if (!conn.isCouplingEnabled()) {
                        SccpConnRsrMessageImpl rsr = (SccpConnRsrMessageImpl)msg;
                        conn.receiveMessage(rsr);
                        listener.onResetIndication(conn, rsr.getResetCause());
                    } else {
                        conn.receiveMessage(msg);
                    }
                } else if (msg instanceof SccpConnRscMessageImpl) {
                    if (!this.checkSourceLocalReferenceNumber(msg, conn)) {
                        conn.sendErr(new ErrorCauseImpl(ErrorCauseValue.LRN_MISMATCH_INCONSISTENT_SOURCE_LRN));
                        return;
                    }
                    if (!conn.isCouplingEnabled()) {
                        conn.receiveMessage(msg);
                        listener.onResetConfirm(conn);
                    } else {
                        conn.receiveMessage(msg);
                    }
                } else if (msg instanceof SccpConnDt1MessageImpl) {
                    conn.receiveMessage(msg);
                } else if (msg instanceof SccpConnDt2MessageImpl) {
                    conn.receiveMessage(msg);
                } else if (msg instanceof SccpConnAkMessageImpl) {
                    conn.receiveMessage(msg);
                } else if (msg instanceof SccpConnItMessageImpl) {
                    if (!this.checkSourceLocalReferenceNumber(msg, conn)) {
                        conn.sendErr(new ErrorCauseImpl(ErrorCauseValue.LRN_MISMATCH_INCONSISTENT_SOURCE_LRN));
                        return;
                    }
                    conn.receiveMessage(msg);
                } else if (msg instanceof SccpConnErrMessageImpl) {
                    SccpConnErrMessageImpl err = (SccpConnErrMessageImpl)msg;
                    if (!conn.isCouplingEnabled()) {
                        if (err.getErrorCause().getValue() != null && err.getErrorCause().getValue() == ErrorCauseValue.SERVICE_CLASS_MISMATCH) {
                            listener.onDisconnectIndication(conn, err.getErrorCause());
                            conn.disconnect(new ReleaseCauseImpl(ReleaseCauseValue.SCCP_FAILURE), new byte[0]);
                        } else {
                            listener.onDisconnectIndication(conn, err.getErrorCause());
                            this.sccpStackImpl.removeConnection(conn.getLocalReference());
                        }
                    } else {
                        conn.receiveMessage(msg);
                    }
                }
            }
            catch (Exception e) {
                if (!this.logger.isEnabledFor(Level.WARN)) break block45;
                this.logger.warn(String.format("Exception from the listener side when delivering SccpData to ssn=%d: Message=%s", msg.getOriginLocalSsn(), msg), e);
            }
        }
    }

    private boolean checkSourceLocalReferenceNumber(SccpConnMessage msg, SccpConnection conn) {
        return ((SccpConnReferencedMessageImpl)msg).getSourceLocalReferenceNumber().getValue() == conn.getRemoteReference().getValue();
    }

    private class SccpTransferDeliveryHandler
    implements Runnable {
        private SccpMessage msg;
        private SccpListener listener;

        public SccpTransferDeliveryHandler(SccpMessage msg, SccpListener listener) {
            this.msg = msg;
            this.listener = listener;
        }

        @Override
        public void run() {
            if (SccpRoutingControl.this.sccpStackImpl.isStarted()) {
                try {
                    if (this.msg instanceof SccpDataMessage) {
                        this.listener.onMessage((SccpDataMessage)this.msg);
                    } else if (this.msg instanceof SccpConnMessage) {
                        LocalReference dln = MessageUtil.getDln((SccpConnMessage)this.msg);
                        SccpConnectionImpl dconn = SccpRoutingControl.this.sccpStackImpl.getConnection(dln);
                        if (dconn == null) {
                            SccpRoutingControl.this.logger.error(String.format("Dropping message. Received SCCPMessage=%s for routing but can't find connection by local reference %s in this message", this.msg, dln));
                            return;
                        }
                        int ssn = dconn.getLocalSsn();
                        SccpListener connListener = SccpRoutingControl.this.sccpProviderImpl.getSccpListener(ssn);
                        if (connListener == null) {
                            if (SccpRoutingControl.this.logger.isEnabledFor(Level.WARN)) {
                                SccpRoutingControl.this.logger.warn(String.format("Received SccpMessage=%s for routing but the SSN is not available for local routing", this.msg));
                            }
                            SccpRoutingControl.this.sendSccpErrorConn((SccpConnMessage)this.msg, ReleaseCauseValue.SUBSYSTEM_FAILURE);
                            return;
                        }
                        SccpRoutingControl.this.processCoMessages((SccpConnMessage)this.msg, dconn, connListener);
                    }
                }
                catch (Exception e) {
                    SccpRoutingControl.this.logger.error("Exception while delivering a system messages to the SCCP-user: " + e.getMessage(), e);
                }
            } else {
                SccpRoutingControl.this.logger.error(String.format("Received SccpDataMessage=%s but SccpStack is not started. Message will be dropped", this.msg));
            }
        }
    }
}

